/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import tdm.lib.Node;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class XMLPrinter
extends DefaultHandler {
    final Integer HAS_CONTENT;
    private static final String IND = "                                                                              ";
    private static final int STATE_CHARS = 0;
    private static final int STATE_TAG = 1;
    Integer childcounter = null;
    Stack csstack = new Stack();
    int indent = 0;
    private boolean prettyPrint = false;
    private PrintWriter pw = null;
    private int state = -1;

    public XMLPrinter(OutputStream out, boolean aPrettyPrint) {
        this.HAS_CONTENT = new Integer(0);
        try {
            this.pw = new PrintWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (UnsupportedEncodingException x) {
            System.err.println("Internal error: unknow encoding: utf-8");
            System.exit(-1);
        }
        this.prettyPrint = aPrettyPrint;
    }

    public XMLPrinter(OutputStream out) {
        this(out, false);
    }

    public void characters(char[] ch, int startpos, int length) {
        this.state = 0;
        if (this.childcounter != this.HAS_CONTENT) {
            this.printWithNL(">", this.prettyPrint);
        }
        this.childcounter = this.HAS_CONTENT;
        StringBuffer sb = new StringBuffer();
        int i = startpos;
        while (i < startpos + length) {
            switch (ch[i]) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append(">");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(ch[i]);
                }
            }
            ++i;
        }
        String chars = sb.toString();
        if (chars.length() == 0) {
            return;
        }
        this.printWithNL(chars, this.prettyPrint);
    }

    public void endDocument() {
        if (!this.prettyPrint) {
            this.pw.println();
        }
        this.pw.flush();
    }

    public void endElement(String uri, String name, String qName) {
        --this.indent;
        if (this.childcounter == null) {
            this.printWithNL(" />", this.prettyPrint);
        } else {
            if (this.state == 1 && !this.prettyPrint) {
                this.pw.println();
            }
            this.printWithNL((this.prettyPrint ? IND.substring(0, this.indent) : "") + "</" + qName + ">", this.prettyPrint);
        }
        this.childcounter = (Integer)this.csstack.pop();
        this.state = 1;
    }

    public void print(Node root, boolean fragment) {
        XMLNode c = root.getContent();
        if (!fragment) {
            this.startDocument();
        }
        if (c instanceof XMLTextNode) {
            char[] text = ((XMLTextNode)c).getText();
            this.characters(text, 0, text.length);
        } else {
            this.startElement("", "", ((XMLElementNode)c).getQName(), ((XMLElementNode)c).getAttributes());
            int i = 0;
            while (i < root.getChildCount()) {
                this.print(root.getChildAsNode(i), true);
                ++i;
            }
            this.endElement("", "", ((XMLElementNode)c).getQName());
        }
        if (!fragment) {
            this.endDocument();
        }
    }

    public void print(Node root) {
        this.print(root, false);
    }

    protected void printWithNL(String s, boolean appendNL) {
        if (appendNL) {
            this.pw.println(s);
        } else {
            this.pw.print(s);
        }
    }

    public void startDocument() {
        this.childcounter = this.HAS_CONTENT;
        this.pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.state = 1;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.childcounter == null) {
            this.printWithNL(">", this.prettyPrint);
            this.childcounter = this.HAS_CONTENT;
        }
        StringBuffer tagopen = new StringBuffer();
        if (this.state == 1 && !this.prettyPrint) {
            tagopen.append("\n");
        }
        tagopen.append('<');
        tagopen.append(qName);
        if (atts != null && atts.getLength() != 0) {
            int i = 0;
            while (i < atts.getLength()) {
                tagopen.append(' ');
                tagopen.append(atts.getQName(i));
                tagopen.append('=');
                tagopen.append('\"');
                tagopen.append(atts.getValue(i));
                tagopen.append('\"');
                ++i;
            }
        }
        this.csstack.push(this.childcounter);
        this.childcounter = null;
        this.pw.print((this.prettyPrint ? IND.substring(0, this.indent) : "") + tagopen.toString());
        ++this.indent;
        this.state = 1;
    }
}

