/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.ParseException;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLTextNode;

public class XMLParser {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private XMLReader xr = null;

    public XMLParser(String saxParserName) throws Exception {
        try {
            this.xr = (XMLReader)Class.forName(saxParserName).newInstance();
        }
        catch (Exception e) {
            throw new Exception("Unable to instantiate parser " + saxParserName);
        }
        try {
            this.xr.setFeature("http://xml.org/sax/features/namespaces", false);
            this.xr.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXException e) {
            throw new Exception("Error setting features:" + e.getMessage());
        }
    }

    public XMLParser() throws Exception {
        this(DEFAULT_PARSER_NAME);
    }

    public static SAXParser getSAXParser(NodeFactory aFactory) {
        return new SAXParser(aFactory);
    }

    public Node parse(String file, NodeFactory aFactory) throws ParseException, FileNotFoundException, IOException {
        SAXParser sp = XMLParser.getSAXParser(aFactory);
        try {
            InputSource is = new InputSource(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            this.xr.setContentHandler(sp);
            this.xr.setErrorHandler(sp);
            this.xr.parse(is);
        }
        catch (SAXException x) {
            throw new ParseException(x.getMessage());
        }
        return sp.getRoot();
    }

    public static class SAXParser
    extends DefaultHandler {
        private Node currentNode = null;
        private String currentText = null;
        private NodeFactory factory = null;
        private Stack treestack = new Stack();

        protected SAXParser(NodeFactory aFactory) {
            this.factory = aFactory;
        }

        public void characters(char[] ch, int start, int length) {
            boolean lastIsWS = this.currentText == null || this.currentText.endsWith(" ");
            StringBuffer sb = new StringBuffer();
            int i = start;
            while (i < start + length) {
                if (Character.isWhitespace(ch[i])) {
                    if (!lastIsWS) {
                        sb.append(" ");
                        lastIsWS = true;
                    }
                } else {
                    sb.append(ch[i]);
                    lastIsWS = false;
                }
                ++i;
            }
            String chars = sb.toString();
            if (chars.trim().length() == 0) {
                return;
            }
            this.currentText = this.currentText != null ? this.currentText + chars : chars;
        }

        public void endDocument() {
        }

        public void endElement(String uri, String name, String qName) {
            if (this.currentText != null) {
                this.currentNode.addChild(this.factory.makeNode(new XMLTextNode(this.currentText.trim().toCharArray())));
            }
            this.currentText = null;
            this.currentNode = (Node)this.treestack.pop();
        }

        public Node getRoot() {
            return this.currentNode;
        }

        public void startDocument() {
            this.currentNode = this.factory.makeNode(new XMLElementNode("$ROOT$", new AttributesImpl()));
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (this.currentText != null) {
                this.currentNode.addChild(this.factory.makeNode(new XMLTextNode(this.currentText.trim().toCharArray())));
            }
            this.currentText = null;
            if (uri != null && uri.length() > 0) {
                System.err.println("Error: namespaces ignored, elem = " + name + ", uri=" + uri);
            }
            Node n = this.factory.makeNode(new XMLElementNode(name == null || name.length() == 0 ? qName : name, atts));
            this.currentNode.addChild(n);
            this.treestack.push(this.currentNode);
            this.currentNode = n;
        }
    }
}

