/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Node;
import tdm.lib.XMLNode;

public class MatchedNodes {
    private Set matches = new HashSet();
    private BaseNode owner = null;

    public MatchedNodes(BaseNode aowner) {
        this.owner = aowner;
    }

    public void addMatch(BranchNode n) {
        this.matches.add(n);
    }

    public void clearMatches() {
        this.matches.clear();
    }

    public void debug(PrintWriter pw, int indent) {
        String ind = "                                                   ".substring(0, indent + 1);
        Iterator i = this.matches.iterator();
        while (i.hasNext()) {
            XMLNode n = ((Node)i.next()).content;
            pw.println(ind + (n == null ? "(null)" : n.toString()));
        }
    }

    public void delMatch(BranchNode n) {
        this.matches.remove(n);
    }

    public BranchNode getFullMatch() {
        Iterator i = this.matches.iterator();
        while (i.hasNext()) {
            BranchNode fmatch = (BranchNode)i.next();
            if (!fmatch.isMatch(3)) continue;
            return fmatch;
        }
        return null;
    }

    public int getMatchCount() {
        return this.matches.size();
    }

    public Set getMatches() {
        return this.matches;
    }
}

