/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class DiffAlgorithm {
    protected abstract boolean appends(Object var1, Object var2);

    protected abstract void content(Object var1, boolean var2) throws IOException;

    protected void copy(List stopNodes) throws IOException {
        Sequence s = new Sequence();
        Iterator i = stopNodes.iterator();
        while (i.hasNext()) {
            Object dst;
            Object stopNode = i.next();
            if (this.emitChildList(s, stopNode, dst = this.lookupBase(stopNode), false)) continue;
            DiffOperation op = new DiffOperation(4, DiffOperation.NO_VALUE, dst, DiffOperation.NO_VALUE);
            this.content(op, true);
            this.content(op, false);
        }
    }

    protected void diff(Object branchRoot) throws IOException {
        boolean rootHasMatch;
        boolean bl = rootHasMatch = this.lookupBase(branchRoot) != null;
        if (rootHasMatch) {
            List stopNodes = this.getStopNodes(branchRoot);
            DiffOperation op = new DiffOperation(1, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE);
            this.content(op, true);
            this.copy(stopNodes);
            this.content(op, false);
        } else {
            DiffOperation op = new DiffOperation(2, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE);
            this.content(op, true);
            this.insert(branchRoot);
            this.content(op, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean emitChildList(Sequence s, Object parent, Object dst, boolean insMode) throws IOException {
        Vector children = new Vector();
        Iterator i = this.getChildIterator(parent);
        while (i.hasNext()) {
            children.add(i.next());
        }
        int ic = 0;
        while (ic < children.size()) {
            block10: {
                Object child;
                boolean lastStopNode;
                block11: {
                    DiffOperation op;
                    Object src;
                    List childStopNodes;
                    block12: {
                        block13: {
                            lastStopNode = ic == children.size() - 1;
                            child = children.elementAt(ic);
                            Object baseMatch = this.lookupBase(child);
                            if (baseMatch == null) break block11;
                            childStopNodes = this.getStopNodes(child);
                            src = this.lookupBase(child);
                            if (childStopNodes.size() != 0 || lastStopNode) break block12;
                            if (!s.isEmpty()) break block13;
                            s.init(src, dst);
                            break block10;
                        }
                        if (!s.appends(src, dst)) break block12;
                        s.append(src);
                        break block10;
                    }
                    if (!s.appends(src, dst)) {
                        if (!s.isEmpty()) {
                            op = new DiffOperation(3, s.src, s.dst, new Long(s.run));
                            this.content(op, true);
                            this.content(op, false);
                        }
                        if (childStopNodes.size() > 0 || lastStopNode) {
                            op = new DiffOperation(3, src, dst, new Long(1L));
                            this.content(op, true);
                            this.copy(childStopNodes);
                            this.content(op, false);
                            s.setEmpty();
                            break block10;
                        } else {
                            s.init(src, dst);
                        }
                        break block10;
                    } else {
                        s.append(src);
                        op = new DiffOperation(3, s.src, s.dst, new Long(s.run));
                        this.content(op, true);
                        this.copy(childStopNodes);
                        this.content(op, false);
                        s.setEmpty();
                    }
                    break block10;
                }
                if (!s.isEmpty()) {
                    DiffOperation op = new DiffOperation(3, s.src, s.dst, new Long(s.run));
                    this.content(op, true);
                    this.content(op, false);
                    s.setEmpty();
                }
                if (!(insMode || ic != 0 && this.lookupBase(children.elementAt(ic - 1)) == null)) {
                    this.content(new DiffOperation(4, DiffOperation.NO_VALUE, dst, DiffOperation.NO_VALUE), true);
                }
                this.insert(child);
                if (!insMode && (lastStopNode || this.lookupBase(children.elementAt(ic + 1)) != null)) {
                    this.content(new DiffOperation(4, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE, DiffOperation.NO_VALUE), false);
                }
            }
            ++ic;
        }
        if (children.size() <= 0) return false;
        return true;
    }

    protected abstract Iterator getChildIterator(Object var1);

    protected abstract List getStopNodes(Object var1);

    protected void insert(Object branch) throws IOException {
        Sequence s = new Sequence();
        this.content(branch, true);
        this.emitChildList(s, branch, DiffOperation.NO_VALUE, true);
        this.content(branch, false);
    }

    protected abstract Object lookupBase(Object var1);

    public static class DiffOperation {
        public static final int COPY = 3;
        public static final int INSERT = 4;
        public static final Long NO_VALUE = new Long(Long.MIN_VALUE);
        public static final int ROOT_COPY = 1;
        public static final int ROOT_INSERT = 2;
        private Object destination;
        private int operation;
        private Long run;
        private Object source;

        protected DiffOperation(int aOperation, Object aSource, Object aDestination, Long aRun) {
            if (aSource == null || aDestination == null || aRun == null) {
                throw new IllegalArgumentException();
            }
            this.operation = aOperation;
            this.source = aSource;
            this.destination = aDestination;
            this.run = aRun;
        }

        public Object getDestination() {
            return this.destination;
        }

        public int getOperation() {
            return this.operation;
        }

        public Long getRun() {
            return this.run;
        }

        public Object getSource() {
            return this.source;
        }
    }

    class Sequence {
        Object dst = null;
        long run = -1L;
        Object src = null;
        Object tail = null;

        Sequence() {
        }

        void append(Object aSrc) {
            ++this.run;
            this.tail = aSrc;
        }

        boolean appends(Object asrc, Object adst) {
            return !this.isEmpty() && adst.equals(this.dst) && DiffAlgorithm.this.appends(this.tail, asrc);
        }

        void init(Object asrc, Object adst) {
            this.src = asrc;
            this.tail = asrc;
            this.dst = adst;
            this.run = 1L;
        }

        boolean isEmpty() {
            return this.run == -1L;
        }

        void setEmpty() {
            this.run = -1L;
        }
    }
}

