/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openexi.scomp.EXISchemaFactory;
import org.openexi.scomp.Event;
import org.openexi.scomp.Goal;
import org.openexi.scomp.Production;
import org.openexi.scomp.RightHandSide;
import org.openexi.scomp.Substance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProtoGrammar
extends RightHandSide
implements Comparable<ProtoGrammar> {
    private final TreeSet<Substance> sortedSubstances = new TreeSet();
    private final List<ProtoGrammar> linkedGrammars = new ArrayList<ProtoGrammar>();
    private Set<Goal> goalBag = new HashSet<Goal>();
    private final TreeSet<ProtoGrammar> synthesis;
    private int m_index = Integer.MAX_VALUE;
    private final int m_serialNumber;
    private final EXISchemaFactory m_schemaFactory;

    public ProtoGrammar(int n, EXISchemaFactory eXISchemaFactory) {
        this(n, null, eXISchemaFactory);
    }

    private ProtoGrammar(int n, TreeSet<ProtoGrammar> treeSet, EXISchemaFactory eXISchemaFactory) {
        this.synthesis = treeSet;
        this.m_serialNumber = n;
        this.m_schemaFactory = eXISchemaFactory;
    }

    private ProtoGrammar createSyntheticProtoGrammar() {
        return new ProtoGrammar(this.m_schemaFactory.protoGrammarSerial++, new TreeSet<ProtoGrammar>(), this.m_schemaFactory);
    }

    @Override
    public int compareTo(ProtoGrammar protoGrammar) {
        return this.m_serialNumber - protoGrammar.m_serialNumber;
    }

    @Override
    public final RightHandSide.RHSType getRHSType() {
        return RightHandSide.RHSType.GRAMMAR;
    }

    public int getIndex() {
        return this.m_index;
    }

    public Set<Goal> getGoalBag() {
        return this.goalBag;
    }

    public Substance[] getSubstances() {
        assert (this.linkedGrammars.size() == 0);
        return this.sortedSubstances.toArray(new Substance[0]);
    }

    public boolean hasGoal() {
        Iterator<Substance> iterator = this.sortedSubstances.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getRHSType() != RightHandSide.RHSType.GOAL) continue;
            return true;
        }
        return false;
    }

    final void normalize(Set<ProtoGrammar> set, ArrayList<ProtoGrammar> arrayList) {
        boolean bl;
        if (set.contains(this)) {
            return;
        }
        set.add(this);
        HashSet<ProtoGrammar> hashSet = new HashSet<ProtoGrammar>();
        do {
            bl = false;
            Object[] object = this.linkedGrammars.toArray();
            for (int i = 0; i < object.length; ++i) {
                ProtoGrammar protoGrammar = (ProtoGrammar)object[i];
                this.linkedGrammars.remove(protoGrammar);
                if (this == protoGrammar || hashSet.contains(protoGrammar)) continue;
                hashSet.add(protoGrammar);
                Iterator<Substance> iterator = protoGrammar.sortedSubstances.iterator();
                while (iterator.hasNext()) {
                    this.addSubstance(iterator.next(), arrayList);
                }
                if (!this.linkedGrammars.addAll(protoGrammar.linkedGrammars)) continue;
                bl = true;
            }
        } while (bl);
        for (Substance substance : this.sortedSubstances) {
            if (substance.getRHSType() != RightHandSide.RHSType.PROD) continue;
            ((Production)substance).getSubsequentGrammar().normalize(set, arrayList);
        }
    }

    void setIndex(int n) {
        this.m_index = n;
    }

    void appendProtoGrammar(ProtoGrammar protoGrammar) {
        this.linkedGrammars.add(protoGrammar);
    }

    void importGoals(ProtoGrammar protoGrammar) {
        Iterator<Goal> iterator = protoGrammar.goalBag.iterator();
        while (iterator.hasNext()) {
            this.goalBag.add(iterator.next());
        }
    }

    void entail(ProtoGrammar protoGrammar) {
        for (Goal goal : this.goalBag) {
            ProtoGrammar protoGrammar2 = goal.getOwnerGrammar();
            protoGrammar2.sortedSubstances.remove(goal);
            if (protoGrammar2 == protoGrammar) continue;
            protoGrammar2.linkedGrammars.add(protoGrammar);
        }
        this.goalBag.clear();
        if (this != protoGrammar) {
            this.importGoals(protoGrammar);
        }
    }

    void addSubstance(Substance substance, ArrayList<ProtoGrammar> arrayList) {
        for (Substance substance2 : this.sortedSubstances) {
            Object object;
            Object object2;
            int n;
            if (substance2.equals(substance)) {
                return;
            }
            if (substance2.getPriority() != substance.getPriority()) continue;
            Production production = (Production)substance2;
            Production production2 = (Production)substance;
            if (!production.getEvent().equals(production2.getEvent())) continue;
            assert (production.getParticleNumber() == production2.getParticleNumber());
            Event event = production.getEvent();
            assert (event.getEventType() != 7);
            if (event.getEventType() == 8) {
                return;
            }
            ProtoGrammar protoGrammar = production.getSubsequentGrammar();
            ProtoGrammar protoGrammar2 = production2.getSubsequentGrammar();
            assert (protoGrammar != protoGrammar2);
            if (protoGrammar.synthesis != null || protoGrammar2.synthesis != null) {
                if (protoGrammar.synthesis != null && protoGrammar2.synthesis == null) {
                    if (protoGrammar.synthesis.contains(protoGrammar2)) {
                        return;
                    }
                } else if (protoGrammar.synthesis == null && protoGrammar2.synthesis != null) {
                    if (protoGrammar2.synthesis.contains(protoGrammar)) {
                        this.sortedSubstances.remove(production);
                        this.sortedSubstances.add(production2);
                        return;
                    }
                } else {
                    int n2;
                    n = protoGrammar.synthesis.size() < protoGrammar2.synthesis.size() ? 1 : 0;
                    if (n != 0) {
                        object2 = protoGrammar;
                        protoGrammar = protoGrammar2;
                        protoGrammar2 = object2;
                    }
                    object = protoGrammar2.synthesis.toArray();
                    for (n2 = 0; n2 < ((Object[])object).length && protoGrammar.synthesis.contains(object[n2]); ++n2) {
                    }
                    if (n2 == ((Object[])object).length) {
                        if (n != 0) {
                            this.sortedSubstances.remove(production);
                            this.sortedSubstances.add(production2);
                        }
                        return;
                    }
                }
            }
            object2 = this.createSyntheticProtoGrammar();
            object2.appendProtoGrammar(protoGrammar);
            if (protoGrammar.synthesis != null) {
                object2.synthesis.addAll(protoGrammar.synthesis);
            } else {
                object2.synthesis.add(protoGrammar);
            }
            object2.appendProtoGrammar(protoGrammar2);
            if (protoGrammar2.synthesis != null) {
                object2.synthesis.addAll(protoGrammar2.synthesis);
            } else {
                object2.synthesis.add(protoGrammar2);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                object = arrayList.get(n);
                Iterator<ProtoGrammar> iterator = object2.synthesis.iterator();
                Iterator<ProtoGrammar> iterator2 = object.synthesis.iterator();
                int n3 = object2.synthesis.size();
                if (n3 != object.synthesis.size()) continue;
                int n4 = 0;
                while (iterator.hasNext() && iterator.next().m_serialNumber == iterator2.next().m_serialNumber) {
                    ++n4;
                }
                if (n4 != n3) continue;
                object2 = object;
                break;
            }
            if (n == arrayList.size()) {
                arrayList.add((ProtoGrammar)object2);
            }
            this.sortedSubstances.remove(production);
            this.sortedSubstances.add(new Production(production.getEvent(), (ProtoGrammar)object2, production.getParticleNumber()));
            return;
        }
        this.sortedSubstances.add(substance);
    }
}

