/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.openexi.proc.EXIDecoder;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.SchemaId;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.io.Base64BinaryValueScriber;
import org.openexi.proc.io.DateTimeValueScriber;
import org.openexi.proc.io.DateValueScriber;
import org.openexi.proc.io.FloatValueScriber;
import org.openexi.proc.io.GDayValueScriber;
import org.openexi.proc.io.GMonthDayValueScriber;
import org.openexi.proc.io.GMonthValueScriber;
import org.openexi.proc.io.GYearMonthValueScriber;
import org.openexi.proc.io.GYearValueScriber;
import org.openexi.proc.io.HexBinaryValueScriber;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.TimeValueScriber;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchema;
import org.openexi.schema.GrammarSchema;
import org.openexi.scomp.EXISchemaStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EXISchemaReader
extends EXISchemaStruct {
    private SchemaScanner m_scanner = null;
    private final Scribble m_scribble = new Scribble();
    private final ArrayList<Integer> m_grammarsInTypes = new ArrayList();
    private final ArrayList<Integer> m_typePositions = new ArrayList();
    private final ArrayList<Integer> m_gramPositions = new ArrayList();
    private final HashMap<Long, Integer> m_productionMap = new HashMap();
    private static final String ENCODED_FIXTURE_GRAMMARS = "FixtureGrammars.exi";
    private static final String ENCODED_FIXTURE_TYPES = "FixtureTypes.exi";
    private static final byte[] m_fixtureGrammarsBytes;
    private static final byte[] m_fixtureTypesBytes;

    @Override
    protected void reset() {
        super.reset();
        this.m_scanner = null;
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_grammarsInTypes.clear();
        this.m_typePositions.clear();
        this.m_gramPositions.clear();
        this.m_productionMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EXISchema parse(InputStream inputStream) throws IOException, EXIOptionsException {
        try {
            this.reset();
            EXIDecoder eXIDecoder = new EXIDecoder();
            eXIDecoder.setInputStream(inputStream);
            eXIDecoder.setGrammarCache(new GrammarCache(GrammarSchema.getEXISchema(), 1));
            Scanner scanner = eXIDecoder.processHeader();
            EXIOptions eXIOptions = scanner.getHeaderOptions();
            if (eXIOptions == null) {
                throw new RuntimeException();
            }
            SchemaId schemaId = eXIOptions.getSchemaId();
            if (schemaId == null) {
                throw new RuntimeException();
            }
            String string = schemaId.getValue();
            if (string != null) {
                if (!"nagasena:grammar".equals(string)) {
                    throw new RuntimeException();
                }
                if (!eXIOptions.isStrict()) {
                    throw new RuntimeException();
                }
            }
            this.m_scanner = SchemaScanner.newScanner(scanner);
            EventType eventType = this.expectStartElement("EXIGrammar");
            if (string != null && eventType.itemType != 11) {
                throw new RuntimeException();
            }
            EXISchema eXISchema = this.processEXIGrammar();
            return eXISchema;
        }
        finally {
            inputStream.close();
        }
    }

    private EXISchema processEXIGrammar() throws IOException {
        this.expectStartElement("StringTable");
        this.processStringTable();
        this.expectStartElement("Types");
        this.processTypes();
        this.expectStartElement("Elements");
        this.processElements();
        this.expectStartElement("Attributes");
        this.processAttributes();
        this.expectStartElement("Grammars");
        this.processGrammars();
        this.expectEndElement();
        for (int i = 0; i < this.m_grammarsInTypes.size(); ++i) {
            int n = this.m_grammarsInTypes.get(i);
            this.m_types[n] = this.m_gramPositions.get(this.m_types[n]);
        }
        return new EXISchema(this.m_elems, this.m_n_elems, this.m_attrs, this.m_n_attrs, this.m_types, this.m_n_types, this.m_uris, this.m_n_uris, this.m_names, this.m_n_names, this.m_localNames, this.m_strings, this.m_n_strings, this.m_ints, this.m_n_ints, this.m_mantissas, this.m_exponents, this.m_n_floats, this.m_decimals, this.m_n_decimals, this.m_integers, this.m_n_integers, this.m_longs, this.m_n_longs, this.m_datetimes, this.m_n_datetimes, this.m_durations, this.m_n_durations, this.m_binaries, this.m_n_binaries, this.m_variantTypes, this.m_variants, this.m_n_variants, this.m_grammars, this.m_n_grammars, this.m_grammarCount, this.m_productions, this.m_n_productions, this.m_eventTypes, this.m_eventData, this.m_n_events, this.m_n_stypes);
    }

    private void processStringTable() throws IOException {
        EventDescription eventDescription;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        while ((eventDescription = this.nextElement()) != null) {
            if (!"Namespace".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            this.doNamespace(arrayList);
        }
        this.expectEndElement();
        int n = arrayList.size();
        this.m_localNames = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.m_localNames[i] = arrayList.get(i);
        }
    }

    private void doNamespace(ArrayList<int[]> arrayList) throws IOException {
        EventDescription eventDescription;
        this.expectStartElement("Uri");
        String string = this.readStringContent();
        int n = this.internUri(string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while ((eventDescription = this.nextElement()) != null) {
            if (!"Name".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            arrayList2.add(this.readStringContent());
        }
        this.expectEndElement();
        int n2 = arrayList2.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList2.get(i);
            nArray[i] = this.internName(string2);
        }
        arrayList.add(n, nArray);
    }

    private void processTypes() throws IOException {
        int n;
        int n2;
        Object object;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            object = eventDescription.getName();
            if ("Typable".equals(object)) {
                block11: {
                    do {
                        n2 = this.readIntContent();
                        hashSet.add(n2);
                        eventDescription = this.nextElement();
                        if (eventDescription == null) break block11;
                    } while ("Typable".equals(eventDescription.getName()));
                    this.m_scanner.putBack(eventDescription);
                }
                this.m_scanner = new SchemaScannerFacade(this.m_scanner, m_fixtureTypesBytes);
            } else {
                this.m_scanner.putBack(eventDescription);
                if (!"AnyType".equals(object)) {
                    this.m_scanner = new SchemaScannerFacade(this.m_scanner, m_fixtureTypesBytes);
                }
            }
        } else {
            this.m_scanner = new SchemaScannerFacade(this.m_scanner, m_fixtureTypesBytes);
        }
        object = new ArrayList();
        n2 = 0;
        eventDescription = this.nextElement();
        if ("AnyType".equals(eventDescription.getName())) {
            n = this.doComplexType("http://www.w3.org/2001/XMLSchema", "anyType");
            assert (n == 0);
            this.m_types[n + 2] = n2++;
            this.m_grammarsInTypes.add(n + 4);
            this.m_typePositions.add(n);
            eventDescription = this.nextElement();
            if (eventDescription == null || !"AnySimpleType".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            n = this.doSimpleType("AnySimpleType", (ArrayList<Integer>)object, false);
            this.m_types[n + 2] = n2++;
            this.m_grammarsInTypes.add(n + 4);
            this.m_typePositions.add(n);
            while ((eventDescription = this.nextElement()) != null) {
                String string = eventDescription.getName();
                n = n2 == 0 || "ComplexType".equals(string) ? this.doComplexType() : this.doSimpleType(string, (ArrayList<Integer>)object, hashSet.contains(n2));
                this.m_types[n + 2] = n2++;
                this.m_grammarsInTypes.add(n + 4);
                this.m_typePositions.add(n);
            }
        }
        this.expectEndElement();
        n = ((ArrayList)object).size();
        for (int i = 0; i < n; ++i) {
            int n3 = (Integer)((ArrayList)object).get(i);
            this.m_types[n3] = this.m_typePositions.get(this.m_types[n3]);
        }
        ((ArrayList)object).clear();
    }

    private void doTypeCommon(int n, boolean bl) throws IOException {
        this.doTypeCommon(n, null, null, bl);
    }

    private void doTypeCommon(int n, String string, String string2, boolean bl) throws IOException {
        int n2;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription == null) {
            throw new RuntimeException();
        }
        if ("Uri".equals(eventDescription.getName())) {
            string = this.readStringContent();
            this.expectStartElement("Name");
            string2 = this.readStringContent();
            eventDescription = this.nextElement();
            if (eventDescription == null) {
                throw new RuntimeException();
            }
        }
        int n3 = -1;
        int n4 = -1;
        if (string2 != null) {
            assert (string != null);
            n4 = this.indexOfUri(string);
            if (n4 == -1) {
                throw new RuntimeException();
            }
            n3 = this.indexOfLocalName(string2, n4);
            if (n3 == -1) {
                throw new RuntimeException();
            }
        }
        this.m_types[n + 0] = n3;
        this.m_types[n + 1] = n4;
        boolean bl2 = bl;
        if ("Typable".equals(eventDescription.getName())) {
            bl2 = true;
            this.expectEndElement();
            eventDescription = this.nextElement();
            if (eventDescription == null) {
                throw new RuntimeException();
            }
        }
        int n5 = this.m_types[n + 3] = bl2 ? 1 : 0;
        if (!"Grammar".equals(eventDescription.getName())) {
            throw new RuntimeException();
        }
        this.m_types[n + 4] = n2 = this.readIntContent();
    }

    private int doComplexType() throws IOException {
        return this.doComplexType(null, null);
    }

    private int doComplexType(String string, String string2) throws IOException {
        assert (string2 == null && string == null || "anyType".equals(string2) && "http://www.w3.org/2001/XMLSchema".equals(string));
        int n = this.m_n_types;
        this.ensureTypes(6);
        this.m_n_types += 6;
        this.doTypeCommon(n, string, string2, false);
        int n2 = 0;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            if (!"ContentDatatype".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            n2 = this.readIntContent();
            n2 = this.m_typePositions.get(n2);
        }
        this.m_types[n + 5] = n2;
        this.expectEndElement();
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int doSimpleType(String var1_1, ArrayList<Integer> var2_2, boolean var3_3) throws IOException {
        block13: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    var4_4 = this.m_n_types;
                                    this.ensureTypes(8);
                                    this.m_n_types += 8;
                                    ++this.m_n_stypes;
                                    var6_5 = var4_4 + 6;
                                    if ("AnySimpleType".equals(var1_1)) {
                                        this.doTypeCommon(var4_4, "http://www.w3.org/2001/XMLSchema", "anySimpleType", var3_3);
                                        var5_6 = -1;
                                    } else {
                                        this.doTypeCommon(var4_4, var3_3);
                                        this.expectStartElement("BaseType");
                                        var5_6 = this.readIntContent();
                                        if (!EXISchemaReader.$assertionsDisabled && var5_6 <= 0) {
                                            throw new AssertionError();
                                        }
                                        var2_2.add(var6_5);
                                    }
                                    this.m_types[var6_5] = var5_6;
                                    var7_7 = -2147483648;
                                    var8_8 = 1;
                                    if (!"ListType".equals(var1_1)) break block12;
                                    var8_8 = 2;
                                    this.doListType(var4_4, var2_2);
                                    this.expectEndElement();
                                    break block13;
                                }
                                if (!"UnionType".equals(var1_1)) break block14;
                                var8_8 = 3;
                                this.expectEndElement();
                                break block13;
                            }
                            if (!"AnySimpleType".equals(var1_1)) break block15;
                            var8_8 = 0;
                            this.expectEndElement();
                            break block13;
                        }
                        if (!"StringType".equals(var1_1)) break block16;
                        var7_7 = this.doStringType(var4_4, var7_7);
                        var9_9 = this.nextElement();
                        if (var9_9 != null) {
                            if ("RestrictedCharset".equals(var9_9.getName())) {
                                var7_7 = this.doRestrictedCharset(var7_7);
                            } else {
                                this.m_scanner.putBack(var9_9);
                            }
                        }
                        ** GOTO lbl63
                    }
                    if (!"BooleanType".equals(var1_1)) break block17;
                    var7_7 = this.doBooleanType(var4_4, var7_7);
                    this.expectEndElement();
                    break block13;
                }
                if ("DecimalType".equals(var1_1)) ** GOTO lbl63
                if (!"IntegerType".equals(var1_1)) break block18;
                var7_7 = this.doIntegerType(var4_4, var7_7);
                ** GOTO lbl63
            }
            if ("FloatType".equals(var1_1) || "DurationType".equals(var1_1) || "DateTimeType".equals(var1_1) || "TimeType".equals(var1_1) || "DateType".equals(var1_1) || "GYearMonthType".equals(var1_1) || "GYearType".equals(var1_1) || "GMonthDayType".equals(var1_1) || "GDayType".equals(var1_1) || "GMonthType".equals(var1_1) || "HexBinaryType".equals(var1_1) || "Base64BinaryType".equals(var1_1) || "AnyURIType".equals(var1_1)) ** GOTO lbl63
            if ("QNameType".equals(var1_1)) {
                this.expectEndElement();
            } else {
                if (!EXISchemaReader.$assertionsDisabled) {
                    throw new AssertionError();
                }
lbl63:
                // 7 sources

                if ((var9_9 = this.nextElement()) != null) {
                    if ("Enumeration".equals(var9_9.getName())) {
                        this.doEnumerations();
                        var7_7 |= 4;
                    } else {
                        throw new RuntimeException();
                    }
                }
                this.expectEndElement();
            }
        }
        this.m_types[var4_4 + 5] = var7_7 |= var8_8;
        return var4_4;
    }

    private int doRestrictedCharset(int n) throws IOException {
        EventDescription eventDescription;
        int n2 = 0;
        while ((eventDescription = this.nextElement()) != null) {
            int n3;
            String string = eventDescription.getName();
            if ("StartChar".equals(string)) {
                n3 = this.readIntContent();
                eventDescription = this.nextElement();
                if (eventDescription == null || !"EndChar".equals(eventDescription.getName())) {
                    throw new RuntimeException();
                }
                int n4 = this.readIntContent();
                if (n4 < n3) {
                    throw new RuntimeException();
                }
                int n5 = n3;
                while (n5 <= n4) {
                    ++n2;
                    this.ensureTypes(1);
                    this.m_types[this.m_n_types++] = n5++;
                }
                continue;
            }
            if ("Char".equals(string)) {
                n3 = this.readIntContent();
                ++n2;
                this.ensureTypes(1);
                this.m_types[this.m_n_types++] = n3;
                continue;
            }
            throw new RuntimeException();
        }
        if (n2 == 0 || 255 < n2) {
            throw new RuntimeException();
        }
        this.expectEndElement();
        return n | n2 << 5;
    }

    private void doEnumerations() throws IOException {
        EventDescription eventDescription;
        this.ensureTypes(1);
        int n = this.m_n_types++;
        int n2 = 0;
        while ((eventDescription = this.nextElement()) != null) {
            byte[] byArray;
            int n3;
            String string;
            this.ensureTypes(1);
            ++this.m_n_types;
            String string2 = eventDescription.getName();
            if ("String".equals(string2)) {
                string = this.readStringContent();
                n3 = this.addVariantStringValue(string);
            } else if ("Integer".equals(string2)) {
                BigInteger bigInteger = this.readBigIntegerContent();
                n3 = this.doIntegralVariantValue(bigInteger, 0);
            } else if ("Decimal".equals(string2)) {
                BigDecimal bigDecimal = this.readBigDecimalContent();
                n3 = this.addVariantDecimalValue(bigDecimal);
            } else if ("Float".equals(string2)) {
                string = this.readStringContent();
                if (!FloatValueScriber.instance.doProcess(string, this.m_scribble, new StringBuilder())) {
                    throw new RuntimeException();
                }
                FloatValueScriber.canonicalizeValue((Scribble)this.m_scribble);
                n3 = this.addVariantFloatValue(FloatValueScriber.getMantissa((Scribble)this.m_scribble), FloatValueScriber.getExponent((Scribble)this.m_scribble));
            } else if ("Duration".equals(string2)) {
                string = this.readStringContent();
                n3 = this.addVariantDurationValue(EXISchema.datatypeFactory.newDuration(string));
            } else if ("DateTime".equals(string2)) {
                string = this.readStringContent();
                if (!DateTimeValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("Time".equals(string2)) {
                string = this.readStringContent();
                if (!TimeValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("Date".equals(string2)) {
                string = this.readStringContent();
                if (!DateValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("GYearMonth".equals(string2)) {
                string = this.readStringContent();
                if (!GYearMonthValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("GYear".equals(string2)) {
                string = this.readStringContent();
                if (!GYearValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("GMonthDay".equals(string2)) {
                string = this.readStringContent();
                if (!GMonthDayValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("GDay".equals(string2)) {
                string = this.readStringContent();
                if (!GDayValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("GMonth".equals(string2)) {
                string = this.readStringContent();
                if (!GMonthValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                n3 = this.addVariantDateTimeValue(this.m_scribble.dateTime);
            } else if ("HexBinary".equals(string2)) {
                string = this.readStringContent();
                if (!HexBinaryValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                int n4 = this.m_scribble.intValue1;
                byArray = new byte[n4];
                System.arraycopy(this.m_scribble.binaryValue, 0, byArray, 0, n4);
                n3 = this.addVariantBinaryValue(byArray, (byte)10);
            } else if ("Base64Binary".equals(string2)) {
                string = this.readStringContent();
                if (!Base64BinaryValueScriber.instance.process(string, -1, (EXISchema)null, this.m_scribble, (Scriber)null)) {
                    throw new RuntimeException();
                }
                int n5 = this.m_scribble.intValue1;
                byArray = new byte[n5];
                System.arraycopy(this.m_scribble.binaryValue, 0, byArray, 0, n5);
                n3 = this.addVariantBinaryValue(byArray, (byte)8);
            } else {
                throw new RuntimeException();
            }
            this.m_types[var4_4] = n3;
            ++n2;
        }
        if (n2 == 0) {
            throw new RuntimeException();
        }
        this.m_types[n] = n2;
        this.expectEndElement();
    }

    private int doStringType(int n, int n2) throws IOException {
        int n3 = 0;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            if ("Replace".equals(eventDescription.getName())) {
                n3 = 1;
                this.expectEndElement();
            } else if ("Collapse".equals(eventDescription.getName())) {
                n3 = 2;
                this.expectEndElement();
            } else {
                this.m_scanner.putBack(eventDescription);
            }
        }
        return n2 |= n3 << 3;
    }

    private void doListType(int n, ArrayList<Integer> arrayList) throws IOException {
        this.expectStartElement("ItemType");
        int n2 = this.readIntContent();
        int n3 = n + 7;
        this.m_types[n3] = n2;
        arrayList.add(n3);
    }

    private int doBooleanType(int n, int n2) throws IOException {
        boolean bl = false;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            if ("Patterned".equals(eventDescription.getName())) {
                bl = true;
                this.expectEndElement();
            } else {
                throw new RuntimeException();
            }
        }
        if (bl) {
            n2 |= 8;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIntegerType(int n, int n2) throws IOException {
        int n3 = 255;
        int n4 = -1;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            if ("NonNegative".equals(eventDescription.getName())) {
                n3 = 254;
                this.expectEndElement();
            } else if ("NBit".equals(eventDescription.getName())) {
                n3 = this.readIntContent();
                if (n3 < 0 || 12 < n3) {
                    throw new RuntimeException();
                }
                eventDescription = this.nextElement();
                if (eventDescription == null) throw new RuntimeException();
                if (!"MinInteger".equals(eventDescription.getName())) throw new RuntimeException();
                BigInteger bigInteger = this.readBigIntegerContent();
                n4 = this.doIntegralVariantValue(bigInteger, n3);
            } else {
                this.m_scanner.putBack(eventDescription);
            }
        }
        this.m_types[n + 7] = n4;
        return n2 |= n3 << 3;
    }

    private void processElements() throws IOException {
        EventDescription eventDescription;
        int n = -1;
        int n2 = -1;
        while ((eventDescription = this.nextElement()) != null) {
            String string = eventDescription.getName();
            if (n2 == -1 && !"Uri".equals(string)) {
                throw new RuntimeException();
            }
            if ("Uri".equals(string)) {
                String string2 = this.readStringContent();
                n2 = this.indexOfUri(string2);
                if (n2 == -1) {
                    throw new RuntimeException();
                }
                this.expectStartElement("Name");
                String string3 = this.readStringContent();
                n = this.indexOfLocalName(string3, n2);
                if (n != -1) continue;
                throw new RuntimeException();
            }
            if ("GlobalElement".equals(string)) {
                this.doElement(n2, n, true);
                continue;
            }
            if ("LocalElement".equals(string)) {
                this.doElement(n2, n, false);
                continue;
            }
            throw new RuntimeException();
        }
        this.expectEndElement();
    }

    private void doElement(int n, int n2, boolean bl) throws IOException {
        boolean bl2;
        int n3 = this.m_n_elems;
        this.ensureElems(4);
        this.m_n_elems += 4;
        this.m_elems[n3 + 0] = n2;
        this.m_elems[n3 + 1] = n;
        this.expectStartElement("Type");
        int n4 = this.readIntContent();
        int n5 = this.m_typePositions.get(n4);
        if (bl) {
            n5 = 0 - n5 - 1;
        }
        this.m_elems[n3 + 2] = n5;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            if (!"Nillable".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            bl2 = true;
            this.expectEndElement();
        } else {
            bl2 = false;
        }
        this.m_elems[n3 + 3] = bl2 ? 1 : 0;
        this.expectEndElement();
    }

    private void processAttributes() throws IOException {
        EventDescription eventDescription;
        int n = -1;
        int n2 = -1;
        while ((eventDescription = this.nextElement()) != null) {
            String string = eventDescription.getName();
            if (n2 == -1 && !"Uri".equals(string)) {
                throw new RuntimeException();
            }
            if ("Uri".equals(string)) {
                String string2 = this.readStringContent();
                n2 = this.indexOfUri(string2);
                if (n2 == -1) {
                    throw new RuntimeException();
                }
                this.expectStartElement("Name");
                String string3 = this.readStringContent();
                n = this.indexOfLocalName(string3, n2);
                if (n != -1) continue;
                throw new RuntimeException();
            }
            if ("GlobalAttribute".equals(string)) {
                this.doAttribute(n2, n, true);
                continue;
            }
            if ("LocalAttribute".equals(string)) {
                this.doAttribute(n2, n, false);
                continue;
            }
            throw new RuntimeException();
        }
        this.expectEndElement();
    }

    private void doAttribute(int n, int n2, boolean bl) throws IOException {
        int n3 = this.m_n_attrs;
        this.ensureAttrs(3);
        this.m_n_attrs += 3;
        this.m_attrs[n3 + 0] = n2;
        this.m_attrs[n3 + 1] = n;
        this.expectStartElement("Type");
        int n4 = this.readIntContent();
        int n5 = this.m_typePositions.get(n4);
        if (bl) {
            n5 = 0 - n5 - 1;
        }
        this.m_attrs[n3 + 2] = n5;
        this.expectEndElement();
    }

    private void processGrammars() throws IOException {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n3 = 0;
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            String string = eventDescription.getName();
            this.m_scanner.putBack(eventDescription);
            if (!"Fixture".equals(string)) {
                this.m_scanner = new SchemaScannerFacade(this.m_scanner, m_fixtureGrammarsBytes);
            }
        } else {
            this.m_scanner = new SchemaScannerFacade(this.m_scanner, m_fixtureGrammarsBytes);
        }
        while ((eventDescription = this.nextElement()) != null) {
            if (!"Grammar".equals(eventDescription.getName()) && !"Fixture".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            this.doGrammar(n3, arrayList, arrayList2);
            ++n3;
        }
        this.expectEndElement();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = arrayList.get(n2);
            this.m_grammars[n] = this.m_gramPositions.get(this.m_grammars[n]);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            n = arrayList2.get(n2);
            this.m_productions[n] = this.m_gramPositions.get(this.m_productions[n]);
        }
    }

    private void doGrammar(int n, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        EventDescription eventDescription;
        ++this.m_grammarCount;
        boolean bl = false;
        this.expectStartElement("Productions");
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        while ((eventDescription = this.nextElement()) != null) {
            String string = eventDescription.getName();
            if ("EndElement".equals(string)) {
                bl = true;
                this.expectEndElement();
                continue;
            }
            if ("AttributeWildcard".equals(string)) {
                n5 = -1;
                this.expectEndElement();
            } else if ("ElementWildcard".equals(string)) {
                n5 = -2;
                this.expectEndElement();
            } else if ("CharactersMixed".equals(string)) {
                n5 = -3;
                this.expectEndElement();
            } else if ("CharactersTyped".equals(string)) {
                n5 = -4;
                this.expectEndElement();
            } else if ("Attribute".equals(string)) {
                n4 = this.readIntContent();
                int n6 = 3 * n4;
                if (n6 < 0 || this.m_n_attrs <= n6) {
                    throw new RuntimeException();
                }
                n5 = this.addEvent((byte)0, n6);
            } else if ("Element".equals(string)) {
                n4 = this.readIntContent();
                int n7 = 4 * n4;
                if (n7 < 0 || this.m_n_elems <= n7) {
                    throw new RuntimeException();
                }
                n5 = this.addEvent((byte)1, n7);
            } else if ("AttributeWildcardNS".equals(string)) {
                String string2 = this.readStringContent();
                n5 = this.addEvent((byte)2, string2);
            } else if ("ElementWildcardNS".equals(string)) {
                String string3 = this.readStringContent();
                n5 = this.addEvent((byte)3, string3);
            } else {
                throw new RuntimeException();
            }
            eventDescription = this.nextElement();
            if (eventDescription == null || !"Grammar".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            n4 = this.readIntContent();
            if (n4 < 0) {
                throw new RuntimeException();
            }
            long l = (long)(n5 + 4) << 32 | (long)n4;
            Integer n8 = this.m_productionMap.get(l);
            if (n8 != null) {
                n3 = n8;
            } else {
                n3 = this.m_n_productions;
                this.ensureProduction();
                this.m_n_productions += 2;
                this.m_productionMap.put(l, n3);
                this.m_productions[n3 + 0] = n5;
                this.m_productions[n3 + 1] = n4;
                arrayList2.add(n3 + 1);
            }
            arrayList3.add(n3);
        }
        this.expectEndElement();
        boolean bl2 = false;
        n5 = 0;
        int n9 = -1;
        n4 = -1;
        eventDescription = this.nextElement();
        if (eventDescription != null) {
            if (!"ContentGrammar".equals(eventDescription.getName())) {
                throw new RuntimeException();
            }
            bl2 = true;
            n4 = this.readIntContent();
            eventDescription = this.nextElement();
            if (eventDescription != null) {
                if (!"EmptyGrammar".equals(eventDescription.getName())) {
                    throw new RuntimeException();
                }
                n5 = 1;
                n9 = this.readIntContent();
            }
        }
        assert (n5 == 0 || bl2);
        int n10 = this.m_n_grammars;
        n3 = 2;
        if (bl2) {
            ++n3;
            if (n5 != 0) {
                ++n3;
            }
        }
        int n11 = n10 + n3;
        int n12 = arrayList3.size();
        this.ensureGrammar(n3 += n12);
        this.m_n_grammars += n3;
        this.m_grammars[n10 + 0] = n;
        int n13 = n12;
        if (bl) {
            n13 |= 0x10000;
        }
        if (bl2) {
            n13 |= 0x20000;
            n2 = n10 + 2;
            this.m_grammars[n2] = n4;
            arrayList.add(n2);
            if (n5 != 0) {
                n13 |= 0x40000;
                int n14 = n10 + 3;
                this.m_grammars[n14] = n9;
                arrayList.add(n14);
            }
        }
        this.m_grammars[n10 + 1] = n13;
        n2 = 0;
        while (n2 < n12) {
            this.m_grammars[n11] = (Integer)arrayList3.get(n2);
            ++n2;
            ++n11;
        }
        this.m_gramPositions.add(n10);
        this.expectEndElement();
    }

    private EventType expectStartElement(String string) throws IOException {
        EventDescription eventDescription = this.nextElement();
        if (eventDescription == null || !string.equals(eventDescription.getName())) {
            throw new RuntimeException();
        }
        return eventDescription.getEventType();
    }

    private void expectEndElement() throws IOException {
        EventDescription eventDescription = this.nextElement();
        if (eventDescription != null) {
            throw new RuntimeException();
        }
        eventDescription = this.m_scanner.nextEvent();
        if (eventDescription.getEventKind() != 7) {
            throw new RuntimeException();
        }
    }

    private EventDescription nextElement() throws IOException {
        EventDescription eventDescription;
        block5: while ((eventDescription = this.m_scanner.nextEvent()) != null) {
            switch (eventDescription.getEventKind()) {
                case 6: {
                    Characters characters = eventDescription.getCharacters();
                    if (characters.length != 0) {
                        int n = characters.startIndex + characters.length;
                        for (int i = characters.startIndex; i < n; ++i) {
                            char c = characters.characters[i];
                            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                            throw new RuntimeException();
                        }
                    }
                }
                case 0: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    continue block5;
                }
                case 2: {
                    if (!"urn:publicid:nagasena".equals(eventDescription.getURI())) {
                        throw new RuntimeException();
                    }
                    return eventDescription;
                }
            }
            this.m_scanner.putBack(eventDescription);
            return null;
        }
        throw new RuntimeException();
    }

    private int readIntContent() throws IOException {
        return Integer.parseInt(this.readStringContent());
    }

    private BigInteger readBigIntegerContent() throws IOException {
        return new BigInteger(this.readStringContent());
    }

    private BigDecimal readBigDecimalContent() throws IOException {
        return new BigDecimal(this.readStringContent());
    }

    private String readStringContent() throws IOException {
        EventDescription eventDescription;
        String string = "";
        block5: while ((eventDescription = this.m_scanner.nextEvent()) != null) {
            switch (eventDescription.getEventKind()) {
                case 6: {
                    string = string + eventDescription.getCharacters().makeString();
                    continue block5;
                }
                case 7: {
                    return string;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    continue block5;
                }
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    static {
        int n;
        Object object;
        m_fixtureGrammarsBytes = new byte[40];
        m_fixtureTypesBytes = new byte[660];
        URL uRL = EXISchemaReader.class.getResource(ENCODED_FIXTURE_GRAMMARS);
        try {
            object = uRL.openConnection().getInputStream();
            int n2 = 0;
            while ((n = ((InputStream)object).read(m_fixtureGrammarsBytes, n2, m_fixtureGrammarsBytes.length - n2)) != -1) {
                if (n2 == m_fixtureGrammarsBytes.length) {
                    throw new RuntimeException("m_fixtureGrammarsBytes size is too small.");
                }
                n2 += n;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        object = EXISchemaReader.class.getResource(ENCODED_FIXTURE_TYPES);
        try {
            int n3;
            InputStream inputStream = ((URL)object).openConnection().getInputStream();
            n = 0;
            while ((n3 = inputStream.read(m_fixtureTypesBytes, n, m_fixtureTypesBytes.length - n)) != -1) {
                if (n == m_fixtureTypesBytes.length) {
                    throw new RuntimeException("m_fixtureTypesBytes size is too small.");
                }
                n += n3;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private final class SchemaScannerFacade
    extends SchemaScanner {
        private final Scanner m_fragmentScanner;
        private final SchemaScanner m_schemaScanner;

        SchemaScannerFacade(SchemaScanner schemaScanner, byte[] byArray) {
            this.m_schemaScanner = schemaScanner;
            EXIDecoder eXIDecoder = new EXIDecoder();
            eXIDecoder.setInputStream((InputStream)new ByteArrayInputStream(byArray));
            Scanner scanner = null;
            try {
                eXIDecoder.setGrammarCache(new GrammarCache(GrammarSchema.getEXISchema(), 1));
                eXIDecoder.setFragment(true);
                scanner = eXIDecoder.processHeader();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_fragmentScanner = scanner;
            try {
                EventDescription eventDescription = this.m_fragmentScanner.nextEvent();
                assert (eventDescription.getEventKind() == 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public EventDescription nextEvent() throws IOException {
            if (this.event != null) {
                EventDescription eventDescription = this.event;
                this.event = null;
                return eventDescription;
            }
            EventDescription eventDescription = this.m_fragmentScanner.nextEvent();
            if (eventDescription != null && eventDescription.getEventKind() != 1) {
                return eventDescription;
            }
            return this.m_schemaScanner.nextEvent();
        }
    }

    private static abstract class SchemaScanner {
        public EventDescription event = null;

        SchemaScanner() {
        }

        public abstract EventDescription nextEvent() throws IOException;

        public final void putBack(EventDescription eventDescription) {
            assert (this.event == null);
            this.event = eventDescription;
        }

        public static SchemaScanner newScanner(final Scanner scanner) {
            return new SchemaScanner(){
                private final Scanner m_scanner;
                {
                    this.m_scanner = scanner;
                }

                public EventDescription nextEvent() throws IOException {
                    if (this.event != null) {
                        EventDescription eventDescription = this.event;
                        this.event = null;
                        return eventDescription;
                    }
                    return this.m_scanner.nextEvent();
                }
            };
        }
    }
}

