/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.exi.xsd.regex.jdk1_4;

import com.thaiopensource.exi.util.Utf16;
import com.thaiopensource.exi.xsd.regex.RegexSyntaxException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Translator {
    private final String regExp;
    private int pos = 0;
    private final int length;
    private char curChar;
    private boolean eos = false;
    private static final int NONBMP_MAX = 0x10FFFF;
    protected static final char EOS = '\u0000';

    protected Translator(String string) {
        this.regExp = string;
        this.length = string.length();
    }

    public static List<SimpleCharClass> translate(String string) throws RegexSyntaxException {
        Translator translator = new Translator(string);
        return Translator._translate(translator);
    }

    protected static List<SimpleCharClass> _translate(Translator translator) throws RegexSyntaxException {
        CharClass charClass = translator.translateTop();
        return charClass.toRanges();
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
            switch (this.curChar) {
                default: 
            }
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private CharClass translateTop() throws RegexSyntaxException {
        this.advance();
        CharClass charClass = this.translateRegExp(new CharClassHolder());
        if (!this.eos) {
            throw this.makeException("expected_eos");
        }
        return charClass;
    }

    private CharClass translateRegExp(CharClassHolder charClassHolder) throws RegexSyntaxException {
        CharClass charClass = this.translateBranch(charClassHolder);
        if (this.curChar != '|') {
            return charClass;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        arrayList.add(charClass);
        do {
            this.advance();
            charClass = this.translateBranch(charClassHolder);
            arrayList.add(charClass);
        } while (this.curChar == '|');
        return new Union(arrayList);
    }

    private CharClass translateBranch(CharClassHolder charClassHolder) throws RegexSyntaxException {
        if (!this.translateAtom(charClassHolder)) {
            return charClassHolder.cc;
        }
        this.translateQuantifier();
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        arrayList.add(charClassHolder.cc);
        while (this.translateAtom(charClassHolder)) {
            this.translateQuantifier();
            arrayList.add(charClassHolder.cc);
        }
        return new Union(arrayList);
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.advance();
                break;
            }
            case '{': {
                this.advance();
                this.translateQuantity();
                this.expect('}');
                this.advance();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String string = this.parseQuantExact();
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.curChar == ',') {
                this.advance();
                if (this.curChar != '}') {
                    String string2 = this.parseQuantExact();
                    try {
                        int n2 = Integer.parseInt(string2);
                        if (n < 0 || n2 < n) {
                            throw this.makeException("invalid_quantity_range");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n >= 0 || new BigDecimal(string).compareTo(new BigDecimal(string2)) <= 0) break block7;
                        throw this.makeException("invalid_quantity_range");
                    }
                }
            }
        }
    }

    private String parseQuantExact() throws RegexSyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected_digit");
            }
            stringBuffer.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return stringBuffer.toString();
    }

    private boolean translateAtom(CharClassHolder charClassHolder) throws RegexSyntaxException {
        charClassHolder.cc = null;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                return false;
            }
            case '(': {
                this.advance();
                charClassHolder.cc = this.translateRegExp(charClassHolder);
                this.expect(')');
                this.advance();
                return true;
            }
            case '\\': {
                this.advance();
                charClassHolder.cc = this.parseCharClassEsc();
                return true;
            }
            case '[': {
                this.advance();
                charClassHolder.cc = this.parseCharClassExpr();
                return true;
            }
            case '.': {
                charClassHolder.cc = new CharRange(0, 0x10FFFF);
                break;
            }
            case '$': 
            case '^': {
                charClassHolder.cc = new SingleChar(this.curChar);
                break;
            }
            default: {
                if (Translator.isRegExpMetaChar(this.curChar)) {
                    return false;
                }
                charClassHolder.cc = new SingleChar(this.curChar);
            }
        }
        this.advance();
        return true;
    }

    private CharClass parseCharClassEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar(10);
            }
            case 'r': {
                this.advance();
                return new SingleChar(13);
            }
            case 't': {
                this.advance();
                return new SingleChar(9);
            }
            case 'C': 
            case 'I': 
            case 'c': 
            case 'i': {
                throw new RegexSyntaxException("\\" + this.curChar + " was used.");
            }
            case 's': {
                this.advance();
                return new Union(new SimpleCharClass[]{new SingleChar(9), new SingleChar(10), new SingleChar(13), new SingleChar(32)});
            }
            case 'D': 
            case 'P': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'p': 
            case 'w': {
                throw new RegexSyntaxException("\\" + this.curChar + " was used.");
            }
            case '-': 
            case '^': {
                break;
            }
            default: {
                if (Translator.isRegExpMetaChar(this.curChar)) break;
                throw this.makeException("bad_escape");
            }
        }
        SingleChar singleChar = new SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    protected static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    protected void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        do {
            charClass = this.parseCharClassEscOrXmlChar();
            if (this.curChar == '-') {
                this.advance();
                if (this.curChar == '[') {
                    arrayList.add(charClass);
                    break;
                }
                CharClass charClass2 = this.parseCharClassEscOrXmlChar();
                if (charClass.singleChar() < 0 || charClass2.singleChar() < 0) {
                    throw this.makeException("multi_range");
                }
                if (charClass.singleChar() > charClass2.singleChar()) {
                    throw this.makeException("invalid_range");
                }
                arrayList.add(new CharRange(charClass.singleChar(), charClass2.singleChar()));
                if (this.curChar != '-') continue;
                this.advance();
                this.expect('[');
                break;
            }
            arrayList.add(charClass);
        } while (this.curChar != ']');
        charClass = arrayList.size() == 1 ? (CharClass)arrayList.get(0) : new Union(arrayList);
        if (bl) {
            charClass = new Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return charClass;
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        SingleChar singleChar;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseCharClassEsc();
            }
            case '-': 
            case '[': 
            case ']': {
                throw this.makeException("should_quote", new String(new char[]{this.curChar}));
            }
        }
        if (Utf16.isSurrogate(this.curChar)) {
            if (!Utf16.isSurrogate1(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            char c = this.curChar;
            this.advance();
            if (!Utf16.isSurrogate2(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            singleChar = new SingleChar(Utf16.scalarValue(c, this.curChar));
        } else {
            singleChar = new SingleChar(this.curChar);
        }
        this.advance();
        return singleChar;
    }

    protected RegexSyntaxException makeException(String string) {
        return new RegexSyntaxException(string, this.pos - 1);
    }

    protected RegexSyntaxException makeException(String string, String string2) {
        return new RegexSyntaxException(string + " \"" + string2 + "\"", this.pos - 1);
    }

    static boolean isJavaMetaChar(int n) {
        switch (n) {
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRegExpMetaChar(int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static SimpleCharClass createSimpleCharClass(int n, int n2) {
        if (n == n2) {
            return new SingleChar(n);
        }
        assert (n < n2);
        return new CharRange(n, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Complement
    extends CharClass {
        private final ArrayList<SimpleCharClass> ranges;

        Complement(CharClass charClass) {
            this.ranges = this.outputChars(charClass);
        }

        final ArrayList<SimpleCharClass> toRanges() {
            return this.ranges;
        }

        private ArrayList<SimpleCharClass> outputChars(CharClass charClass) {
            SimpleCharClass simpleCharClass;
            List<SimpleCharClass> list = charClass.toRanges();
            ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>();
            int n = list.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                SimpleCharClass simpleCharClass2 = list.get(i);
                int n3 = simpleCharClass2.getMin();
                if (n2 != n3) {
                    assert (n2 < n3);
                    int n4 = n3 - 1;
                    simpleCharClass = Translator.createSimpleCharClass(n2, n4);
                    arrayList.add(simpleCharClass);
                }
                n2 = simpleCharClass2.getMax() + 1;
            }
            if (n2 <= 0x10FFFF) {
                if (n2 == 0x10FFFF) {
                    simpleCharClass = new SingleChar(n2);
                } else {
                    assert (n2 < 0x10FFFF);
                    simpleCharClass = new CharRange(n2, 0x10FFFF);
                }
                arrayList.add(simpleCharClass);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Union
    extends CharClass {
        private final ArrayList<SimpleCharClass> ranges;

        Union(SimpleCharClass[] simpleCharClassArray) {
            this.ranges = new ArrayList();
            for (int i = 0; i < simpleCharClassArray.length; ++i) {
                this.ranges.add(simpleCharClassArray[i]);
            }
        }

        Union(List<CharClass> list) {
            ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>();
            for (int i = 0; i < list.size(); ++i) {
                CharClass charClass = list.get(i);
                List<SimpleCharClass> list2 = charClass.toRanges();
                for (int j = 0; j < list2.size(); ++j) {
                    arrayList.add(list2.get(j));
                }
            }
            this.ranges = arrayList;
        }

        @Override
        final List<SimpleCharClass> toRanges() {
            TreeSet<SimpleCharClass> treeSet = new TreeSet<SimpleCharClass>();
            for (int i = 0; i < this.ranges.size(); ++i) {
                treeSet.add(this.ranges.get(i));
            }
            ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>();
            SimpleCharClass simpleCharClass = null;
            for (SimpleCharClass simpleCharClass2 : treeSet) {
                int n;
                if (simpleCharClass == null) {
                    simpleCharClass = simpleCharClass2;
                    continue;
                }
                int n2 = simpleCharClass.getMin();
                if (n2 == (n = simpleCharClass2.getMin())) {
                    assert (simpleCharClass.getMax() >= simpleCharClass2.getMax());
                    continue;
                }
                assert (n2 < n);
                int n3 = simpleCharClass.getMax();
                if (n3 < n) {
                    arrayList.add(simpleCharClass);
                    simpleCharClass = simpleCharClass2;
                    continue;
                }
                int n4 = simpleCharClass2.getMax();
                simpleCharClass = Translator.createSimpleCharClass(n2, n3 < n4 ? n4 : n3);
            }
            if (simpleCharClass != null) {
                arrayList.add(simpleCharClass);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Subtraction
    extends CharClass {
        private ArrayList<SimpleCharClass> ranges;

        Subtraction(CharClass charClass, CharClass charClass2) {
            List<SimpleCharClass> list = charClass.toRanges();
            List<SimpleCharClass> list2 = charClass2.toRanges();
            this.ranges = this.outputChars(list, list2);
        }

        final ArrayList<SimpleCharClass> toRanges() {
            return this.ranges;
        }

        ArrayList<SimpleCharClass> outputChars(List<SimpleCharClass> list, List<SimpleCharClass> list2) {
            int n = list2.size();
            int n2 = list.size();
            ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>();
            if (n2 == 0) {
                return arrayList;
            }
            int n3 = 0;
            SimpleCharClass simpleCharClass = list.get(n3++);
            int n4 = simpleCharClass.getMin();
            int n5 = simpleCharClass.getMax();
            int n6 = 0;
            while (n6 < n && simpleCharClass != null) {
                SimpleCharClass simpleCharClass2 = list2.get(n6);
                int n7 = simpleCharClass2.getMin();
                int n8 = simpleCharClass2.getMax();
                if (n4 < n7) {
                    if (n5 < n7) {
                        arrayList.add(Translator.createSimpleCharClass(n4, n5));
                        simpleCharClass = n3 < n2 ? list.get(n3++) : null;
                        if (simpleCharClass == null) continue;
                        n4 = simpleCharClass.getMin();
                        n5 = simpleCharClass.getMax();
                        continue;
                    }
                    arrayList.add(Translator.createSimpleCharClass(n4, n7 - 1));
                    if (n5 <= n8) {
                        if (n5 == n8) {
                            ++n6;
                        }
                        if ((simpleCharClass = n3 < n2 ? list.get(n3++) : null) == null) continue;
                        n4 = simpleCharClass.getMin();
                        n5 = simpleCharClass.getMax();
                        continue;
                    }
                    ++n6;
                    n4 = n8 + 1;
                    continue;
                }
                if (n7 < n4) {
                    if (n4 < n8) {
                        if (n8 < n5) {
                            ++n6;
                            n4 = n8 + 1;
                            continue;
                        }
                        if (n5 == n8) {
                            ++n6;
                        }
                        if ((simpleCharClass = n3 < n2 ? list.get(n3++) : null) == null) continue;
                        n4 = simpleCharClass.getMin();
                        n5 = simpleCharClass.getMax();
                        continue;
                    }
                    if (n8 < n4) {
                        ++n6;
                        continue;
                    }
                    if (n4 < n5) {
                        n4 = n8 + 1;
                    } else {
                        SimpleCharClass simpleCharClass3 = simpleCharClass = n3 < n2 ? list.get(n3++) : null;
                        if (simpleCharClass != null) {
                            n4 = simpleCharClass.getMin();
                            n5 = simpleCharClass.getMax();
                        }
                    }
                    ++n6;
                    continue;
                }
                if (n8 < n5) {
                    ++n6;
                    n4 = n8 + 1;
                    continue;
                }
                if (n5 > n8) continue;
                if (n5 == n8) {
                    ++n6;
                }
                if ((simpleCharClass = n3 < n2 ? list.get(n3++) : null) == null) continue;
                n4 = simpleCharClass.getMin();
                n5 = simpleCharClass.getMax();
            }
            if (simpleCharClass != null) {
                arrayList.add(Translator.createSimpleCharClass(n4, n5));
                while (n3 < n2) {
                    simpleCharClass = list.get(n3++);
                    arrayList.add(Translator.createSimpleCharClass(simpleCharClass.getMin(), simpleCharClass.getMax()));
                }
            }
            return arrayList;
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int n, int n2) {
            this.lower = n;
            this.upper = n2;
        }

        int getMin() {
            return this.lower;
        }

        int getMax() {
            return this.upper;
        }

        int getCharacterCount() {
            return this.upper - this.lower + 1;
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final int c;

        SingleChar(int n) {
            this.c = n;
        }

        public int singleChar() {
            return this.c;
        }

        public int getMin() {
            return this.c;
        }

        public int getMax() {
            return this.c;
        }

        public int getCharacterCount() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SimpleCharClass
    extends CharClass
    implements Comparable {
        SimpleCharClass() {
        }

        abstract int getMin();

        abstract int getMax();

        abstract int getCharacterCount();

        @Override
        final List<SimpleCharClass> toRanges() {
            ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>();
            arrayList.add(this);
            return arrayList;
        }

        public final int compareTo(Object object) {
            int n;
            int n2;
            SimpleCharClass simpleCharClass = (SimpleCharClass)object;
            int n3 = this.getMin();
            if (n3 < (n2 = simpleCharClass.getMin())) {
                return -1;
            }
            if (n3 != n2) {
                return 1;
            }
            int n4 = this.getMax();
            if (n4 > (n = simpleCharClass.getMax())) {
                return -1;
            }
            if (n4 < n) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class CharClass {
        CharClass() {
        }

        abstract List<SimpleCharClass> toRanges();

        public int singleChar() {
            return -1;
        }
    }

    private static class CharClassHolder {
        CharClass cc;

        private CharClassHolder() {
        }
    }
}

