/*
 * Decompiled with CFR 0.152.
 */
package faxma.test;

import fc.fp.syxaw.util.Log;
import fc.fp.syxaw.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xas.XmlWriter;
import fc.fp.util.xmlr.MutableRefTreeImpl;
import fc.fp.util.xmlr.NodeNotFoundException;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTreeNodeImpl;
import fc.fp.util.xmlr.RefTrees;
import fc.fp.util.xmlr.XasSerialization;
import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DirTreeGenerator {
    public static final int NO_VERSION = -1;
    private static final long RND_SEED = 42L;
    private static Random rndz = new Random(42L);
    public static long idGen = 0L;
    public static final String ROOT_ID = String.valueOf(idGen);

    public static void permutateTree(fc.fp.util.xmlr.MutableRefTree t, long ops, String pdf, double deleteTreeProb, Random rnd) {
        TreeSet<String> treeNodes = new TreeSet<String>(new Comparator(rnd){
            final int seed;
            {
                this.seed = random.nextInt();
            }

            public boolean equals(Object o1, Object o2) {
                return this.compare(o1, o2) == 0;
            }

            public int compare(Object o1, Object o2) {
                return (o1.hashCode() ^ this.seed) - (o2.hashCode() ^ this.seed);
            }
        });
        DirTreeGenerator.treeSet(t, t.getRoot(), treeNodes, '+');
        Object pos = treeNodes.last();
        int redos = 0;
        boolean redo = false;
        char op = 'Q';
        while (ops > 0L) {
            RefTreeNode rndNode;
            op = redo ? op : (char)pdf.charAt(rnd.nextInt(pdf.length()));
            redo = false;
            String rndId = (String)pos;
            RefTreeNode rndDirNode = rndNode = t.getNode(rndId);
            int dscan = treeNodes.size();
            while (((DirNodeContent)rndDirNode.getContent()).getType() == 3) {
                pos = DirTreeGenerator.nextPos(pos, treeNodes);
                rndDirNode = t.getNode((String)pos);
                if (--dscan >= 0) continue;
                Log.log((String)"No dir found", (int)0);
            }
            String nId = DirTreeGenerator.nextId();
            try {
                block2 : switch (op) {
                    case 'i': {
                        t.insert(rndDirNode.getId(), nId, (Object)new DirNodeContent(nId, DirTreeGenerator.fileName(nId, rnd), 3));
                        treeNodes.add(nId);
                        break;
                    }
                    case 'I': {
                        t.insert(rndDirNode.getId(), nId, (Object)new DirNodeContent(nId, DirTreeGenerator.dirName(nId, rnd), 2));
                        treeNodes.add(nId);
                        break;
                    }
                    case 'd': {
                        Iterator i = rndNode.getChildIterator();
                        while (i.hasNext() && (rndNode = (RefTreeNode)i.next()) == null) {
                        }
                        while (rnd.nextDouble() < deleteTreeProb) {
                            rndNode = rndNode.getParent();
                        }
                        if (rndNode == null || ROOT_ID.equals(rndNode.getId())) break;
                        HashSet deletia = new HashSet();
                        DirTreeGenerator.treeSet(t, rndNode, deletia, '+');
                        try {
                            t.delete(rndNode.getId());
                        }
                        catch (IllegalArgumentException ex) {
                            Log.log((String)"Ignoring ChangeTree delete bug", (int)4);
                            break;
                        }
                        DirTreeGenerator.treeSet(t, rndNode, treeNodes, '-');
                        break;
                    }
                    case 'u': {
                        DirNodeContent c = (DirNodeContent)rndNode.getContent();
                        String newName = c.getType() == 3 ? DirTreeGenerator.fileName(DirTreeGenerator.nextId(), rnd) : DirTreeGenerator.dirName(DirTreeGenerator.nextId(), rnd);
                        DirNodeContent nc = new DirNodeContent(c);
                        nc.setName(newName);
                        t.update(rndNode.getId(), (Object)nc);
                        break;
                    }
                    case 'm': {
                        String moveNode = (String)treeNodes.first();
                        if (ROOT_ID.equals(moveNode)) {
                            redo = true;
                            break;
                        }
                        RefTreeNode newParent = rndDirNode;
                        while (newParent != null) {
                            if (newParent.getId().equals(moveNode)) {
                                redo = true;
                                break block2;
                            }
                            newParent = newParent.getParent();
                        }
                        t.move(moveNode, rndDirNode.getId());
                        break;
                    }
                    default: {
                        Log.log((String)("Invalid op " + op), (int)0);
                    }
                }
                if (redo) {
                    ++ops;
                    if (++redos > 10) {
                        redo = false;
                        redos = 0;
                        Log.log((String)"10 redos failed, giving up", (int)5);
                    }
                }
                pos = DirTreeGenerator.nextPos(pos, treeNodes);
            }
            catch (NodeNotFoundException ex) {
                Log.log((String)"Selected nonexisting node", (int)2);
            }
            --ops;
        }
    }

    private static void treeSet(fc.fp.util.xmlr.MutableRefTree t, RefTreeNode root, Set s, char op) {
        switch (op) {
            case '+': {
                s.add(root.getId());
                break;
            }
            case '-': {
                s.remove(root.getId());
                break;
            }
            default: {
                Log.log((String)("Invalid op " + op), (int)0);
            }
        }
        Iterator i = root.getChildIterator();
        while (i.hasNext()) {
            DirTreeGenerator.treeSet(t, (RefTreeNode)i.next(), s, op);
        }
    }

    public static MutableRefTree randomDirTree(long nodes, long nodesPerDir, double dirProb, double variance, double dirVariance, Random rnd) {
        String id = DirTreeGenerator.nextId();
        MutableRefTree t = new MutableRefTree(id, new DirNodeContent(id, null, 1));
        try {
            LinkedList<String> roots = new LinkedList<String>();
            roots.add(t.getRoot().getId());
            while (nodes > 0L && roots.size() > 0) {
                String nId;
                String parentId = (String)roots.removeFirst();
                long dents = (long)(rnd.nextGaussian() * variance) + nodesPerDir;
                dents = Math.max(1L, dents);
                long dirs = (long)(rnd.nextGaussian() * dirVariance + (double)dents * dirProb);
                long files = dents - (dirs = Math.max(1L, dirs));
                if (files + dirs > nodes) {
                    dirs = 0L;
                }
                if (files > nodes) {
                    files = nodes;
                }
                nodes -= dirs + files;
                while (dirs > 0L) {
                    nId = DirTreeGenerator.nextId();
                    t.insert(parentId, nId, new DirNodeContent(nId, DirTreeGenerator.dirName(nId, rnd), 2));
                    roots.addLast(nId);
                    --dirs;
                }
                while (files > 0L) {
                    nId = DirTreeGenerator.nextId();
                    t.insert(parentId, nId, new DirNodeContent(nId, DirTreeGenerator.fileName(nId, rnd), 3));
                    --files;
                }
            }
        }
        catch (NodeNotFoundException ex) {
            Log.log((String)"Tree construction error", (int)0, (Object)((Object)ex));
        }
        return t;
    }

    public static String fileName(String id, Random rnd) {
        String[] fnames = new String[]{"foo", "bar", "baz", "quup", "ding", "dong", "jabber", "wocky", "armadillo", "gnu", "gnat"};
        String[] exts = new String[]{"c", "java", "txt", "h", "doc", "xml", "gif", "jpg", "tmp", "class", "ps", "tex"};
        return String.valueOf(fnames[rnd.nextInt(fnames.length)]) + "-" + id + "." + exts[rnd.nextInt(exts.length)];
    }

    public static String dirName(String id, Random rnd) {
        String[] dnames = new String[]{"bin", "share", "doc", "linux", "src", "cache", "sbin", "home", "texmf"};
        return String.valueOf(dnames[rnd.nextInt(dnames.length)]) + "-" + id;
    }

    public static String nextId() {
        return String.valueOf(idGen++);
    }

    protected static Object nextPos(Object pos, SortedSet s) {
        try {
            SortedSet<Object> tmp = s.subSet(s.first(), pos);
            return tmp.size() == 0 ? s.last() : tmp.last();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return s.first();
        }
    }

    public static class DirNodeContent
    implements DirectoryEntry {
        private String id;
        private String name;
        private int type;

        public DirNodeContent() {
            this(null, null, -1);
        }

        public DirNodeContent(DirNodeContent src) {
            this.id = src.id;
            this.name = src.name;
            this.type = src.type;
        }

        public DirNodeContent(String aId, String aName, int aType) {
            this.id = aId;
            this.name = aName;
            this.type = aType;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            if (this.type == 1) {
                return null;
            }
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            return o instanceof DirectoryEntry && Util.equals((Object)((DirectoryEntry)o).getId(), (Object)this.getId()) && Util.equals((Object)((DirectoryEntry)o).getName(), (Object)this.getName()) && ((DirectoryEntry)o).getType() == this.getType();
        }

        public String getLocationId() {
            return "#lid#";
        }

        public String getNextId() {
            return "#nextid#";
        }

        public String getUid() {
            return "#uid#-" + this.getId();
        }

        public int getVersion() {
            return 0;
        }

        public String getLinkNextId() {
            return "#lnextid#";
        }

        public String getLinkUid() {
            return "#luid#";
        }

        public int getLinkVersion() {
            return 1;
        }

        public String getLinkId() {
            return this.id;
        }
    }

    public static class MutableRefTree
    extends MutableRefTreeImpl {
        private Map index = new HashMap();
        private RefTreeNodeImpl root = null;

        public MutableRefTree(String rootId, Object content) {
            this.root = new RefTreeNodeImpl(null, rootId, false, content);
            this.index.put(rootId, this.root);
        }

        public MutableRefTree(RefTree initTree) {
            this.root = (RefTreeNodeImpl)initTree.getRoot();
            this.init((RefTreeNode)this.root);
        }

        public RefTreeNode getNode(String id) {
            return (RefTreeNode)this.index.get(id);
        }

        public void delete(String id) throws NodeNotFoundException {
            RefTreeNodeImpl n = (RefTreeNodeImpl)this.index.get(id);
            if (n == null) {
                throw new NodeNotFoundException(id);
            }
            RefTreeNodeImpl p = (RefTreeNodeImpl)n.getParent();
            if (this.index.get(p.getId()) == null) {
                throw new NodeNotFoundException(id);
            }
            if (p == null) {
                this.root = null;
            } else {
                p.removeChild(n);
                this.index.remove(id);
            }
        }

        public void insert(String parentId, long pos, String newId, Object content) throws NodeNotFoundException {
            RefTreeNodeImpl n;
            if (content == null || pos != -1L) {
                Log.log((String)"Invalid op", (int)0);
            }
            if ((n = (RefTreeNodeImpl)this.index.get(parentId)) == null) {
                throw new NodeNotFoundException(parentId);
            }
            RefTreeNodeImpl newNode = new RefTreeNodeImpl((RefTreeNode)n, newId, false, content);
            if (this.index.put(newId, newNode) != null) {
                Log.log((String)"Duplicate id", (int)0);
            }
            n.addChild(newNode);
        }

        public void move(String nodeId, String parentId, long pos) throws NodeNotFoundException {
            RefTreeNodeImpl n;
            if (pos != -1L) {
                Log.log((String)"Invalid op", (int)0);
            }
            if ((n = (RefTreeNodeImpl)this.index.get(nodeId)) == null) {
                throw new NodeNotFoundException(nodeId);
            }
            RefTreeNodeImpl pNew = (RefTreeNodeImpl)this.index.get(parentId);
            if (pNew == null) {
                throw new NodeNotFoundException(parentId);
            }
            RefTreeNodeImpl p = (RefTreeNodeImpl)n.getParent();
            if (p == null) {
                Log.log((String)"Tried to move root", (int)0);
            }
            p.removeChild(n);
            pNew.addChild(n);
        }

        public boolean update(String nodeId, Object content) throws NodeNotFoundException {
            RefTreeNodeImpl n;
            if (content == null) {
                Log.log((String)"Invalid op", (int)0);
            }
            if ((n = (RefTreeNodeImpl)this.index.get(nodeId)) == null) {
                throw new NodeNotFoundException(nodeId);
            }
            if (!content.equals(n.getContent())) {
                n.setContent(content);
                return true;
            }
            return false;
        }

        public RefTreeNode getRoot() {
            return this.root;
        }

        private void init(RefTreeNode root) {
            if (this.index.put(root.getId(), root) != null) {
                Log.log((String)"Duplicate ids", (int)0);
            }
            Iterator i = root.getChildIterator();
            while (i.hasNext()) {
                this.init((RefTreeNode)i.next());
            }
        }
    }

    public static interface DirectoryEntry
    extends RefTrees.IdentifiableContent {
        public static final int NONE = -1;
        public static final int TREE = 1;
        public static final int DIR = 2;
        public static final int FILE = 3;
        public static final XasCodec XAS_CODEC = new XasCodec();
        public static final XasCodec DEBUG_XAS_CODEC = new XasCodec(false);

        public String getId();

        public String getLocationId();

        public String getName();

        public String getNextId();

        public int getType();

        public String getUid();

        public int getVersion();

        public static class XasCodec
        implements XasSerialization.ContentCodec {
            protected boolean strict = true;
            public static final String TREE_TAG = "tree";
            public static final String DIR_TAG = "directory";
            public static final String FILE_TAG = "file";
            public static final String ID_ATTR = "id";
            public static final String NAME_ATTR = "name";
            public static final String LID_ATTR = "lid";
            public static final String UID_ATTR = "uid";
            public static final String NEXTID_ATTR = "nextid";
            public static final String VERSION_ATTR = "version";

            protected XasCodec() {
                this(true);
            }

            protected XasCodec(boolean strict) {
                this.strict = strict;
            }

            public RefTrees.IdentifiableContent startContent(XmlReader r) throws IOException {
                int type = -1;
                String id = null;
                String nextId = null;
                String locationId = null;
                String name = null;
                int version = -1;
                boolean readVersion = false;
                String uid = null;
                EventSequence es = r.currentDelimiter();
                if (es == null) {
                    throw new IOException("Expected directory element");
                }
                Enumeration en = es.events();
                while (en.hasMoreElements()) {
                    Event e = (Event)en.nextElement();
                    if (e.getType() == 2) {
                        String tString = e.getName();
                        if (TREE_TAG.equals(tString)) {
                            type = 1;
                            continue;
                        }
                        if (DIR_TAG.equals(tString)) {
                            type = 2;
                            continue;
                        }
                        if (FILE_TAG.equals(tString)) {
                            type = 3;
                            continue;
                        }
                        throw new IOException("Unknown tag: " + tString);
                    }
                    if (e.getType() != 3) continue;
                    String att = e.getName();
                    String val = e.getValue().toString();
                    if (ID_ATTR.equals(att)) {
                        id = val;
                        continue;
                    }
                    if (VERSION_ATTR.equals(att)) {
                        try {
                            version = Integer.parseInt(val);
                            readVersion = true;
                            continue;
                        }
                        catch (NumberFormatException x) {
                            throw new IOException("Invalid version: " + val);
                        }
                    }
                    if (NAME_ATTR.equals(att)) {
                        name = val;
                        continue;
                    }
                    if (LID_ATTR.equals(att)) {
                        locationId = val;
                        continue;
                    }
                    if (UID_ATTR.equals(att)) {
                        uid = val;
                        continue;
                    }
                    if (NEXTID_ATTR.equals(att)) {
                        nextId = val;
                        continue;
                    }
                    throw new IOException("Unknown attribute: " + att);
                }
                boolean[] isset = new boolean[]{id != null, nextId != null, locationId != null, name != null, readVersion, uid != null};
                if (type == -1 || !isset[0] || type == 1 && (!isset[1] || !isset[2] || isset[3] || isset[4] || isset[5]) || type == 3 && (isset[1] || isset[2] || !isset[3] || !isset[4] || !isset[5]) || type == 2 && (isset[1] || isset[2] || !isset[3] || isset[4] || isset[5])) {
                    throw new IOException("Too many/missing attributes for id " + id);
                }
                return new DirectoryEntryImpl(type, id, locationId, name, nextId, uid, version);
            }

            public void finishContent(Object c, XmlReader r) throws IOException {
                Event e;
                EventSequence es = r.currentDelimiter();
                Event event = e = es != null ? es.get(0) : null;
                if (e == null || e.getType() != 4) {
                    throw new IOException("Expected end of directory element");
                }
            }

            public void startObject(Object o, XmlWriter writer) throws IOException {
                if (!(o instanceof DirectoryEntry)) {
                    Log.log((String)("Wrong class " + o.getClass().getName()), (int)0);
                }
                DirectoryEntry n = (DirectoryEntry)o;
                switch (n.getType()) {
                    case 3: {
                        writer.addEvent(Event.createStartElement((String)"", (String)FILE_TAG));
                        writer.addEvent(Event.createAttribute((String)"", (String)ID_ATTR, (String)n.getId()));
                        writer.addEvent(Event.createAttribute((String)"", (String)NAME_ATTR, (String)n.getName()));
                        writer.addEvent(Event.createAttribute((String)"", (String)VERSION_ATTR, (String)String.valueOf(n.getVersion())));
                        writer.addEvent(Event.createAttribute((String)"", (String)UID_ATTR, (String)this.mshall(n.getUid())));
                        break;
                    }
                    case 2: {
                        writer.addEvent(Event.createStartElement((String)"", (String)DIR_TAG));
                        writer.addEvent(Event.createAttribute((String)"", (String)ID_ATTR, (String)n.getId()));
                        writer.addEvent(Event.createAttribute((String)"", (String)NAME_ATTR, (String)n.getName()));
                        break;
                    }
                    case 1: {
                        writer.addEvent(Event.createStartElement((String)"", (String)TREE_TAG));
                        writer.addEvent(Event.createAttribute((String)"", (String)ID_ATTR, (String)n.getId()));
                        writer.addEvent(Event.createAttribute((String)"", (String)LID_ATTR, (String)n.getLocationId()));
                        writer.addEvent(Event.createAttribute((String)"", (String)NEXTID_ATTR, (String)n.getNextId()));
                    }
                }
            }

            public void finishObject(Object o, XmlWriter writer) throws IOException {
                if (!(o instanceof DirectoryEntry)) {
                    Log.log((String)"Wrong class", (int)0);
                }
                DirectoryEntry n = (DirectoryEntry)o;
                switch (n.getType()) {
                    case 3: {
                        writer.addEvent(Event.createEndElement((String)"", (String)FILE_TAG));
                        break;
                    }
                    case 2: {
                        writer.addEvent(Event.createEndElement((String)"", (String)DIR_TAG));
                        break;
                    }
                    case 1: {
                        writer.addEvent(Event.createEndElement((String)"", (String)TREE_TAG));
                    }
                }
            }

            protected String mshall(String s) {
                if (s == null && !this.strict) {
                    return "";
                }
                return s;
            }
        }
    }

    public static class DirectoryEntryImpl
    implements DirectoryEntry {
        protected int type;
        protected String id;
        protected String name;
        protected String locationId;
        protected int version;
        protected String uid;
        protected String nextId;

        public int getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getLinkId() {
            return this.getId();
        }

        public String getLocationId() {
            return this.locationId;
        }

        public String getNextId() {
            return this.nextId;
        }

        public String getName() {
            return this.name;
        }

        public String getUid() {
            return this.uid;
        }

        public int getVersion() {
            return this.version;
        }

        public DirectoryEntryImpl(int aType, String aId, String aLocationId, String aName, String aNextId, String aUid, int aVersion) {
            this.type = aType;
            this.id = aId;
            this.locationId = aLocationId;
            this.name = aName;
            this.uid = aUid;
            this.version = aVersion;
            this.nextId = aNextId;
        }
    }
}

