/*
 * Decompiled with CFR 0.152.
 */
package faxma.benchmark;

import faxma.benchmark.BenchMark;
import fc.fp.syxaw.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import junit.framework.Assert;

public class UseCases
extends BenchMark {
    int ok = 0;
    int improv = 0;
    int worse = 0;
    int fail = 0;

    public UseCases(String[] args) {
        super(args);
    }

    public void run() throws IOException {
        TreeMap dirs = new TreeMap();
        File dbase = new File(this.workDir, "b.xml");
        File dnew = new File(this.workDir, "n.xml");
        File ddelta = new File(this.workDir, UseCases.getSetProperty("deltafile", "d.xml"));
        String initer = UseCases.getSetProperty("initer", null);
        System.out.println("Running " + this.getClass().getName() + " test...");
        UseCases.scanDataSets(dirs, new File(UseCases.getSetProperty("root", ".")), UseCases.getSetProperty("dirfilter", ".*(\\.|\\./tests).*"), UseCases.getSetProperty("conffile", "faxma\\.benchmark\\.UseCases"));
        block0: for (Map.Entry e : dirs.entrySet()) {
            List l = (List)e.getValue();
            if (l.size() < 1) continue;
            File dir = (File)e.getKey();
            System.setProperty("caseroot", dir.toString());
            File conffile = new File(dir, (String)l.get(0));
            Properties p = new Properties();
            FileInputStream cin = new FileInputStream(conffile);
            p.load(cin);
            cin.close();
            int test = 0;
            while (test < Integer.MAX_VALUE) {
                String pfx;
                String string = pfx = test == 0 ? "" : String.valueOf(String.valueOf(test)) + ".";
                if (p.getProperty(String.valueOf(pfx) + "basec") == null && p.getProperty(String.valueOf(pfx) + "base") == null) continue block0;
                System.setProperty("name", p.getProperty(String.valueOf(pfx) + "name"));
                int laps = UseCases.getSetProperty("laps", 1);
                this.getFile(p, String.valueOf(pfx) + "basec", dir, new File(""), "basecfile");
                this.getFile(p, String.valueOf(pfx) + "newc", dir, new File(""), "newcfile");
                File basef = this.getFile(p, String.valueOf(pfx) + "base", dir, dbase, "basefile");
                File newf = this.getFile(p, String.valueOf(pfx) + "new", dir, dnew, "newfile");
                File deltaf = this.getFile(p, String.valueOf(pfx) + "delta", dir, ddelta, "deltafile");
                if (initer != null) {
                    System.setProperty("mode", "init");
                    this.exec(initer, new String[0], false, null, Long.MAX_VALUE);
                }
                int lap = 0;
                while (lap < laps) {
                    System.setProperty("lap", "" + lap);
                    this.doDiff(basef, newf, deltaf);
                    ++lap;
                }
                ++test;
            }
        }
        System.out.println("--------------------------------------------------");
        System.out.println("Better\tOK\tWorse\tFail");
        System.out.println(this.improv + "\t" + this.ok + "\t" + this.worse + "\t" + this.fail);
        if (this.worse > 0 || this.fail > 0) {
            System.out.println("Result became worse, please do not check in.");
        }
        if (this.fail > 0) {
            Assert.fail((String)"Test failed due to new failures.");
        }
    }

    protected File getFile(Properties p, String prop, File propRoot, File defaultFile, String sysprop) {
        File f;
        String name = p.getProperty(prop);
        File file = f = name == null ? defaultFile : new File(propRoot, name.trim());
        if (f != null && sysprop != null) {
            System.setProperty(sysprop, f.toString());
        }
        return f;
    }

    protected void doDiff(File basef, File newf, File deltaf) throws IOException {
        String reporter = UseCases.getSetProperty("reporter", null);
        long now = System.currentTimeMillis();
        try {
            this.exec(UseCases.getSetProperty("differ", "!faxma.Diff"), new String[]{basef.toString(), newf.toString(), deltaf.toString()}, true, UseCases.getSetProperty("logfile", null), (long)(1000.0 * UseCases.getSetProperty("timeout", 1.0E9)));
        }
        catch (Exception ex) {
            ++this.fail;
            Log.log((String)"FAILED: ", (int)3, (Object)ex);
            return;
        }
        System.setProperty("lap.time", String.valueOf(System.currentTimeMillis() - now));
        if (reporter != null) {
            System.setProperty("mode", "report");
            this.exec(reporter, new String[0], false, null, Long.MAX_VALUE);
        }
        ++this.ok;
    }

    public static void scanDataSets(Map dirs, File root, String df, String ff) {
        if (root.isDirectory()) {
            File[] e = root.listFiles();
            int i = 0;
            while (i < e.length) {
                if (e[i].getPath().matches(df)) {
                    UseCases.scanDataSets(dirs, e[i], df, ff);
                }
                ++i;
            }
        } else if (root.getName().matches(ff)) {
            File dir = root.getParentFile();
            LinkedList<String> l = (LinkedList<String>)dirs.get(dir);
            if (l == null) {
                l = new LinkedList<String>();
                dirs.put(dir, l);
            }
            l.add(root.getName());
            Collections.sort(l);
        }
    }

    public static void main(String[] args) throws IOException {
        new UseCases(args).run();
    }
}

