/*
 * Decompiled with CFR 0.152.
 */
package faxma.benchmark;

import faxma.Patch;
import faxma.XmlUtil;
import faxma.benchmark.BenchMark;
import faxma.test.DirTreeGenerator;
import fc.fp.syxaw.util.Log;
import fc.fp.syxaw.util.Util;
import fc.fp.util.xas.DataEventSequence;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.EventStream;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xmlr.ChangeTree;
import fc.fp.util.xmlr.IdAddressableRefTree;
import fc.fp.util.xmlr.MutableRefTree;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTrees;
import fc.fp.util.xmlr.XasSerialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Random;

public class SynteticDirTree
extends BenchMark {
    public SynteticDirTree(String[] args) {
        super(args);
    }

    public void run() {
        long rndSeed = SynteticDirTree.getSetProperty("seed", 422);
        long DSIZE = SynteticDirTree.getSetProperty("dirsize", 5);
        double DPROB = SynteticDirTree.getSetProperty("dirp", 0.1);
        double DELTREEP = SynteticDirTree.getSetProperty("deltreep", 0.05);
        double VAR = SynteticDirTree.getSetProperty("var", 5.0);
        double DVAR = SynteticDirTree.getSetProperty("dvar", 2.0);
        Random rnd = new Random(rndSeed);
        int step = SynteticDirTree.getSetProperty("tree.step", 10);
        int tstart = SynteticDirTree.getSetProperty("tree.min", 50);
        int tend = SynteticDirTree.getSetProperty("tree.max", 1000);
        int tlaps = SynteticDirTree.getSetProperty("tree.laps", 1);
        int estep = SynteticDirTree.getSetProperty("edits.step", 10000000);
        int estart = SynteticDirTree.getSetProperty("edits.min", 10);
        int eend = SynteticDirTree.getSetProperty("edits.max", 1000);
        int eslice = SynteticDirTree.getSetProperty("edits.sliceatsize", -1);
        int enoslice = SynteticDirTree.getSetProperty("edits.notinslice", -1);
        String pdf = SynteticDirTree.getSetProperty("pdf", "dimu");
        String differ = SynteticDirTree.getSetProperty("differ", "!faxma.Diff");
        String patcher = SynteticDirTree.getSetProperty("patcher", "!faxma.Patch");
        String harvester = SynteticDirTree.getSetProperty("reporter", null);
        String baseName = SynteticDirTree.getSetProperty("basefile", "b.xml");
        String newName = SynteticDirTree.getSetProperty("newfile", "n.xml");
        String diffName = SynteticDirTree.getSetProperty("deltafile", "d.xml");
        String diffLogFile = SynteticDirTree.getSetProperty("difflog", null);
        boolean verify = Boolean.parseBoolean(SynteticDirTree.getSetProperty("verify", "true"));
        long timeout = (long)(1000.0 * SynteticDirTree.getSetProperty("timeout", 1.0E9));
        int tsize = tstart;
        while (tsize < tend) {
            int lap = 0;
            while (lap < tlaps) {
                int rtsize = tsize;
                DirTreeGenerator.MutableRefTree baset = DirTreeGenerator.randomDirTree(rtsize, DSIZE, DPROB, VAR, DVAR, new Random(rndSeed));
                ChangeTree dt = new ChangeTree((IdAddressableRefTree)baset);
                int realestart = eslice > 0 && tsize != eslice ? enoslice : estart;
                int realeend = eslice > 0 && tsize != eslice ? enoslice + 1 : eend;
                int realestep = eslice > 0 && tsize != eslice ? 1 : estep;
                int edits = realestart;
                while (edits < realeend) {
                    block14: {
                        try {
                            DirTreeGenerator.permutateTree((MutableRefTree)dt, edits, pdf, DELTREEP, rnd);
                        }
                        catch (Exception ex) {
                            Log.log((String)"Dirtree generator bombed; not computing this lap", (int)3, (Object)ex);
                            break block14;
                        }
                        File basef = null;
                        File newf = null;
                        File deltaf = null;
                        try {
                            basef = new File(this.workDir, baseName);
                            fc.fp.syxaw.util.XmlUtil.writeRefTree((RefTree)baset, (File)basef, (XasSerialization.ContentWriter)DirTreeGenerator.DirectoryEntry.XAS_CODEC);
                            newf = new File(this.workDir, newName);
                            fc.fp.syxaw.util.XmlUtil.writeRefTree((RefTree)dt, (File)newf, (XasSerialization.ContentWriter)DirTreeGenerator.DirectoryEntry.XAS_CODEC);
                            deltaf = new File(this.workDir, diffName);
                        }
                        catch (IOException ex) {
                            Log.log((String)"Error wrinting test trees", (int)2, (Object)ex);
                        }
                        long dstart = 0L;
                        long dend = -1L;
                        try {
                            if (deltaf.exists() && !deltaf.delete()) {
                                Log.log((String)("Cannot remove old " + deltaf), (int)3);
                            }
                            dstart = System.currentTimeMillis();
                            this.exec(differ, new String[]{basef.toString(), newf.toString(), deltaf.toString()}, true, diffLogFile, timeout);
                            dend = System.currentTimeMillis();
                            Log.log((String)("Done in " + (dend - dstart) + " msec"), (int)5);
                        }
                        catch (Exception ex) {
                            Log.log((String)"FAILED: ", (int)3, (Object)ex);
                        }
                        if (verify) {
                            this.verifyDiff(patcher, basef, newf, deltaf);
                        }
                        try {
                            System.setProperty("lap.time", String.valueOf(dend - dstart));
                            System.setProperty("lap.edits", String.valueOf(edits));
                            System.setProperty("lap.lap", String.valueOf(lap));
                            System.setProperty("lap.treesize", String.valueOf(tsize));
                            if (harvester != null) {
                                this.exec(harvester, new String[0], false, null, Long.MAX_VALUE);
                            }
                        }
                        catch (IOException ex) {
                            Log.log((String)"Reporter excepted", (int)3, (Object)ex);
                        }
                        dt.reset();
                    }
                    edits += realestep;
                }
                ++lap;
            }
            tsize += step;
        }
    }

    private void verifyDiff(String patcher, File basef, File newf, File deltaf) {
        FileInputStream vNewIn;
        FileInputStream vPatchIn;
        block13: {
            vPatchIn = null;
            vNewIn = null;
            try {
                try {
                    File patchf = new File(this.workDir, "p.xml");
                    if (patchf.exists() && !patchf.delete()) {
                        Log.log((String)("Cannot remove old " + patchf), (int)3);
                    }
                    this.exec(patcher, new String[]{basef.toString(), deltaf.toString(), patchf.toString()}, true, null, Long.MAX_VALUE);
                    vPatchIn = new FileInputStream(patchf);
                    TypedXmlParser ppr = fc.fp.syxaw.util.XmlUtil.getXmlParser((InputStream)vPatchIn);
                    DataEventSequence pes = new DataEventSequence((EventSequence)new EventStream(ppr));
                    Patch.TextAsNodeCC patchedXpCC = new Patch.TextAsNodeCC();
                    IdAddressableRefTree pT = RefTrees.getAddressableTree((RefTree)XmlUtil.readTree(new XmlReader((EventSequence)pes), (XasSerialization.ContentReader)patchedXpCC));
                    vNewIn = new FileInputStream(newf);
                    TypedXmlParser npr = fc.fp.syxaw.util.XmlUtil.getXmlParser((InputStream)vNewIn);
                    DataEventSequence nes = new DataEventSequence((EventSequence)new EventStream(npr));
                    IdAddressableRefTree nT = RefTrees.getAddressableTree((RefTree)XmlUtil.readTree(new XmlReader((EventSequence)nes), (XasSerialization.ContentReader)patchedXpCC));
                    SynteticDirTree.refTreeCmp(pT.getRoot(), nT.getRoot(), nT, null);
                }
                catch (IOException ex) {
                    Log.log((String)"Verify IOExcepted", (int)2, (Object)ex);
                }
                break block13;
            }
            catch (Throwable throwable) {
                try {
                    InputStream[] inputStreamArray = new InputStream[]{vPatchIn, vNewIn};
                    int n = 0;
                    int n2 = inputStreamArray.length;
                    while (n < n2) {
                        InputStream in = inputStreamArray[n];
                        if (in != null) {
                            in.close();
                        }
                        ++n;
                    }
                }
                catch (IOException ex1) {
                    Log.log((String)"Can't close a verify stream", (int)2, (Object)ex1);
                }
            }
            throw throwable;
        }
        try {
            InputStream[] inputStreamArray = new InputStream[]{vPatchIn, vNewIn};
            int n = 0;
            int n3 = inputStreamArray.length;
            while (n < n3) {
                InputStream in = inputStreamArray[n];
                if (in != null) {
                    in.close();
                }
                ++n;
            }
        }
        catch (IOException ex1) {
            Log.log((String)"Can't close a verify stream", (int)2, (Object)ex1);
        }
    }

    public static void refTreeCmp(RefTreeNode n1, RefTreeNode n2, IdAddressableRefTree base, String rtId) {
        Object c1 = n1.getContent();
        Object c2 = n2.getContent();
        if (n1.isNodeRef()) {
            RefTreeNode refd = base.getNode(n1.getId());
            if (refd == null) {
                Log.log((String)("Broken noderef " + n1.getId()), (int)2);
            }
            c1 = refd.getContent();
        } else if (n2.isNodeRef()) {
            Log.log((String)"May not have refs", (int)2);
        }
        if (!Util.equals((Object)c1, (Object)c2)) {
            if (rtId != null) {
                Log.log((String)("The following error occured when comparing in treeref " + rtId), (int)3);
            }
            String c1s = n1.isNodeRef() ? "#node ref " + n1.getId() : "" + ((XasSerialization.GenericContent)c1).getHead();
            Log.log((String)("Mismatching content \nP:" + c1s + "\nF:" + ((XasSerialization.GenericContent)c2).getHead()), (int)2);
        }
        Iterator i = n1.getChildIterator();
        Iterator j = n2.getChildIterator();
        while (i.hasNext() && j.hasNext()) {
            RefTreeNode cn1 = (RefTreeNode)i.next();
            RefTreeNode cn2 = (RefTreeNode)j.next();
            if (cn1.isTreeRef()) {
                RefTreeNode refd = base.getNode(cn1.getId());
                if (refd == null) {
                    Log.log((String)("Broken treeref " + cn1.getId()), (int)2);
                }
                SynteticDirTree.refTreeCmp(refd, cn2, base, cn1.getId());
            } else if (cn2.isTreeRef()) {
                Log.log((String)"May not have refs", (int)2);
            } else {
                SynteticDirTree.refTreeCmp(cn1, cn2, base, null);
            }
            if (i.hasNext() == j.hasNext()) continue;
            Log.log((String)"Differing child count", (int)2);
        }
    }

    public static void main(String[] args) {
        new SynteticDirTree(args).run();
    }
}

