/*
 * Decompiled with CFR 0.152.
 */
package faxma.benchmark;

import fc.fp.syxaw.util.Log;
import fc.fp.syxaw.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;

public class BenchMark {
    protected Properties setup = new Properties(System.getProperties());
    protected File workDir;

    public BenchMark(String[] settings) {
        try {
            String[] stringArray = settings;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String f = stringArray[n];
                FileInputStream fin = new FileInputStream(f);
                this.setup.load(fin);
                fin.close();
                ++n;
            }
            System.setProperties(this.setup);
        }
        catch (IOException ex) {
            Log.log((String)"Can't load settings", (int)2);
        }
        this.workDir = new File(this.setup.getProperty("workdir", "tmp"));
        if (!this.workDir.exists() && !this.workDir.mkdir()) {
            Log.log((String)("Cant create workdir " + this.workDir), (int)2);
        }
    }

    protected void exec(final String program, final String[] args, final boolean stderr, final String logFile, final long timeout) throws IOException {
        block21: {
            if (program.startsWith("!")) {
                try {
                    Class<?> pc = Class.forName(program.substring(1));
                    final Method main = pc.getMethod("main", String[].class);
                    OutputStream lout = System.out;
                    PrintStream ps = null;
                    PrintStream old = null;
                    try {
                        if (logFile != null) {
                            lout = new FileOutputStream(logFile);
                            ps = new PrintStream(lout);
                            ps.flush();
                            if (stderr) {
                                old = System.err;
                                System.setErr(ps);
                            } else {
                                old = System.out;
                                System.setOut(ps);
                            }
                        }
                        Thread runner = new Thread(){

                            public void run() {
                                try {
                                    main.invoke(null, new Object[]{args});
                                }
                                catch (InvocationTargetException ex) {
                                    if (ex.getCause() instanceof ThreadDeath) {
                                        Log.log((String)"Killed by timeout", (int)4);
                                    } else {
                                        Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                                    }
                                }
                                catch (IllegalArgumentException ex) {
                                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                                }
                                catch (IllegalAccessException ex) {
                                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                                }
                                catch (ThreadDeath ex) {
                                    Log.log((String)"Killed by timeout", (int)4);
                                }
                                catch (Throwable ex) {
                                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                                }
                            }
                        };
                        runner.start();
                        Thread.yield();
                        long now = System.currentTimeMillis();
                        try {
                            runner.join(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (runner.isAlive() && System.currentTimeMillis() - now >= timeout) {
                            runner.stop();
                        }
                    }
                    catch (Throwable throwable) {
                        Log.setOut((PrintStream)System.out);
                        if (logFile != null) {
                            ps.flush();
                            lout.close();
                            if (stderr) {
                                System.setErr(old);
                            } else {
                                System.setOut(old);
                            }
                        }
                        throw throwable;
                    }
                    Log.setOut((PrintStream)System.out);
                    if (logFile == null) break block21;
                    ps.flush();
                    lout.close();
                    if (stderr) {
                        System.setErr(old);
                        break block21;
                    }
                    System.setOut(old);
                }
                catch (SecurityException ex) {
                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                }
                catch (NoSuchMethodException ex) {
                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                }
                catch (ClassNotFoundException ex) {
                    Log.log((String)("Exception executing " + program), (int)3, (Object)ex);
                }
            } else {
                String[] args2 = new String[args.length + 1];
                args2[0] = program;
                LinkedList<String> env = new LinkedList<String>();
                Enumeration<?> en = System.getProperties().propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (key.startsWith("java.") || key.startsWith("sun.")) continue;
                    env.add(String.valueOf(key.replace('.', '_')) + "=" + System.getProperty(key));
                }
                System.arraycopy(args, 0, args2, 1, args.length);
                final Process p = Runtime.getRuntime().exec(args2, env.toArray(new String[env.size()]));
                final Thread mainThread = Thread.currentThread();
                Thread watchDog = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(timeout);
                            Log.log((String)"Interrupting process.", (int)4);
                            mainThread.interrupt();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                watchDog.start();
                new Thread(){

                    public void run() {
                        OutputStream lout = System.out;
                        try {
                            try {
                                if (logFile != null) {
                                    lout = new FileOutputStream(logFile);
                                }
                                Util.copyStream((InputStream)(stderr ? p.getErrorStream() : p.getInputStream()), (OutputStream)lout);
                            }
                            catch (IOException ex) {
                                Log.log((String)"Error copying process out", (int)3);
                            }
                        }
                        finally {
                            if (logFile != null) {
                                try {
                                    lout.flush();
                                    lout.close();
                                }
                                catch (IOException ex) {
                                    Log.log((String)"Cannot close log-out", (int)3);
                                }
                            }
                        }
                    }
                }.start();
                try {
                    p.waitFor();
                    BenchMark.getSetProperty("killed", 0);
                }
                catch (InterruptedException ex) {
                    Log.log((String)("Timeout of " + program + ", now I kill it"), (int)4);
                    p.destroy();
                    BenchMark.getSetProperty("killed", 1);
                }
                watchDog.interrupt();
            }
        }
    }

    protected static String getSetProperty(String name, String defaultVal) {
        String val = System.getProperty(name, null);
        if (val == null && defaultVal != null) {
            val = defaultVal;
            System.setProperty(name, val);
        }
        return val;
    }

    protected static int getSetProperty(String name, int defaultVal) {
        return Integer.parseInt(BenchMark.getSetProperty(name, String.valueOf(defaultVal)));
    }

    protected static boolean getSetProperty(String name, boolean defaultVal) {
        return Boolean.parseBoolean(BenchMark.getSetProperty(name, String.valueOf(defaultVal)));
    }

    protected static double getSetProperty(String name, double defaultVal) {
        return Double.parseDouble(BenchMark.getSetProperty(name, String.valueOf(defaultVal)));
    }
}

