/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import fc.fp.syxaw.util.Log;
import fc.fp.util.xas.DefaultXmlParser;
import fc.fp.util.xas.DefaultXmlSerializer;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xas.XmlWriter;
import fc.fp.util.xmlr.RefTree;
import fc.fp.util.xmlr.RefTreeImpl;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.RefTreeNodeImpl;
import fc.fp.util.xmlr.RefTrees;
import fc.fp.util.xmlr.ReferenceEvent;
import fc.fp.util.xmlr.XasSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParserException;

public class XmlUtil {
    private XmlUtil() {
    }

    public static XmlWriter getXmlWriter(OutputStream out) throws IOException {
        return new XmlWriter(XmlUtil.getXmlSerializer(out));
    }

    public static final TypedXmlParser getXmlParser(InputStream is) throws IOException {
        DefaultXmlParser pr = new DefaultXmlParser();
        try {
            pr.setInput(is, "utf-8");
        }
        catch (XmlPullParserException ex) {
            throw new IOException(String.valueOf(ex.toString()) + ": " + ex.getMessage());
        }
        return pr;
    }

    public static TypedXmlSerializer getXmlSerializer(OutputStream out) throws IOException {
        return XmlUtil.getXmlSerializer(out, true);
    }

    public static TypedXmlSerializer getXmlSerializer(OutputStream out, boolean indent) throws IOException {
        DefaultXmlSerializer ser = new DefaultXmlSerializer();
        ser.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", indent);
        ser.setOutput(out, "utf-8");
        return ser;
    }

    public static RefTree readTree(XmlReader rd, XasSerialization.ContentReader cf) throws IOException {
        boolean wholeDocument = true;
        Event e = rd.advance();
        if (e != null && e.getType() != 0) {
            wholeDocument = false;
            rd.backup();
        }
        RefTreeNodeImpl root = XmlUtil.readTree(rd, cf, null);
        if (wholeDocument && ((e = rd.advance()) == null || e.getType() != 1)) {
            throw new IOException("Expected to find end-of-document, got " + e);
        }
        return new RefTreeImpl((RefTreeNode)root);
    }

    public static RefTreeNodeImpl readTree(XmlReader rd, XasSerialization.ContentReader cf, RefTreeNode parent) throws IOException {
        Event e = rd.advance();
        RefTreeNodeImpl root = null;
        if (e.getType() != ReferenceEvent.REF_TREE && e.getType() != ReferenceEvent.END_REF_NODE && e.getType() != 4 && e.getType() != 1) {
            boolean isNodeRef = e.getType() == ReferenceEvent.START_REF_NODE;
            RefTrees.IdentifiableContent content = null;
            String id = null;
            if (isNodeRef) {
                ReferenceEvent re = (ReferenceEvent)e;
                if (re.getTargetType() != 0) {
                    Log.log((String)"Target type != id not implemented", (int)0);
                }
                id = re.getTarget();
            } else {
                rd.backup(1);
                content = cf.startContent(rd);
                id = content.getId();
            }
            root = new RefTreeNodeImpl(parent, id, false, (Object)(isNodeRef ? null : content));
            if (isNodeRef || e.getType() == 2) {
                RefTreeNodeImpl child = null;
                while ((child = XmlUtil.readTree(rd, cf, (RefTreeNode)root)) != null) {
                    root.addChild(child);
                }
            }
            if (isNodeRef) {
                e = rd.advance();
                if (e.getType() != ReferenceEvent.END_REF_NODE) {
                    throw new IOException("Expected </ref:node>, got " + e);
                }
            } else {
                cf.finishContent((Object)content, rd);
            }
        } else {
            if (e.getType() == ReferenceEvent.REF_TREE) {
                ReferenceEvent re = (ReferenceEvent)e;
                if (re.getTargetType() != 0) {
                    Log.log((String)"Target type != id not implemented", (int)0);
                }
                return new RefTreeNodeImpl(parent, re.getTarget(), true, null);
            }
            rd.backup(1);
        }
        return root;
    }

    public static void dumpTree(RefTree t, String name, XasSerialization.ContentCodec cc) {
        Log.log((String)("Dump of tree " + name), (int)5);
        try {
            XmlWriter wr = new XmlWriter(XmlUtil.getXmlSerializer(System.out));
            XmlUtil.writeDebugTree(t.getRoot(), cc, wr);
            wr.flush();
            System.out.println();
        }
        catch (IOException x) {
            Log.log((String)"IOEx dumping tree", (int)3, (Object)x);
        }
    }

    public static void writeDebugTree(RefTreeNode n, XasSerialization.ContentCodec sz, XmlWriter es) throws IOException {
        if (!n.isReference()) {
            sz.startObject(n.getContent(), es);
        } else if (n.isNodeRef()) {
            es.addEvent((Event)ReferenceEvent.createNodeReference((int)0, (String)n.getId()));
        } else {
            es.addEvent((Event)ReferenceEvent.createTreeReference((int)0, (String)n.getId()));
            return;
        }
        Iterator i = n.getChildIterator();
        while (i.hasNext()) {
            XmlUtil.writeDebugTree((RefTreeNode)i.next(), sz, es);
        }
        if (!n.isReference()) {
            sz.finishObject(n.getContent(), es);
        } else {
            es.addEvent((Event)ReferenceEvent.createEndNodeReference());
        }
    }
}

