/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment<E> {
    private List<E> ins;
    private int off;
    private int len;
    private Operation op;
    private int pos;

    protected Segment(int off, int len, Operation op, List<E> ins, int pos) {
        this.off = off;
        this.len = len;
        this.op = op;
        this.ins = ins;
        this.pos = pos;
    }

    public static final <F> Segment<F> createIns(int off, List<F> data, int pos) {
        return new Segment<F>(off, data.size(), Operation.INSERT, data, pos);
    }

    public static final <F> Segment<F> createCopy(int off, int len, int pos) {
        return new Segment(off, len, Operation.COPY, null, pos);
    }

    public static final <F> Segment<F> createUpdate(int off, int len, List<F> data, int pos) {
        return new Segment<F>(off, len, Operation.UPDATE, data, pos);
    }

    public Operation getOp() {
        return this.op;
    }

    public int getOffset() {
        return this.off;
    }

    public int getLength() {
        return this.len;
    }

    public int getPosition() {
        return this.pos;
    }

    public List<E> getInsert() {
        return this.ins;
    }

    public int getInsertLen() {
        return this.op == Operation.COPY ? this.len : this.ins.size();
    }

    public String toString() {
        String insstr;
        String string = insstr = this.ins != null ? this.ins.toString() : null;
        if (insstr != null && insstr.length() > 48) {
            insstr = String.valueOf(insstr.substring(0, 24)) + "..." + insstr.substring(insstr.length() - 24);
        }
        return "<" + this.pos + ": " + (Object)((Object)this.op) + "," + this.off + "," + this.len + (this.op != Operation.COPY ? "," + insstr.replace('\n', '\u0000') + ">" : ">");
    }

    public boolean appendsTo(Segment<E> head) {
        return head.op == this.op && head.off + head.len == this.off;
    }

    public <F extends E> void append(Segment<F> s, List<E> inserts) {
        this.len += s.len;
        if (this.ins != null) {
            this.ins = inserts.subList(this.off, this.off + this.len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT,
        COPY,
        UPDATE;

    }
}

