/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import faxma.HashAlgorithm;
import faxma.Segment;
import fc.fp.syxaw.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlMatcher<E> {
    public int[] tokenBoundaries;
    public int[] docTokenBounds;
    int falseHashMatches = 0;
    private HashAlgorithm<E> ha;

    public GlMatcher(HashAlgorithm<E> ha) {
        this.ha = ha;
    }

    public List<Segment<E>> match(List<E> base, List<E> doc, int[] sizes) {
        long timeB = System.currentTimeMillis();
        ArrayList<Segment<Segment<E>>> baseList = new ArrayList<Segment<Segment<E>>>();
        baseList.add(Segment.createIns(0, base, 0));
        LinkedList<Segment<Segment<E>>> matchList = new LinkedList<Segment<Segment<E>>>();
        matchList.add(Segment.createIns(0, doc, 0));
        int minSize = sizes[sizes.length - 1];
        int[] nArray = sizes;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int b = nArray[n];
            this.findChunks(matchList, baseList, b, minSize);
            ++n;
        }
        long timeS = System.currentTimeMillis();
        this.simplify(matchList, doc);
        long timeU = System.currentTimeMillis();
        long timeE = System.currentTimeMillis();
        assert (GlMatcher._testPositionConsistency(matchList));
        return matchList;
    }

    private static final <E> boolean _testPositionConsistency(List<Segment<E>> ml) {
        Log.log((String)"testing position list consistency", (int)5);
        int pos = 0;
        for (Segment<E> s : ml) {
            if (pos != s.getPosition()) {
                return false;
            }
            pos += s.getInsertLen();
        }
        return true;
    }

    public void simplify(List<Segment<E>> ml, List<E> doc) {
        Segment<E> prev = null;
        ListIterator<Segment<E>> li = ml.listIterator();
        while (li.hasNext()) {
            Segment<E> current = li.next();
            if (prev != null && current.appendsTo(prev)) {
                li.remove();
                prev.append(current, doc);
                continue;
            }
            prev = current;
        }
    }

    public void updatify(List<Segment<E>> ml, List<Segment<E>> deletia, int baseLen) {
        int i = 0;
        while (i < ml.size()) {
            Segment<E> next;
            Segment<E> prev = i > 0 ? ml.get(i - 1) : null;
            Segment<E> current = ml.get(i);
            Segment<E> segment = next = i + 1 < ml.size() ? ml.get(i + 1) : null;
            if (!(current.getOp() != Segment.Operation.INSERT || prev != null && prev.getOp() != Segment.Operation.COPY || next != null && next.getOp() != Segment.Operation.COPY)) {
                int rqend;
                int rqstart = prev != null ? prev.getOffset() + prev.getLength() : 0;
                int n = rqend = next != null ? next.getOffset() : baseLen;
                if (rqend > rqstart) {
                    ListIterator<Segment<E>> j = deletia.listIterator();
                    while (j.hasNext()) {
                        Segment<E> del = j.next();
                        if (del.getOffset() > rqstart) break;
                        if (del.getOffset() < rqstart || del.getOffset() + del.getLength() < rqend) continue;
                        assert (del.getOffset() + del.getLength() == rqend);
                        j.remove();
                        ml.set(i, Segment.createUpdate(del.getOffset(), del.getLength(), current.getInsert(), current.getPosition()));
                    }
                }
            }
            ++i;
        }
    }

    protected void findChunks(List<Segment<E>> currentOps, List<Segment<E>> base, int chunkSize, int minSize) {
        int firstRegion = 0;
        int scanpos = -1;
        Segment<E> m = null;
        Segment<Object> collatedIns = null;
        Segment match = null;
        int collatedLen = -1;
        if (base.size() == 0) {
            return;
        }
        ListIterator i = currentOps.listIterator();
        while (scanpos != -1 || i.hasNext()) {
            if (scanpos == -1) {
                m = i.next();
                if (m.getOp() == Segment.Operation.COPY) {
                    firstRegion = -m.getOffset();
                    continue;
                }
                if (m.getOp() == Segment.Operation.INSERT && m.getLength() < chunkSize) continue;
                i.remove();
                scanpos = 0;
            }
            assert (m.getOp() == Segment.Operation.INSERT);
            int[] offlen = this.findChunkInRegions(scanpos, m.getInsert(), base, firstRegion, chunkSize, minSize);
            if (offlen == null) {
                int inssize;
                int splitSize = chunkSize;
                if (this.docTokenBounds != null) {
                    int off = m.getOffset() + splitSize;
                    int low = Arrays.binarySearch(this.docTokenBounds, off);
                    if (low < 0) {
                        low = -low - 1;
                    }
                    splitSize = this.docTokenBounds[low] - m.getOffset();
                    assert (splitSize > 0);
                }
                boolean willSplit = m.getInsert().size() - scanpos > splitSize;
                int n = inssize = willSplit ? splitSize : m.getInsert().size() - scanpos;
                if (collatedIns == null) {
                    collatedIns = Segment.createCopy(scanpos, -1, scanpos);
                    collatedLen = inssize;
                } else {
                    assert (collatedIns.getOffset() + collatedLen == scanpos);
                    collatedLen += inssize;
                }
                scanpos = willSplit ? (scanpos += splitSize) : -1;
            } else {
                match = Segment.createCopy(offlen[0], offlen[1], m.getPosition() + scanpos);
                scanpos = scanpos + offlen[1] < m.getInsert().size() ? (scanpos += offlen[1]) : -1;
                firstRegion = offlen[2];
            }
            if (!(collatedIns == null || scanpos != -1 && i.hasNext() && match == null)) {
                int origin = collatedIns.getOffset();
                collatedIns = Segment.createIns(origin + m.getOffset(), m.getInsert().subList(origin, origin + collatedLen), origin + m.getPosition());
                i.add(collatedIns);
                collatedIns = null;
            }
            if (match == null) continue;
            i.add(match);
            match = null;
        }
        assert (collatedIns == null);
    }

    protected int[] findChunkInRegions(int scanpos, List<E> chunkToMatch, List<Segment<E>> baseRegions, int firstRegion, int chunkSize, int minSize) {
        if (firstRegion < 0) {
            int offset = -firstRegion;
            firstRegion = 0;
            while (firstRegion < baseRegions.size() && baseRegions.get(firstRegion).getOffset() < offset) {
                ++firstRegion;
            }
        }
        int bfly = 0;
        int maxbfly = chunkSize >= 8 ? Integer.MAX_VALUE : 2 * chunkSize + 2;
        int ofi = firstRegion;
        while (ofi < firstRegion + baseRegions.size()) {
            block20: {
                int[] offlen;
                Segment<E> region;
                int i;
                block21: {
                    int mid;
                    i = (baseRegions.size() + bfly + firstRegion) % baseRegions.size();
                    if ((bfly = bfly <= 0 ? -bfly + 1 : -bfly) > maxbfly || bfly < -maxbfly) {
                        return null;
                    }
                    region = baseRegions.get(i);
                    offlen = this.findChunk(scanpos, chunkToMatch, region.getInsert(), chunkSize, minSize);
                    if (offlen == null) break block20;
                    if (this.tokenBoundaries == null) break block21;
                    int start = -1;
                    int end = -1;
                    int regionMax = region.getOffset() + region.getLength();
                    int regionMin = region.getOffset();
                    Log.log((String)("Unaligned match is " + region.getInsert().subList(offlen[0], offlen[0] + offlen[1])), (int)5);
                    int origStart = offlen[0] + region.getOffset();
                    int low = Arrays.binarySearch(this.tokenBoundaries, origStart);
                    if (low < 0) {
                        low = -low - 2;
                        assert (this.tokenBoundaries[low + 1] >= regionMin);
                        mid = (this.tokenBoundaries[low] + this.tokenBoundaries[low + 1]) / 2;
                        start = origStart <= mid && this.tokenBoundaries[low] >= regionMin ? this.tokenBoundaries[low] : this.tokenBoundaries[low + 1];
                    } else {
                        start = origStart;
                    }
                    int origEnd = offlen[0] + offlen[1] + region.getOffset();
                    int hi = Arrays.binarySearch(this.tokenBoundaries, origEnd);
                    if (hi < 0) {
                        hi = -hi - 2;
                        assert (this.tokenBoundaries[hi] <= regionMax);
                        mid = (this.tokenBoundaries[hi] + this.tokenBoundaries[hi + 1]) / 2;
                        end = origEnd > mid && this.tokenBoundaries[hi + 1] <= regionMax ? this.tokenBoundaries[hi + 1] : this.tokenBoundaries[hi];
                    } else {
                        end = origEnd;
                    }
                    if (end <= start) break block20;
                    offlen[0] = start - region.getOffset();
                    offlen[1] = end - start;
                    assert (offlen[0] >= 0);
                    assert (offlen[1] >= 0);
                    assert (offlen[0] < region.getLength());
                    assert (offlen[0] + offlen[1] <= region.getLength());
                    assert (region.getLength() == region.getInsert().size());
                    Log.log((String)("Aligned match is " + region.getInsert().subList(offlen[0], offlen[0] + offlen[1])), (int)5);
                }
                baseRegions.remove(i);
                if (offlen[0] > 0) {
                    Segment<E> pre = Segment.createIns(region.getOffset(), region.getInsert().subList(0, offlen[0]), region.getOffset());
                    baseRegions.add(i, pre);
                    ++i;
                }
                if (offlen[0] + offlen[1] < region.getLength()) {
                    int start = offlen[0] + offlen[1];
                    Segment<E> post = Segment.createIns(start + region.getOffset(), region.getInsert().subList(start, region.getInsert().size()), start + region.getOffset());
                    baseRegions.add(i, post);
                }
                offlen[0] = offlen[0] + region.getOffset();
                return new int[]{offlen[0], offlen[1], i + 1};
            }
            ++ofi;
        }
        return null;
    }

    protected int[] findChunk(int scanpos, List<E> chunk, List<E> baseRegion, int chunkSize, int minSize) {
        int len = Math.min(chunkSize, chunk.size() - scanpos);
        if (baseRegion.size() < len || len < minSize) {
            return null;
        }
        short[] froll = this.initroll(chunk, len, scanpos);
        short[] broll = this.initroll(baseRegion, len, 0);
        int i = 0;
        while (i + len <= baseRegion.size()) {
            if (froll[0] == broll[0] && froll[1] == broll[1]) {
                int j = 0;
                while (j < len && chunk.get(scanpos + j).equals(baseRegion.get(i + j))) {
                    ++j;
                }
                if (j == len) {
                    int maxmore = Math.min(chunk.size() - len - scanpos, baseRegion.size() - i - len);
                    int extra = 0;
                    while (extra < maxmore && baseRegion.get(i + len + extra).equals(chunk.get(scanpos + len + extra))) {
                        ++extra;
                    }
                    return new int[]{i, len + extra};
                }
                ++this.falseHashMatches;
            }
            if (i + len < baseRegion.size()) {
                this.updateroll(broll, baseRegion.get(i), baseRegion.get(i + len), i, i + len);
            }
            ++i;
        }
        return null;
    }

    protected final short[] initroll(List<E> baseRegion, int len, int off) {
        short a = 0;
        short b = 0;
        int i = 0;
        while (i < len) {
            short hash = this.ha.quickHash(baseRegion.get(i + off));
            a = (short)(a + hash);
            b = (short)(b + (len - i) * hash);
            ++i;
        }
        return new short[]{a, b};
    }

    protected final void updateroll(short[] state, E outT, E inT, int k, int l) {
        short in = this.ha.quickHash(inT);
        short out = this.ha.quickHash(outT);
        state[0] = (short)(state[0] + (in - out));
        state[1] = (short)(state[1] - (l - k) * out + state[0]);
    }
}

