/*
 * Decompiled with CFR 0.152.
 */
package faxma;

import faxma.CanonicalEventSequence;
import faxma.GlMatcher;
import faxma.ListOfEvents;
import faxma.Segment;
import faxma.XmlUtil;
import faxma.io.EventUtil;
import fc.fp.syxaw.util.Log;
import fc.fp.syxaw.util.Util;
import fc.fp.util.xas.Event;
import fc.fp.util.xas.EventList;
import fc.fp.util.xas.EventSequence;
import fc.fp.util.xas.TransformedEventStream;
import fc.fp.util.xas.TypedXmlParser;
import fc.fp.util.xas.TypedXmlSerializer;
import fc.fp.util.xas.XasUtil;
import fc.fp.util.xas.XmlReader;
import fc.fp.util.xas.XmlWriter;
import fc.fp.util.xmlr.RefTreeNode;
import fc.fp.util.xmlr.ReferenceEvent;
import fc.fp.util.xmlr.tdm.Diff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff
implements Diff.SequenceTester {
    static final int[] CHUNK_SIZES = new int[]{32, 16, 8, 4, 2, 1};
    public static Map<String, String> ENCODER_ALIASES = new HashMap<String, String>();
    public static Map<String, String> FILTER_ALIASES = new HashMap<String, String>();

    static {
        ENCODER_ALIASES.put("xml", "faxma.Diff.XmlDiffEncoder");
        ENCODER_ALIASES.put("align", "faxma.Diff.AlignEncoder");
        FILTER_ALIASES.put("simple", "faxma.CanonicalEventSequence");
        FILTER_ALIASES.put("full", null);
        FILTER_ALIASES.put("none", null);
    }

    public static Boolean encodeDiff(XmlReader mr, XmlWriter out, EventList eout, boolean parentChanged, LinkedList<ReferenceEvent> tagStack, MultiXPath xp, String[] topPath, List<Event> base) throws IOException {
        boolean bl;
        int n;
        Boolean bl2;
        String thisPath;
        MatchedEvent e = (MatchedEvent)mr.getCurrentEvent();
        if (e.getType() == 4) {
            return null;
        }
        Segment<Event> matchTag = e.getMatchTag();
        int matchPos = mr.getCurrentPosition();
        int changed = matchTag.getOp() != Segment.Operation.COPY ? 1 : 0;
        boolean isText = e.getType() == 5 || e.getType() == 8 || e.getType() == 10 || e.getType() == 9;
        EventSequence es = null;
        if (e.getType() == 2) {
            es = mr.currentDelimiter();
            Enumeration en = es.events();
            while (en.hasMoreElements() && changed == 0) {
                int n2 = changed = ((MatchedEvent)((Object)en.nextElement())).getMatchTag() != matchTag ? 1 : 0;
            }
            int basepos = matchTag.getOffset() + (mr.getCurrentPosition() - matchTag.getPosition());
            while (changed == 0 && basepos < base.size() && base.get(basepos).getType() == 3) {
                changed = 1;
            }
        } else {
            mr.advance();
        }
        String string = thisPath = changed != 0 ? null : Diff.getPath(matchPos, matchTag, xp);
        if (changed != 0 || parentChanged) {
            for (Event event : tagStack) {
                EventUtil.emit(event, out, eout);
            }
            tagStack.clear();
        }
        if (changed == 0) {
            tagStack.addLast(isText ? ReferenceEvent.createTreeReference((String)thisPath) : ReferenceEvent.createNodeReference((String)thisPath));
        } else if (es == null) {
            EventUtil.emit((Event)e, out, eout);
        } else {
            EventUtil.emit(es, out, eout);
        }
        boolean bl3 = false;
        int delayedChildTrees = 0;
        int __TSMARK = tagStack.size();
        boolean orderChanged = false;
        Object var19_25 = null;
        while (!isText && (bl2 = Diff.encodeDiff(mr, out, eout, (changed | n) != 0, tagStack, xp, topPath, base)) != null) {
            MatchedEvent nexte = (MatchedEvent)mr.getCurrentEvent();
            if (nexte != null && nexte.getMatchTag() != matchTag) {
                orderChanged = true;
            }
            if ((n |= bl2.booleanValue()) != 0 || changed != 0) continue;
            assert (topPath[0] != null);
            tagStack.addLast(ReferenceEvent.createTreeReference((String)topPath[0]));
            ++delayedChildTrees;
        }
        if (n == 0 && changed == 0 && !orderChanged) {
            while (delayedChildTrees > 0) {
                tagStack.removeLast();
                --delayedChildTrees;
            }
            assert (tagStack.size() == __TSMARK);
        } else if (n == 0 && changed == 0 && orderChanged) {
            for (Event event : tagStack) {
                EventUtil.emit(event, out, eout);
            }
            tagStack.clear();
            bl = true;
        } else assert (tagStack.size() == (changed == 0 && n == 0 && !orderChanged ? 1 : 0));
        if (es != null) {
            e = (MatchedEvent)mr.advance();
            assert (e == null || e.getType() == 4);
        }
        if (changed == 0) {
            if (!bl) {
                tagStack.removeLast();
                if (parentChanged) {
                    EventUtil.emit((Event)ReferenceEvent.createTreeReference((String)thisPath), out, eout);
                }
            } else if (!isText) {
                EventUtil.emit((Event)ReferenceEvent.createEndNodeReference(), out, eout);
            }
        } else if (es != null) {
            EventUtil.emit((Event)e, out, eout);
        }
        assert (changed == 0 || tagStack.size() == 0);
        topPath[0] = thisPath;
        return changed | bl;
    }

    private static String getPath(int branchPos, Segment<Event> match, MultiXPath xp) {
        int offset = branchPos - match.getPosition();
        assert (offset < match.getLength());
        return xp.getPath(match.getOffset() + offset + 1, match.getOffset(), match.getInsertLen());
    }

    public static void main(String[] args) throws IOException {
        Class encoder = XmlDiffEncoder.class;
        Class filter = CanonicalEventSequence.class;
        Log.setOut((PrintStream)System.err);
        String encoderName = System.getProperty("encoder");
        String filterName = System.getProperty("filter");
        if (encoderName != null) {
            if (ENCODER_ALIASES.containsKey(encoderName)) {
                encoderName = ENCODER_ALIASES.get(encoderName);
            }
            try {
                encoder = encoderName != null ? Class.forName(encoderName) : null;
            }
            catch (ClassNotFoundException ex) {
                Log.log((String)("Cannot locate encoder " + encoderName), (int)2);
            }
        }
        if (filterName != null) {
            if (FILTER_ALIASES.containsKey(filterName)) {
                filterName = FILTER_ALIASES.get(filterName);
            }
            try {
                filter = filterName != null ? Class.forName(filterName) : null;
            }
            catch (ClassNotFoundException ex) {
                Log.log((String)("Cannot locate filter " + filterName), (int)2);
            }
        }
        if (args.length < 2) {
            Log.log((String)"Usage [-Dencoder={xml,align,<class>}] [-Dfilter={simple,<class>}] base.xml new.xml [out.xml]", (int)3);
            System.exit(1);
        }
        OutputStream dout = System.out;
        try {
            try {
                FileInputStream base = new FileInputStream(args[0]);
                FileInputStream updated = new FileInputStream(args[1]);
                if (args.length > 2 && !"-".equals(args[2])) {
                    dout = new FileOutputStream(args[2]);
                }
                Diff.diff(base, updated, dout, filter, encoder, null, true);
            }
            catch (IOException ex) {
                Log.log((String)"IO error while diffing", (int)3, (Object)ex);
            }
        }
        finally {
            if (dout != System.out) {
                ((OutputStream)dout).close();
            }
        }
    }

    public static boolean diff(InputStream bases, InputStream docs, OutputStream dout) throws IOException {
        return Diff.diff(bases, docs, dout, CanonicalEventSequence.class, XmlDiffEncoder.class, null, true);
    }

    public static boolean diff(EventSequence baseEs, TypedXmlParser baseParser, EventSequence docEs, TypedXmlParser docParser, OutputStream dout, Class outputEncoding, Map<String, String> encoderOptions, boolean emitEmpty) throws IOException {
        boolean isEmpty;
        long _start = System.currentTimeMillis();
        ArrayList<Integer> posListBase = baseParser == null ? null : new ArrayList<Integer>();
        ArrayList<Integer> posListNew = docParser == null ? null : new ArrayList<Integer>();
        EventList preamble = new EventList();
        List<Event> base = EventUtil.makeEventList(baseEs, preamble, posListBase, baseParser);
        List<Event> doc = EventUtil.makeEventList(docEs, null, posListNew, docParser);
        GlMatcher<Event> m = new GlMatcher<Event>(EventUtil.getEventHashAlgorithm());
        List ml = m.match(base, doc, CHUNK_SIZES);
        long _stop = System.currentTimeMillis();
        boolean bl = isEmpty = ml.size() == 1 && ml.get(0).getLength() == base.size() && ml.get(0).getOp() == Segment.Operation.COPY;
        if (dout != null && !isEmpty || emitEmpty) {
            if (outputEncoding == XmlDiffEncoder.class) {
                XmlDiffEncoder.encodeDiff(base, doc, ml, (EventSequence)preamble, dout);
            } else if (outputEncoding == AlignEncoder.class) {
                AlignEncoder.encodeDiff(base, doc, ml, (EventSequence)preamble, dout, AlignEncoder.DEFAULT_PT, AlignEncoder.DEFAULT_PT);
            } else {
                throw new IllegalArgumentException("Unknown encoder " + outputEncoding);
            }
        }
        if (isEmpty) {
            Log.log((String)("Documents identical  (" + base.size() + " XAS events in " + (_stop - _start) + "ms)."), (int)5);
        } else {
            Log.log((String)"Documents differ.", (int)5);
            Log.log((String)("Match list is " + ml), (int)6);
        }
        return !isEmpty;
    }

    public static boolean diff(InputStream bases, InputStream docs, OutputStream dout, Class<? extends EventSequence> filter, Class outputEncoding, Map<String, String> encoderOptions, boolean emitEmpty) throws IOException {
        TypedXmlParser docpa = XmlUtil.getXmlParser(docs);
        TypedXmlParser basepa = XmlUtil.getXmlParser(bases);
        Log.log((String)("Comparing by filter " + (filter == null ? "<none>" : filter.getName())), (int)5);
        return Diff.diff(EventUtil.getEventSequence(basepa, filter), basepa, EventUtil.getEventSequence(docpa, filter), basepa, dout, outputEncoding, encoderOptions, emitEmpty);
    }

    public static void diff(File basef, File docf, OutputStream dout) throws IOException {
        long _start = System.currentTimeMillis();
        EventList preamble = new EventList();
        List<Event> base = EventUtil.getEventSequence(basef.toString(), preamble);
        long _b1 = System.currentTimeMillis();
        List<Event> b1 = EventUtil.getEventSequence(docf.toString(), null);
        long _ms = System.currentTimeMillis();
        GlMatcher<Event> m = new GlMatcher<Event>(EventUtil.getEventHashAlgorithm());
        List<Segment<Event>> m1 = m.match(base, b1, CHUNK_SIZES);
        long _me = System.currentTimeMillis();
        EventList elr = new EventList();
        elr.add(Event.createStartDocument());
        elr.add(Event.createNamespacePrefix((String)"http://www.hiit.fi/fc/xml/ref", (String)"ref"));
        elr.addAll((EventSequence)preamble);
        XmlReader rd = new XmlReader((EventSequence)new ListOfMatchedEvents(m1, b1));
        while (rd.getCurrentEvent().getType() != 2) {
            rd.advance();
        }
        Diff.encodeDiff(rd, null, elr, true, new LinkedList<ReferenceEvent>(), new MultiXPath(new ListOfEvents(base)), new String[1], base);
        elr.add(Event.createEndDocument());
        long _er = System.currentTimeMillis();
        RefEStoDiffES des = new RefEStoDiffES((EventSequence)elr);
        TypedXmlSerializer dser = XmlUtil.getXmlSerializer(dout);
        dser.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", false);
        XmlWriter dwr = new XmlWriter(dser);
        Enumeration en = des.events();
        while (en.hasMoreElements()) {
            dwr.addEvent((Event)en.nextElement());
        }
        dwr.flush();
        dout.flush();
        dout.close();
        long _ed = System.currentTimeMillis();
        Log.log((String)"Times are {_start,_b1-_start,_ms-_b1,_me-_ms,_er-_me,_ed-_er,total=}=", (int)5, (Object)new long[]{_start, _b1 - _start, _ms - _b1, _me - _ms, _er - _me, _ed - _er, _ed - _start});
    }

    public boolean inSequence(RefTreeNode baseTail, RefTreeNode baseNext) {
        String baseId = baseTail.getId();
        String nextId = baseNext.getId();
        int sep = baseId.lastIndexOf(47);
        if (sep == -1 || nextId.length() < sep || sep != nextId.lastIndexOf(47) || !nextId.startsWith(baseId.substring(0, sep))) {
            return false;
        }
        return Integer.parseInt(baseId.substring(sep + 1)) + 1 == Integer.parseInt(nextId.substring(sep + 1));
    }

    public static class MultiXPath {
        SortedMap<Integer, NumericXPath> paths = new TreeMap<Integer, NumericXPath>();
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !MultiXPath.class.desiredAssertionStatus();
        }

        public MultiXPath(EventSequence es) {
            this.paths.put(0, new NumericXPath(es));
        }

        public String getPath(int ix, int cacheIx, int len) {
            if (!$assertionsDisabled && ix < cacheIx) {
                throw new AssertionError();
            }
            NumericXPath exact = (NumericXPath)this.paths.get(cacheIx);
            if (exact == null) {
                SortedMap<Integer, NumericXPath> lessPaths = this.paths.headMap(cacheIx);
                if (!$assertionsDisabled && lessPaths == null) {
                    throw new AssertionError();
                }
                NumericXPath refpath = (NumericXPath)this.paths.get(lessPaths.lastKey());
                exact = new NumericXPath(refpath);
                this.paths.put(cacheIx, exact);
                exact.moveto(ix);
            }
            exact.moveto(ix);
            return exact.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchedEvent
    extends Event {
        private Segment<Event> match;

        MatchedEvent(Event e, Segment<Event> match) {
            super(e.getType(), e.getNamespace(), e.getName(), e.getValue());
            this.match = match;
        }

        public Segment<Event> getMatchTag() {
            return this.match;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListOfMatchedEvents
    implements EventSequence {
        List<Segment<Event>> ml;
        ListIterator<Segment<Event>> mi;
        Segment<Event> current = null;
        ListOfMatchedEvents tagger = null;
        private List<Event> el;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ListOfMatchedEvents.class.desiredAssertionStatus();
        }

        public ListOfMatchedEvents(List<Segment<Event>> ml, List<Event> doc) {
            this.el = doc;
            this.ml = ml;
            this.tagger = this;
            this.mi = ml.listIterator();
            this.current = this.mi.hasNext() ? this.mi.next() : null;
        }

        /*
         * Unable to fully structure code
         */
        protected Segment<Event> getTag(int pos) {
            if (this.current == null) {
                return null;
            }
            if (this.current.getPosition() <= pos && this.current.getPosition() + this.current.getLength() > pos) {
                return this.current;
            }
            if (pos >= this.current.getPosition()) ** GOTO lbl22
            while (this.mi.hasPrevious()) {
                this.current = this.mi.previous();
                if (this.current.getPosition() > pos) continue;
                if (!ListOfMatchedEvents.$assertionsDisabled && this.current.getPosition() > pos) {
                    throw new AssertionError();
                }
                if (!ListOfMatchedEvents.$assertionsDisabled && this.current.getPosition() + this.current.getLength() <= pos) {
                    throw new AssertionError();
                }
                return this.current;
            }
            return null;
lbl-1000:
            // 1 sources

            {
                this.current = this.mi.next();
                if (pos >= this.current.getPosition() + this.current.getLength()) continue;
                if (!ListOfMatchedEvents.$assertionsDisabled && this.current.getPosition() > pos) {
                    throw new AssertionError();
                }
                if (!ListOfMatchedEvents.$assertionsDisabled && this.current.getPosition() + this.current.getLength() <= pos) {
                    throw new AssertionError();
                }
                return this.current;
lbl22:
                // 2 sources

                ** while (this.mi.hasNext())
            }
lbl23:
            // 1 sources

            return null;
        }

        protected int getLength(Segment<Event> s) {
            return s.getOp() != Segment.Operation.COPY ? s.getInsert().size() : s.getLength();
        }

        public Event get(int pos) {
            Segment<Event> mt = this.tagger.getTag(pos);
            if (mt == null) {
                return null;
            }
            return new MatchedEvent(this.el.get(pos), mt);
        }

        public EventSequence subSequence(int from, int to) {
            EventList el2 = new EventList();
            int i = from;
            while (i < to) {
                el2.add(this.get(i));
                ++i;
            }
            return el2;
        }

        public Enumeration events() {
            return null;
        }

        public void forgetUntil(int dummy) {
        }

        public void forget() {
        }

        public int getSmallestActiveIndex() {
            return 0;
        }

        public int getLargestActiveIndex() {
            return this.el.size() - 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof EventSequence && XasUtil.sequenceEquals((EventSequence)this, (EventSequence)((EventSequence)obj));
        }

        public String toString() {
            return this.el.toString();
        }

        public int hashCode() {
            return this.el.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListPosTransformer
    implements AlignEncoder.PosTransformer {
        List<Integer> l = null;

        public ListPosTransformer(List<Integer> l) {
            this.l = l;
        }

        @Override
        public String transform(int pos) {
            return pos == -1 ? "-" : (this.l.get(pos) >> 16) + "," + (this.l.get(pos) & 0xFFFF);
        }
    }

    public static class NumericXPath {
        static final int MAXDEPTH = 128;
        int len = 0;
        int[] counters = new int[128];
        int pos = 0;
        boolean lastWasText = false;
        boolean lastWasEE = false;
        EventSequence es;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !NumericXPath.class.desiredAssertionStatus();
        }

        public NumericXPath(EventSequence es) {
            this.es = es;
        }

        public NumericXPath(NumericXPath base) {
            this.len = base.len;
            System.arraycopy(base.counters, 0, this.counters, 0, 128);
            this.pos = base.pos;
            this.es = base.es;
        }

        /*
         * Unable to fully structure code
         */
        public void moveto(int target) {
            _op = this.pos;
            if (target < this.pos) {
                Log.log((String)("Backing: target=" + target + ", pos=" + this.pos), (int)2, (Object)new Throwable());
            }
            if (NumericXPath.$assertionsDisabled || target >= this.pos) ** GOTO lbl27
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                e = this.es.get(this.pos);
                if (e == null && this.es.get(this.pos - 1) == null) {
                    Log.log((String)"Moved >1 beyond ED(). This should not happen...", (int)4);
                }
                type = e == null ? -1 : e.getType();
                this.lastWasText = type == 5 || type == 8 || type == 10 || type == 9;
                this.lastWasEE = type == 4;
                switch (type) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 3: 
                    case 7: 
                    case 11: {
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: {
                        this.down();
                        this.up();
                        this.forwardNextDown();
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.down();
                        break;
                    }
                    case 4: {
                        this.up();
                        this.forwardNextDown();
                    }
                }
                ++this.pos;
lbl27:
                // 2 sources

                ** while (this.pos < target)
            }
lbl28:
            // 1 sources

        }

        public void down() {
            ++this.len;
        }

        public void up() {
            this.counters[this.len] = 0;
            --this.len;
        }

        public void forwardNextDown() {
            int n = this.len;
            this.counters[n] = this.counters[n] + 1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.len) {
                sb.append('/');
                sb.append(this.counters[i]);
                ++i;
            }
            if (this.lastWasText | this.lastWasEE) {
                sb.append('/').append(this.counters[this.len] - 1);
            }
            return sb.toString();
        }

        public static void test(EventSequence es) {
            NumericXPath xp = new NumericXPath(es);
            int i = 0;
            while (es.get(i) != null) {
                xp.moveto(i + 1);
                System.out.println(String.valueOf(Util.format((String)String.valueOf(i), (int)-5)) + Util.format((String)xp.toString(), (int)-20) + " " + fc.fp.util.Util.toPrintable((String)es.get(i).toString()));
                ++i;
            }
        }
    }

    public static class RefEStoDiffES
    extends TransformedEventStream {
        private Stack<String> parentPaths = new Stack();

        public RefEStoDiffES(EventSequence es) {
            super(es);
        }

        protected void transform(Event ev, EventList el, XmlReader xr) {
            switch (ev.getType()) {
                case 0: {
                    el.add(ev);
                    el.add(Event.createNamespacePrefix((String)"http://www.hiit.fi/fc/xml/tdm/diff", (String)"diff"));
                    el.add(Event.createStartElement((String)"http://www.hiit.fi/fc/xml/tdm/diff", (String)"diff"));
                    el.add(Event.createAttribute((String)"", (String)"op", (String)"insert"));
                    this.parentPaths.push(null);
                    break;
                }
                case 1127948989: {
                    int run = 1;
                    Event p = ev;
                    Event n = null;
                    while ((n = xr.advance()) != null) {
                        if (n.getType() != ReferenceEvent.REF_TREE || !this.appends(((ReferenceEvent)p).getTarget(), ((ReferenceEvent)n).getTarget())) {
                            xr.backup();
                            break;
                        }
                        p = n;
                        ++run;
                    }
                    el.add(Event.createStartElement((String)"http://www.hiit.fi/fc/xml/tdm/diff", (String)"copy"));
                    el.add(Event.createAttribute((String)"", (String)"src", (String)this.getRelativePath(this.parentPaths.peek(), ((ReferenceEvent)ev).getTarget())));
                    el.add(Event.createAttribute((String)"", (String)"run", (String)String.valueOf(run)));
                    el.add(Event.createEndElement((String)"http://www.hiit.fi/fc/xml/tdm/diff", (String)"copy"));
                    break;
                }
                case 1124385342: {
                    ReferenceEvent re = (ReferenceEvent)ev;
                    el.add((Event)ReferenceEvent.createNodeReference((String)this.getRelativePath(this.parentPaths.peek(), re.getTarget())));
                    String longPath = re.getTarget();
                    this.parentPaths.push(longPath);
                    break;
                }
                case 1132987045: {
                    this.parentPaths.pop();
                    el.add(ev);
                    break;
                }
                case 1: {
                    el.add(Event.createEndElement((String)"http://www.hiit.fi/fc/xml/tdm/diff", (String)"diff"));
                    el.add(ev);
                    this.parentPaths.pop();
                    break;
                }
                default: {
                    el.add(ev);
                }
            }
        }

        private String getRelativePath(String parent, String path) {
            if (parent != null && path.startsWith(parent)) {
                return "." + path.substring(parent.length());
            }
            return path;
        }

        private boolean appends(String baseId, String nextId) {
            int sep = baseId.lastIndexOf(47);
            if (sep == -1 || nextId.length() < sep || sep != nextId.lastIndexOf(47) || !nextId.startsWith(baseId.substring(0, sep))) {
                return false;
            }
            return Integer.parseInt(baseId.substring(sep + 1)) + 1 == Integer.parseInt(nextId.substring(sep + 1));
        }
    }

    public static class RelativeXPathExpander
    extends TransformedEventStream {
        private Stack<String> parentPaths = new Stack();
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !RelativeXPathExpander.class.desiredAssertionStatus();
        }

        public RelativeXPathExpander(EventSequence es) {
            super(es);
        }

        protected void transform(Event ev, EventList el, XmlReader xr) {
            switch (ev.getType()) {
                case 0: {
                    el.add(ev);
                    this.parentPaths.push(null);
                    break;
                }
                case 1127948989: {
                    ReferenceEvent re = (ReferenceEvent)ev;
                    if (re.getTarget().startsWith(".")) {
                        re = ReferenceEvent.createTreeReference((String)this.getAbsolutePath(this.parentPaths.peek(), re.getTarget()));
                    }
                    el.add(ev);
                    break;
                }
                case 2: {
                    if ("http://www.hiit.fi/fc/xml/tdm/diff".equals(ev.getNamespace()) && "copy".equals(ev.getName())) {
                        el.add(ev);
                        Event e = xr.advance();
                        while (e.getType() == 3) {
                            if ("src".equals(e.getName()) && ((String)e.getValue()).startsWith(".")) {
                                el.add(Event.createAttribute((String)"", (String)"src", (String)this.getAbsolutePath(this.parentPaths.peek(), (String)e.getValue())));
                            } else {
                                el.add(e);
                            }
                            e = xr.advance();
                        }
                        xr.backup();
                        break;
                    }
                    el.add(ev);
                    break;
                }
                case 1124385342: {
                    ReferenceEvent re = (ReferenceEvent)ev;
                    if (re.getTarget().startsWith(".")) {
                        re = ReferenceEvent.createNodeReference((String)this.getAbsolutePath(this.parentPaths.peek(), re.getTarget()));
                    }
                    el.add((Event)re);
                    this.parentPaths.push(re.getTarget());
                    break;
                }
                case 1132987045: {
                    this.parentPaths.pop();
                    el.add(ev);
                    break;
                }
                case 1: {
                    el.add(ev);
                    this.parentPaths.pop();
                    break;
                }
                default: {
                    el.add(ev);
                }
            }
        }

        private String getAbsolutePath(String parent, String path) {
            if (!$assertionsDisabled && !path.startsWith(".")) {
                throw new AssertionError();
            }
            return String.valueOf(parent) + path.substring(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlDiffEncoder {
        public static <E> void encodeDiff(List<Event> base, List<Event> doc, List<Segment<Event>> matches, EventSequence preamble, OutputStream out) throws IOException {
            EventList elr = new EventList();
            elr.add(Event.createStartDocument());
            elr.add(Event.createNamespacePrefix((String)"http://www.hiit.fi/fc/xml/ref", (String)"ref"));
            elr.addAll(preamble);
            XmlReader rd = new XmlReader((EventSequence)new ListOfMatchedEvents(matches, doc));
            while (rd.getCurrentEvent().getType() != 2) {
                rd.advance();
            }
            Diff.encodeDiff(rd, null, elr, true, new LinkedList<ReferenceEvent>(), new MultiXPath(new ListOfEvents(base)), new String[1], base);
            elr.add(Event.createEndDocument());
            long _er = System.currentTimeMillis();
            RefEStoDiffES des = new RefEStoDiffES((EventSequence)elr);
            TypedXmlSerializer dser = XmlUtil.getXmlSerializer(out);
            dser.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            XmlWriter dwr = new XmlWriter(dser);
            Enumeration en = des.events();
            while (en.hasMoreElements()) {
                dwr.addEvent((Event)en.nextElement());
            }
            dwr.flush();
            out.flush();
            out.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlignEncoder {
        public static final int EVENT_COLWIDTH = 40;
        public static final int POS_COLWIDTH = 6;
        public static final PosTransformer DEFAULT_PT = new DefaultPosTranformer();

        public static <E> void encodeDiff(List<E> base, List<E> doc, List<Segment<E>> matches, EventSequence preamble, OutputStream out) {
            AlignEncoder.encodeDiff(base, doc, matches, preamble, out, DEFAULT_PT, DEFAULT_PT);
        }

        public static <E> void encodeDiff(List<E> base, List<E> doc, List<Segment<E>> matches, EventSequence preamble, OutputStream out, PosTransformer lpt, PosTransformer rpt) {
            PrintWriter pw = new PrintWriter(out);
            int pos = 0;
            while (pos < base.size()) {
                Segment<E> match = null;
                boolean found = false;
                for (Segment<E> s : matches) {
                    if (s.getOp() == Segment.Operation.INSERT && match != null) {
                        int i = 0;
                        while (i < s.getInsert().size()) {
                            AlignEncoder.emitLine(pw, -1, "-", s.getInsert().get(i), s.getOp() == Segment.Operation.UPDATE, s.getPosition() + i, lpt, rpt);
                            ++i;
                        }
                        continue;
                    }
                    if (s.getOffset() == pos && s.getOp() != Segment.Operation.INSERT) {
                        found = true;
                        match = s;
                        int slen = s.getLength();
                        int i = 0;
                        while (i < slen) {
                            Object updated = null;
                            updated = s.getOp() == Segment.Operation.UPDATE ? (i < s.getInsert().size() ? s.getInsert().get(i) : "-") : (Object)base.get(pos);
                            if (i > 2 && slen > 5 && i < slen - 2 && s.getOp() != Segment.Operation.UPDATE) {
                                if (i < 5) {
                                    pw.println(Util.format((String)".", (int)-48));
                                }
                            } else {
                                AlignEncoder.emitLine(pw, pos, base.get(pos), updated, s.getOp() == Segment.Operation.UPDATE, s.getPosition() + i, lpt, rpt);
                            }
                            ++pos;
                            ++i;
                        }
                        if (s.getOp() != Segment.Operation.UPDATE) continue;
                        i = s.getLength();
                        while (i < s.getInsert().size()) {
                            AlignEncoder.emitLine(pw, -1, "-", s.getInsert().get(i), s.getOp() == Segment.Operation.UPDATE, s.getPosition() + i, lpt, rpt);
                            ++i;
                        }
                        continue;
                    }
                    match = null;
                }
                if (found) continue;
                AlignEncoder.emitLine(pw, pos, base.get(pos), "-", false, -1, lpt, rpt);
                ++pos;
            }
            pw.flush();
        }

        private static void emitLine(PrintWriter out, int pos, Object base, Object mod, boolean update, int rpos, PosTransformer lpt, PosTransformer rpt) {
            String baseS = fc.fp.util.Util.toPrintable((String)base.toString());
            String brS = fc.fp.util.Util.toPrintable((String)mod.toString());
            if (baseS.length() > 40) {
                baseS = String.valueOf(baseS.substring(0, 20)) + "..." + baseS.substring(baseS.length() - 17);
            }
            if (brS.length() > 40) {
                brS = String.valueOf(brS.substring(0, 20)) + "..." + brS.substring(brS.length() - 17);
            }
            out.println(String.valueOf(Util.format((String)lpt.transform(pos), (int)-6, (char)' ')) + " " + Util.format((String)baseS, (int)-40, (char)' ') + " " + Util.format((String)brS, (int)40, (char)' ') + (update ? " *" : "  ") + Util.format((String)rpt.transform(rpos), (int)6, (char)' '));
        }

        public static interface PosTransformer {
            public String transform(int var1);
        }

        public static class DefaultPosTranformer
        implements PosTransformer {
            public String transform(int pos) {
                return pos == -1 ? "-" : String.valueOf(pos);
            }
        }
    }
}

