/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.types;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBase64CharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDHexBinaryCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDStringCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.AbstractTypeEncoder;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class LexicalTypeEncoder
extends AbstractTypeEncoder {
    protected RestrictedCharacterSetDatatype rcsBase64Binary = new RestrictedCharacterSetDatatype(new XSDBase64CharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsHexBinary = new RestrictedCharacterSetDatatype(new XSDHexBinaryCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsBoolean = new RestrictedCharacterSetDatatype(new XSDBooleanCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDateTime = new RestrictedCharacterSetDatatype(new XSDDateTimeCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDecimal = new RestrictedCharacterSetDatatype(new XSDDecimalCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDouble = new RestrictedCharacterSetDatatype(new XSDDoubleCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsInteger = new RestrictedCharacterSetDatatype(new XSDIntegerCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsString = new RestrictedCharacterSetDatatype(new XSDStringCharacterSet(), null);
    protected Value lastValue;
    protected Datatype lastDatatype;

    public LexicalTypeEncoder() throws EXIException {
        this(null, null);
    }

    public LexicalTypeEncoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations);
    }

    public boolean isValid(Datatype datatype, Value value) {
        this.lastDatatype = this.dtrMapInUse ? this.getDtrDatatype(datatype) : datatype;
        this.lastValue = value;
        return true;
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        switch (this.lastDatatype.getDatatypeID()) {
            case exi_base64Binary: {
                this.rcsBase64Binary.isValid(this.lastValue);
                this.rcsBase64Binary.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_hexBinary: {
                this.rcsHexBinary.isValid(this.lastValue);
                this.rcsHexBinary.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_boolean: {
                this.rcsBoolean.isValid(this.lastValue);
                this.rcsBoolean.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_dateTime: 
            case exi_time: 
            case exi_date: 
            case exi_gYearMonth: 
            case exi_gYear: 
            case exi_gMonthDay: 
            case exi_gDay: 
            case exi_gMonth: {
                this.rcsDateTime.isValid(this.lastValue);
                this.rcsDateTime.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_decimal: {
                this.rcsDecimal.isValid(this.lastValue);
                this.rcsDecimal.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_double: {
                this.rcsDouble.isValid(this.lastValue);
                this.rcsDouble.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_integer: {
                this.rcsInteger.isValid(this.lastValue);
                this.rcsInteger.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            case exi_string: {
                this.rcsString.isValid(this.lastValue);
                this.rcsString.writeValue(qnContext, valueChannel, stringEncoder);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

