/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.types;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.BinaryBase64Datatype;
import com.siemens.ct.exi.datatype.BinaryHexDatatype;
import com.siemens.ct.exi.datatype.BooleanDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatetimeDatatype;
import com.siemens.ct.exi.datatype.DecimalDatatype;
import com.siemens.ct.exi.datatype.FloatDatatype;
import com.siemens.ct.exi.datatype.IntegerDatatype;
import com.siemens.ct.exi.datatype.ListDatatype;
import com.siemens.ct.exi.datatype.StringDatatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.types.TypeCoder;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractTypeCoder
implements TypeCoder {
    protected final QName[] dtrMapTypes;
    protected final QName[] dtrMapRepresentations;
    protected Map<QName, Datatype> dtrMap;
    protected final boolean dtrMapInUse;

    public AbstractTypeCoder() throws EXIException {
        this(null, null);
    }

    public AbstractTypeCoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations) throws EXIException {
        this.dtrMapTypes = dtrMapTypes;
        this.dtrMapRepresentations = dtrMapRepresentations;
        if (dtrMapTypes == null) {
            this.dtrMapInUse = false;
        } else {
            this.dtrMapInUse = true;
            this.dtrMap = new HashMap<QName, Datatype>();
            assert (dtrMapTypes.length == dtrMapRepresentations.length);
            this.initDtrMaps();
        }
    }

    private void initDtrMaps() throws EXIException {
        assert (this.dtrMapInUse);
        this.dtrMap.put(BuiltIn.XSD_BASE64BINARY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "base64Binary"));
        this.dtrMap.put(BuiltIn.XSD_HEXBINARY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "hexBinary"));
        this.dtrMap.put(BuiltIn.XSD_BOOLEAN, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "boolean"));
        this.dtrMap.put(BuiltIn.XSD_DATETIME, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "dateTime"));
        this.dtrMap.put(BuiltIn.XSD_TIME, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "time"));
        this.dtrMap.put(BuiltIn.XSD_DATE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "date"));
        this.dtrMap.put(BuiltIn.XSD_GYEARMONTH, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gYearMonth"));
        this.dtrMap.put(BuiltIn.XSD_GYEAR, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gYear"));
        this.dtrMap.put(BuiltIn.XSD_GMONTHDAY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gMonthDay"));
        this.dtrMap.put(BuiltIn.XSD_GDAY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gDay"));
        this.dtrMap.put(BuiltIn.XSD_GMONTH, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gMonth"));
        this.dtrMap.put(BuiltIn.XSD_DECIMAL, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "decimal"));
        this.dtrMap.put(BuiltIn.XSD_FLOAT, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "double"));
        this.dtrMap.put(BuiltIn.XSD_DOUBLE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "double"));
        this.dtrMap.put(BuiltIn.XSD_INTEGER, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "integer"));
        this.dtrMap.put(BuiltIn.XSD_STRING, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "string"));
        this.dtrMap.put(BuiltIn.XSD_ANY_SIMPLE_TYPE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "string"));
        for (int i = 0; i < this.dtrMapTypes.length; ++i) {
            QName dtrMapRepr = this.dtrMapRepresentations[i];
            Datatype representation = this.getDatatypeRepresentation(dtrMapRepr.getNamespaceURI(), dtrMapRepr.getLocalPart());
            QName type = this.dtrMapTypes[i];
            this.dtrMap.put(type, representation);
        }
    }

    protected Datatype getDtrDatatype(Datatype datatype) {
        Datatype dtrDatatype;
        assert (this.dtrMapInUse);
        if (datatype == BuiltIn.DEFAULT_DATATYPE) {
            dtrDatatype = datatype;
        } else {
            Datatype dtBase;
            QNameContext baseType;
            QNameContext qncSchemaType = datatype.getSchemaType();
            QName schemaType = qncSchemaType.getQName();
            dtrDatatype = this.dtrMap.get(schemaType);
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.STRING && ((StringDatatype)datatype).isDerivedByUnion()) {
                dtrDatatype = datatype;
                baseType = qncSchemaType.getSimpleBaseType();
                if (baseType != null && (dtBase = baseType.getSimpleDatatype()) != null && dtBase.getBuiltInType() == BuiltInType.STRING && ((StringDatatype)dtBase).isDerivedByUnion()) {
                    dtrDatatype = null;
                }
            }
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.LIST) {
                dtrDatatype = datatype;
                baseType = qncSchemaType.getSimpleBaseType();
                if (baseType != null && (dtBase = baseType.getSimpleDatatype()) != null && dtBase.getBuiltInType() == BuiltInType.LIST) {
                    dtrDatatype = null;
                }
            }
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.ENUMERATION) {
                dtrDatatype = datatype;
                baseType = qncSchemaType.getSimpleBaseType();
                if (baseType != null && (dtBase = baseType.getSimpleDatatype()) != null && dtBase.getBuiltInType() == BuiltInType.ENUMERATION) {
                    dtrDatatype = null;
                }
            }
            if (dtrDatatype == null && (dtrDatatype = this.updateDtrDatatype(qncSchemaType)).getBuiltInType() == BuiltInType.INTEGER && (datatype.getBuiltInType() == BuiltInType.NBIT_UNSIGNED_INTEGER || datatype.getBuiltInType() == BuiltInType.UNSIGNED_INTEGER)) {
                dtrDatatype = datatype;
            }
        }
        assert (dtrDatatype != null);
        if (dtrDatatype.getBuiltInType() == BuiltInType.LIST) {
            Datatype prev = dtrDatatype;
            ListDatatype ldt = (ListDatatype)dtrDatatype;
            Datatype dtList = ldt.getListDatatype();
            dtrDatatype = (dtrDatatype = this.getDtrDatatype(dtList)) != dtList ? new ListDatatype(dtrDatatype, ldt.getSchemaType()) : prev;
        }
        return dtrDatatype;
    }

    protected Datatype updateDtrDatatype(QNameContext qncSchemaType) {
        assert (this.dtrMapInUse);
        QNameContext simpleBaseType = qncSchemaType.getSimpleBaseType();
        Datatype dt = this.dtrMap.get(simpleBaseType.getQName());
        if (dt == null) {
            dt = this.updateDtrDatatype(simpleBaseType);
        } else {
            this.dtrMap.put(simpleBaseType.getQName(), dt);
        }
        return dt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Datatype getDatatypeRepresentation(String reprUri, String reprLocalPart) throws EXIException {
        assert (this.dtrMapInUse);
        try {
            void var3_20;
            Object var3_3 = null;
            if ("http://www.w3.org/2009/exi".equals(reprUri)) {
                if ("base64Binary".equals(reprLocalPart)) {
                    BinaryBase64Datatype binaryBase64Datatype = new BinaryBase64Datatype(null);
                    return var3_20;
                } else if ("hexBinary".equals(reprLocalPart)) {
                    BinaryHexDatatype binaryHexDatatype = new BinaryHexDatatype(null);
                    return var3_20;
                } else if ("boolean".equals(reprLocalPart)) {
                    BooleanDatatype booleanDatatype = new BooleanDatatype(null);
                    return var3_20;
                } else if ("dateTime".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.dateTime, null);
                    return var3_20;
                } else if ("time".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.time, null);
                    return var3_20;
                } else if ("date".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.date, null);
                    return var3_20;
                } else if ("gYearMonth".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYearMonth, null);
                    return var3_20;
                } else if ("gYear".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYear, null);
                    return var3_20;
                } else if ("gMonthDay".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonthDay, null);
                    return var3_20;
                } else if ("gDay".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gDay, null);
                    return var3_20;
                } else if ("gMonth".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonth, null);
                    return var3_20;
                } else if ("decimal".equals(reprLocalPart)) {
                    DecimalDatatype decimalDatatype = new DecimalDatatype(null);
                    return var3_20;
                } else if ("double".equals(reprLocalPart)) {
                    FloatDatatype floatDatatype = new FloatDatatype(null);
                    return var3_20;
                } else if ("integer".equals(reprLocalPart)) {
                    IntegerDatatype integerDatatype = new IntegerDatatype(null);
                    return var3_20;
                } else {
                    if (!"string".equals(reprLocalPart)) throw new EXIException("[EXI] Unsupported datatype representation: {" + reprUri + "}" + reprLocalPart);
                    StringDatatype stringDatatype = new StringDatatype(null);
                }
                return var3_20;
            } else {
                String className = QNameUtilities.getClassName(new QName(reprUri, reprLocalPart));
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                if (!(o instanceof Datatype)) throw new Exception("[EXI] no Datatype instance");
                Datatype datatype = (Datatype)o;
            }
            return var3_20;
        }
        catch (Exception exception) {
            throw new EXIException(exception);
        }
    }
}

