/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream {
    public static final int BUFFER_CAPACITY = 8;
    private int capacity = 0;
    private int buffer = 0;
    private InputStream istream;

    public BitInputStream(InputStream istream) {
        this.istream = istream;
    }

    public void setInputStream(InputStream istream) {
        this.istream = istream;
        this.capacity = 0;
        this.buffer = 0;
    }

    private final int readDirectByte() throws IOException {
        int b = this.istream.read();
        if (b == -1) {
            throw new EOFException("Premature EOS found while reading data.");
        }
        return b;
    }

    private final void readBuffer() throws IOException {
        this.buffer = this.readDirectByte();
        this.capacity = 8;
    }

    public void align() throws IOException {
        if (this.capacity != 0) {
            this.capacity = 0;
        }
    }

    public int lookAhead() throws IOException {
        if (this.capacity == 0) {
            this.readBuffer();
        }
        return this.buffer;
    }

    public void skip(long n) throws IOException {
        if (this.capacity == 0) {
            while (n != 0L) {
                n -= this.istream.skip(n);
            }
        } else {
            int i = 0;
            while ((long)i < n) {
                this.readBits(8);
                ++n;
            }
        }
    }

    public int readBit() throws IOException {
        if (this.capacity == 0) {
            this.readBuffer();
        }
        return this.buffer >> --this.capacity & 1;
    }

    public int readBits(int n) throws IOException {
        int result;
        assert (n > 0);
        if (n <= this.capacity) {
            result = this.buffer >> (this.capacity -= n) & 255 >> 8 - n;
        } else if (this.capacity == 0 && n == 8) {
            result = this.readDirectByte();
        } else {
            result = this.buffer & 255 >> 8 - this.capacity;
            n -= this.capacity;
            this.capacity = 0;
            while (n > 7) {
                if (this.capacity == 0) {
                    this.readBuffer();
                }
                result = result << 8 | this.buffer;
                n -= 8;
                this.capacity = 0;
            }
            if (n > 0) {
                if (this.capacity == 0) {
                    this.readBuffer();
                }
                this.capacity = 8 - n;
                result = result << n | this.buffer >> this.capacity;
            }
        }
        return result;
    }

    public final int read() throws IOException {
        return this.capacity == 0 ? this.readDirectByte() : this.readBits(8);
    }

    public void read(byte[] b, int off, int len) throws IOException {
        assert (len >= 0);
        if (len != 0) {
            if (this.capacity == 0) {
                int br;
                int readBytes = 0;
                do {
                    if ((br = this.istream.read(b, readBytes, len - readBytes)) != -1) continue;
                    throw new EOFException("Premature EOS found while reading data.");
                } while ((readBytes += br) < len);
            } else {
                int shift = 8 - this.capacity;
                for (int i = 0; i < len; ++i) {
                    this.buffer = this.readDirectByte();
                    b[i] = (byte)(this.buffer << shift | this.buffer >> this.capacity);
                }
            }
        }
    }
}

