/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class RestrictedCharacterSetDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -6098764255799006920L;
    protected String lastValidValue;
    protected RestrictedCharacterSet rcs;

    public RestrictedCharacterSetDatatype(RestrictedCharacterSet rcs, QNameContext schemaType) {
        super(BuiltInType.RCS_STRING, schemaType);
        this.rcs = rcs;
    }

    public RestrictedCharacterSet getRestrictedCharacterSet() {
        return this.rcs;
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_string;
    }

    public boolean isValid(Value value) {
        this.lastValidValue = value.toString();
        return true;
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        if (stringEncoder.isStringHit(this.lastValidValue)) {
            stringEncoder.writeValue(qnContext, valueChannel, this.lastValidValue);
        } else {
            int L = this.lastValidValue.length();
            valueChannel.encodeUnsignedInteger(L + 2);
            if (L > 0) {
                int numberOfBits = this.rcs.getCodingLength();
                for (int i = 0; i < L; ++i) {
                    int codePoint = this.lastValidValue.codePointAt(i);
                    int code = this.rcs.getCode(codePoint);
                    if (code == -1) {
                        valueChannel.encodeNBitUnsignedInteger(this.rcs.size(), numberOfBits);
                        valueChannel.encodeUnsignedInteger(codePoint);
                        continue;
                    }
                    valueChannel.encodeNBitUnsignedInteger(code, numberOfBits);
                }
                stringEncoder.addValue(qnContext, this.lastValidValue);
            }
        }
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        StringValue value;
        int i = valueChannel.decodeUnsignedInteger();
        if (i == 0) {
            value = stringDecoder.readValueLocalHit(qnContext, valueChannel);
        } else if (i == 1) {
            value = stringDecoder.readValueGlobalHit(valueChannel);
        } else {
            int L = i - 2;
            if (L > 0) {
                int numberOfBits = this.rcs.getCodingLength();
                int size = this.rcs.size();
                char[] cValue = new char[L];
                value = new StringValue(cValue);
                for (int k = 0; k < L; ++k) {
                    int code = valueChannel.decodeNBitUnsignedInteger(numberOfBits);
                    int codePoint = code == size ? valueChannel.decodeUnsignedInteger() : this.rcs.getCodePoint(code);
                    Character.toChars(codePoint, cValue, k);
                }
                stringDecoder.addValue(qnContext, value);
            } else {
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        return value;
    }
}

