/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class EnumerationDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -5065239322174326749L;
    protected Datatype dtEnumValues;
    protected int codingLength;
    protected Value[] enumValues;
    protected int lastValidIndex;

    public EnumerationDatatype(Value[] enumValues, Datatype dtEnumValues, QNameContext schemaType) {
        super(BuiltInType.ENUMERATION, schemaType);
        this.dtEnumValues = dtEnumValues;
        this.enumValues = enumValues;
        this.codingLength = MethodsBag.getCodingLength(enumValues.length);
    }

    public Datatype getEnumValueDatatype() {
        return this.dtEnumValues;
    }

    public DatatypeID getDatatypeID() {
        return this.dtEnumValues.getDatatypeID();
    }

    public int getEnumerationSize() {
        return this.enumValues.length;
    }

    public int getCodingLength() {
        return this.codingLength;
    }

    public boolean isValid(Value value) {
        for (int index = 0; index < this.enumValues.length; ++index) {
            if (!this.enumValues[index].equals(value)) continue;
            this.lastValidIndex = index;
            return true;
        }
        return false;
    }

    public Value getEnumValue(int i) {
        assert (i >= 0 && i < this.enumValues.length);
        return this.enumValues[i];
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastValidIndex, this.codingLength);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        int index = valueChannel.decodeNBitUnsignedInteger(this.codingLength);
        assert (index >= 0 && index < this.enumValues.length);
        return this.enumValues[index];
    }
}

