/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EncodingOptions;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.core.AbstractEXIHeader;
import com.siemens.ct.exi.core.EXIBodyEncoderInOrder;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.io.channel.BitEncoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.DecimalValue;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.QNameValue;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import javax.xml.namespace.QName;

public class EXIHeaderEncoder
extends AbstractEXIHeader {
    protected static final BooleanValue BOOLEAN_VALUE_TRUE = new BooleanValue(true);

    public void write(BitEncoderChannel headerChannel, EXIFactory f) throws EXIException {
        try {
            EncodingOptions headerOptions = f.getEncodingOptions();
            CodingMode codingMode = f.getCodingMode();
            if (headerOptions.isOptionEnabled("INCLUDE_COOKIE")) {
                headerChannel.encode(36);
                headerChannel.encode(69);
                headerChannel.encode(88);
                headerChannel.encode(73);
            }
            headerChannel.encodeNBitUnsignedInteger(2, 2);
            boolean includeOptions = headerOptions.isOptionEnabled("INCLUDE_OPTIONS");
            headerChannel.encodeBoolean(includeOptions);
            headerChannel.encodeBoolean(false);
            headerChannel.encodeNBitUnsignedInteger(0, 4);
            if (includeOptions) {
                this.writeEXIOptions(f, headerChannel);
            }
            if (codingMode != CodingMode.BIT_PACKED) {
                headerChannel.align();
                headerChannel.flush();
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void writeEXIOptions(EXIFactory f, EncoderChannel encoderChannel) throws EXIException, IOException {
        EXIBodyEncoderInOrder encoder = (EXIBodyEncoderInOrder)this.getHeaderFactory().createEXIBodyEncoder();
        encoder.setOutputChannel(encoderChannel);
        encoder.encodeStartDocument();
        encoder.encodeStartElement("http://www.w3.org/2009/exi", "header", null);
        if (this.isLessCommon(f)) {
            encoder.encodeStartElement("http://www.w3.org/2009/exi", "lesscommon", null);
            if (this.isUncommon(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "uncommon", null);
                if (this.isUserDefinedMetaData(f) && f.getEncodingOptions().isOptionEnabled("INCLUDE_PROFILE_VALUES")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "p", null);
                    boolean negative = f.isLocalValuePartitions();
                    IntegerValue integral = IntegerValue.valueOf(1 + f.getMaximumNumberOfBuiltInElementGrammars());
                    IntegerValue revFractional = IntegerValue.valueOf(1 + f.getMaximumNumberOfBuiltInProductions());
                    QNameValue qnv = new QNameValue("http://www.w3.org/2001/XMLSchema", "decimal", null);
                    encoder.encodeAttributeXsiType(qnv, null);
                    DecimalValue dv = new DecimalValue(negative, integral, revFractional);
                    encoder.encodeCharactersForce(dv);
                    encoder.encodeEndElement();
                }
                if (this.isAlignment(f)) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "alignment", null);
                    if (this.isByte(f)) {
                        encoder.encodeStartElement("http://www.w3.org/2009/exi", "byte", null);
                        encoder.encodeEndElement();
                    }
                    if (this.isPreCompress(f)) {
                        encoder.encodeStartElement("http://www.w3.org/2009/exi", "pre-compress", null);
                        encoder.encodeEndElement();
                    }
                    encoder.encodeEndElement();
                }
                if (this.isSelfContained(f)) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "selfContained", null);
                    encoder.encodeEndElement();
                }
                if (this.isValueMaxLength(f)) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "valueMaxLength", null);
                    encoder.encodeCharacters(IntegerValue.valueOf(f.getValueMaxLength()));
                    encoder.encodeEndElement();
                }
                if (this.isValuePartitionCapacity(f)) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "valuePartitionCapacity", null);
                    encoder.encodeCharacters(IntegerValue.valueOf(f.getValuePartitionCapacity()));
                    encoder.encodeEndElement();
                }
                if (this.isDatatypeRepresentationMap(f)) {
                    QName[] types = f.getDatatypeRepresentationMapTypes();
                    QName[] representations = f.getDatatypeRepresentationMapRepresentations();
                    assert (types.length == representations.length);
                    for (int i = 0; i < types.length; ++i) {
                        encoder.encodeStartElement("http://www.w3.org/2009/exi", "datatypeRepresentationMap", null);
                        QName type = types[i];
                        encoder.encodeStartElement(type.getNamespaceURI(), type.getLocalPart(), null);
                        encoder.encodeEndElement();
                        QName representation = representations[i];
                        encoder.encodeStartElement(representation.getNamespaceURI(), representation.getLocalPart(), null);
                        encoder.encodeEndElement();
                        encoder.encodeEndElement();
                    }
                }
                encoder.encodeEndElement();
            }
            if (this.isPreserve(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "preserve", null);
                FidelityOptions fo = f.getFidelityOptions();
                if (fo.isFidelityEnabled("PRESERVE_DTDS")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "dtd", null);
                    encoder.encodeEndElement();
                }
                if (fo.isFidelityEnabled("PRESERVE_PREFIXES")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "prefixes", null);
                    encoder.encodeEndElement();
                }
                if (fo.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "lexicalValues", null);
                    encoder.encodeEndElement();
                }
                if (fo.isFidelityEnabled("PRESERVE_COMMENTS")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "comments", null);
                    encoder.encodeEndElement();
                }
                if (fo.isFidelityEnabled("PRESERVE_PIS")) {
                    encoder.encodeStartElement("http://www.w3.org/2009/exi", "pis", null);
                    encoder.encodeEndElement();
                }
                encoder.encodeEndElement();
            }
            if (this.isBlockSize(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "blockSize", null);
                encoder.encodeCharacters(IntegerValue.valueOf(f.getBlockSize()));
                encoder.encodeEndElement();
            }
            encoder.encodeEndElement();
        }
        if (this.isCommon(f)) {
            encoder.encodeStartElement("http://www.w3.org/2009/exi", "common", null);
            if (this.isCompression(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "compression", null);
                encoder.encodeEndElement();
            }
            if (this.isFragment(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "fragment", null);
                encoder.encodeEndElement();
            }
            if (this.isSchemaId(f)) {
                encoder.encodeStartElement("http://www.w3.org/2009/exi", "schemaId", null);
                Grammars g = f.getGrammars();
                if (g.isBuiltInXMLSchemaTypesOnly()) {
                    assert ("".equals(g.getSchemaId()));
                    encoder.encodeCharacters(StringCoder.EMPTY_STRING_VALUE);
                } else if (g.isSchemaInformed()) {
                    String schemaId = g.getSchemaId();
                    assert (schemaId != null && schemaId.length() > 0);
                    encoder.encodeCharacters(new StringValue(schemaId));
                } else {
                    encoder.encodeAttributeXsiNil(BOOLEAN_VALUE_TRUE, null);
                }
                encoder.encodeEndElement();
            }
            encoder.encodeEndElement();
        }
        if (this.isStrict(f)) {
            encoder.encodeStartElement("http://www.w3.org/2009/exi", "strict", null);
            encoder.encodeEndElement();
        }
        encoder.encodeEndElement();
        encoder.encodeEndDocument();
    }

    protected boolean isLessCommon(EXIFactory f) {
        return this.isUncommon(f) || this.isPreserve(f) || this.isBlockSize(f);
    }

    protected boolean isUncommon(EXIFactory f) {
        return this.isUserDefinedMetaData(f) || this.isAlignment(f) || this.isSelfContained(f) || this.isValueMaxLength(f) || this.isValuePartitionCapacity(f) || this.isDatatypeRepresentationMap(f);
    }

    protected boolean isUserDefinedMetaData(EXIFactory f) {
        return f.isGrammarLearningDisabled() || !f.isLocalValuePartitions();
    }

    protected boolean isAlignment(EXIFactory f) {
        return this.isByte(f) || this.isPreCompress(f);
    }

    protected boolean isByte(EXIFactory f) {
        return f.getCodingMode() == CodingMode.BYTE_PACKED;
    }

    protected boolean isPreCompress(EXIFactory f) {
        return f.getCodingMode() == CodingMode.PRE_COMPRESSION;
    }

    protected boolean isSelfContained(EXIFactory f) {
        return f.getFidelityOptions().isFidelityEnabled("SELF_CONTAINED");
    }

    protected boolean isValueMaxLength(EXIFactory f) {
        return f.getValueMaxLength() != -1;
    }

    protected boolean isValuePartitionCapacity(EXIFactory f) {
        return f.getValuePartitionCapacity() >= 0;
    }

    protected boolean isDatatypeRepresentationMap(EXIFactory f) {
        return f.getDatatypeRepresentationMapTypes() != null;
    }

    protected boolean isPreserve(EXIFactory f) {
        FidelityOptions fo = f.getFidelityOptions();
        return fo.isFidelityEnabled("PRESERVE_DTDS") || fo.isFidelityEnabled("PRESERVE_PREFIXES") || fo.isFidelityEnabled("PRESERVE_LEXICAL_VALUES") || fo.isFidelityEnabled("PRESERVE_COMMENTS") || fo.isFidelityEnabled("PRESERVE_PIS");
    }

    protected boolean isBlockSize(EXIFactory f) {
        return f.getBlockSize() != 1000000;
    }

    protected boolean isCommon(EXIFactory f) {
        return this.isCompression(f) || this.isFragment(f) || this.isSchemaId(f);
    }

    protected boolean isCompression(EXIFactory f) {
        return f.getCodingMode() == CodingMode.COMPRESSION;
    }

    protected boolean isFragment(EXIFactory f) {
        return f.isFragment();
    }

    protected boolean isSchemaId(EXIFactory f) {
        EncodingOptions ho = f.getEncodingOptions();
        return ho.isOptionEnabled("INCLUDE_SCHEMA_ID");
    }

    protected boolean isStrict(EXIFactory f) {
        return f.getFidelityOptions().isStrict();
    }
}

