/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.AbstractEXIBodyCoder;
import com.siemens.ct.exi.core.AbstractEXIBodyDecoder;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.PreReadValue;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.io.channel.ByteDecoderChannel;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.values.Value;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXIBodyDecoderReordered
extends AbstractEXIBodyDecoder {
    protected List<EventType> eventTypes = new ArrayList<EventType>();
    protected int eventTypeIndex;
    protected List<AbstractEXIBodyCoder.ElementContext> elementEntries = new ArrayList<AbstractEXIBodyCoder.ElementContext>();
    protected int elementEntryIndex;
    protected List<QNameEntry> qnameEntries = new ArrayList<QNameEntry>();
    protected int qnameEntryIndex;
    protected List<DocType> docTypeEntries = new ArrayList<DocType>();
    protected int docTypeEntryIndex;
    protected List<char[]> entityReferences = new ArrayList<char[]>();
    protected int entityReferenceIndex;
    protected List<char[]> comments = new ArrayList<char[]>();
    protected int commentIndex;
    protected List<NamespaceDeclaration> nsEntries = new ArrayList<NamespaceDeclaration>();
    protected int nsEntryIndex;
    protected List<ProcessingInstruction> processingEntries = new ArrayList<ProcessingInstruction>();
    protected int processingEntryIndex;
    protected int blockValues;
    boolean stillNoEndOfDocument = true;
    AbstractEXIBodyCoder.ElementContext lastBlockElementContext;
    protected CodingMode codingMode;
    AbstractEXIBodyCoder.ElementContext currElementEntry;
    protected Map<QNameContext, PreReadValue> contentValues;
    protected List<Value> xsiValues;
    protected int xsiValueIndex;
    protected List<String> xsiPrefixes;
    protected int xsiPrefixIndex;
    protected Inflater inflater;
    protected InputStream recentInflaterInputStream;
    protected Map<QNameContext, List<Datatype>> channelDatatypes;
    protected Map<QNameContext, PreReadValue> preReadValues = new HashMap<QNameContext, PreReadValue>();
    protected boolean firstChannel;
    protected InputStream is;

    public EXIBodyDecoderReordered(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.channelDatatypes = new LinkedHashMap<QNameContext, List<Datatype>>();
        this.contentValues = new HashMap<QNameContext, PreReadValue>();
        this.xsiValues = new ArrayList<Value>();
        this.xsiPrefixes = new ArrayList<String>();
        this.codingMode = exiFactory.getCodingMode();
    }

    @Override
    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.nextEvent = null;
        this.nextEventType = EventType.START_DOCUMENT;
        this.elementEntries.clear();
        this.elementEntryIndex = 0;
        this.qnameEntries.clear();
        this.qnameEntryIndex = 0;
        this.docTypeEntries.clear();
        this.docTypeEntryIndex = 0;
        this.entityReferences.clear();
        this.entityReferenceIndex = 0;
        this.comments.clear();
        this.commentIndex = 0;
        this.nsEntries.clear();
        this.nsEntryIndex = 0;
        this.processingEntries.clear();
        this.processingEntryIndex = 0;
        this.stillNoEndOfDocument = true;
        this.lastBlockElementContext = null;
        this.channelDatatypes.clear();
        this.initBlock();
        this.preReadBlockStructure();
        this.preReadBlockContent();
    }

    protected void initBlock() {
        this.blockValues = 0;
        this.eventTypes.clear();
        this.eventTypeIndex = 0;
        this.initCompressionBlock();
        this.contentValues.clear();
        this.xsiValues.clear();
        this.xsiValueIndex = 0;
        this.xsiPrefixes.clear();
        this.xsiPrefixIndex = 0;
    }

    protected void initCompressionBlock() {
        this.channelDatatypes.clear();
        this.preReadValues.clear();
    }

    protected void addDatatype(QNameContext qnc, Datatype d) {
        List<Datatype> ds = this.channelDatatypes.get(qnc);
        if (ds == null) {
            ds = new ArrayList<Datatype>();
            this.channelDatatypes.put(qnc, ds);
        }
        ds.add(d);
    }

    @Override
    public void setInputStream(InputStream is) throws EXIException, IOException {
        this.updateInputStream(is);
        this.initForEachRun();
    }

    @Override
    public void updateInputStream(InputStream is) throws EXIException, IOException {
        this.is = is;
        this.firstChannel = true;
        this.channel = this.getNextChannel();
    }

    @Override
    public void setInputChannel(DecoderChannel channel) throws EXIException, IOException {
        throw new RuntimeException("[EXI] Reorderd EXI Body decoder needs to be set via setInputStream(...)");
    }

    @Override
    public void updateInputChannel(DecoderChannel decoderChannel) throws EXIException, IOException {
        throw new RuntimeException("[EXI] Reorderd EXI Body decoder needs to be set via updateInputStream(...)");
    }

    public DecoderChannel getNextChannel() throws IOException {
        if (this.codingMode == CodingMode.COMPRESSION) {
            if (this.firstChannel) {
                if (this.inflater == null) {
                    this.inflater = new Inflater(true);
                }
                this.recentInflaterInputStream = new EXIInflaterInputStream(this.is, this.inflater);
                this.firstChannel = false;
            } else {
                assert (this.inflater != null);
                while (!this.inflater.finished()) {
                    this.recentInflaterInputStream.read();
                }
            }
            this.inflater.reset();
            return new ByteDecoderChannel(this.recentInflaterInputStream);
        }
        assert (this.codingMode == CodingMode.PRE_COMPRESSION);
        if (this.firstChannel) {
            this.channel = new ByteDecoderChannel(this.is);
            this.firstChannel = false;
        }
        return this.channel;
    }

    protected void updateAttributeToXsiType() throws EXIException, IOException {
        this.eventTypes.set(this.eventTypes.size() - 1, EventType.ATTRIBUTE_XSI_TYPE);
        this.decodeAttributeXsiTypeStructure();
        this.xsiValues.add(this.attributeValue);
        this.xsiPrefixes.add(this.attributePrefix);
    }

    protected void handleSpecialAttributeCases() throws EXIException, IOException {
        if (this.getXsiTypeContext().equals(this.attributeQNameContext)) {
            this.updateAttributeToXsiType();
        } else if (this.getXsiNilContext().equals(this.attributeQNameContext) && this.getCurrentGrammar().isSchemaInformed()) {
            this.eventTypes.set(this.eventTypes.size() - 1, EventType.ATTRIBUTE_XSI_NIL);
            this.decodeAttributeXsiNilStructure();
            this.xsiValues.add(this.attributeValue);
            this.xsiPrefixes.add(this.attributePrefix);
        } else {
            Datatype dt = BuiltIn.DEFAULT_DATATYPE;
            if (this.getCurrentGrammar().isSchemaInformed() && this.attributeQNameContext.getGlobalAttribute() != null) {
                dt = this.attributeQNameContext.getGlobalAttribute().getDatatype();
            }
            this.addQNameEntry(new QNameEntry(this.attributeQNameContext, this.attributePrefix));
            this.incrementValues(this.attributeQNameContext, dt);
        }
    }

    protected void preReadBlockStructure() throws EXIException, IOException {
        boolean stillBlockReadable = true;
        boolean deferredStartElement = false;
        if (this.lastBlockElementContext != null) {
            this.updateElementContext(this.lastBlockElementContext);
        }
        block29: while (this.stillNoEndOfDocument && stillBlockReadable) {
            if (deferredStartElement) {
                switch (this.nextEventType) {
                    case ATTRIBUTE: 
                    case ATTRIBUTE_INVALID_VALUE: 
                    case ATTRIBUTE_ANY_INVALID_VALUE: 
                    case ATTRIBUTE_GENERIC: 
                    case ATTRIBUTE_NS: 
                    case ATTRIBUTE_GENERIC_UNDECLARED: 
                    case START_ELEMENT: 
                    case START_ELEMENT_NS: 
                    case START_ELEMENT_GENERIC: 
                    case START_ELEMENT_GENERIC_UNDECLARED: 
                    case END_ELEMENT: 
                    case END_ELEMENT_UNDECLARED: 
                    case CHARACTERS: 
                    case CHARACTERS_GENERIC: 
                    case CHARACTERS_GENERIC_UNDECLARED: 
                    case DOC_TYPE: 
                    case ENTITY_REFERENCE: 
                    case COMMENT: 
                    case PROCESSING_INSTRUCTION: {
                        this.elementEntries.add(this.getElementContext());
                        deferredStartElement = false;
                    }
                }
            }
            this.eventTypes.add(this.nextEventType);
            switch (this.nextEventType) {
                case START_DOCUMENT: {
                    this.decodeStartDocumentStructure();
                    break;
                }
                case START_ELEMENT: {
                    this.decodeStartElementStructure();
                    deferredStartElement = true;
                    break;
                }
                case START_ELEMENT_NS: {
                    this.decodeStartElementNSStructure();
                    deferredStartElement = true;
                    break;
                }
                case START_ELEMENT_GENERIC: {
                    this.decodeStartElementGenericStructure();
                    deferredStartElement = true;
                    break;
                }
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    this.decodeStartElementGenericUndeclaredStructure();
                    deferredStartElement = true;
                    break;
                }
                case NAMESPACE_DECLARATION: {
                    this.nsEntries.add(this.decodeNamespaceDeclarationStructure());
                    break;
                }
                case ATTRIBUTE_XSI_TYPE: {
                    this.decodeAttributeXsiTypeStructure();
                    this.xsiPrefixes.add(this.attributePrefix);
                    this.xsiValues.add(this.attributeValue);
                    break;
                }
                case ATTRIBUTE_XSI_NIL: {
                    this.decodeAttributeXsiNilStructure();
                    this.xsiPrefixes.add(this.attributePrefix);
                    this.xsiValues.add(this.attributeValue);
                    break;
                }
                case ATTRIBUTE: {
                    Datatype dtAT = this.decodeAttributeStructure();
                    if (this.getXsiTypeContext().equals(this.attributeQNameContext)) {
                        this.updateAttributeToXsiType();
                        break;
                    }
                    this.addQNameEntry(new QNameEntry(this.attributeQNameContext, this.attributePrefix));
                    this.incrementValues(this.attributeQNameContext, dtAT);
                    break;
                }
                case ATTRIBUTE_INVALID_VALUE: {
                    this.decodeAttributeStructure();
                    this.addQNameEntry(new QNameEntry(this.attributeQNameContext, this.attributePrefix));
                    this.incrementValues(this.attributeQNameContext, BuiltIn.DEFAULT_DATATYPE);
                    break;
                }
                case ATTRIBUTE_ANY_INVALID_VALUE: {
                    this.decodeAttributeAnyInvalidValueStructure();
                    this.addQNameEntry(new QNameEntry(this.attributeQNameContext, this.attributePrefix));
                    this.incrementValues(this.attributeQNameContext, BuiltIn.DEFAULT_DATATYPE);
                    break;
                }
                case ATTRIBUTE_NS: {
                    this.decodeAttributeNSStructure();
                    this.handleSpecialAttributeCases();
                    break;
                }
                case ATTRIBUTE_GENERIC: {
                    this.decodeAttributeGenericStructure();
                    this.handleSpecialAttributeCases();
                    break;
                }
                case ATTRIBUTE_GENERIC_UNDECLARED: {
                    this.decodeAttributeGenericUndeclaredStructure();
                    this.handleSpecialAttributeCases();
                    break;
                }
                case CHARACTERS: {
                    QNameContext qnc = this.getElementContext().qnameContext;
                    this.incrementValues(qnc, this.decodeCharactersStructure());
                    this.addQNameEntry(new QNameEntry(qnc, null));
                    break;
                }
                case CHARACTERS_GENERIC: {
                    this.decodeCharactersGenericStructure();
                    QNameContext qnc = this.getElementContext().qnameContext;
                    this.incrementValues(qnc, BuiltIn.DEFAULT_DATATYPE);
                    this.addQNameEntry(new QNameEntry(qnc, null));
                    break;
                }
                case CHARACTERS_GENERIC_UNDECLARED: {
                    this.decodeCharactersGenericUndeclaredStructure();
                    QNameContext qnc = this.getElementContext().qnameContext;
                    this.incrementValues(qnc, BuiltIn.DEFAULT_DATATYPE);
                    this.addQNameEntry(new QNameEntry(qnc, null));
                    break;
                }
                case END_ELEMENT: {
                    this.decodeEndElementStructure();
                    this.elementEntries.add(this.getElementContext());
                    break;
                }
                case END_ELEMENT_UNDECLARED: {
                    this.decodeEndElementUndeclaredStructure();
                    this.elementEntries.add(this.getElementContext());
                    break;
                }
                case END_DOCUMENT: {
                    this.decodeEndDocumentStructure();
                    this.stillNoEndOfDocument = false;
                    continue block29;
                }
                case DOC_TYPE: {
                    this.docTypeEntries.add(this.decodeDocTypeStructure());
                    break;
                }
                case ENTITY_REFERENCE: {
                    this.entityReferences.add(this.decodeEntityReferenceStructure());
                    break;
                }
                case COMMENT: {
                    this.comments.add(this.decodeCommentStructure());
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    this.processingEntries.add(this.decodeProcessingInstructionStructure());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Event " + (Object)((Object)this.nextEventType));
                }
            }
            if (this.blockValues == this.exiFactory.getBlockSize()) {
                stillBlockReadable = false;
                this.lastBlockElementContext = this.getElementContext();
                assert (!deferredStartElement);
                continue;
            }
            this.decodeEventCode();
        }
        this.updateElementContext(this.lastBlockElementContext);
    }

    protected void preReadBlockContent() throws EXIException {
        try {
            Iterator<QNameContext> iterCh = this.channelDatatypes.keySet().iterator();
            if (this.blockValues <= 100) {
                while (iterCh.hasNext()) {
                    QNameContext o = iterCh.next();
                    List<Datatype> ld = this.channelDatatypes.get(o);
                    Value[] contentValues = new Value[ld.size()];
                    for (int i = 0; i < ld.size(); ++i) {
                        contentValues[i] = this.typeDecoder.readValue(ld.get(i), o, this.channel, this.stringDecoder);
                    }
                    PreReadValue prv = new PreReadValue(contentValues);
                    this.preReadValues.put(o, prv);
                }
            } else {
                List<Datatype> ld;
                DecoderChannel bdcLessEqual100 = null;
                while (iterCh.hasNext()) {
                    QNameContext o = iterCh.next();
                    ld = this.channelDatatypes.get(o);
                    if (ld.size() > 100) continue;
                    Value[] contentValues = new Value[ld.size()];
                    if (bdcLessEqual100 == null) {
                        bdcLessEqual100 = this.getNextChannel();
                    }
                    for (int i = 0; i < ld.size(); ++i) {
                        contentValues[i] = this.typeDecoder.readValue(ld.get(i), o, bdcLessEqual100, this.stringDecoder);
                    }
                    PreReadValue prv = new PreReadValue(contentValues);
                    this.preReadValues.put(o, prv);
                }
                for (QNameContext o : this.channelDatatypes.keySet()) {
                    ld = this.channelDatatypes.get(o);
                    if (ld.size() <= 100) continue;
                    DecoderChannel bdcGreater100 = this.getNextChannel();
                    Value[] contentValues = new Value[ld.size()];
                    for (int i = 0; i < ld.size(); ++i) {
                        contentValues[i] = this.typeDecoder.readValue(ld.get(i), o, bdcGreater100, this.stringDecoder);
                    }
                    PreReadValue prv = new PreReadValue(contentValues);
                    this.preReadValues.put(o, prv);
                }
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void setContentValues(DecoderChannel bdc, QNameContext channelContext, int occs, List<Datatype> datatypes) throws IOException {
        assert (datatypes.size() == occs);
        Value[] decodedValues = new Value[occs];
        for (int k = 0; k < occs; ++k) {
            Datatype dt = datatypes.get(k);
            decodedValues[k] = this.typeDecoder.readValue(dt, channelContext, bdc, this.stringDecoder);
        }
        this.contentValues.put(channelContext, new PreReadValue(decodedValues));
    }

    private final void setupNewBlock() throws IOException, EXIException {
        this.initBlock();
        this.channel = this.getNextChannel();
        this.decodeEventCode();
        this.preReadBlockStructure();
        this.preReadBlockContent();
    }

    protected Value getNextContentValue(QNameContext qname) throws EXIException, IOException {
        --this.blockValues;
        Value v = this.preReadValues.get(qname).getNextContantValue();
        return v;
    }

    @Override
    public EventType next() throws EXIException, IOException {
        if (this.stillNoEndOfDocument && this.blockValues == 0) {
            this.setupNewBlock();
        }
        if (this.stillNoEndOfDocument || this.eventTypes.size() > this.eventTypeIndex) {
            return this.eventTypes.get(this.eventTypeIndex++);
        }
        return null;
    }

    protected void incrementValues(QNameContext valueContext, Datatype datatype) {
        ++this.blockValues;
        this.addDatatype(valueContext, datatype);
    }

    @Override
    public void decodeStartDocument() {
    }

    protected final AbstractEXIBodyCoder.ElementContext setNextElemementEntry() {
        this.currElementEntry = this.elementEntries.get(this.elementEntryIndex++);
        return this.currElementEntry;
    }

    @Override
    public QNameContext decodeStartElement() throws IOException, EXIException {
        return this.setNextElemementEntry().qnameContext;
    }

    @Override
    public QNameContext decodeEndElement() throws EXIException {
        QNameContext eeBefore = this.currElementEntry.qnameContext;
        this.setNextElemementEntry();
        return eeBefore;
    }

    @Override
    public List<NamespaceDeclaration> getDeclaredPrefixDeclarations() {
        return this.currElementEntry.nsDeclarations;
    }

    @Override
    public String getElementPrefix() {
        return this.currElementEntry.getPrefix();
    }

    @Override
    public String getElementQNameAsString() {
        return this.currElementEntry.getQNameAsString();
    }

    @Override
    public NamespaceDeclaration decodeNamespaceDeclaration() throws EXIException {
        return this.nsEntries.get(this.nsEntryIndex++);
    }

    @Override
    public QNameContext decodeAttributeXsiNil() throws EXIException, IOException {
        this.attributeQNameContext = this.getXsiNilContext();
        this.attributePrefix = this.xsiPrefixes.get(this.xsiPrefixIndex++);
        this.attributeValue = this.xsiValues.get(this.xsiValueIndex++);
        return this.attributeQNameContext;
    }

    @Override
    public QNameContext decodeAttributeXsiType() throws EXIException, IOException {
        this.attributeQNameContext = this.getXsiTypeContext();
        this.attributePrefix = this.xsiPrefixes.get(this.xsiPrefixIndex++);
        this.attributeValue = this.xsiValues.get(this.xsiValueIndex++);
        return this.attributeQNameContext;
    }

    protected final void addQNameEntry(QNameEntry qne) {
        this.qnameEntries.add(qne);
    }

    protected final QNameEntry getNextQNameEntry() {
        return this.qnameEntries.get(this.qnameEntryIndex++);
    }

    @Override
    public QNameContext decodeAttribute() throws EXIException, IOException {
        QNameEntry at = this.getNextQNameEntry();
        this.attributeQNameContext = at.qnContext;
        this.attributePrefix = at.prefix;
        this.attributeValue = this.getNextContentValue(this.attributeQNameContext);
        return this.attributeQNameContext;
    }

    @Override
    public Value decodeCharacters() throws EXIException, IOException {
        QNameEntry ch = this.getNextQNameEntry();
        Value chVal = this.getNextContentValue(ch.qnContext);
        return chVal;
    }

    public Value decodeCharactersGeneric() throws EXIException, IOException {
        return this.decodeCharacters();
    }

    public Value decodeCharactersGenericUndeclared() throws EXIException, IOException {
        return this.decodeCharacters();
    }

    @Override
    public void decodeEndDocument() throws EXIException {
    }

    @Override
    public DocType decodeDocType() throws EXIException {
        return this.docTypeEntries.get(this.docTypeEntryIndex++);
    }

    @Override
    public char[] decodeEntityReference() throws EXIException {
        return this.entityReferences.get(this.entityReferenceIndex++);
    }

    @Override
    public char[] decodeComment() throws EXIException {
        return this.comments.get(this.commentIndex++);
    }

    @Override
    public ProcessingInstruction decodeProcessingInstruction() throws EXIException {
        return this.processingEntries.get(this.processingEntryIndex++);
    }

    class EXIInflaterInputStream
    extends FilterInputStream {
        private final Inflater inflater;
        private final byte[] outputBuffer;
        private int outputOffset;
        private int outputLimit;
        private final byte[] inputBuffer;
        private int inputLength;
        private static final int BUF_SIZE = 1024;

        public EXIInflaterInputStream(InputStream inputStream, Inflater inflater) {
            super(inputStream);
            this.inflater = inflater;
            this.inputBuffer = new byte[1024];
            this.inputLength = 0;
            this.outputBuffer = new byte[1024];
            this.outputLimit = 0;
            this.outputOffset = 0;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                b[i + off] = (byte)this.read();
            }
            return len;
        }

        public int read() throws IOException {
            while (this.outputOffset == this.outputLimit && !this.inflater.finished()) {
                this.outputOffset = 0;
                this.inflater.setInput(this.inputBuffer, 0, this.inputLength);
                try {
                    this.outputLimit = this.inflater.inflate(this.outputBuffer);
                }
                catch (DataFormatException e) {
                    throw new IOException(e.getMessage());
                }
                int remain = this.inflater.getRemaining();
                if (remain != 0 && remain != this.inputLength) {
                    int inputOffset = this.inputLength - remain;
                    this.inputLength = remain;
                    System.arraycopy(this.inputBuffer, inputOffset, this.inputBuffer, 0, this.inputLength);
                    continue;
                }
                if (this.outputLimit == 0 && remain == 0) {
                    assert (!this.inflater.finished());
                    this.inputLength = super.read(this.inputBuffer, 0, this.inputBuffer.length);
                    if (this.inputLength >= 0) continue;
                    this.inputLength = 0;
                    return -1;
                }
                this.inputLength = remain;
            }
            return this.outputOffset != this.outputLimit ? this.outputBuffer[this.outputOffset++] & 0xFF : -1;
        }
    }

    static class QNameEntry {
        final QNameContext qnContext;
        final String prefix;

        public QNameEntry(QNameContext qnContext, String prefix) {
            this.qnContext = qnContext;
            this.prefix = prefix;
        }
    }

    static class EndElementEntry {
        final AbstractEXIBodyCoder.ElementContext before;
        final AbstractEXIBodyCoder.ElementContext after;

        public EndElementEntry(AbstractEXIBodyCoder.ElementContext before, AbstractEXIBodyCoder.ElementContext after) {
            this.before = before;
            this.after = after;
        }
    }
}

