/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.GrammarUriContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.datatype.BooleanDatatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.BuiltInStartTag;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.helpers.DefaultErrorHandler;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractEXIBodyCoder {
    protected final EXIFactory exiFactory;
    protected final Grammars grammar;
    protected final GrammarContext grammarContext;
    protected final FidelityOptions fidelityOptions;
    protected final boolean preservePrefix;
    protected final boolean preserveLexicalValues;
    protected ErrorHandler errorHandler;
    protected final BooleanDatatype booleanDatatype;
    private ElementContext elementContext;
    protected ElementContext[] elementContextStack;
    protected int elementContextStackIndex;
    public static final int INITIAL_STACK_SIZE = 16;
    protected Map<QNameContext, StartElement> runtimeGlobalElements;
    List<RuntimeUriContext> runtimeUris;
    protected QNameContext xsiTypeContext;
    protected QNameContext xsiNilContext;
    protected final int gUris;
    protected int nextQNameID;
    protected int nextUriID;
    protected final boolean limitGrammarLearning;
    protected final int maxBuiltInElementGrammars;
    protected final int maxBuiltInProductions;
    protected int learnedProductions;

    public AbstractEXIBodyCoder(EXIFactory exiFactory) throws EXIException {
        this.exiFactory = exiFactory;
        this.grammar = exiFactory.getGrammars();
        this.grammarContext = this.grammar.getGrammarContext();
        this.nextUriID = this.gUris = this.grammarContext.getNumberOfGrammarUriContexts();
        this.fidelityOptions = exiFactory.getFidelityOptions();
        this.preservePrefix = this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES");
        this.preserveLexicalValues = this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES");
        this.errorHandler = new DefaultErrorHandler();
        this.runtimeGlobalElements = new HashMap<QNameContext, StartElement>();
        this.runtimeUris = new ArrayList<RuntimeUriContext>();
        for (int i = 0; i < this.gUris; ++i) {
            this.runtimeUris.add(new RuntimeUriContext(this.grammarContext.getGrammarUriContext(i)));
        }
        this.elementContextStack = new ElementContext[16];
        this.booleanDatatype = new BooleanDatatype(null);
        if (this.grammar.isSchemaInformed()) {
            this.maxBuiltInElementGrammars = this.exiFactory.getMaximumNumberOfBuiltInElementGrammars();
            this.maxBuiltInProductions = this.exiFactory.getMaximumNumberOfBuiltInProductions();
            this.limitGrammarLearning = this.maxBuiltInElementGrammars >= 0 || this.maxBuiltInProductions >= 0;
        } else {
            this.maxBuiltInElementGrammars = -1;
            this.maxBuiltInProductions = -1;
            this.limitGrammarLearning = false;
        }
    }

    protected QNameContext getXsiTypeContext() {
        if (this.xsiTypeContext == null) {
            this.xsiTypeContext = this.grammarContext.getGrammarUriContext(2).getQNameContext(1);
        }
        return this.xsiTypeContext;
    }

    protected QNameContext getXsiNilContext() {
        if (this.xsiNilContext == null) {
            this.xsiNilContext = this.grammarContext.getGrammarUriContext(2).getQNameContext(0);
        }
        return this.xsiNilContext;
    }

    protected final boolean isBuiltInStartTagGrammarWithAtXsiTypeOnly(Grammar g) {
        Attribute at;
        QNameContext qn0;
        Production p0;
        Event ev0;
        boolean ret = false;
        if (g.getNumberOfEvents() == 1 && (ev0 = (p0 = g.getProduction(0)).getEvent()).isEventType(EventType.ATTRIBUTE) && (qn0 = (at = (Attribute)ev0).getQNameContext()).getNamespaceUriID() == 2 && qn0.getLocalNameID() == 1) {
            ret = true;
        }
        return ret;
    }

    protected final StartElement getGlobalStartElement(QNameContext qnc) {
        StartElement se = qnc.getGlobalStartElement();
        if (se == null && (se = this.runtimeGlobalElements.get(qnc)) == null) {
            se = new StartElement(qnc);
            se.setGrammar(new BuiltInStartTag());
            this.runtimeGlobalElements.put(qnc, se);
        }
        return se;
    }

    protected final Grammar getCurrentGrammar() {
        return this.elementContext.gr;
    }

    protected final void updateCurrentRule(Grammar newCurrentGrammar) {
        this.elementContext.gr = newCurrentGrammar;
    }

    protected final ElementContext getElementContext() {
        return this.elementContext;
    }

    protected final void updateElementContext(ElementContext elementContext) {
        this.elementContext = elementContext;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void initForEachRun() throws EXIException, IOException {
        this.runtimeGlobalElements.clear();
        for (int i = 0; i < this.nextUriID; ++i) {
            this.runtimeUris.get(i).clear();
        }
        this.nextQNameID = this.grammarContext.getNumberOfGrammarQNameContexts();
        this.nextUriID = this.gUris;
        Grammar startRule = this.exiFactory.isFragment() ? this.grammar.getFragmentGrammar() : this.grammar.getDocumentGrammar();
        this.elementContextStackIndex = 0;
        this.elementContextStack[this.elementContextStackIndex] = this.elementContext = new ElementContext(null, startRule);
    }

    protected final void declarePrefix(String pfx, String uri) {
        this.declarePrefix(new NamespaceDeclaration(uri, pfx));
    }

    protected final void declarePrefix(NamespaceDeclaration nsDecl) {
        if (this.elementContext.nsDeclarations == null) {
            this.elementContext.nsDeclarations = new ArrayList<NamespaceDeclaration>();
        }
        assert (!this.elementContext.nsDeclarations.contains(nsDecl));
        this.elementContext.nsDeclarations.add(nsDecl);
    }

    protected final String getURI(String prefix) {
        for (int i = this.elementContextStackIndex; i > 0; --i) {
            ElementContext ec = this.elementContextStack[i];
            if (ec.nsDeclarations == null) continue;
            for (NamespaceDeclaration ns : ec.nsDeclarations) {
                if (!ns.prefix.equals(prefix)) continue;
                return ns.namespaceURI;
            }
        }
        return prefix.length() == 0 ? "" : null;
    }

    protected final String getPrefix(String uri) {
        for (int i = 1; i <= this.elementContextStackIndex; ++i) {
            ElementContext ec = this.elementContextStack[i];
            if (ec.nsDeclarations == null) continue;
            for (NamespaceDeclaration ns : ec.nsDeclarations) {
                if (!ns.namespaceURI.equals(uri)) continue;
                return ns.prefix;
            }
        }
        return null;
    }

    protected void pushElement(Grammar updContextGrammar, StartElement se) {
        this.elementContext.gr = updContextGrammar;
        if (this.elementContextStack.length == ++this.elementContextStackIndex) {
            ElementContext[] elementContextStackNew = new ElementContext[this.elementContextStack.length << 2];
            System.arraycopy(this.elementContextStack, 0, elementContextStackNew, 0, this.elementContextStack.length);
            this.elementContextStack = elementContextStackNew;
        }
        this.elementContextStack[this.elementContextStackIndex] = this.elementContext = new ElementContext(se.getQNameContext(), se.getGrammar());
    }

    protected final ElementContext popElement() {
        assert (this.elementContextStackIndex > 0);
        ElementContext poppedEC = this.elementContextStack[this.elementContextStackIndex];
        this.elementContextStack[this.elementContextStackIndex--] = null;
        this.elementContext = this.elementContextStack[this.elementContextStackIndex];
        return poppedEC;
    }

    protected RuntimeUriContext addUri(String uri) {
        RuntimeUriContext ruc;
        int uriID;
        if ((uriID = this.nextUriID++) < this.runtimeUris.size()) {
            ruc = this.runtimeUris.get(uriID);
            ruc.setNamespaceUri(uri);
        } else {
            ruc = new RuntimeUriContext(uriID, uri);
            this.runtimeUris.add(ruc);
        }
        return ruc;
    }

    protected int getNumberOfUris() {
        return this.nextUriID;
    }

    protected RuntimeUriContext getUri(String namespaceUri) {
        for (int i = 0; i < this.nextUriID && i < this.runtimeUris.size(); ++i) {
            RuntimeUriContext ruc = this.runtimeUris.get(i);
            if (!ruc.namespaceUri.equals(namespaceUri)) continue;
            return ruc;
        }
        return null;
    }

    protected RuntimeUriContext getUri(int namespaceUriID) {
        assert (namespaceUriID >= 0 && namespaceUriID < this.nextUriID);
        return this.runtimeUris.get(namespaceUriID);
    }

    protected void throwWarning(String message) {
        this.errorHandler.warning(new EXIException(message + ", options=" + this.exiFactory.getFidelityOptions()));
    }

    final class RuntimeUriContext {
        final int namespaceUriID;
        private String namespaceUri;
        final GrammarUriContext guc;
        List<QNameContext> qnames;
        List<String> prefixes;

        public RuntimeUriContext(int namespaceUriID, String namespaceUri) {
            this(null, namespaceUriID, namespaceUri);
        }

        public RuntimeUriContext(GrammarUriContext guc) {
            this(guc, guc.getNamespaceUriID(), guc.getNamespaceUri());
        }

        private RuntimeUriContext(GrammarUriContext guc, int namespaceUriID, String namespaceUri) {
            this.guc = guc;
            this.namespaceUriID = namespaceUriID;
            this.namespaceUri = namespaceUri;
        }

        protected void clear() {
            if (this.guc == null) {
                this.namespaceUri = null;
            }
            if (this.qnames != null && this.qnames.size() > 0) {
                this.qnames.clear();
            }
            if (AbstractEXIBodyCoder.this.preservePrefix && this.prefixes != null && this.prefixes.size() > 0) {
                this.prefixes.clear();
            }
        }

        protected QNameContext getQNameContext(String localName) {
            QNameContext qnc = null;
            if (this.guc != null) {
                qnc = this.guc.getQNameContext(localName);
            }
            if (qnc == null && this.qnames != null && this.qnames.size() != 0) {
                for (int i = this.qnames.size() - 1; i >= 0; --i) {
                    qnc = this.qnames.get(i);
                    if (!qnc.getLocalName().equals(localName)) continue;
                    return qnc;
                }
                qnc = null;
            }
            return qnc;
        }

        protected QNameContext getQNameContext(int localNameID) {
            QNameContext qnc = null;
            int sub = 0;
            if (this.guc != null) {
                qnc = this.guc.getQNameContext(localNameID);
                sub = this.guc.getNumberOfQNames();
            }
            if (qnc == null) {
                assert ((localNameID -= sub) >= 0 && localNameID < this.qnames.size());
                qnc = this.qnames.get(localNameID);
            }
            return qnc;
        }

        protected int getNumberOfQNames() {
            int n = 0;
            if (this.guc != null) {
                n = this.guc.getNumberOfQNames();
            }
            if (this.qnames != null) {
                n += this.qnames.size();
            }
            return n;
        }

        protected QNameContext addQNameContext(String localName) {
            if (this.qnames == null) {
                this.qnames = new ArrayList<QNameContext>();
            }
            int localNameID = this.getNumberOfQNames();
            QName qName = new QName(this.namespaceUri, localName);
            int qNameID = AbstractEXIBodyCoder.this.nextQNameID++;
            QNameContext qnc = new QNameContext(this.namespaceUriID, localNameID, qName, qNameID);
            this.qnames.add(qnc);
            return qnc;
        }

        protected int getNumberOfPrefixes() {
            int pfs = 0;
            if (this.guc != null) {
                pfs = this.guc.getNumberOfPrefixes();
            }
            if (this.prefixes != null) {
                assert (AbstractEXIBodyCoder.this.preservePrefix);
                pfs += this.prefixes.size();
            }
            return pfs;
        }

        protected void addPrefix(String prefix) {
            assert (AbstractEXIBodyCoder.this.preservePrefix);
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<String>();
            }
            this.prefixes.add(prefix);
        }

        protected int getPrefixID(String prefix) {
            assert (AbstractEXIBodyCoder.this.preservePrefix);
            int id = -1;
            if (this.guc != null) {
                id = this.guc.getPrefixID(prefix);
            }
            if (id == -1 && this.prefixes != null && this.prefixes.size() != 0) {
                for (int i = 0; i < this.prefixes.size(); ++i) {
                    if (!this.prefixes.get(i).equals(prefix)) continue;
                    return i;
                }
            }
            return id;
        }

        protected String getPrefix(int prefixID) {
            String pfx = null;
            int sub = 0;
            if (this.guc != null) {
                pfx = this.guc.getPrefix(prefixID);
                sub = this.guc.getNumberOfPrefixes();
            }
            if (pfx == null) {
                assert (AbstractEXIBodyCoder.this.preservePrefix);
                assert (this.prefixes != null);
                assert ((prefixID -= sub) >= 0 && prefixID < this.prefixes.size());
                pfx = this.prefixes.get(prefixID);
            }
            return pfx;
        }

        protected void setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        protected String getNamespaceUri() {
            return this.namespaceUri;
        }

        protected int getNamespaceUriID() {
            return this.namespaceUriID;
        }
    }

    final class ElementContext {
        private String prefix;
        private String sqname;
        Grammar gr;
        List<NamespaceDeclaration> nsDeclarations;
        final QNameContext qnameContext;

        public ElementContext(QNameContext qnameContext, Grammar gr) {
            this.qnameContext = qnameContext;
            this.gr = gr;
        }

        String getQNameAsString() {
            if (this.sqname == null) {
                this.sqname = AbstractEXIBodyCoder.this.preservePrefix ? QNameUtilities.getQualifiedName(this.qnameContext.getLocalName(), this.getPrefix()) : this.qnameContext.getDefaultQNameAsString();
            }
            return this.sqname;
        }

        void setPrefix(String pfx) {
            this.prefix = pfx;
        }

        String getPrefix() {
            return this.prefix;
        }
    }
}

