/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.context;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class QNameContext
implements Serializable {
    private static final long serialVersionUID = 3603278826401543189L;
    final int namespaceUriID;
    final int localNameID;
    final QName qName;
    final int qNameID;
    final String defaultQNameAsString;
    final String defaultPrefix;
    StartElement grammarGlobalElement;
    Attribute grammarGlobalAttribute;
    Datatype simpleDatatype;
    SchemaInformedFirstStartTagGrammar typeGrammar;
    QNameContext simpleBaseType;

    public QNameContext(int namespaceUriID, int localNameID, QName qName, int qNameID) {
        this.namespaceUriID = namespaceUriID;
        this.localNameID = localNameID;
        this.qName = qName;
        switch (namespaceUriID) {
            case 0: {
                this.defaultPrefix = "";
                this.defaultQNameAsString = this.qName.getLocalPart();
                break;
            }
            case 1: {
                this.defaultPrefix = "xml";
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
                break;
            }
            case 2: {
                this.defaultPrefix = "xsi";
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
                break;
            }
            default: {
                this.defaultPrefix = "ns" + namespaceUriID;
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
            }
        }
        this.qNameID = qNameID;
    }

    public QName getQName() {
        return this.qName;
    }

    public String getDefaultQNameAsString() {
        return this.defaultQNameAsString;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public int getQNameID() {
        return this.qNameID;
    }

    public int getLocalNameID() {
        return this.localNameID;
    }

    public String getLocalName() {
        return this.qName.getLocalPart();
    }

    public void setGlobalStartElement(StartElement grammarGlobalElement) {
        this.grammarGlobalElement = grammarGlobalElement;
    }

    public StartElement getGlobalStartElement() {
        return this.grammarGlobalElement;
    }

    public void setGlobalAttribute(Attribute grammarGlobalAttribute) {
        this.grammarGlobalAttribute = grammarGlobalAttribute;
    }

    public Attribute getGlobalAttribute() {
        return this.grammarGlobalAttribute;
    }

    public void setSimpleDatatype(Datatype simpleDatatype) {
        this.simpleDatatype = simpleDatatype;
    }

    public Datatype getSimpleDatatype() {
        return this.simpleDatatype;
    }

    public void setTypeGrammar(SchemaInformedFirstStartTagGrammar typeGrammar) {
        this.typeGrammar = typeGrammar;
    }

    public SchemaInformedFirstStartTagGrammar getTypeGrammar() {
        return this.typeGrammar;
    }

    public QNameContext getSimpleBaseType() {
        return this.simpleBaseType;
    }

    public void setSimpleBaseType(QNameContext simpleBaseType) {
        this.simpleBaseType = simpleBaseType;
    }

    public int getNamespaceUriID() {
        return this.namespaceUriID;
    }

    public String getNamespaceUri() {
        return this.qName.getNamespaceURI();
    }

    protected int compareTo(String localName) {
        return this.getQName().getLocalPart().compareTo(localName);
    }

    public String toString() {
        return "{" + this.namespaceUriID + "}" + this.localNameID + "," + this.getLocalName();
    }

    public final boolean equals(Object o) {
        if (o instanceof QNameContext) {
            QNameContext other = (QNameContext)o;
            return other.qNameID == this.qNameID;
        }
        return false;
    }

    public final int hashCode() {
        return this.qNameID;
    }
}

