/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.stream;

import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamEncoder;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.attributes.AttributeFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.util.SimpleDocTypeParser;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.SAXException;

public class StAXEncoder
implements XMLStreamWriter {
    protected EXIBodyEncoder encoder;
    protected EXIStreamEncoder exiStream;
    protected StringBuilder sbChars = new StringBuilder();
    protected SimpleDocTypeParser dtdParser;
    protected final boolean preserveDTD;
    protected final boolean preserveComment;
    protected final boolean preservePI;
    protected boolean pendingATs;
    protected AttributeList exiAttributes;
    protected EncoderNamespaceContext nsContext;

    public StAXEncoder(EXIFactory factory) throws EXIException {
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.nsContext = new EncoderNamespaceContext();
        this.exiStream = new EXIStreamEncoder(factory);
        FidelityOptions fo = factory.getFidelityOptions();
        this.preserveDTD = fo.isFidelityEnabled("PRESERVE_DTDS");
        this.preserveComment = fo.isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePI = fo.isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        this.encoder = this.exiStream.encodeHeader(os);
    }

    protected void init() {
        this.pendingATs = false;
        this.sbChars.setLength(0);
        this.exiAttributes.clear();
        this.nsContext.reset();
    }

    protected SimpleDocTypeParser getDtdParser() throws SAXException {
        if (this.dtdParser == null) {
            this.dtdParser = new SimpleDocTypeParser();
        }
        return this.dtdParser;
    }

    public void encode(XMLEventReader xmlEvent) throws XMLStreamException, EXIException, IOException {
        block15: while (xmlEvent.hasNext()) {
            XMLEvent event = xmlEvent.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    this.writeStartDocument();
                    continue block15;
                }
                case 8: {
                    this.writeEndDocument();
                    continue block15;
                }
                case 1: {
                    StartElement se = event.asStartElement();
                    QName qn = se.getName();
                    String pfx = qn.getPrefix();
                    this.writeStartElement(pfx, qn.getLocalPart(), qn.getNamespaceURI());
                    Iterator<Namespace> namespaces = se.getNamespaces();
                    while (namespaces.hasNext()) {
                        Namespace ns = namespaces.next();
                        this.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    }
                    Iterator<Attribute> attributes = se.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute at = attributes.next();
                        QName qnAt = at.getName();
                        this.writeAttribute(qnAt.getPrefix(), qnAt.getNamespaceURI(), qnAt.getLocalPart(), at.getValue());
                    }
                    continue block15;
                }
                case 2: {
                    this.writeEndElement();
                    continue block15;
                }
                case 13: {
                    Namespace ns = (Namespace)event;
                    this.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    continue block15;
                }
                case 4: {
                    Characters chars = event.asCharacters();
                    this.writeCharacters(chars.getData());
                    continue block15;
                }
                case 6: {
                    continue block15;
                }
                case 10: {
                    continue block15;
                }
                case 3: {
                    ProcessingInstruction pi = (ProcessingInstruction)event;
                    this.writeProcessingInstruction(pi.getTarget(), pi.getData());
                    continue block15;
                }
                case 5: {
                    Comment cm = (Comment)event;
                    this.writeComment(cm.getText());
                    continue block15;
                }
                case 11: {
                    DTD dtd = (DTD)event;
                    this.writeDTD(dtd.getDocumentTypeDeclaration());
                    continue block15;
                }
                case 15: {
                    continue block15;
                }
                case 9: {
                    EntityReference er = (EntityReference)event;
                    this.writeEntityRef(er.getName());
                    continue block15;
                }
            }
            System.out.println("StAX Event '" + event + "' not supported!");
        }
    }

    public void encode(XMLStreamReader xmlStream) throws XMLStreamException, EXIException, IOException {
        assert (xmlStream.getEventType() == 7);
        this.writeStartDocument();
        block14: while (xmlStream.hasNext()) {
            int event = xmlStream.next();
            switch (event) {
                case 7: {
                    throw new EXIException("Unexpected START_DOCUMENT event");
                }
                case 8: {
                    this.writeEndDocument();
                    break;
                }
                case 1: {
                    QName qn = xmlStream.getName();
                    String pfx = qn.getPrefix();
                    this.writeStartElement(pfx, qn.getLocalPart(), qn.getNamespaceURI());
                    int nsCnt = xmlStream.getNamespaceCount();
                    for (int i = 0; i < nsCnt; ++i) {
                        String nsPfx = xmlStream.getNamespacePrefix(i);
                        nsPfx = nsPfx == null ? "" : nsPfx;
                        String nsUri = xmlStream.getNamespaceURI(i);
                        this.writeNamespace(nsPfx, nsUri);
                    }
                    int atCnt = xmlStream.getAttributeCount();
                    for (int i = 0; i < atCnt; ++i) {
                        QName atQname = xmlStream.getAttributeName(i);
                        this.writeAttribute(atQname.getPrefix(), atQname.getNamespaceURI(), atQname.getLocalPart(), xmlStream.getAttributeValue(i));
                    }
                    continue block14;
                }
                case 2: {
                    this.writeEndElement();
                    break;
                }
                case 13: {
                    break;
                }
                case 4: {
                    this.writeCharacters(xmlStream.getTextCharacters(), xmlStream.getTextStart(), xmlStream.getTextLength());
                    break;
                }
                case 6: {
                    String ignorableSpace = xmlStream.getText();
                    this.writeCharacters(ignorableSpace);
                    break;
                }
                case 10: {
                    break;
                }
                case 3: {
                    this.writeProcessingInstruction(xmlStream.getPITarget(), xmlStream.getPIData());
                    break;
                }
                case 5: {
                    this.writeCharacters(xmlStream.getTextCharacters(), xmlStream.getTextStart(), xmlStream.getTextLength());
                    break;
                }
                case 11: {
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    System.out.println("Event '" + event + "' not supported!");
                }
            }
        }
    }

    protected void appendChars(String text) {
        this.sbChars.append(text);
    }

    protected void appendChars(char[] text, int start, int len) {
        this.sbChars.append(text, start, len);
    }

    protected void checkPendingEvents() throws EXIException, IOException {
        if (this.pendingATs) {
            this.encoder.encodeAttributeList(this.exiAttributes);
            this.exiAttributes.clear();
            this.pendingATs = false;
        }
        if (this.sbChars.length() > 0) {
            this.encoder.encodeCharacters(new StringValue(this.sbChars.toString()));
            this.sbChars.setLength(0);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            this.exiAttributes.addAttribute(namespaceURI, localName, prefix, value);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.writeCharacters(data);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.appendChars(text);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.appendChars(text, start, len);
    }

    public void writeComment(String data) throws XMLStreamException {
        if (this.preserveComment) {
            try {
                this.checkPendingEvents();
                char[] chars = data.toCharArray();
                this.encoder.encodeComment(chars, 0, chars.length);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        if (this.preserveDTD) {
            try {
                this.checkPendingEvents();
                SimpleDocTypeParser dtdParser = this.getDtdParser();
                dtdParser.parse(dtd);
                this.encoder.encodeDocType(dtdParser.name, dtdParser.publicID, dtdParser.systemID, dtdParser.text);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.encoder.encodeEndDocument();
            this.encoder.flush();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.encoder.encodeEndElement();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        if (this.preserveDTD) {
            try {
                this.checkPendingEvents();
                this.encoder.encodeEntityReference(name);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        try {
            this.exiAttributes.addNamespaceDeclaration(namespaceURI, prefix);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this.preservePI) {
            try {
                this.checkPendingEvents();
                this.encoder.encodeProcessingInstruction(target, data);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.init();
        try {
            this.encoder.encodeStartDocument();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            assert (namespaceURI != null);
            assert (localName != null);
            this.checkPendingEvents();
            this.encoder.encodeStartElement(namespaceURI, localName, prefix);
            this.pendingATs = true;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void close() throws XMLStreamException {
        this.close();
    }

    public void flush() throws XMLStreamException {
        try {
            this.encoder.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.getNamespaceContext().getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new IllegalArgumentException("NamespaceContext cannot be replaced");
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writeNamespace(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute("", localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(this.getNamespaceContext().getPrefix(namespaceURI), namespaceURI, localName, value);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.setPrefix("", namespaceURI);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement("", localName);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement("", localName, namespaceURI);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEndElement();
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement("", localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(this.getNamespaceContext().getPrefix(namespaceURI), localName, namespaceURI);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EncoderNamespaceContext
    implements NamespaceContext {
        List<List<NamespaceDeclaration>> nsContexts = new ArrayList<List<NamespaceDeclaration>>();

        public void reset() {
            this.nsContexts.clear();
            this.pushContext();
            this.bindPrefix("http://www.w3.org/XML/1998/namespace", "");
            this.bindPrefix("http://www.w3.org/XML/1998/namespace", "xml");
        }

        public void pushContext() {
            this.nsContexts.add(null);
        }

        public void bindPrefix(String namespaceURI, String prefix) {
            int level = this.nsContexts.size() - 1;
            List<NamespaceDeclaration> l = this.nsContexts.get(level);
            if (l == null) {
                l = new ArrayList<NamespaceDeclaration>();
                this.nsContexts.set(level, l);
            }
            l.add(new NamespaceDeclaration(namespaceURI, prefix));
        }

        public List<NamespaceDeclaration> popContext() {
            assert (this.nsContexts.size() > 1);
            return this.nsContexts.remove(this.nsContexts.size() - 1);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (int level = this.nsContexts.size() - 1; level >= 0; --level) {
                List<NamespaceDeclaration> l = this.nsContexts.get(level);
                if (l == null) continue;
                for (NamespaceDeclaration nsDecl : l) {
                    if (!nsDecl.prefix.equals(prefix)) continue;
                    return nsDecl.namespaceURI;
                }
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (int level = this.nsContexts.size() - 1; level >= 0; --level) {
                List<NamespaceDeclaration> l = this.nsContexts.get(level);
                if (l == null) continue;
                for (NamespaceDeclaration nsDecl : l) {
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    return nsDecl.prefix;
                }
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (int level = this.nsContexts.size() - 1; level >= 0; --level) {
                List<NamespaceDeclaration> l = this.nsContexts.get(level);
                if (l == null) continue;
                for (NamespaceDeclaration nsDecl : l) {
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    prefixes.add(nsDecl.prefix);
                }
            }
            return prefixes.iterator();
        }
    }
}

