/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.sax;

import com.siemens.ct.exi.Constants;
import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamDecoder;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.util.NoEntityResolver;
import com.siemens.ct.exi.values.ListValue;
import com.siemens.ct.exi.values.Value;
import com.siemens.ct.exi.values.ValueType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXDecoder
implements XMLReader {
    protected EXIFactory noOptionsFactory;
    protected EXIStreamDecoder exiStream;
    protected EXIBodyDecoder decoder;
    protected ContentHandler contentHandler;
    protected DTDHandler dtdHandler;
    protected LexicalHandler lexicalHandler;
    protected DeclHandler declHandler;
    protected ErrorHandler errorHandler;
    protected static final String ATTRIBUTE_TYPE = "CDATA";
    static final int DEFAULT_CHAR_BUFFER_SIZE = 4096;
    protected char[] cbuffer = new char[4096];
    protected AttributesImpl attributes;
    protected boolean namespaces = true;
    protected boolean namespacePrefixes = false;
    protected boolean exiBodyOnly = false;
    protected StringBuilder sbHelper;

    public SAXDecoder(EXIFactory noOptionsFactory) throws EXIException {
        this.noOptionsFactory = noOptionsFactory;
        this.exiStream = new EXIStreamDecoder(noOptionsFactory);
        this.attributes = new AttributesImpl();
        if (noOptionsFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES")) {
            this.namespacePrefixes = true;
        }
    }

    protected void initForEachRun() {
        this.attributes.clear();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.namespacePrefixes;
        }
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.namespaces = value;
        } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.namespacePrefixes = value;
        } else if ("http://www.w3.org/exi/features/exi-body-only".equals(name)) {
            this.exiBodyOnly = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            this.declHandler = (DeclHandler)value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            return this.declHandler;
        }
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        FileInputStream fis = new FileInputStream(systemId);
        InputSource is = new InputSource(fis);
        this.parse(is);
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        assert (inputSource != null);
        assert (this.exiStream != null);
        if (this.contentHandler == null) {
            throw new SAXException("No content handler set!");
        }
        try {
            InputStream is = inputSource.getByteStream();
            if (is == null && inputSource.getSystemId() != null) {
                is = new FileInputStream(inputSource.getSystemId());
            }
            if (is == null) {
                throw new EXIException("No valid input source " + is);
            }
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            this.decoder = this.exiBodyOnly ? this.exiStream.getBodyOnlyDecoder(is) : this.exiStream.decodeHeader(is);
            this.initForEachRun();
            this.parseEXIEvents();
        }
        catch (EXIException e) {
            throw new SAXException("EXI", e);
        }
    }

    protected void parseEXIEvents() throws IOException, EXIException, SAXException {
        EventType eventType;
        List<NamespaceDeclaration> eePrefixes = null;
        QNameContext deferredStartElement = null;
        block26: while ((eventType = this.decoder.next()) != null) {
            if (deferredStartElement != null) {
                switch (eventType) {
                    case START_ELEMENT: 
                    case START_ELEMENT_NS: 
                    case START_ELEMENT_GENERIC: 
                    case START_ELEMENT_GENERIC_UNDECLARED: 
                    case END_ELEMENT: 
                    case END_ELEMENT_UNDECLARED: 
                    case CHARACTERS: 
                    case CHARACTERS_GENERIC: 
                    case CHARACTERS_GENERIC_UNDECLARED: 
                    case DOC_TYPE: 
                    case ENTITY_REFERENCE: 
                    case COMMENT: 
                    case PROCESSING_INSTRUCTION: {
                        this.handleDeferredStartElement(deferredStartElement);
                        deferredStartElement = null;
                    }
                }
            }
            switch (eventType) {
                case START_DOCUMENT: {
                    this.decoder.decodeStartDocument();
                    this.contentHandler.startDocument();
                    break;
                }
                case END_DOCUMENT: {
                    this.decoder.decodeEndDocument();
                    this.contentHandler.endDocument();
                    break;
                }
                case ATTRIBUTE_XSI_NIL: {
                    this.handleAttribute(this.decoder.decodeAttributeXsiNil());
                    break;
                }
                case ATTRIBUTE_XSI_TYPE: {
                    this.handleAttribute(this.decoder.decodeAttributeXsiType());
                    break;
                }
                case ATTRIBUTE: 
                case ATTRIBUTE_NS: 
                case ATTRIBUTE_GENERIC: 
                case ATTRIBUTE_GENERIC_UNDECLARED: 
                case ATTRIBUTE_INVALID_VALUE: 
                case ATTRIBUTE_ANY_INVALID_VALUE: {
                    this.handleAttribute(this.decoder.decodeAttribute());
                    break;
                }
                case NAMESPACE_DECLARATION: {
                    this.decoder.decodeNamespaceDeclaration();
                    break;
                }
                case SELF_CONTAINED: {
                    this.decoder.decodeStartSelfContainedFragment();
                    break;
                }
                case START_ELEMENT: 
                case START_ELEMENT_NS: 
                case START_ELEMENT_GENERIC: 
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    deferredStartElement = this.decoder.decodeStartElement();
                    break;
                }
                case END_ELEMENT: 
                case END_ELEMENT_UNDECLARED: {
                    if (this.namespaces) {
                        eePrefixes = this.decoder.getDeclaredPrefixDeclarations();
                    }
                    String eeQNameAsString = this.decoder.getElementQNameAsString();
                    QNameContext eeQName = this.decoder.decodeEndElement();
                    this.contentHandler.endElement(eeQName.getNamespaceUri(), eeQName.getLocalName(), eeQNameAsString);
                    if (!this.namespaces) continue block26;
                    this.endPrefixMappings(eePrefixes);
                    break;
                }
                case CHARACTERS: 
                case CHARACTERS_GENERIC: 
                case CHARACTERS_GENERIC_UNDECLARED: {
                    Value val = this.decoder.decodeCharacters();
                    switch (val.getValueType()) {
                        case BOOLEAN: 
                        case STRING: {
                            char[] chars = val.getCharacters();
                            this.contentHandler.characters(chars, 0, chars.length);
                            break;
                        }
                        case LIST: {
                            char[] chars;
                            ListValue lv = (ListValue)val;
                            Value[] values = lv.toValues();
                            if (values.length <= 0) continue block26;
                            ValueType vt = values[0].getValueType();
                            switch (vt) {
                                case BOOLEAN: 
                                case STRING: {
                                    for (Value val2 : values) {
                                        chars = val2.getCharacters();
                                        this.contentHandler.characters(chars, 0, chars.length);
                                        this.contentHandler.characters(Constants.XSD_LIST_DELIM_CHAR_ARRAY, 0, Constants.XSD_LIST_DELIM_CHAR_ARRAY.length);
                                    }
                                    continue block26;
                                }
                                default: {
                                    int offset = 0;
                                    for (Value val2 : values) {
                                        int len = val2.getCharactersLength();
                                        if (this.cbuffer.length < offset + len + 1) {
                                            this.contentHandler.characters(this.cbuffer, 0, offset);
                                            offset = 0;
                                        }
                                        val2.getCharacters(this.cbuffer, offset);
                                        offset += len;
                                        this.cbuffer[offset++] = 32;
                                    }
                                    this.contentHandler.characters(this.cbuffer, 0, offset);
                                    break;
                                }
                            }
                            continue block26;
                        }
                        default: {
                            int slen = val.getCharactersLength();
                            this.ensureBufferCapacity(slen);
                            val.getCharacters(this.cbuffer, 0);
                            this.contentHandler.characters(this.cbuffer, 0, slen);
                            break;
                        }
                    }
                    continue block26;
                }
                case DOC_TYPE: {
                    this.handleDocType(this.decoder.decodeDocType());
                    break;
                }
                case ENTITY_REFERENCE: {
                    this.handleEntityReference(this.decoder.decodeEntityReference());
                    break;
                }
                case COMMENT: {
                    this.handleComment(this.decoder.decodeComment());
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    ProcessingInstruction pi = this.decoder.decodeProcessingInstruction();
                    this.contentHandler.processingInstruction(pi.target, pi.data);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)eventType) + "' ");
                }
            }
        }
    }

    protected final void startPrefixMappings(List<NamespaceDeclaration> prefixes) throws SAXException {
        if (prefixes != null) {
            for (NamespaceDeclaration ns : prefixes) {
                this.contentHandler.startPrefixMapping(ns.prefix, ns.namespaceURI);
            }
        }
    }

    protected final void endPrefixMappings(List<NamespaceDeclaration> eePrefixes) throws SAXException {
        if (eePrefixes != null) {
            for (NamespaceDeclaration ns : eePrefixes) {
                this.contentHandler.endPrefixMapping(ns.prefix);
            }
        }
    }

    protected void handleDeferredStartElement(QNameContext deferredStartElement) throws SAXException, IOException, EXIException {
        if (this.namespaces) {
            this.startPrefixMappings(this.decoder.getDeclaredPrefixDeclarations());
        }
        String seQNameAsString = this.decoder.getElementQNameAsString();
        this.contentHandler.startElement(deferredStartElement.getNamespaceUri(), deferredStartElement.getLocalName(), seQNameAsString, this.attributes);
        this.attributes.clear();
    }

    private final void ensureBufferCapacity(int reqSize) {
        if (reqSize > this.cbuffer.length) {
            int newSize = this.cbuffer.length;
            while ((newSize <<= 2) < reqSize) {
            }
            this.cbuffer = new char[newSize];
        }
    }

    protected void handleAttribute(QNameContext atQName) throws SAXException, IOException, EXIException {
        String sVal;
        Value val = this.decoder.getAttributeValue();
        switch (val.getValueType()) {
            case BOOLEAN: 
            case STRING: {
                sVal = val.toString();
                break;
            }
            case LIST: {
                ListValue lv = (ListValue)val;
                Value[] values = lv.toValues();
                if (values.length > 0) {
                    if (this.sbHelper == null) {
                        this.sbHelper = new StringBuilder();
                    } else {
                        this.sbHelper.setLength(0);
                    }
                    ValueType vt = values[0].getValueType();
                    switch (vt) {
                        case BOOLEAN: 
                        case STRING: {
                            for (Value val2 : values) {
                                this.sbHelper.append(val2.getCharacters());
                                this.sbHelper.append(' ');
                            }
                            break;
                        }
                        default: {
                            for (Value val2 : values) {
                                int slen = val2.getCharactersLength();
                                this.ensureBufferCapacity(slen);
                                val2.getCharacters(this.cbuffer, 0);
                                this.sbHelper.append(this.cbuffer, 0, slen);
                                this.sbHelper.append(' ');
                            }
                        }
                    }
                    sVal = this.sbHelper.toString();
                    break;
                }
                sVal = "";
                break;
            }
            default: {
                int slen = val.getCharactersLength();
                this.ensureBufferCapacity(slen);
                sVal = val.toString(this.cbuffer, 0);
            }
        }
        String atQNameAsString = this.decoder.getAttributeQNameAsString();
        this.attributes.addAttribute(atQName.getNamespaceUri(), atQName.getLocalName(), atQNameAsString, ATTRIBUTE_TYPE, sVal);
    }

    protected void handleDocType(DocType docType) throws SAXException, IOException {
        if (this.lexicalHandler != null) {
            String name = new String(docType.name);
            String publicId = docType.publicID.length == 0 ? null : new String(docType.publicID);
            String systemId = docType.systemID.length == 0 ? null : new String(docType.systemID);
            this.contentHandler.characters(new char[0], 0, 0);
            this.lexicalHandler.startDTD(name, publicId, systemId);
            if (docType.text.length > 0) {
                DeclHandler dh = null;
                if (this.declHandler != null) {
                    dh = this.declHandler;
                } else if (this.lexicalHandler instanceof DeclHandler) {
                    dh = (DeclHandler)((Object)this.lexicalHandler);
                }
                if (dh != null) {
                    DocTypeTextLexicalHandler dttlh = new DocTypeTextLexicalHandler(dh);
                    dttlh.parse(docType.text);
                }
            }
            this.lexicalHandler.endDTD();
        }
    }

    protected void handleEntityReference(char[] erName) throws SAXException {
        String entityReferenceName = new String(erName);
        this.contentHandler.skippedEntity(entityReferenceName);
    }

    protected void handleComment(char[] comment) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(comment, 0, comment.length);
        }
    }

    static class DocTypeTextLexicalHandler {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();

        public DocTypeTextLexicalHandler(DeclHandler dh) throws SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
            this.xmlReader.setEntityResolver(new NoEntityResolver());
            this.xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", dh);
        }

        public void parse(char[] docTypeText) throws IOException, SAXException {
            StringBuilder dt = new StringBuilder();
            dt.append("<!DOCTYPE foo_name [ ");
            dt.append(docTypeText);
            dt.append("]>");
            dt.append("<foo />");
            StringReader r = new StringReader(dt.toString());
            this.xmlReader.parse(new InputSource(r));
        }
    }
}

