/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.dom;

import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamEncoder;
import com.siemens.ct.exi.attributes.AttributeFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMWriter {
    protected EXIFactory factory;
    protected EXIStreamEncoder exiStream;
    protected EXIBodyEncoder exiBody;
    private AttributeList exiAttributes;
    protected boolean preserveWhitespaces;
    protected boolean preserveComments;
    protected boolean preservePIs;
    protected StringBuilder sbChars;

    public DOMWriter(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = new EXIStreamEncoder(factory);
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.sbChars = new StringBuilder();
        this.preserveComments = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePIs = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutput(OutputStream os) throws EXIException, IOException {
        this.exiBody = this.exiStream.encodeHeader(os);
    }

    public void encode(Document doc) throws EXIException, IOException {
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(doc.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encodeFragment(DocumentFragment docFragment) throws EXIException, IOException {
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(docFragment.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encode(Node n) throws EXIException, IOException {
        if (n.getNodeType() == 9) {
            this.encode((Document)n);
        } else if (n.getNodeType() == 11) {
            this.encodeFragment((DocumentFragment)n);
        } else {
            this.exiBody.encodeStartDocument();
            this.encodeNode(n);
            this.exiBody.encodeEndDocument();
            this.exiBody.flush();
        }
    }

    protected void encodeNode(Node root) throws EXIException, IOException {
        assert (root.getNodeType() == 1);
        String namespaceURI = root.getNamespaceURI() == null ? "" : root.getNamespaceURI();
        String localName = root.getLocalName();
        if (localName == null) {
            throw new EXIException("EXI requires namespace-aware DOM (nodes) " + root.getNodeName());
        }
        String prefix = root.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        this.exiBody.encodeStartElement(namespaceURI, localName, prefix);
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node at = attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(at.getNamespaceURI())) {
                String pfx = at.getPrefix() == null ? "" : at.getLocalName();
                this.exiAttributes.addNamespaceDeclaration(at.getNodeValue(), pfx);
                continue;
            }
            this.exiAttributes.addAttribute(at.getNamespaceURI(), at.getLocalName(), at.getPrefix(), at.getNodeValue());
        }
        this.exiBody.encodeAttributeList(this.exiAttributes);
        this.exiAttributes.clear();
        NodeList children = root.getChildNodes();
        this.encodeChildNodes(children);
        this.exiBody.encodeEndElement();
    }

    protected void encodeChildNodes(NodeList children) throws EXIException, IOException {
        block10: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    this.checkPendingChars();
                    this.encodeNode(n);
                    continue block10;
                }
                case 2: {
                    continue block10;
                }
                case 3: {
                    this.sbChars.append(n.getNodeValue());
                    continue block10;
                }
                case 8: {
                    if (!this.preserveComments) continue block10;
                    this.checkPendingChars();
                    String c = n.getNodeValue();
                    this.exiBody.encodeComment(c.toCharArray(), 0, c.length());
                    continue block10;
                }
                case 10: {
                    this.checkPendingChars();
                    DocumentType dt = (DocumentType)n;
                    String publicID = dt.getPublicId() == null ? "" : dt.getPublicId();
                    String systemID = dt.getSystemId() == null ? "" : dt.getSystemId();
                    String text = dt.getInternalSubset() == null ? "" : dt.getInternalSubset();
                    this.exiBody.encodeDocType(dt.getName(), publicID, systemID, text);
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 4: {
                    this.checkPendingChars();
                    this.exiBody.encodeCharacters(new StringValue(n.getNodeValue()));
                    continue block10;
                }
                case 7: {
                    if (!this.preservePIs) continue block10;
                    this.checkPendingChars();
                    ProcessingInstruction pi = (ProcessingInstruction)n;
                    this.exiBody.encodeProcessingInstruction(pi.getTarget(), pi.getData());
                    continue block10;
                }
                default: {
                    System.err.println("[WARNING] Unhandled DOM NodeType: " + n.getNodeType());
                }
            }
        }
        this.checkPendingChars();
    }

    protected void checkPendingChars() throws EXIException, IOException {
        if (this.sbChars.length() > 0) {
            this.exiBody.encodeCharacters(new StringValue(this.sbChars.toString()));
            this.sbChars.setLength(0);
        }
    }
}

