/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIHeaderEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.BitEncoderChannel;
import java.io.IOException;
import java.io.OutputStream;

public class EXIStreamEncoder {
    protected final EXIHeaderEncoder exiHeader;
    protected final EXIBodyEncoder exiBody;
    protected final EXIFactory exiFactory;

    public EXIStreamEncoder(EXIFactory exiFactory) throws EXIException {
        this.exiFactory = exiFactory;
        this.exiHeader = new EXIHeaderEncoder();
        this.exiBody = exiFactory.createEXIBodyEncoder();
    }

    public EXIBodyEncoder encodeHeader(OutputStream os) throws EXIException, IOException {
        BitEncoderChannel headerChannel = new BitEncoderChannel(os);
        this.exiHeader.write(headerChannel, this.exiFactory);
        if (this.exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.exiBody.setOutputChannel(headerChannel);
        } else {
            this.exiBody.setOutputStream(os);
        }
        return this.exiBody;
    }
}

