/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIHeaderDecoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import java.io.IOException;
import java.io.InputStream;

public class EXIStreamDecoder {
    protected final EXIHeaderDecoder exiHeader = new EXIHeaderDecoder();
    protected EXIBodyDecoder exiBody;
    protected final EXIFactory noOptionsFactory;

    public EXIStreamDecoder(EXIFactory noOptionsFactory) throws EXIException {
        this.exiBody = noOptionsFactory.createEXIBodyDecoder();
        this.noOptionsFactory = noOptionsFactory;
    }

    public EXIBodyDecoder getBodyOnlyDecoder(InputStream is) throws EXIException, IOException {
        this.exiBody.setInputStream(is);
        return this.exiBody;
    }

    public EXIBodyDecoder decodeHeader(InputStream is) throws EXIException, IOException {
        BitDecoderChannel headerChannel = new BitDecoderChannel(is);
        EXIFactory exiFactory = this.exiHeader.parse(headerChannel, this.noOptionsFactory);
        if (exiFactory != this.noOptionsFactory) {
            this.exiBody = exiFactory.createEXIBodyDecoder();
        }
        if (exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.exiBody.setInputChannel(headerChannel);
        } else {
            this.exiBody.setInputStream(is);
        }
        return this.exiBody;
    }
}

