/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.util;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageResolver {
    private static final String REPLACEMENT_TEXT_NULL = "<null/>";
    private final ResourceBundle m_bundle;
    private final PrintStream m_pStream;

    public MessageResolver(Class<?> clazz) {
        this(clazz.getName() + "XMsg", null);
    }

    public MessageResolver(Class<?> clazz, Locale locale) {
        this(clazz.getName() + "XMsg", locale, null);
    }

    public MessageResolver(Class<?> clazz, PrintStream printStream) {
        this(clazz.getName() + "XMsg", null, printStream);
    }

    public MessageResolver(Class<?> clazz, Locale locale, PrintStream printStream) {
        this(clazz.getName() + "XMsg", locale, printStream);
    }

    MessageResolver(String string, Locale locale) {
        this(string, locale, null);
    }

    MessageResolver(String string, Locale locale, PrintStream printStream) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.m_pStream = printStream;
        this.m_bundle = ResourceBundle.getBundle(string, locale);
    }

    public String getMessage(int n) {
        String string;
        block2: {
            string = null;
            try {
                string = this.getMessage(n, null);
            }
            catch (MissingResourceException missingResourceException) {
                if (this.m_pStream == null) break block2;
                this.m_pStream.println(missingResourceException.getMessage());
                missingResourceException.printStackTrace(this.m_pStream);
            }
        }
        return string;
    }

    public String getMessage(int n, String[] stringArray) {
        String string;
        stringArray = stringArray != null ? stringArray : new String[]{};
        String string2 = string = this.m_bundle.getString(String.valueOf(n));
        if (string != null && string.length() > 0 && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                stringArray[i] = REPLACEMENT_TEXT_NULL;
            }
            string2 = MessageFormat.format(string, stringArray);
        }
        return string2 != null ? string2 : "";
    }

    protected ResourceBundle getBundle() {
        return this.m_bundle;
    }
}

