/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.schema;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;

public final class XSDateTime
implements Externalizable {
    public static final int FIELD_UNDEFINED = Integer.MIN_VALUE;
    private byte primTypeId;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int timeZone;
    public BigInteger reverseFractionalSecond;
    private static final int[] LAST_DAY_OF_MONTH = new int[]{Integer.MIN_VALUE, 31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int DEFAULT_YEAR = 4;

    public static int getLastDayOfMonth(int n, int n2) {
        if (n2 == Integer.MIN_VALUE) {
            assert (n == Integer.MIN_VALUE);
            n2 = 1;
        }
        if (n == Integer.MIN_VALUE) {
            n = 4;
        }
        long l = XSDateTime.calculateQuotientModulo(n2, 1, 13);
        n2 = XSDateTime.getModulo(l);
        n += XSDateTime.getQuotient(l);
        int n3 = LAST_DAY_OF_MONTH[n2];
        if (n3 == -1) {
            assert (n2 == 2);
            n3 = n == Integer.MIN_VALUE || n % 400 == 0 || n % 100 != 0 && n % 4 == 0 ? 29 : 28;
        }
        return n3;
    }

    XSDateTime(XSDateTime xSDateTime) {
        this.primTypeId = xSDateTime.primTypeId;
        this.year = xSDateTime.year;
        this.month = xSDateTime.month;
        this.day = xSDateTime.day;
        this.hour = xSDateTime.hour;
        this.minute = xSDateTime.minute;
        this.second = xSDateTime.second;
        this.reverseFractionalSecond = xSDateTime.reverseFractionalSecond;
        this.timeZone = xSDateTime.timeZone;
    }

    public XSDateTime() {
    }

    public XSDateTime(int n, int n2, int n3, int n4, int n5, int n6, BigInteger bigInteger, int n7, byte by) {
        this.primTypeId = by;
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.reverseFractionalSecond = bigInteger;
        this.timeZone = n7;
    }

    public boolean equals(Object object) {
        if (object instanceof XSDateTime) {
            XSDateTime xSDateTime = (XSDateTime)object;
            int n = this.timeZone;
            int n2 = xSDateTime.timeZone;
            assert (!(n != 0 && n != Integer.MIN_VALUE || n2 != 0 && n2 != Integer.MIN_VALUE));
            if (this.timeZone != xSDateTime.timeZone) {
                return false;
            }
            if (this.primTypeId != xSDateTime.primTypeId || this.year != xSDateTime.year || this.month != xSDateTime.month || this.day != xSDateTime.day || this.hour != xSDateTime.hour || this.minute != xSDateTime.minute || this.second != xSDateTime.second) {
                return false;
            }
            if (this.reverseFractionalSecond == null) {
                return xSDateTime.reverseFractionalSecond == null || xSDateTime.reverseFractionalSecond.signum() == 0;
            }
            if (xSDateTime.reverseFractionalSecond == null) {
                return this.reverseFractionalSecond.signum() == 0;
            }
            return this.reverseFractionalSecond.equals(xSDateTime.reverseFractionalSecond);
        }
        return false;
    }

    public void normalize() {
        int n;
        switch (this.primTypeId) {
            case 9: {
                this.year = 4;
                this.month = 1;
                this.day = 1;
                break;
            }
            case 10: {
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 11: {
                this.day = 1;
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 12: {
                this.month = 1;
                this.day = 1;
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 13: {
                this.year = 4;
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 14: {
                this.year = 4;
                this.month = 1;
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 15: {
                this.year = 4;
                this.day = 1;
                this.hour = 0;
                this.minute = 0;
                this.second = 0;
                this.reverseFractionalSecond = null;
                break;
            }
            case 8: {
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        int n2 = n = this.timeZone != Integer.MIN_VALUE ? 0 - this.timeZone : 0;
        assert (-840 <= n && n <= 840);
        int n3 = n % 60;
        int n4 = n / 60;
        int n5 = this.second;
        this.second = n5 % 60;
        int n6 = n5 / 60;
        long l = XSDateTime.calculateQuotientModulo(this.minute + n3 + n6, 60);
        this.minute = XSDateTime.getModulo(l);
        n6 = XSDateTime.getQuotient(l);
        l = XSDateTime.calculateQuotientModulo(this.hour + n4 + n6, 24);
        this.hour = XSDateTime.getModulo(l);
        n6 = XSDateTime.getQuotient(l);
        int n7 = XSDateTime.getLastDayOfMonth(this.year, this.month);
        int n8 = this.day > n7 ? n7 : (this.day < 1 ? 1 : this.day);
        this.day = n8 + n6;
        while (true) {
            if (this.day < 1) {
                this.day += XSDateTime.getLastDayOfMonth(this.year, this.month - 1);
                n6 = -1;
            } else {
                n7 = XSDateTime.getLastDayOfMonth(this.year, this.month);
                if (this.day <= n7) break;
                this.day -= n7;
                n6 = 1;
            }
            n5 = this.month + n6;
            l = XSDateTime.calculateQuotientModulo(n5, 1, 13);
            this.month = XSDateTime.getModulo(l);
            this.year += XSDateTime.getQuotient(l);
        }
        this.timeZone = this.timeZone != Integer.MIN_VALUE ? 0 : Integer.MIN_VALUE;
    }

    private static long calculateQuotientModulo(int n, int n2, int n3) {
        long l = XSDateTime.calculateQuotientModulo(n - n2, n3 - n2);
        int n4 = XSDateTime.getQuotient(l);
        int n5 = XSDateTime.getModulo(l) + n2;
        return XSDateTime.toCompositeLong(n4, n5);
    }

    private static long calculateQuotientModulo(int n, int n2) {
        assert (n2 > 0);
        int n3 = n / n2;
        int n4 = n % n2;
        if (n4 < 0) {
            --n3;
            n4 += n2;
        }
        return XSDateTime.toCompositeLong(n3, n4);
    }

    private static long toCompositeLong(int n, int n2) {
        return (long)n << 32 | (long)n2;
    }

    private static int getQuotient(long l) {
        return (int)(l >>> 32);
    }

    private static int getModulo(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.primTypeId = (byte)objectInput.read();
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.reverseFractionalSecond = null;
        this.timeZone = Integer.MIN_VALUE;
        switch (this.primTypeId) {
            case 9: {
                this.hour = objectInput.readInt();
                this.minute = objectInput.readInt();
                this.second = objectInput.readInt();
                this.reverseFractionalSecond = XSDateTime.readPredicatedInteger(objectInput);
                break;
            }
            case 10: {
                this.year = objectInput.readInt();
                this.month = objectInput.readInt();
                this.day = objectInput.readInt();
                break;
            }
            case 11: {
                this.year = objectInput.readInt();
                this.month = objectInput.readInt();
                break;
            }
            case 12: {
                this.year = objectInput.readInt();
                break;
            }
            case 13: {
                this.month = objectInput.readInt();
                this.day = objectInput.readInt();
                break;
            }
            case 14: {
                this.day = objectInput.readInt();
                break;
            }
            case 15: {
                this.month = objectInput.readInt();
                break;
            }
            case 8: {
                this.year = objectInput.readInt();
                this.month = objectInput.readInt();
                this.day = objectInput.readInt();
                this.hour = objectInput.readInt();
                this.minute = objectInput.readInt();
                this.second = objectInput.readInt();
                this.reverseFractionalSecond = XSDateTime.readPredicatedInteger(objectInput);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.timeZone = XSDateTime.readPredicatedInt(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(this.primTypeId);
        switch (this.primTypeId) {
            case 9: {
                objectOutput.writeInt(this.hour);
                objectOutput.writeInt(this.minute);
                objectOutput.writeInt(this.second);
                XSDateTime.writePredicatedInteger(this.reverseFractionalSecond, objectOutput);
                break;
            }
            case 10: {
                objectOutput.writeInt(this.year);
                objectOutput.writeInt(this.month);
                objectOutput.writeInt(this.day);
                break;
            }
            case 11: {
                objectOutput.writeInt(this.year);
                objectOutput.writeInt(this.month);
                break;
            }
            case 12: {
                objectOutput.writeInt(this.year);
                break;
            }
            case 13: {
                objectOutput.writeInt(this.month);
                objectOutput.writeInt(this.day);
                break;
            }
            case 14: {
                objectOutput.writeInt(this.day);
                break;
            }
            case 15: {
                objectOutput.writeInt(this.month);
                break;
            }
            case 8: {
                objectOutput.writeInt(this.year);
                objectOutput.writeInt(this.month);
                objectOutput.writeInt(this.day);
                objectOutput.writeInt(this.hour);
                objectOutput.writeInt(this.minute);
                objectOutput.writeInt(this.second);
                XSDateTime.writePredicatedInteger(this.reverseFractionalSecond, objectOutput);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        XSDateTime.writePredicatedInt(this.timeZone, objectOutput);
    }

    private static void writePredicatedInt(int n, ObjectOutput objectOutput) throws IOException {
        if (n != Integer.MIN_VALUE) {
            objectOutput.write(1);
            objectOutput.writeInt(n);
        } else {
            objectOutput.write(0);
        }
    }

    private static int readPredicatedInt(ObjectInput objectInput) throws IOException {
        int n = objectInput.read();
        if (n == 1) {
            return objectInput.readInt();
        }
        assert (n == 0);
        return Integer.MIN_VALUE;
    }

    private static void writePredicatedInteger(BigInteger bigInteger, ObjectOutput objectOutput) throws IOException {
        if (bigInteger != null) {
            objectOutput.write(1);
            objectOutput.writeObject(bigInteger);
        } else {
            objectOutput.write(0);
        }
    }

    private static BigInteger readPredicatedInteger(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.read();
        if (n == 1) {
            return (BigInteger)objectInput.readObject();
        }
        assert (n == 0);
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.primTypeId) {
            case 9: {
                XSDateTime.printTwoDigits(this.hour, stringBuilder);
                XSDateTime.printTwoDigits(this.minute, stringBuilder.append(':'));
                XSDateTime.printTwoDigits(this.second, stringBuilder.append(':'));
                if (this.reverseFractionalSecond == null) break;
                XSDateTime.printFractionalSecond(this.reverseFractionalSecond, stringBuilder);
                break;
            }
            case 10: {
                XSDateTime.printYear(this.year, stringBuilder);
                XSDateTime.printTwoDigits(this.month, stringBuilder.append('-'));
                XSDateTime.printTwoDigits(this.day, stringBuilder.append('-'));
                break;
            }
            case 11: {
                XSDateTime.printYear(this.year, stringBuilder);
                XSDateTime.printTwoDigits(this.month, stringBuilder.append('-'));
                break;
            }
            case 12: {
                XSDateTime.printYear(this.year, stringBuilder);
                break;
            }
            case 13: {
                XSDateTime.printTwoDigits(this.month, stringBuilder.append("--"));
                XSDateTime.printTwoDigits(this.day, stringBuilder.append('-'));
                break;
            }
            case 14: {
                XSDateTime.printTwoDigits(this.day, stringBuilder.append("---"));
                break;
            }
            case 15: {
                XSDateTime.printTwoDigits(this.month, stringBuilder.append("--"));
                break;
            }
            case 8: {
                XSDateTime.printYear(this.year, stringBuilder);
                XSDateTime.printTwoDigits(this.month, stringBuilder.append('-'));
                XSDateTime.printTwoDigits(this.day, stringBuilder.append('-'));
                stringBuilder.append('T');
                XSDateTime.printTwoDigits(this.hour, stringBuilder);
                XSDateTime.printTwoDigits(this.minute, stringBuilder.append(':'));
                XSDateTime.printTwoDigits(this.second, stringBuilder.append(':'));
                if (this.reverseFractionalSecond == null) break;
                XSDateTime.printFractionalSecond(this.reverseFractionalSecond, stringBuilder);
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        if (this.timeZone != Integer.MIN_VALUE) {
            XSDateTime.printTimezone(this.timeZone, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static void printTimezone(int n, StringBuilder stringBuilder) {
        assert (n != Integer.MIN_VALUE);
        if (n == 0) {
            stringBuilder.append('Z');
        } else {
            if (n > 0) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('-');
                n = 0 - n;
            }
            int n2 = n / 60;
            XSDateTime.printTwoDigits(n2, stringBuilder);
            stringBuilder.append(':');
            int n3 = n % 60;
            XSDateTime.printTwoDigits(n3, stringBuilder);
        }
    }

    private static void printTwoDigits(int n, StringBuilder stringBuilder) {
        assert (n != Integer.MIN_VALUE && n >= 0 && n < 100);
        if (n < 10) {
            stringBuilder.append("0");
            stringBuilder.append((char)(48 + n));
        } else {
            stringBuilder.append((char)(48 + n / 10));
            stringBuilder.append((char)(48 + n % 10));
        }
    }

    private static void printYear(int n, StringBuilder stringBuilder) {
        assert (n != Integer.MIN_VALUE && n != 0);
        if (n < 0) {
            stringBuilder.append('-');
            n = 0 - n;
        }
        if (n < 10) {
            stringBuilder.append("000");
            stringBuilder.append((char)(48 + n));
        } else if (n < 100) {
            stringBuilder.append("00");
            stringBuilder.append((char)(48 + n / 10));
            stringBuilder.append((char)(48 + n % 10));
        } else if (n < 1000) {
            stringBuilder.append("0");
            stringBuilder.append((char)(48 + n / 100));
            stringBuilder.append((char)(48 + n / 10 % 10));
            stringBuilder.append((char)(48 + n % 10));
        } else {
            stringBuilder.append(n);
        }
    }

    private static void printFractionalSecond(BigInteger bigInteger, StringBuilder stringBuilder) {
        String string = bigInteger.toString();
        int n = string.length();
        for (int i = n - 1; i > -1; --i) {
            stringBuilder.append('.').append(string.charAt(i));
        }
    }
}

