/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.schema;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.openexi.schema.Base64;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchemaConst;
import org.openexi.schema.EXISchemaRuntimeException;
import org.openexi.schema.HexBin;
import org.openexi.schema.XSDateTime;

public final class EXISchema
implements Externalizable {
    private static final long serialVersionUID = 1405246188507692833L;
    private static final byte[] COOKIE = new byte[]{36, 51, 43, 45};
    public static final int NIL_NODE = -1;
    public static final int NIL_VALUE = -1;
    public static final int EMPTY_STRING = 0;
    public static final int NIL_GRAM = -1;
    public static final int EVENT_AT_WILDCARD = -1;
    public static final int EVENT_SE_WILDCARD = -2;
    public static final int EVENT_CH_UNTYPED = -3;
    public static final int EVENT_CH_TYPED = -4;
    public static final int MIN_EVENT_ID = -4;
    public static final byte EVENT_TYPE_AT = 0;
    public static final byte EVENT_TYPE_SE = 1;
    public static final byte EVENT_TYPE_AT_WILDCARD_NS = 2;
    public static final byte EVENT_TYPE_SE_WILDCARD_NS = 3;
    public static final int TRUE_VALUE = 1;
    public static final int FALSE_VALUE = 0;
    public static final int UNBOUNDED_OCCURS = -1;
    public static final int CONSTRAINT_NONE = 0;
    public static final int CONSTRAINT_DEFAULT = 1;
    public static final int CONSTRAINT_FIXED = 2;
    public static final int WHITESPACE_PRESERVE = 0;
    public static final int WHITESPACE_REPLACE = 1;
    public static final int WHITESPACE_COLLAPSE = 2;
    public static final byte VARIANT_STRING = 0;
    public static final byte VARIANT_FLOAT = 1;
    public static final byte VARIANT_DECIMAL = 2;
    public static final byte VARIANT_INTEGER = 3;
    public static final byte VARIANT_INT = 4;
    public static final byte VARIANT_LONG = 5;
    public static final byte VARIANT_DATETIME = 6;
    public static final byte VARIANT_DURATION = 7;
    public static final byte VARIANT_BASE64 = 8;
    public static final byte VARIANT_BOOLEAN = 9;
    public static final byte VARIANT_HEXBIN = 10;
    public static final int INTEGER_CODEC_DEFAULT = 255;
    public static final int INTEGER_CODEC_NONNEGATIVE = 254;
    private static final byte[] ANCESTRY_IDS = new byte[]{-1, -1, 2, 3, 4, 5, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, -1, -1, 21};
    private static final String[] ELEMENT_NAMES = new String[]{"", "", "StringType", "BooleanType", "DecimalType", "FloatType", "FloatType", "DurationType", "DateTimeType", "TimeType", "DateType", "GYearMonthType", "GYearType", "GMonthDayType", "GDayType", "GMonthType", "HexBinaryType", "Base64BinaryType", "AnyURIType", "QNameType", "QNameType", "IntegerType"};
    private static final boolean[] DEFAULT_TYPABLES = new boolean[]{true, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, true, false, true, true, false, true, false, true, true, true, true, false, true, true, false, false, false, false, false, false, false};
    public static final byte UR_SIMPLE_TYPE = 0;
    public static final byte ATOMIC_SIMPLE_TYPE = 1;
    public static final byte LIST_SIMPLE_TYPE = 2;
    public static final byte UNION_SIMPLE_TYPE = 3;
    private int[] m_elems;
    private int[] m_attrs;
    private int[] m_types;
    public String[] uris;
    public String[][] localNames;
    private int[][] m_localNames;
    String[] m_names;
    String[] m_strings;
    int[] m_ints;
    long[] m_mantissas;
    int[] m_exponents;
    BigDecimal[] m_decimals;
    BigInteger[] m_integers;
    long[] m_longs;
    XSDateTime[] m_datetimes;
    Duration[] m_durations;
    byte[][] m_binaries;
    byte[] m_variantTypes;
    int[] m_variants;
    private transient XSDateTime[] m_computedDatetimes;
    private transient Characters[] m_variantCharacters;
    private int m_n_stypes;
    public transient byte[] ancestryIds;
    private transient int m_stypes_end;
    private int[] m_grammars;
    private int[] m_productions;
    private byte[] m_eventTypes;
    private int[] m_eventData;
    private int m_grammarCount;
    private transient int[] m_fragmentINodes;
    private transient int m_n_fragmentElems;
    private transient HashMap<String, int[]> m_globalElementsDirectory;
    private transient HashMap<String, int[]> m_globalAttributesDirectory;
    private transient HashMap<String, int[]> m_globalTypesDirectory;
    private transient int[] m_buitinTypes;
    private transient int[] m_globalElems;
    private transient int[] m_globalAttrs;
    public static final DatatypeFactory datatypeFactory;

    public EXISchema() {
    }

    public EXISchema(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3, String[] stringArray, int n4, String[] stringArray2, int n5, int[][] nArray4, String[] stringArray3, int n6, int[] nArray5, int n7, long[] lArray, int[] nArray6, int n8, BigDecimal[] bigDecimalArray, int n9, BigInteger[] bigIntegerArray, int n10, long[] lArray2, int n11, XSDateTime[] xSDateTimeArray, int n12, Duration[] durationArray, int n13, byte[][] byArray, int n14, byte[] byArray2, int[] nArray7, int n15, int[] nArray8, int n16, int n17, int[] nArray9, int n18, byte[] byArray3, int[] nArray10, int n19, int n20) {
        this.m_elems = new int[n];
        System.arraycopy(nArray, 0, this.m_elems, 0, n);
        this.m_attrs = new int[n2];
        System.arraycopy(nArray2, 0, this.m_attrs, 0, n2);
        this.m_types = new int[n3];
        System.arraycopy(nArray3, 0, this.m_types, 0, n3);
        this.uris = new String[n4];
        System.arraycopy(stringArray, 0, this.uris, 0, n4);
        this.m_localNames = new int[nArray4.length][];
        for (int i = 0; i < nArray4.length; ++i) {
            this.m_localNames[i] = new int[nArray4[i].length];
            System.arraycopy(nArray4[i], 0, this.m_localNames[i], 0, nArray4[i].length);
        }
        this.m_names = new String[n5];
        System.arraycopy(stringArray2, 0, this.m_names, 0, n5);
        this.m_strings = new String[n6];
        System.arraycopy(stringArray3, 0, this.m_strings, 0, n6);
        this.m_ints = new int[n7];
        System.arraycopy(nArray5, 0, this.m_ints, 0, n7);
        this.m_mantissas = new long[n8];
        System.arraycopy(lArray, 0, this.m_mantissas, 0, n8);
        this.m_exponents = new int[n8];
        System.arraycopy(nArray6, 0, this.m_exponents, 0, n8);
        this.m_decimals = new BigDecimal[n9];
        System.arraycopy(bigDecimalArray, 0, this.m_decimals, 0, n9);
        this.m_integers = new BigInteger[n10];
        System.arraycopy(bigIntegerArray, 0, this.m_integers, 0, n10);
        this.m_longs = new long[n11];
        System.arraycopy(lArray2, 0, this.m_longs, 0, n11);
        this.m_datetimes = new XSDateTime[n12];
        System.arraycopy(xSDateTimeArray, 0, this.m_datetimes, 0, n12);
        this.m_durations = new Duration[n13];
        System.arraycopy(durationArray, 0, this.m_durations, 0, n13);
        this.m_binaries = new byte[n14][];
        System.arraycopy(byArray, 0, this.m_binaries, 0, n14);
        this.m_variants = new int[n15];
        System.arraycopy(nArray7, 0, this.m_variants, 0, n15);
        this.m_variantTypes = new byte[n15];
        System.arraycopy(byArray2, 0, this.m_variantTypes, 0, n15);
        this.m_grammars = new int[n16];
        System.arraycopy(nArray8, 0, this.m_grammars, 0, n16);
        this.m_productions = new int[n18];
        System.arraycopy(nArray9, 0, this.m_productions, 0, n18);
        this.m_eventTypes = new byte[n19];
        System.arraycopy(byArray3, 0, this.m_eventTypes, 0, n19);
        this.m_eventData = new int[n19];
        System.arraycopy(nArray10, 0, this.m_eventData, 0, n19);
        this.m_n_stypes = n20;
        this.m_grammarCount = n17;
        this.setUp();
    }

    private void setUp() {
        this.computeAncestryIds();
        this.populateLocalNames();
        this.computeGlobalDirectory();
        this.computeVariantCharacters();
        this.computeDateTimes();
        this.buildFragmentsArray();
    }

    private void computeAncestryIds() {
        this.ancestryIds = new byte[this.m_n_stypes + 1];
        this.ancestryIds[0] = -1;
        int n = 6;
        int n2 = 0;
        while (n2 < this.m_n_stypes) {
            int n3;
            int n4 = this.getSerialOfType(n);
            assert (0 < n4 && n4 <= this.m_n_stypes && this.isSimpleType(n));
            ++n2;
            if (this.getVarietyOfSimpleType(n) == 1) {
                int n5;
                int n6 = n;
                while ((n5 = this.getSerialOfType(n6)) >= 22) {
                    n6 = this.getBaseTypeOfSimpleType(n6);
                }
                assert (n5 >= 2);
                n3 = ANCESTRY_IDS[n5];
            } else {
                n3 = -1;
            }
            this.ancestryIds[n4] = n3;
            n += EXISchema._getTypeSize(n, this.m_types, this.ancestryIds);
        }
        this.m_stypes_end = n;
    }

    private void populateLocalNames() {
        this.localNames = new String[this.m_localNames.length][];
        for (int i = 0; i < this.m_localNames.length; ++i) {
            String[] stringArray = new String[this.m_localNames[i].length];
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray[j] = this.m_names[this.m_localNames[i][j]];
            }
            this.localNames[i] = stringArray;
        }
    }

    private void buildFragmentsArray() {
        int n;
        int n2;
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = -1;
        int n5 = -1;
        int n6 = Integer.MIN_VALUE;
        boolean bl = true;
        for (n3 = 0; n3 < this.m_elems.length; n3 += 4) {
            int n7 = n3;
            n2 = this.m_elems[n7 + 1];
            n = this.m_elems[n7 + 0];
            if (n5 != n2 || n4 != n) {
                if (n3 != 0) {
                    arrayList.add(bl ? n6 : 0 - n6 - 1);
                }
                n6 = n7;
                bl = true;
                n5 = n2;
                n4 = n;
                continue;
            }
            assert (n6 != n7 && n2 == n5 && n == n4);
            if (this.getTypeOfElem(n7) == this.getTypeOfElem(n6) && this.isNillableElement(n7) == this.isNillableElement(n6)) continue;
            bl = false;
        }
        if (n3 != 0) {
            arrayList.add(bl ? n6 : 0 - n6 - 1);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        n4 = -1;
        n5 = -1;
        n6 = Integer.MIN_VALUE;
        bl = true;
        for (n3 = 0; n3 < this.m_attrs.length; n3 += 3) {
            n2 = n3;
            n = this.m_attrs[n3 + 1];
            int n8 = this.m_attrs[n3 + 0];
            if (n5 != n || n4 != n8) {
                if (n3 != 0) {
                    arrayList2.add(bl ? n6 : 0 - n6 - 1);
                }
                n6 = n2;
                bl = true;
                n5 = n;
                n4 = n8;
                continue;
            }
            assert (n6 != n2 && n == n5 && n8 == n4);
            if (this.getTypeOfAttr(n2) == this.getTypeOfAttr(n6)) continue;
            bl = false;
        }
        if (n3 != 0) {
            arrayList2.add(bl ? n6 : 0 - n6 - 1);
        }
        n2 = 0;
        this.m_n_fragmentElems = arrayList.size();
        this.m_fragmentINodes = new int[this.m_n_fragmentElems + arrayList2.size()];
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_fragmentINodes[n2++] = (Integer)iterator.next();
        }
        assert (n2 == this.m_n_fragmentElems);
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            this.m_fragmentINodes[n2++] = (Integer)iterator.next();
        }
    }

    private void computeGlobalDirectory() {
        int[] nArray;
        Object object;
        int n;
        int n2;
        this.m_globalElementsDirectory = new HashMap();
        this.m_globalAttributesDirectory = new HashMap();
        this.m_globalTypesDirectory = new HashMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < this.m_elems.length; n2 += 4) {
            if (!this.isGlobalElem(n2)) continue;
            String string = this.getNameOfElem(n2);
            int[] nArray2 = this.m_globalElementsDirectory.get(string);
            if (nArray2 != null) {
                int[] nArray3 = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                nArray3[nArray2.length] = n2;
                nArray2 = nArray3;
            } else {
                nArray2 = new int[]{n2};
            }
            this.m_globalElementsDirectory.put(string, nArray2);
            arrayList.add(n2);
        }
        this.m_globalElems = new int[arrayList.size()];
        assert (this.m_globalElems.length == this.getGlobalElemCountOfSchema());
        for (n2 = 0; n2 < this.m_globalElems.length; ++n2) {
            this.m_globalElems[n2] = (Integer)arrayList.get(n2);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < this.m_attrs.length; n += 3) {
            if (!this.isGlobalAttr(n)) continue;
            int n3 = this.m_attrs[n + 1];
            int n4 = this.m_attrs[n + 0];
            object = this.m_names[this.m_localNames[n3][n4]];
            nArray = this.m_globalAttributesDirectory.get(object);
            if (nArray != null) {
                int[] nArray4 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
                nArray4[nArray.length] = n;
                nArray = nArray4;
            } else {
                nArray = new int[]{n};
            }
            this.m_globalAttributesDirectory.put((String)object, nArray);
            arrayList2.add(n);
        }
        this.m_globalAttrs = new int[arrayList2.size()];
        for (n = 0; n < this.m_globalAttrs.length; ++n) {
            this.m_globalAttrs[n] = (Integer)arrayList2.get(n);
        }
        this.m_buitinTypes = new int[46];
        n = 0;
        int n5 = 0;
        while (n < this.m_types.length) {
            String string = this.getNameOfType(n);
            if (n5 < 46) {
                assert (this.getUriOfType(n) == 3 && string.length() != 0);
                this.m_buitinTypes[n5] = n;
            }
            if (!"".equals(string)) {
                int[] nArray5 = this.m_globalTypesDirectory.get(string);
                object = nArray5;
                if (nArray5 != null) {
                    nArray = new int[((Object)object).length + 1];
                    System.arraycopy(object, 0, nArray, 0, ((Object)object).length);
                    nArray[((Object)object).length] = n;
                    object = nArray;
                } else {
                    object = new int[1];
                    object[0] = n;
                }
                this.m_globalTypesDirectory.put(string, (int[])object);
            }
            n += EXISchema._getTypeSize(n, this.m_types, this.ancestryIds);
            ++n5;
        }
    }

    private void computeVariantCharacters() {
        int n = this.m_variants.length;
        Characters[] charactersArray = new Characters[n];
        for (int i = 0; i < n; ++i) {
            String string = this.computeVariantCharacters(i);
            charactersArray[i] = new Characters(string.toCharArray(), 0, string.length(), false);
        }
        this.m_variantCharacters = charactersArray;
    }

    private String computeVariantCharacters(int n) {
        String string = "";
        switch (this.m_variantTypes[n]) {
            case 0: {
                string = this.getStringValueOfVariant(n);
                break;
            }
            case 1: {
                int n2 = this.m_variants[n];
                long l = this.m_mantissas[n2];
                int n3 = this.m_exponents[n2];
                if (n3 != 0) {
                    if (n3 == -16384) {
                        string = l == 1L ? "INF" : (l == -1L ? "-INF" : "NaN");
                        break;
                    }
                    string = Long.toString(l) + "E" + Integer.toString(n3);
                    break;
                }
                string = Long.toString(l);
                break;
            }
            case 2: {
                BigDecimal bigDecimal = this.getDecimalValueOfVariant(n);
                string = bigDecimal.toPlainString();
                break;
            }
            case 3: {
                BigInteger bigInteger = this.getIntegerValueOfVariant(n);
                string = bigInteger.toString();
                break;
            }
            case 4: {
                int n4 = this.getIntValueOfVariant(n);
                string = Integer.toString(n4);
                break;
            }
            case 5: {
                long l = this.getLongValueOfVariant(n);
                string = Long.toString(l);
                break;
            }
            case 6: {
                XSDateTime xSDateTime = this.getDateTimeValueOfVariant(n);
                string = xSDateTime.toString();
                break;
            }
            case 7: {
                string = this.getDurationValueOfVariant(n).toString();
                break;
            }
            case 8: {
                byte[] byArray = this.getBinaryValueOfVariant(n);
                int n5 = byArray.length / 3 << 2;
                if (byArray.length % 3 != 0) {
                    n5 += 4;
                }
                n5 += n5 / 76;
                char[] cArray = new char[n5];
                int n6 = Base64.encode(byArray, 0, byArray.length, cArray, 0);
                string = new String(cArray, 0, n6);
                break;
            }
            case 9: {
                assert (false);
                return null;
            }
            case 10: {
                byte[] byArray = this.getBinaryValueOfVariant(n);
                StringBuffer stringBuffer = new StringBuffer();
                HexBin.encode(byArray, byArray.length, stringBuffer);
                string = stringBuffer.toString();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return string;
    }

    private void computeDateTimes() {
        int n = this.m_datetimes.length;
        XSDateTime[] xSDateTimeArray = new XSDateTime[n];
        for (int i = 0; i < n; ++i) {
            XSDateTime xSDateTime;
            xSDateTimeArray[i] = xSDateTime = new XSDateTime(this.m_datetimes[i]);
            xSDateTime.normalize();
        }
        this.m_computedDatetimes = xSDateTimeArray;
    }

    public int[] getElems() {
        return this.m_elems;
    }

    int[] getAttrs() {
        return this.m_attrs;
    }

    public int[] getTypes() {
        return this.m_types;
    }

    public int[][] getLocalNames() {
        return this.m_localNames;
    }

    public int[] getGrammars() {
        return this.m_grammars;
    }

    public int[] getInts() {
        return this.m_ints;
    }

    public long[] getLongs() {
        return this.m_longs;
    }

    public int[] getVariants() {
        return this.m_variants;
    }

    public int[] getFragmentINodes() {
        return this.m_fragmentINodes;
    }

    public int getFragmentElemCount() {
        return this.m_n_fragmentElems;
    }

    public int getTotalSimpleTypeCount() {
        return this.m_n_stypes;
    }

    public int getTotalGrammarCount() {
        return this.m_grammarCount;
    }

    public boolean isSimpleType(int n) {
        return (this.m_types[n + 5] & Integer.MIN_VALUE) != 0;
    }

    public static boolean _isSimpleType(int n, int[] nArray) {
        return (nArray[n + 5] & Integer.MIN_VALUE) != 0;
    }

    public static int _getTypeSize(int n, int[] nArray, byte[] byArray) {
        assert (n != -1);
        if ((nArray[n + 5] & Integer.MIN_VALUE) != 0) {
            return EXISchema._getSizeOfSimpleType(n, nArray, byArray);
        }
        return 6;
    }

    public int getGlobalElemOfSchema(String string, String string2) {
        int[] nArray = this.m_globalElementsDirectory.get(string2);
        if (nArray != null) {
            for (int n : nArray) {
                int n2 = this.getUriOfElem(n);
                if (!string.equals(this.uris[n2])) continue;
                return n;
            }
        }
        return -1;
    }

    public int getGlobalAttrOfSchema(String string, String string2) {
        int[] nArray = this.m_globalAttributesDirectory.get(string2);
        if (nArray != null) {
            for (int n : nArray) {
                int n2 = this.getUriOfAttr(n);
                if (!string.equals(this.uris[n2])) continue;
                return n;
            }
        }
        return -1;
    }

    public int getTypeOfSchema(String string, String string2) {
        int[] nArray = this.m_globalTypesDirectory.get(string2);
        if (nArray != null) {
            for (int n : nArray) {
                int n2 = this.getUriOfType(n);
                if (n2 == -1 || !string.equals(this.uris[n2])) continue;
                return n;
            }
        }
        return -1;
    }

    public int getGlobalElemCountOfSchema() {
        return this.m_globalElems.length;
    }

    public int getGlobalElemOfSchema(int n) {
        assert (0 <= n && n < this.m_globalElems.length);
        return this.m_globalElems[n];
    }

    public int getGlobalAttrCountOfSchema() {
        return this.m_globalAttrs.length;
    }

    public int getGlobalAttrOfSchema(int n) {
        assert (0 <= n && n < this.m_globalAttrs.length);
        return this.m_globalAttrs[n];
    }

    public int getBuiltinTypeOfSchema(int n) throws EXISchemaRuntimeException {
        if (n < 0 || 45 < n) {
            throw new EXISchemaRuntimeException(1, new String[]{String.valueOf(n), String.valueOf(0), String.valueOf(45)});
        }
        return this.m_buitinTypes[n];
    }

    public int getElemCountOfSchema() {
        return this.m_elems.length / 4;
    }

    public String getNameOfElem(int n) {
        assert (0 <= n);
        int n2 = this.m_elems[n + 0];
        if (n2 != -1) {
            int n3 = this.m_elems[n + 1];
            return this.m_names[this.m_localNames[n3][n2]];
        }
        return "";
    }

    public int getLocalNameOfElem(int n) {
        assert (0 <= n);
        return this.m_elems[n + 0];
    }

    public int getUriOfElem(int n) {
        assert (0 <= n);
        return this.m_elems[n + 1];
    }

    public int getTypeOfElem(int n) {
        assert (0 <= n);
        int n2 = this.m_elems[n + 2];
        return (n2 & Integer.MIN_VALUE) != 0 ? ~n2 : n2;
    }

    public boolean isGlobalElem(int n) {
        int n2 = this.m_elems[n + 2];
        return (n2 & Integer.MIN_VALUE) != 0;
    }

    public boolean isNillableElement(int n) {
        assert (0 <= n);
        return this.m_elems[n + 3] != 0;
    }

    public static boolean _isNillableElement(int n, int[] nArray) {
        assert (0 <= n);
        return nArray[n + 3] != 0;
    }

    public int getSerialOfElem(int n) {
        assert (0 <= n && n % 4 == 0);
        return n / 4;
    }

    public String getNameOfType(int n) {
        assert (0 <= n);
        int n2 = this.m_types[n + 0];
        if (n2 != -1) {
            int n3 = this.m_types[n + 1];
            return this.m_names[this.m_localNames[n3][n2]];
        }
        return "";
    }

    public int getLocalNameOfType(int n) {
        assert (0 <= n);
        return this.m_types[n + 0];
    }

    public int getUriOfType(int n) {
        assert (0 <= n);
        return this.m_types[n + 1];
    }

    public int getSerialOfType(int n) {
        assert (0 <= n);
        return this.m_types[n + 2];
    }

    public int getGrammarOfType(int n) {
        assert (0 <= n);
        return this.m_types[n + 4];
    }

    public static int _getGrammarOfType(int n, int[] nArray) {
        assert (0 <= n);
        return nArray[n + 4];
    }

    public boolean isTypableType(int n) {
        assert (0 <= n);
        return this.m_types[n + 3] != 0;
    }

    private static int _getSizeOfSimpleType(int n, int[] nArray, byte[] byArray) {
        int n2 = 8;
        byte by = EXISchema._getVarietyOfSimpleType(n, nArray);
        if (by == 1) {
            if (EXISchema._isEnumeratedAtomicSimpleType(n, nArray)) {
                n2 += 1 + EXISchema._getEnumerationFacetCountOfAtomicSimpleType(n, nArray, byArray);
            }
            if (byArray[nArray[n + 2]] == 2) {
                n2 += EXISchema._getRestrictedCharacterCountOfStringSimpleType(n, nArray, byArray);
            }
        }
        return n2;
    }

    public int getBaseTypeOfSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return this.m_types[n + 6];
    }

    public byte getVarietyOfSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return EXISchema._getVarietyOfSimpleType(n, this.m_types);
    }

    public static byte _getVarietyOfSimpleType(int n, int[] nArray) {
        return (byte)(nArray[n + 5] & 3);
    }

    public int getItemTypeOfListSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return this.m_types[n + 7];
    }

    public boolean isPrimitiveSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        int n2 = this.getSerialOfType(n);
        return 1 < n2 && n2 < 21;
    }

    public boolean isIntegralSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return this.ancestryIds[this.m_types[n + 2]] == 21;
    }

    public int getWidthOfIntegralSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return EXISchema._getWidthOfIntegralSimpleType(n, this.m_types);
    }

    public static int _getWidthOfIntegralSimpleType(int n, int[] nArray) throws EXISchemaRuntimeException {
        return (nArray[n + 5] & 0x7F8) >> 3;
    }

    public int getWhitespaceFacetValueOfStringSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.ancestryIds[this.m_types[n + 2]] == 2);
        return (this.m_types[n + 5] & 0x18) >> 3;
    }

    public boolean isPatternedBooleanSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.ancestryIds[this.m_types[n + 2]] == 3);
        return (this.m_types[n + 5] & 8) != 0;
    }

    public int getMinInclusiveFacetOfIntegerSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.ancestryIds[this.m_types[n + 2]] == 21);
        return this.m_types[n + 6 + 1];
    }

    public int getRestrictedCharacterCountOfStringSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.ancestryIds[this.m_types[n + 2]] == 2);
        return EXISchema._getRestrictedCharacterCountOfStringSimpleType(n, this.m_types, this.ancestryIds);
    }

    private static int _getRestrictedCharacterCountOfStringSimpleType(int n, int[] nArray, byte[] byArray) {
        int n2 = (nArray[n + 5] & 0x1FE0) >> 5;
        assert (0 <= n2 && n2 < 256);
        return n2;
    }

    public int getRestrictedCharacterOfSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        return n + 8;
    }

    private boolean isEnumeratedAtomicSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.getVarietyOfSimpleType(n) == 1);
        return EXISchema._isEnumeratedAtomicSimpleType(n, this.m_types);
    }

    private static boolean _isEnumeratedAtomicSimpleType(int n, int[] nArray) {
        return (nArray[n + 5] & 4) != 0;
    }

    public int getEnumerationFacetCountOfAtomicSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.getVarietyOfSimpleType(n) == 1);
        return EXISchema._getEnumerationFacetCountOfAtomicSimpleType(n, this.m_types, this.ancestryIds);
    }

    private static int _getEnumerationFacetCountOfAtomicSimpleType(int n, int[] nArray, byte[] byArray) {
        if (EXISchema._isEnumeratedAtomicSimpleType(n, nArray)) {
            int n2 = byArray[nArray[n + 2]] == 2 ? EXISchema._getRestrictedCharacterCountOfStringSimpleType(n, nArray, byArray) : 0;
            return nArray[n + 8 + n2];
        }
        return 0;
    }

    public int getEnumerationFacetOfAtomicSimpleType(int n, int n2) {
        assert (0 <= n && this.m_types[n + 5] < 0 && this.getVarietyOfSimpleType(n) == 1);
        int n3 = EXISchema._getEnumerationFacetCountOfAtomicSimpleType(n, this.m_types, this.ancestryIds);
        if (n2 < 0 || n2 >= n3) {
            throw new EXISchemaRuntimeException(1, new String[]{String.valueOf(n2), String.valueOf(0), String.valueOf(n3 - 1)});
        }
        int n4 = this.ancestryIds[this.m_types[n + 2]] == 2 ? EXISchema._getRestrictedCharacterCountOfStringSimpleType(n, this.m_types, this.ancestryIds) : 0;
        return this.m_types[n + 8 + n4 + 1 + n2];
    }

    public int getNextSimpleType(int n) {
        assert (0 <= n && this.m_types[n + 5] < 0);
        int n2 = n + EXISchema._getSizeOfSimpleType(n, this.m_types, this.ancestryIds);
        if (n2 != this.m_stypes_end) {
            return n2;
        }
        return -1;
    }

    public int getContentDatatypeOfComplexType(int n) {
        assert (0 <= n && this.m_types[n + 5] >= 0);
        int n2 = this.m_types[n + 5];
        return n2 != 0 ? n2 : -1;
    }

    public static int getSizeOfGrammar(int n, int[] nArray) {
        int n2 = 2;
        if (EXISchema._hasContentGrammar(n, nArray)) {
            ++n2;
            if (EXISchema._hasEmptyGrammar(n, nArray)) {
                ++n2;
            }
        }
        return n2 + EXISchema._getProductionCountOfGrammar(n, nArray);
    }

    public int getSerialOfGrammar(int n) {
        return this.m_grammars[n + 0];
    }

    public boolean hasEndElement(int n) {
        return (this.m_grammars[n + 1] & 0x10000) != 0;
    }

    public boolean hasEmptyGrammar(int n) {
        return EXISchema._hasEmptyGrammar(n, this.m_grammars);
    }

    public static boolean _hasEmptyGrammar(int n, int[] nArray) {
        boolean bl;
        boolean bl2 = bl = (nArray[n + 1] & 0x40000) != 0;
        assert (!bl || EXISchema._hasContentGrammar(n, nArray));
        return bl;
    }

    public boolean hasContentGrammar(int n) {
        return EXISchema._hasContentGrammar(n, this.m_grammars);
    }

    public static boolean _hasContentGrammar(int n, int[] nArray) {
        return (nArray[n + 1] & 0x20000) != 0;
    }

    public int getProductionCountOfGrammar(int n) {
        return EXISchema._getProductionCountOfGrammar(n, this.m_grammars);
    }

    public static int _getProductionCountOfGrammar(int n, int[] nArray) {
        return nArray[n + 1] & 0xFFFF;
    }

    public int getProductionOfGrammar(int n, int n2) {
        int n3 = this.getProductionCountOfGrammar(n);
        if (n2 < 0 || n2 >= n3) {
            throw new EXISchemaRuntimeException(1, new String[]{String.valueOf(n2), String.valueOf(0), String.valueOf(n3 - 1)});
        }
        return EXISchema._getProductionOfGrammar(n, n2, this.m_grammars);
    }

    public static int _getProductionOfGrammar(int n, int n2, int[] nArray) {
        int n3 = n + 2;
        if (EXISchema._hasContentGrammar(n, nArray)) {
            ++n3;
            if (EXISchema._hasEmptyGrammar(n, nArray)) {
                ++n3;
            }
        }
        return nArray[n3 + n2];
    }

    public int getContentGrammarOfGrammar(int n) {
        return EXISchema._getContentGrammarOfGrammar(n, this.m_grammars);
    }

    public static int _getContentGrammarOfGrammar(int n, int[] nArray) {
        if (EXISchema._hasContentGrammar(n, nArray)) {
            return nArray[n + 2];
        }
        return -1;
    }

    public int getTypeEmptyGrammarOfGrammar(int n) {
        return EXISchema._getTypeEmptyGrammarOfGrammar(n, this.m_grammars);
    }

    public static int _getTypeEmptyGrammarOfGrammar(int n, int[] nArray) {
        if (EXISchema._hasEmptyGrammar(n, nArray)) {
            return nArray[n + 3];
        }
        return -1;
    }

    public int getEventOfProduction(int n) {
        return this.m_productions[n + 0];
    }

    public int getGrammarOfProduction(int n) {
        return this.m_productions[n + 1];
    }

    public byte getEventType(int n) {
        return this.m_eventTypes[n];
    }

    public int getNodeOfEventType(int n) {
        assert (this.m_eventTypes[n] == 0 || this.m_eventTypes[n] == 1);
        return this.m_eventData[n];
    }

    public int getUriOfEventType(int n) {
        assert (this.m_eventTypes[n] == 2 || this.m_eventTypes[n] == 3);
        return this.m_eventData[n];
    }

    public int getLocalNameOfAttr(int n) {
        assert (0 <= n);
        return this.m_attrs[n + 0];
    }

    public int getUriOfAttr(int n) {
        assert (0 <= n);
        return this.m_attrs[n + 1];
    }

    public int getTypeOfAttr(int n) {
        assert (0 <= n);
        return EXISchema._getTypeOfAttr(n, this.m_attrs);
    }

    public static int _getTypeOfAttr(int n, int[] nArray) {
        int n2 = nArray[n + 2];
        return (n2 & Integer.MIN_VALUE) != 0 ? ~n2 : n2;
    }

    public boolean isGlobalAttr(int n) {
        int n2 = this.m_attrs[n + 2];
        return (n2 & Integer.MIN_VALUE) != 0;
    }

    public int getTypeOfVariant(int n) {
        return this.m_variantTypes[n];
    }

    public Characters getVariantCharacters(int n) {
        return this.m_variantCharacters[n];
    }

    public String getStringValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 0);
        return this.m_strings[this.m_variants[n]];
    }

    public boolean getBooleanValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 9);
        assert (this.m_variants[n] == 0 || this.m_variants[n] == 1);
        return this.m_variants[n] == 1;
    }

    public long getMantissaOfFloatVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 1);
        return this.m_mantissas[this.m_variants[n]];
    }

    public int getExponentOfFloatVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 1);
        return this.m_exponents[this.m_variants[n]];
    }

    public BigDecimal getDecimalValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 2);
        return this.m_decimals[this.m_variants[n]];
    }

    public int getIntValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 4);
        return this.m_ints[this.m_variants[n]];
    }

    public long getLongValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 5);
        return this.m_longs[this.m_variants[n]];
    }

    public BigInteger getIntegerValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 3);
        return this.m_integers[this.m_variants[n]];
    }

    public XSDateTime getDateTimeValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 6);
        return this.m_datetimes[this.m_variants[n]];
    }

    public XSDateTime getComputedDateTimeValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 6);
        return this.m_computedDatetimes[this.m_variants[n]];
    }

    public Duration getDurationValueOfVariant(int n) {
        assert (0 <= n && this.m_variantTypes[n] == 7);
        return this.m_durations[this.m_variants[n]];
    }

    public byte[] getBinaryValueOfVariant(int n) {
        byte by = this.m_variantTypes[n];
        assert (0 <= n && (by == 8 || by == 10));
        return this.m_binaries[this.m_variants[n]];
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < COOKIE.length; ++n3) {
            if ((byte)objectInput.read() == COOKIE[n3]) continue;
            throw new StreamCorruptedException("The stream starts with a wrong magic cookie.");
        }
        int n4 = objectInput.readInt();
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        int[] nArray3 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        String[] stringArray = new String[n4 + 4];
        stringArray[0] = "";
        stringArray[1] = "http://www.w3.org/XML/1998/namespace";
        stringArray[2] = "http://www.w3.org/2001/XMLSchema-instance";
        stringArray[3] = "http://www.w3.org/2001/XMLSchema";
        for (n3 = 4; n3 < n4 + 4; ++n3) {
            stringArray[n3] = objectInput.readUTF();
        }
        n4 = objectInput.readInt();
        String[] stringArray2 = new String[EXISchemaConst.N_BUILTIN_LOCAL_NAMES + n4];
        n3 = 0;
        stringArray2[n3++] = "";
        for (n2 = 0; n2 < EXISchemaConst.XML_LOCALNAMES.length; ++n2) {
            stringArray2[n3++] = EXISchemaConst.XML_LOCALNAMES[n2];
        }
        for (n2 = 0; n2 < EXISchemaConst.XSI_LOCALNAMES.length; ++n2) {
            stringArray2[n3++] = EXISchemaConst.XSI_LOCALNAMES[n2];
        }
        for (n2 = 0; n2 < EXISchemaConst.XSD_LOCALNAMES.length; ++n2) {
            stringArray2[n3++] = EXISchemaConst.XSD_LOCALNAMES[n2];
        }
        assert (n3 == EXISchemaConst.N_BUILTIN_LOCAL_NAMES);
        while (n3 < stringArray2.length) {
            stringArray2[n3] = objectInput.readUTF();
            ++n3;
        }
        n4 = objectInput.readInt();
        int[][] nArrayArray = new int[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            nArrayArray[n3] = new int[objectInput.readInt()];
            for (int i = 0; i < nArrayArray[n3].length; ++i) {
                nArrayArray[n3][i] = objectInput.readInt();
            }
        }
        n4 = objectInput.readInt();
        String[] stringArray3 = new String[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            stringArray3[n3] = objectInput.readUTF();
        }
        n4 = objectInput.readInt();
        int[] nArray4 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray4[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        long[] lArray = new long[n4];
        int[] nArray5 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            lArray[n3] = objectInput.readLong();
            nArray5[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            bigDecimalArray[n3] = new BigDecimal(new BigInteger(objectInput.readUTF()), objectInput.readInt());
        }
        n4 = objectInput.readInt();
        BigInteger[] bigIntegerArray = new BigInteger[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            bigIntegerArray[n3] = new BigInteger(objectInput.readUTF());
        }
        n4 = objectInput.readInt();
        long[] lArray2 = new long[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            lArray2[n3] = objectInput.readLong();
        }
        n4 = objectInput.readInt();
        XSDateTime[] xSDateTimeArray = new XSDateTime[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            xSDateTimeArray[n3] = (XSDateTime)objectInput.readObject();
        }
        n4 = objectInput.readInt();
        Duration[] durationArray = new Duration[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            durationArray[n3] = datatypeFactory.newDuration(objectInput.readUTF());
        }
        n4 = objectInput.readInt();
        byte[][] byArrayArray = new byte[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            byArrayArray[n3] = new byte[objectInput.readInt()];
            for (int i = 0; i < byArrayArray[n3].length && (n5 = objectInput.read(byArrayArray[n3], i, byArrayArray[n3].length - i)) >= 0; i += n5) {
            }
        }
        n4 = objectInput.readInt();
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n3] = (byte)objectInput.read();
        }
        n4 = objectInput.readInt();
        int[] nArray6 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray6[n3] = objectInput.readInt();
        }
        int n6 = objectInput.readInt();
        int n7 = objectInput.readInt();
        n4 = objectInput.readInt();
        int[] nArray7 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray7[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        int[] nArray8 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray8[n3] = objectInput.readInt();
        }
        n4 = objectInput.readInt();
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4 && (n = objectInput.read(byArray2, i, byArray2.length - i)) >= 0; i += n) {
        }
        int[] nArray9 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray9[n3] = objectInput.readInt();
        }
        this.m_elems = nArray;
        this.m_attrs = nArray2;
        this.m_types = nArray3;
        this.uris = stringArray;
        this.m_names = stringArray2;
        this.m_localNames = nArrayArray;
        this.m_strings = stringArray3;
        this.m_ints = nArray4;
        this.m_mantissas = lArray;
        this.m_exponents = nArray5;
        this.m_decimals = bigDecimalArray;
        this.m_integers = bigIntegerArray;
        this.m_longs = lArray2;
        this.m_datetimes = xSDateTimeArray;
        this.m_durations = durationArray;
        this.m_binaries = byArrayArray;
        this.m_variantTypes = byArray;
        this.m_variants = nArray6;
        this.m_grammars = nArray7;
        this.m_grammarCount = n7;
        this.m_productions = nArray8;
        this.m_eventTypes = byArray2;
        this.m_eventData = nArray9;
        this.m_n_stypes = n6;
        this.setUp();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        objectOutput.write(COOKIE);
        int n2 = this.m_elems.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_elems[n]);
        }
        n2 = this.m_attrs.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_attrs[n]);
        }
        n2 = this.m_types.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_types[n]);
        }
        n2 = this.uris.length;
        assert (n2 >= 4);
        objectOutput.writeInt(n2 - 4);
        for (n = 4; n < n2; ++n) {
            objectOutput.writeUTF(this.uris[n]);
        }
        n2 = this.m_names.length;
        assert (n2 >= EXISchemaConst.N_BUILTIN_LOCAL_NAMES);
        objectOutput.writeInt(n2 - EXISchemaConst.N_BUILTIN_LOCAL_NAMES);
        for (n = EXISchemaConst.N_BUILTIN_LOCAL_NAMES; n < n2; ++n) {
            objectOutput.writeUTF(this.m_names[n]);
        }
        n2 = this.m_localNames.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_localNames[n].length);
            for (int i = 0; i < this.m_localNames[n].length; ++i) {
                objectOutput.writeInt(this.m_localNames[n][i]);
            }
        }
        n2 = this.m_strings.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeUTF(this.m_strings[n]);
        }
        n2 = this.m_ints.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_ints[n]);
        }
        assert (this.m_mantissas.length == this.m_exponents.length);
        n2 = this.m_mantissas.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeLong(this.m_mantissas[n]);
            objectOutput.writeInt(this.m_exponents[n]);
        }
        n2 = this.m_decimals.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeUTF(this.m_decimals[n].unscaledValue().toString());
            objectOutput.writeInt(this.m_decimals[n].scale());
        }
        n2 = this.m_integers.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeUTF(this.m_integers[n].toString());
        }
        n2 = this.m_longs.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeLong(this.m_longs[n]);
        }
        n2 = this.m_datetimes.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeObject(this.m_datetimes[n]);
        }
        n2 = this.m_durations.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeUTF(this.m_durations[n].toString());
        }
        n2 = this.m_binaries.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_binaries[n].length);
            objectOutput.write(this.m_binaries[n]);
        }
        n2 = this.m_variantTypes.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.write(this.m_variantTypes[n]);
        }
        n2 = this.m_variants.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_variants[n]);
        }
        objectOutput.writeInt(this.m_n_stypes);
        objectOutput.writeInt(this.m_grammarCount);
        n2 = this.m_grammars.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_grammars[n]);
        }
        n2 = this.m_productions.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_productions[n]);
        }
        n2 = this.m_eventTypes.length;
        objectOutput.writeInt(n2);
        objectOutput.write(this.m_eventTypes);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeInt(this.m_eventData[n]);
        }
    }

    public void writeOut(OutputStream outputStream, boolean bl) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<EXIGrammar xmlns=\"urn:publicid:nagasena\">");
        this.writeOutStringTable(outputStreamWriter);
        this.writeTypes(outputStreamWriter, bl);
        this.writeElems(outputStreamWriter);
        this.writeAttrs(outputStreamWriter);
        this.writeGrammars(outputStreamWriter);
        outputStreamWriter.write("</EXIGrammar>");
        outputStreamWriter.flush();
    }

    private void writeOutStringTable(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<StringTable>");
        for (int i = 0; i < this.uris.length; ++i) {
            String[] stringArray = this.localNames[i];
            outputStreamWriter.write("<Namespace>");
            outputStreamWriter.write("<Uri>" + this.uris[i] + "</Uri>");
            for (int j = 0; j < stringArray.length; ++j) {
                outputStreamWriter.write("<Name>" + stringArray[j] + "</Name>");
            }
            outputStreamWriter.write("</Namespace>");
        }
        outputStreamWriter.write("</StringTable>");
    }

    private void writeTypes(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        outputStreamWriter.write("<Types>");
        if (bl) {
            this.writeAnyType(outputStreamWriter);
        }
        int n = 6;
        int n2 = 1;
        while (n < this.m_types.length) {
            if (!bl && n2 < 46) {
                if (!DEFAULT_TYPABLES[n2] && this.isTypableType(n)) {
                    outputStreamWriter.write("<Typable>" + n2 + "</Typable>");
                }
            } else if (this.isSimpleType(n)) {
                this.writeSimpleType(n, outputStreamWriter);
            } else {
                this.writeComplexType(n, outputStreamWriter);
            }
            n += EXISchema._getTypeSize(n, this.m_types, this.ancestryIds);
            ++n2;
        }
        outputStreamWriter.write("</Types>");
    }

    private void writeAnyType(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<AnyType>");
        outputStreamWriter.write("<Typable/>");
        int n = this.getGrammarOfType(0);
        outputStreamWriter.write("<Grammar>" + this.getSerialOfGrammar(n) + "</Grammar>");
        outputStreamWriter.write("</AnyType>");
    }

    private void writeTypeCommon(int n, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.getNameOfType(n);
        if (string.length() != 0) {
            outputStreamWriter.write("<Uri>" + this.uris[this.getUriOfType(n)] + "</Uri>");
            outputStreamWriter.write("<Name>" + string + "</Name>");
        }
        if (this.isTypableType(n)) {
            outputStreamWriter.write("<Typable/>");
        }
        int n2 = this.getGrammarOfType(n);
        outputStreamWriter.write("<Grammar>" + this.getSerialOfGrammar(n2) + "</Grammar>");
    }

    private void writeComplexType(int n, OutputStreamWriter outputStreamWriter) throws IOException {
        if (n != 0) {
            outputStreamWriter.write("<ComplexType>");
        }
        this.writeTypeCommon(n, outputStreamWriter);
        int n2 = this.getContentDatatypeOfComplexType(n);
        if (n2 != -1) {
            outputStreamWriter.write("<ContentDatatype>" + this.getSerialOfType(n2) + "</ContentDatatype>");
        }
        if (n != 0) {
            outputStreamWriter.write("</ComplexType>");
        }
    }

    private void writeSimpleType(int n, OutputStreamWriter outputStreamWriter) throws IOException {
        int n2;
        String string;
        byte by = this.getVarietyOfSimpleType(n);
        if (by == 0) {
            outputStreamWriter.write("<AnySimpleType>");
            outputStreamWriter.write("<Typable/>");
            int n3 = this.getGrammarOfType(n);
            outputStreamWriter.write("<Grammar>" + this.getSerialOfGrammar(n3) + "</Grammar>");
            outputStreamWriter.write("</AnySimpleType>");
            return;
        }
        int n4 = -1;
        if (by == 2) {
            string = "ListType";
        } else if (by == 3) {
            string = "UnionType";
        } else {
            assert (by == 1);
            n2 = n;
            while ((n4 = this.getSerialOfType(n2)) >= 22) {
                n2 = this.getBaseTypeOfSimpleType(n2);
            }
            assert (n4 >= 2 && n4 <= 21);
            string = ELEMENT_NAMES[n4];
        }
        outputStreamWriter.write("<" + string + ">");
        this.writeTypeCommon(n, outputStreamWriter);
        outputStreamWriter.write("<BaseType>" + this.getSerialOfType(this.getBaseTypeOfSimpleType(n)) + "</BaseType>");
        if (by == 2) {
            n2 = this.getItemTypeOfListSimpleType(n);
            outputStreamWriter.write("<ItemType>" + this.getSerialOfType(n2) + "</ItemType>");
        } else if (by != 3 && by != 0) {
            assert (by == 1);
            if (n4 == 2) {
                n2 = this.getWhitespaceFacetValueOfStringSimpleType(n);
                if (n2 == 1) {
                    outputStreamWriter.write("<Replace/>");
                } else if (n2 == 2) {
                    outputStreamWriter.write("<Collapse/>");
                }
                int n5 = this.getRestrictedCharacterCountOfStringSimpleType(n);
                if (n5 != 0) {
                    int n6;
                    outputStreamWriter.write("<RestrictedCharset>");
                    int n7 = this.getRestrictedCharacterOfSimpleType(n);
                    int n8 = n6 = this.m_types[n7 + 0];
                    for (int i = 1; i < n5; ++i) {
                        int n9 = this.m_types[n7 + i];
                        if (n6 + 1 == n9) {
                            n6 = n9;
                            continue;
                        }
                        assert (n6 + 1 < n9);
                        if (n8 == n6) {
                            outputStreamWriter.write("<Char>" + n6 + "</Char>");
                        } else {
                            assert (n8 < n6);
                            outputStreamWriter.write("<StartChar>" + n8 + "</StartChar>");
                            outputStreamWriter.write("<EndChar>" + n6 + "</EndChar>");
                        }
                        n8 = n6 = n9;
                    }
                    if (n8 == n6) {
                        outputStreamWriter.write("<Char>" + n6 + "</Char>");
                    } else {
                        assert (n8 < n6);
                        outputStreamWriter.write("<StartChar>" + n8 + "</StartChar>");
                        outputStreamWriter.write("<EndChar>" + n6 + "</EndChar>");
                    }
                    outputStreamWriter.write("</RestrictedCharset>");
                }
                this.writeEnumerations(n, "String", outputStreamWriter);
            } else if (n4 == 3) {
                if (this.isPatternedBooleanSimpleType(n)) {
                    outputStreamWriter.write("<Patterned/>");
                }
            } else if (n4 == 4) {
                this.writeEnumerations(n, "Decimal", outputStreamWriter);
            } else if (n4 == 5 || n4 == 6) {
                this.writeEnumerations(n, "Float", outputStreamWriter);
            } else if (n4 == 7) {
                this.writeEnumerations(n, "Duration", outputStreamWriter);
            } else if (n4 == 8) {
                this.writeEnumerations(n, "DateTime", outputStreamWriter);
            } else if (n4 == 9) {
                this.writeEnumerations(n, "Time", outputStreamWriter);
            } else if (n4 == 10) {
                this.writeEnumerations(n, "Date", outputStreamWriter);
            } else if (n4 == 11) {
                this.writeEnumerations(n, "GYearMonth", outputStreamWriter);
            } else if (n4 == 12) {
                this.writeEnumerations(n, "GYear", outputStreamWriter);
            } else if (n4 == 13) {
                this.writeEnumerations(n, "GMonthDay", outputStreamWriter);
            } else if (n4 == 14) {
                this.writeEnumerations(n, "GDay", outputStreamWriter);
            } else if (n4 == 15) {
                this.writeEnumerations(n, "GMonth", outputStreamWriter);
            } else if (n4 == 16) {
                this.writeEnumerations(n, "HexBinary", outputStreamWriter);
            } else if (n4 == 17) {
                this.writeEnumerations(n, "Base64Binary", outputStreamWriter);
            } else if (n4 == 18) {
                this.writeEnumerations(n, "String", outputStreamWriter);
            } else if (n4 != 19 && n4 != 20) {
                if (n4 == 21) {
                    n2 = this.getWidthOfIntegralSimpleType(n);
                    if (n2 == 254) {
                        outputStreamWriter.write("<NonNegative/>");
                    } else if (n2 != 255) {
                        assert (0 <= n2 && n2 <= 12);
                        outputStreamWriter.write("<NBit>" + n2 + "</NBit>");
                        int n10 = this.getMinInclusiveFacetOfIntegerSimpleType(n);
                        outputStreamWriter.write("<MinInteger>" + this.getVariantCharacters(n10).makeString() + "</MinInteger>");
                    }
                    this.writeEnumerations(n, "Integer", outputStreamWriter);
                } else assert (false);
            }
        }
        outputStreamWriter.write("</" + string + ">");
    }

    private void writeEnumerations(int n, String string, OutputStreamWriter outputStreamWriter) throws IOException {
        if (this.isEnumeratedAtomicSimpleType(n)) {
            int n2 = 0;
            int n3 = this.getEnumerationFacetCountOfAtomicSimpleType(n);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.getEnumerationFacetOfAtomicSimpleType(n, i);
                if (n4 == -1) continue;
                if (n2++ == 0) {
                    outputStreamWriter.write("<Enumeration>");
                }
                outputStreamWriter.write("<" + string + ">");
                String string2 = this.getVariantCharacters(n4).makeString();
                if ("String".equals(string)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n5 = string2.length();
                    block6: for (int j = 0; j < n5; ++j) {
                        char c = string2.charAt(j);
                        switch (c) {
                            case '\n': {
                                stringBuilder.append("&#xA;");
                                continue block6;
                            }
                            case '\r': {
                                stringBuilder.append("&#xD;");
                                continue block6;
                            }
                            case '\t': {
                                stringBuilder.append("&#x9;");
                                continue block6;
                            }
                            default: {
                                stringBuilder.append(c);
                            }
                        }
                    }
                    string2 = stringBuilder.toString();
                }
                outputStreamWriter.write(string2);
                outputStreamWriter.write("</" + string + ">");
            }
            if (n2 != 0) {
                outputStreamWriter.write("</Enumeration>");
            }
        }
    }

    private void writeElems(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<Elements>");
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.m_elems.length; i += 4) {
            boolean bl;
            int n3 = this.getUriOfElem(i);
            int n4 = this.getLocalNameOfElem(i);
            if (n3 != n2 || n4 != n) {
                outputStreamWriter.write("<Uri>" + this.uris[n3] + "</Uri>");
                outputStreamWriter.write("<Name>" + this.m_names[this.m_localNames[n3][n4]] + "</Name>");
                n2 = n3;
                n = n4;
            }
            if (bl = this.isGlobalElem(i)) {
                outputStreamWriter.write("<GlobalElement>");
            } else {
                outputStreamWriter.write("<LocalElement>");
            }
            outputStreamWriter.write("<Type>" + this.getSerialOfType(this.getTypeOfElem(i)) + "</Type>");
            if (this.isNillableElement(i)) {
                outputStreamWriter.write("<Nillable/>");
            }
            if (bl) {
                outputStreamWriter.write("</GlobalElement>");
                continue;
            }
            outputStreamWriter.write("</LocalElement>");
        }
        outputStreamWriter.write("</Elements>");
    }

    private void writeAttrs(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<Attributes>");
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.m_attrs.length; i += 3) {
            boolean bl;
            int n3 = this.getUriOfAttr(i);
            int n4 = this.getLocalNameOfAttr(i);
            if (n3 != n2 || n4 != n) {
                outputStreamWriter.write("<Uri>" + this.uris[n3] + "</Uri>");
                outputStreamWriter.write("<Name>" + this.m_names[this.m_localNames[n3][n4]] + "</Name>");
                n2 = n3;
                n = n4;
            }
            if (bl = this.isGlobalAttr(i)) {
                outputStreamWriter.write("<GlobalAttribute>");
            } else {
                outputStreamWriter.write("<LocalAttribute>");
            }
            outputStreamWriter.write("<Type>" + this.getSerialOfType(this.getTypeOfAttr(i)) + "</Type>");
            if (bl) {
                outputStreamWriter.write("</GlobalAttribute>");
                continue;
            }
            outputStreamWriter.write("</LocalAttribute>");
        }
        outputStreamWriter.write("</Attributes>");
    }

    private void writeGrammars(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<Grammars>");
        int n = 0;
        int n2 = 0;
        while (n < this.m_grammars.length) {
            if (n2 >= 7) {
                outputStreamWriter.write("<Grammar>");
                outputStreamWriter.write("<Productions>");
                boolean bl = this.hasEndElement(n);
                int n3 = this.getProductionCountOfGrammar(n);
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.getProductionOfGrammar(n, i);
                    int n5 = this.getEventOfProduction(n4);
                    block0 : switch (n5) {
                        case -1: {
                            outputStreamWriter.write("<AttributeWildcard/>");
                            break;
                        }
                        case -2: {
                            outputStreamWriter.write("<ElementWildcard/>");
                            break;
                        }
                        case -4: 
                        case -3: {
                            if (this.hasEndElement(n)) {
                                outputStreamWriter.write("<EndElement/>");
                                bl = false;
                            }
                            if (n5 == -3) {
                                outputStreamWriter.write("<CharactersMixed/>");
                                break;
                            }
                            outputStreamWriter.write("<CharactersTyped/>");
                            break;
                        }
                        default: {
                            switch (this.getEventType(n5)) {
                                case 0: {
                                    int n6 = this.getNodeOfEventType(n5);
                                    outputStreamWriter.write("<Attribute>" + n6 / 3 + "</Attribute>");
                                    break block0;
                                }
                                case 1: {
                                    int n7 = this.getNodeOfEventType(n5);
                                    outputStreamWriter.write("<Element>" + this.getSerialOfElem(n7) + "</Element>");
                                    break block0;
                                }
                                case 2: {
                                    outputStreamWriter.write("<AttributeWildcardNS>" + this.uris[this.getUriOfEventType(n5)] + "</AttributeWildcardNS>");
                                    break block0;
                                }
                                case 3: {
                                    outputStreamWriter.write("<ElementWildcardNS>" + this.uris[this.getUriOfEventType(n5)] + "</ElementWildcardNS>");
                                    break block0;
                                }
                            }
                            assert (false);
                            break;
                        }
                    }
                    outputStreamWriter.write("<Grammar>" + this.getSerialOfGrammar(this.getGrammarOfProduction(n4)) + "</Grammar>");
                }
                if (bl) {
                    outputStreamWriter.write("<EndElement/>");
                }
                outputStreamWriter.write("</Productions>");
                if (this.hasContentGrammar(n)) {
                    outputStreamWriter.write("<ContentGrammar>" + this.getSerialOfGrammar(this.getContentGrammarOfGrammar(n)) + "</ContentGrammar>");
                }
                if (this.hasEmptyGrammar(n)) {
                    outputStreamWriter.write("<EmptyGrammar>" + this.getSerialOfGrammar(this.getTypeEmptyGrammarOfGrammar(n)) + "</EmptyGrammar>");
                }
                outputStreamWriter.write("</Grammar>");
            }
            n += EXISchema.getSizeOfGrammar(n, this.m_grammars);
            ++n2;
        }
        outputStreamWriter.write("</Grammars>");
    }

    static {
        assert (DEFAULT_TYPABLES.length == 46);
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
        finally {
            EXISchema.datatypeFactory = datatypeFactory;
        }
    }
}

