/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.schema;

public final class Characters {
    public boolean isVolatile;
    public char[] characters;
    public int startIndex;
    public final int length;
    public final int ucsCount;
    private final int m_hashCode;
    public static final Characters CHARACTERS_EMPTY = new Characters("".toCharArray(), 0, 0, false);

    public Characters(char[] cArray, int n, int n2, boolean bl) {
        this.isVolatile = bl;
        this.characters = cArray;
        this.startIndex = n;
        this.length = n2;
        int n3 = 0;
        int n4 = this.startIndex + this.length;
        int n5 = 0;
        int n6 = this.startIndex;
        while (n6 < n4) {
            char c = this.characters[n6++];
            n3 = n3 * 31 + c;
            if ((c & 0xFC00) == 55296 && n6 < n4 && ((c = this.characters[n6]) & 0xFC00) == 56320) {
                ++n6;
            }
            ++n5;
        }
        this.ucsCount = n5;
        this.m_hashCode = n3;
    }

    public void turnPermanent() {
        if (this.isVolatile) {
            char[] cArray = new char[this.length];
            System.arraycopy(this.characters, this.startIndex, cArray, 0, this.length);
            this.characters = cArray;
            this.startIndex = 0;
            this.isVolatile = false;
        }
    }

    public int indexOf(char c) {
        int n = this.startIndex + this.length;
        for (int i = this.startIndex; i < n; ++i) {
            if (this.characters[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String substring(int n, int n2) {
        return new String(this.characters, n, n2 - n);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof Characters) {
            Characters characters = (Characters)object;
            if (this.length != characters.length) {
                return false;
            }
            int n = characters.startIndex;
            char[] cArray = characters.characters;
            for (int i = 0; i < this.length; ++i) {
                if (this.characters[this.startIndex + i] == cArray[n + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String makeString() {
        return new String(this.characters, this.startIndex, this.length);
    }
}

