/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.sax;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.EXISchemaResolver;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.QName;
import org.openexi.proc.events.EXIEventDTD;
import org.openexi.proc.events.EXIEventNS;
import org.openexi.proc.events.EXIEventSchemaNil;
import org.openexi.proc.events.EXIEventSchemaType;
import org.openexi.proc.io.Scanner;
import org.openexi.sax.ReaderSupport;
import org.openexi.schema.Characters;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class EXIReader
extends ReaderSupport
implements XMLReader {
    private boolean m_hasLexicalHandler = false;
    private LexicalHandler m_lexicalHandler = null;
    private static final Characters CHARACTERS_TRUE = new Characters("true".toCharArray(), 0, "true".length(), false);
    private static final Characters CHARACTERS_FALSE = new Characters("false".toCharArray(), 0, "false".length(), false);

    public final void setDTDHandler(DTDHandler dTDHandler) {
    }

    public final DTDHandler getDTDHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public final EntityResolver getEntityResolver() {
        return null;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
    }

    public final ErrorHandler getErrorHandler() {
        return null;
    }

    public final void setProperty(String string, Object object) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            this.setLexicalHandler((LexicalHandler)object);
            return;
        }
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return;
        }
        throw new SAXNotRecognizedException("Property '" + string + "' is not recognized.");
    }

    public final Object getProperty(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.m_lexicalHandler;
        }
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return null;
        }
        throw new SAXNotRecognizedException("Property '" + string + "' is not recognized.");
    }

    public final void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException("");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("");
            }
            return;
        }
        throw new SAXNotRecognizedException("Feature '" + string + "' is not recognized.");
    }

    public final boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("Feature '" + string + "' is not recognized.");
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            throw new SAXNotSupportedException("");
        }
        this.parse(inputStream);
    }

    public void parse(String string) throws SAXException {
        throw new SAXNotSupportedException("");
    }

    public final void setAlignmentType(AlignmentType alignmentType) throws EXIOptionsException {
        this.m_decoder.setAlignmentType(alignmentType);
    }

    public final void setFragment(boolean bl) {
        this.m_decoder.setFragment(bl);
    }

    public final void setPreserveLexicalValues(boolean bl) throws EXIOptionsException {
        this.m_decoder.setPreserveLexicalValues(bl);
    }

    public final void setEXISchemaResolver(EXISchemaResolver eXISchemaResolver) {
        this.m_decoder.setEXISchemaResolver(eXISchemaResolver);
    }

    public final void setDatatypeRepresentationMap(QName[] qNameArray, int n) throws EXIOptionsException {
        this.m_decoder.setDatatypeRepresentationMap(qNameArray, n);
    }

    public final void setBlockSize(int n) throws EXIOptionsException {
        this.m_decoder.setBlockSize(n);
    }

    public final void setValueMaxLength(int n) {
        this.m_decoder.setValueMaxLength(n);
    }

    public final void setValuePartitionCapacity(int n) {
        this.m_decoder.setValuePartitionCapacity(n);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.m_lexicalHandler = lexicalHandler;
        this.m_hasLexicalHandler = this.m_lexicalHandler != null;
    }

    private void parse(InputStream inputStream) throws IOException, SAXException {
        EventDescription eventDescription;
        this.reset();
        Scanner scanner = this.processHeader(inputStream);
        while ((eventDescription = scanner.nextEvent()) != null) {
            switch (eventDescription.getEventKind()) {
                case 0: {
                    this.m_contentHandler.startDocument();
                    break;
                }
                case 1: {
                    this.m_contentHandler.endDocument();
                    break;
                }
                case 2: {
                    this.doElement(eventDescription, scanner, 0);
                    break;
                }
                case 10: {
                    if (!this.m_hasLexicalHandler) break;
                    Characters characters = eventDescription.getCharacters();
                    this.m_lexicalHandler.comment(characters.characters, characters.startIndex, characters.length);
                    break;
                }
                case 9: {
                    this.m_contentHandler.processingInstruction(eventDescription.getName(), eventDescription.getCharacters().makeString());
                    break;
                }
                case 12: {
                    if (!this.m_hasLexicalHandler) break;
                    EXIEventDTD eXIEventDTD = (EXIEventDTD)eventDescription;
                    this.m_lexicalHandler.startDTD(eventDescription.getName(), eXIEventDTD.getPublicId(), eXIEventDTD.getSystemId());
                    this.m_lexicalHandler.endDTD();
                    break;
                }
            }
        }
    }

    private void doXsiNil(EventDescription eventDescription) throws SAXException {
        String string;
        if (this.m_preserveNS) {
            String string2 = eventDescription.getPrefix();
            assert (string2.length() != 0);
            this.stringBuilder.setLength(0);
            string = this.stringBuilder.append(string2).append(":nil").toString();
        } else {
            int n = eventDescription.getURIId();
            assert (n < this.m_n_prefixes);
            this.stringBuilder.setLength(0);
            string = this.stringBuilder.append(this.m_prefixesColon[n]).append("nil").toString();
        }
        this.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", string, "", this.m_preserveLexicalValues ? eventDescription.getCharacters() : (((EXIEventSchemaNil)eventDescription).isNilled() ? CHARACTERS_TRUE : CHARACTERS_FALSE));
    }

    private boolean doXsiType(EventDescription eventDescription) throws SAXException {
        Object object;
        Object object2;
        String string;
        boolean bl = false;
        if (this.m_preserveNS) {
            String string2 = eventDescription.getPrefix();
            assert (string2.length() != 0);
            this.stringBuilder.setLength(0);
            string = this.stringBuilder.append(string2).append(":type").toString();
        } else {
            int n = eventDescription.getURIId();
            assert (n < this.m_n_prefixes);
            this.stringBuilder.setLength(0);
            string = this.stringBuilder.append(this.m_prefixesColon[n]).append("type").toString();
        }
        EXIEventSchemaType eXIEventSchemaType = (EXIEventSchemaType)eventDescription;
        if (this.m_preserveLexicalValues) {
            object2 = eXIEventSchemaType.getCharacters().makeString();
        } else {
            object = eXIEventSchemaType.getTypeName();
            if (this.m_preserveNS) {
                String string3 = eXIEventSchemaType.getTypePrefix();
                if (string3.length() != 0) {
                    this.stringBuilder.setLength(0);
                    object2 = this.stringBuilder.append(string3).append(':').append((String)object).toString();
                } else {
                    object2 = object;
                }
            } else {
                String string4 = eXIEventSchemaType.getTypeURI();
                if (string4.length() != 0) {
                    String string5;
                    int n;
                    for (n = this.m_n_namespaceDeclarations - 1; n > -1 && !string4.equals(this.m_namespaceDeclarationsLocus[n << 1 | 1]); --n) {
                    }
                    if (n != -1) {
                        string5 = this.m_namespaceDeclarationsLocus[n << 1];
                    } else {
                        if (this.m_n_namespaceDeclarations < PREFIXES.length) {
                            string5 = PREFIXES[this.m_n_namespaceDeclarations];
                        } else {
                            this.stringBuilder.setLength(0);
                            string5 = this.stringBuilder.append('p').append(this.m_n_namespaceDeclarations).toString();
                        }
                        this.m_contentHandler.startPrefixMapping(string5, string4);
                        this.pushNamespaceDeclaration(string5, string4);
                        bl = true;
                    }
                    this.stringBuilder.setLength(0);
                    object2 = this.stringBuilder.append(string5).append(':').append((String)object).toString();
                } else {
                    object2 = object;
                }
            }
        }
        object = ((String)object2).toCharArray();
        this.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", string, "", new Characters((char[])object, 0, ((Object)object).length, false));
        return bl;
    }

    private void doElement(EventDescription eventDescription, Scanner scanner, int n) throws IOException, SAXException {
        String string;
        String string2;
        int n2 = 0;
        this.m_attrLength = 0;
        String string3 = eventDescription.getURI();
        String string4 = eventDescription.getName();
        if (this.m_preserveNS) {
            string2 = eventDescription.getPrefix();
            while ((eventDescription = scanner.nextEvent()) != null && eventDescription.getEventKind() == 8) {
                String string5 = eventDescription.getURI();
                String string6 = eventDescription.getPrefix();
                this.m_contentHandler.startPrefixMapping(string6, string5);
                this.pushNamespaceDeclaration(string6, string5);
                ++n2;
                String string7 = ((EXIEventNS)eventDescription).getLocalElementNs() ? string6 : null;
                if (string7 == null) continue;
                string2 = string7;
            }
            if (string2.length() != 0) {
                this.stringBuilder.setLength(0);
                string = this.stringBuilder.append(string2).append(':').append(string4).toString();
            } else {
                string = string4;
            }
        } else {
            int n3;
            int n4;
            if (n == 0) {
                for (n4 = 1; n4 < this.m_n_prefixes; ++n4) {
                    this.m_contentHandler.startPrefixMapping(this.m_prefixes[n4], this.m_uris[n4]);
                }
            }
            if ((n4 = eventDescription.getURIId()) < this.m_n_prefixes) {
                n3 = eventDescription.getNameId();
                if (n3 < this.m_n_qualifiedNames[n4]) {
                    string = this.m_qualifiedNames[n4][n3];
                } else {
                    this.stringBuilder.setLength(0);
                    string = this.stringBuilder.append(this.m_prefixesColon[n4]).append(string4).toString();
                }
            } else if (string3 != "") {
                for (n3 = this.m_n_namespaceDeclarations - 1; n3 > -1 && string3 != this.m_namespaceDeclarationsLocus[n3 << 1 | 1]; --n3) {
                }
                if (n3 > -1) {
                    string2 = this.m_namespaceDeclarationsLocus[n3 << 1];
                } else {
                    if (this.m_n_namespaceDeclarations < PREFIXES.length) {
                        string2 = PREFIXES[this.m_n_namespaceDeclarations];
                    } else {
                        this.stringBuilder.setLength(0);
                        string2 = this.stringBuilder.append('p').append(this.m_n_namespaceDeclarations).toString();
                    }
                    this.m_contentHandler.startPrefixMapping(string2, string3);
                    this.pushNamespaceDeclaration(string2, string3);
                    ++n2;
                }
                if (string2.length() != 0) {
                    this.stringBuilder.setLength(0);
                    string = this.stringBuilder.append(string2).append(':').append(string4).toString();
                } else {
                    string = string4;
                }
            } else {
                for (n3 = this.m_n_namespaceDeclarations - 1; n3 > -1; --n3) {
                    if (this.m_namespaceDeclarationsLocus[n3 << 1].length() != 0) continue;
                    if (this.m_namespaceDeclarationsLocus[n3 << 1 | 1].length() == 0) break;
                    this.m_contentHandler.startPrefixMapping("", "");
                    this.pushNamespaceDeclaration("", "");
                    ++n2;
                    break;
                }
                string = string4;
            }
            eventDescription = scanner.nextEvent();
        }
        if (eventDescription.getEventKind() == 4) {
            if (this.doXsiType(eventDescription)) {
                ++n2;
            }
            eventDescription = scanner.nextEvent();
        }
        if (eventDescription.getEventKind() == 5) {
            this.doXsiNil(eventDescription);
            eventDescription = scanner.nextEvent();
        }
        while (eventDescription.getEventKind() == 3) {
            if (this.doAttribute(eventDescription, scanner)) {
                ++n2;
            }
            eventDescription = scanner.nextEvent();
        }
        this.m_contentHandler.startElement(string3, string4, string, this);
        while (true) {
            switch (eventDescription.getEventKind()) {
                case 2: {
                    this.doElement(eventDescription, scanner, n + 1);
                    break;
                }
                case 7: {
                    this.m_contentHandler.endElement(string3, string4, string);
                    if (!this.m_preserveNS && n == 0) {
                        for (int i = 1; i < this.m_n_prefixes; ++i) {
                            this.m_contentHandler.endPrefixMapping(this.m_prefixes[i]);
                        }
                    }
                    int n5 = n2;
                    for (int i = 0; i < n5; ++i) {
                        this.m_contentHandler.endPrefixMapping(this.m_namespaceDeclarationsLocus[--this.m_n_namespaceDeclarations << 1]);
                    }
                    return;
                }
                case 6: {
                    Characters characters = eventDescription.getCharacters();
                    this.m_contentHandler.characters(characters.characters, characters.startIndex, characters.length);
                    break;
                }
                case 10: {
                    if (!this.m_hasLexicalHandler) break;
                    Characters characters = eventDescription.getCharacters();
                    this.m_lexicalHandler.comment(characters.characters, characters.startIndex, characters.length);
                    break;
                }
                case 9: {
                    this.m_contentHandler.processingInstruction(eventDescription.getName(), eventDescription.getCharacters().makeString());
                    break;
                }
                case 11: {
                    this.m_contentHandler.skippedEntity(eventDescription.getName());
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    assert (false);
                    break;
                }
            }
            eventDescription = scanner.nextEvent();
        }
    }
}

