/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

final class EXIDeflaterOutputStream
extends FilterOutputStream {
    private final Deflater m_deflater;
    private final byte[] m_bytesIn;
    private int m_n_bytesIn;
    private final byte[] m_bytesOut;

    public EXIDeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        super(outputStream);
        deflater.reset();
        this.m_deflater = deflater;
        this.m_bytesIn = new byte[65536];
        this.m_n_bytesIn = 0;
        this.m_bytesOut = new byte[8192];
    }

    public void flush() throws IOException {
        this.flushInput();
        super.flush();
    }

    public void close() throws IOException {
        super.close();
    }

    public void write(int n) throws IOException {
        this.m_bytesIn[this.m_n_bytesIn] = (byte)n;
        if (++this.m_n_bytesIn == this.m_bytesIn.length) {
            this.flushInput();
        }
    }

    private void flushInput() throws IOException {
        int n;
        int n2;
        long l = this.m_deflater.getBytesRead();
        this.m_deflater.setInput(this.m_bytesIn, 0, this.m_n_bytesIn);
        while ((n2 = this.m_deflater.deflate(this.m_bytesOut)) != 0) {
            for (n = 0; n < n2; ++n) {
                super.write(0xFF & this.m_bytesOut[n]);
            }
        }
        n = (int)(this.m_deflater.getBytesRead() - l);
        if (n == this.m_n_bytesIn) {
            this.m_n_bytesIn = 0;
        } else if (n != 0) {
            this.m_n_bytesIn -= n;
            System.arraycopy(this.m_bytesIn, n, this.m_bytesIn, 0, this.m_n_bytesIn);
        }
    }

    void resetDeflater() throws IOException {
        if (this.m_n_bytesIn != 0) {
            this.flushInput();
        }
        this.m_deflater.setInput(this.m_bytesIn, 0, this.m_n_bytesIn);
        this.m_deflater.finish();
        while (!this.m_deflater.finished()) {
            int n = this.m_deflater.deflate(this.m_bytesOut);
            for (int i = 0; i < n; ++i) {
                super.write(0xFF & this.m_bytesOut[i]);
            }
        }
        this.m_deflater.reset();
    }
}

