/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.Channel;
import org.openexi.proc.common.EventCode;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.EventCodeTuple;
import org.openexi.proc.io.ByteAlignedCommons;
import org.openexi.proc.io.CharacterBuffer;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriber;
import org.openexi.proc.io.compression.ChannelKeeper;
import org.openexi.proc.io.compression.ChannellingBinaryValueScriberProxy;
import org.openexi.proc.io.compression.ChannellingValueScriberProxy;
import org.openexi.proc.io.compression.EXIDeflaterOutputStream;
import org.openexi.proc.io.compression.ScriberChannel;
import org.openexi.proc.io.compression.ScriberChannelFactory;
import org.openexi.proc.io.compression.ScriberValueHolder;
import org.openexi.schema.Characters;

public final class ChannellingScriber
extends Scriber {
    private final boolean m_compressed;
    private OutputStream m_baseDataStream;
    private OutputStream m_outputStream;
    private final ValueScriber m_stringValueScriberInherentProxy;
    private final ValueScriber m_booleanValueScriberInherentProxy;
    private final ValueScriber m_enumerationValueScriberInherentProxy;
    private final ValueScriber m_listValueScriberInherentProxy;
    private final ValueScriber m_decimalValueScriberInherentProxy;
    private final ValueScriber m_dateTimeValueScriberInherentProxy;
    private final ValueScriber m_timeValueScriberInherentProxy;
    private final ValueScriber m_dateValueScriberInherentProxy;
    private final ValueScriber m_gDayValueScriberInherentProxy;
    private final ValueScriber m_gMonthValueScriberInherentProxy;
    private final ValueScriber m_gMonthDayValueScriberInherentProxy;
    private final ValueScriber m_gYearValueScriberInherentProxy;
    private final ValueScriber m_gYearMonthValueScriberInherentProxy;
    private final ValueScriber m_floatValueScriberInherentProxy;
    private final ValueScriber m_integerValueScriberInherentProxy;
    private final ValueScriber m_base64BinaryValueScriberInherentProxy;
    private final ValueScriber m_hexBinaryValueScriberInherentProxy;
    private final ValueScriber m_stringValueScriberLexicalProxy;
    private final ValueScriber m_booleanValueScriberLexicalProxy;
    private final ValueScriber m_enumerationValueScriberLexicalProxy;
    private final ValueScriber m_listValueScriberLexicalProxy;
    private final ValueScriber m_decimalValueScriberLexicalProxy;
    private final ValueScriber m_dateTimeValueScriberLexicalProxy;
    private final ValueScriber m_timeValueScriberLexicalProxy;
    private final ValueScriber m_dateValueScriberLexicalProxy;
    private final ValueScriber m_gDayValueScriberLexicalProxy;
    private final ValueScriber m_gMonthValueScriberLexicalProxy;
    private final ValueScriber m_gMonthDayValueScriberLexicalProxy;
    private final ValueScriber m_gYearValueScriberLexicalProxy;
    private final ValueScriber m_gYearMonthValueScriberLexicalProxy;
    private final ValueScriber m_floatValueScriberLexicalProxy;
    private final ValueScriber m_integerValueScriberLexicalProxy;
    private final ValueScriber m_base64BinaryValueScriberLexicalProxy;
    private final ValueScriber m_hexBinaryValueScriberLexicalProxy;
    private final ChannelKeeper m_channelKeeper;
    private final Deflater m_deflator;

    public ChannellingScriber(boolean bl) {
        super(false);
        this.m_compressed = bl;
        this.m_channelKeeper = new ChannelKeeper(new ScriberChannelFactory());
        this.m_deflator = bl ? new Deflater(-1, true) : null;
        this.m_stringValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_stringValueScriberInherent);
        this.m_booleanValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_booleanValueScriberInherent);
        this.m_enumerationValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_enumerationValueScriberInherent);
        this.m_listValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_listValueScriberInherent);
        this.m_decimalValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_decimalValueScriberInherent);
        this.m_dateTimeValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_dateTimeValueScriberInherent);
        this.m_timeValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_timeValueScriberInherent);
        this.m_dateValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_dateValueScriberInherent);
        this.m_gDayValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_gDayValueScriberInherent);
        this.m_gMonthValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_gMonthValueScriberInherent);
        this.m_gMonthDayValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_gMonthDayValueScriberInherent);
        this.m_gYearValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_gYearValueScriberInherent);
        this.m_gYearMonthValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_gYearMonthValueScriberInherent);
        this.m_floatValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_floatValueScriberInherent);
        this.m_integerValueScriberInherentProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, m_integerValueScriberInherent);
        this.m_base64BinaryValueScriberInherentProxy = new ChannellingBinaryValueScriberProxy(this.m_channelKeeper, m_base64BinaryValueScriberInherent);
        this.m_hexBinaryValueScriberInherentProxy = new ChannellingBinaryValueScriberProxy(this.m_channelKeeper, m_hexBinaryValueScriberInherent);
        this.m_stringValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_stringValueScriberLexical);
        this.m_booleanValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_booleanValueScriberLexical);
        this.m_enumerationValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_enumerationValueScriberLexical);
        this.m_listValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_listValueScriberLexical);
        this.m_decimalValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_decimalValueScriberLexical);
        this.m_dateTimeValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_dateTimeValueScriberLexical);
        this.m_timeValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_timeValueScriberLexical);
        this.m_dateValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_dateValueScriberLexical);
        this.m_gDayValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_gDayValueScriberLexical);
        this.m_gMonthValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_gMonthValueScriberLexical);
        this.m_gMonthDayValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_gMonthDayValueScriberLexical);
        this.m_gYearValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_gYearValueScriberLexical);
        this.m_gYearMonthValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_gYearMonthValueScriberLexical);
        this.m_floatValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_floatValueScriberLexical);
        this.m_integerValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_integerValueScriberLexical);
        this.m_base64BinaryValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_base64BinaryValueScriberLexical);
        this.m_hexBinaryValueScriberLexicalProxy = new ChannellingValueScriberProxy(this.m_channelKeeper, this.m_hexBinaryValueScriberLexical);
        this.m_valueScriberTable[15] = this.m_stringValueScriberInherentProxy;
        this.m_valueScriberTable[3] = this.m_booleanValueScriberInherentProxy;
        this.m_valueScriberTable[17] = this.m_enumerationValueScriberInherentProxy;
        this.m_valueScriberTable[16] = this.m_listValueScriberInherentProxy;
        this.m_valueScriberTable[12] = this.m_decimalValueScriberInherentProxy;
        this.m_valueScriberTable[4] = this.m_dateTimeValueScriberInherentProxy;
        this.m_valueScriberTable[5] = this.m_timeValueScriberInherentProxy;
        this.m_valueScriberTable[6] = this.m_dateValueScriberInherentProxy;
        this.m_valueScriberTable[10] = this.m_gDayValueScriberInherentProxy;
        this.m_valueScriberTable[11] = this.m_gMonthValueScriberInherentProxy;
        this.m_valueScriberTable[9] = this.m_gMonthDayValueScriberInherentProxy;
        this.m_valueScriberTable[8] = this.m_gYearValueScriberInherentProxy;
        this.m_valueScriberTable[7] = this.m_gYearMonthValueScriberInherentProxy;
        this.m_valueScriberTable[13] = this.m_floatValueScriberInherentProxy;
        this.m_valueScriberTable[14] = this.m_integerValueScriberInherentProxy;
        this.m_valueScriberTable[1] = this.m_base64BinaryValueScriberInherentProxy;
        this.m_valueScriberTable[2] = this.m_hexBinaryValueScriberInherentProxy;
    }

    public void reset() {
        super.reset();
        this.m_channelKeeper.reset();
        if (this.m_compressed) {
            this.m_deflator.reset();
        }
        this.m_baseDataStream = null;
        this.m_outputStream = null;
    }

    public void setDeflateParams(int n, int n2) {
        if (this.m_compressed) {
            this.m_deflator.setLevel(n);
            this.m_deflator.setStrategy(n2);
        }
    }

    public AlignmentType getAlignmentType() {
        return this.m_compressed ? AlignmentType.compress : AlignmentType.preCompress;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.m_baseDataStream = outputStream;
        this.m_outputStream = this.m_compressed ? new EXIDeflaterOutputStream(this.m_baseDataStream, this.m_deflator) : this.m_baseDataStream;
    }

    protected OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    public void setBlockSize(int n) {
        this.m_channelKeeper.setBlockSize(n);
    }

    public final void setPreserveLexicalValues(boolean bl) {
        boolean bl2 = this.m_preserveLexicalValues;
        if (bl2 != bl) {
            super.setPreserveLexicalValues(bl);
            if (bl) {
                this.m_valueScriberTable[15] = this.m_stringValueScriberLexicalProxy;
                this.m_valueScriberTable[3] = this.m_booleanValueScriberLexicalProxy;
                this.m_valueScriberTable[17] = this.m_enumerationValueScriberLexicalProxy;
                this.m_valueScriberTable[16] = this.m_listValueScriberLexicalProxy;
                this.m_valueScriberTable[12] = this.m_decimalValueScriberLexicalProxy;
                this.m_valueScriberTable[4] = this.m_dateTimeValueScriberLexicalProxy;
                this.m_valueScriberTable[5] = this.m_timeValueScriberLexicalProxy;
                this.m_valueScriberTable[6] = this.m_dateValueScriberLexicalProxy;
                this.m_valueScriberTable[10] = this.m_gDayValueScriberLexicalProxy;
                this.m_valueScriberTable[11] = this.m_gMonthValueScriberLexicalProxy;
                this.m_valueScriberTable[9] = this.m_gMonthDayValueScriberLexicalProxy;
                this.m_valueScriberTable[8] = this.m_gYearValueScriberLexicalProxy;
                this.m_valueScriberTable[7] = this.m_gYearMonthValueScriberLexicalProxy;
                this.m_valueScriberTable[13] = this.m_floatValueScriberLexicalProxy;
                this.m_valueScriberTable[14] = this.m_integerValueScriberLexicalProxy;
                this.m_valueScriberTable[1] = this.m_base64BinaryValueScriberLexicalProxy;
                this.m_valueScriberTable[2] = this.m_hexBinaryValueScriberLexicalProxy;
            } else {
                this.m_valueScriberTable[15] = this.m_stringValueScriberInherentProxy;
                this.m_valueScriberTable[3] = this.m_booleanValueScriberInherentProxy;
                this.m_valueScriberTable[17] = this.m_enumerationValueScriberInherentProxy;
                this.m_valueScriberTable[16] = this.m_listValueScriberInherentProxy;
                this.m_valueScriberTable[12] = this.m_decimalValueScriberInherentProxy;
                this.m_valueScriberTable[4] = this.m_dateTimeValueScriberInherentProxy;
                this.m_valueScriberTable[5] = this.m_timeValueScriberInherentProxy;
                this.m_valueScriberTable[6] = this.m_dateValueScriberInherentProxy;
                this.m_valueScriberTable[10] = this.m_gDayValueScriberInherentProxy;
                this.m_valueScriberTable[11] = this.m_gMonthValueScriberInherentProxy;
                this.m_valueScriberTable[9] = this.m_gMonthDayValueScriberInherentProxy;
                this.m_valueScriberTable[8] = this.m_gYearValueScriberInherentProxy;
                this.m_valueScriberTable[7] = this.m_gYearMonthValueScriberInherentProxy;
                this.m_valueScriberTable[13] = this.m_floatValueScriberInherentProxy;
                this.m_valueScriberTable[14] = this.m_integerValueScriberInherentProxy;
                this.m_valueScriberTable[1] = this.m_base64BinaryValueScriberInherentProxy;
                this.m_valueScriberTable[2] = this.m_hexBinaryValueScriberInherentProxy;
            }
        }
    }

    public final void writeEventType(EventType eventType) throws IOException {
        EventCode[] eventCodeArray = eventType.getItemPath();
        EventCode eventCode = eventCodeArray[0].parent;
        int n = eventCodeArray.length;
        for (int i = 0; i < n; ++i) {
            EventCodeTuple eventCodeTuple = (EventCodeTuple)eventCode;
            eventCode = eventCodeArray[i];
            int n2 = eventCodeTuple.width;
            if (n2 == 0) continue;
            this.writeNBitUnsigned(eventCodeTuple.reversed ? eventCodeTuple.itemsCount - 1 - eventCode.position : eventCode.position, n2, this.m_outputStream);
        }
    }

    public void writeNS(String string, String string2, boolean bl) throws IOException {
        assert (this.m_preserveNS);
        assert (this.m_outputStream != null);
        int n = this.writeURI(string, this.m_outputStream);
        this.writePrefixOfNS(string2, n);
        this.writeBoolean(bl, this.m_outputStream);
    }

    public void writeQName(QName qName, EventType eventType) throws IOException {
        int n;
        int n2;
        byte by = eventType.itemType;
        switch (by) {
            case 5: 
            case 8: 
            case 14: 
            case 17: {
                n2 = this.writeURI(qName.namespaceName, this.m_outputStream);
                StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n2);
                n = this.writeLocalName(qName.localName, localNamePartition, this.m_outputStream);
                break;
            }
            case 15: 
            case 18: {
                n2 = eventType.getURIId();
                StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n2);
                n = this.writeLocalName(qName.localName, localNamePartition, this.m_outputStream);
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                n2 = eventType.getURIId();
                n = eventType.getNameId();
                break;
            }
            default: {
                n = -1;
                n2 = -1;
                assert (false);
                break;
            }
        }
        qName.uriId = n2;
        qName.localNameId = n;
        if (this.m_preserveNS) {
            this.writePrefixOfQName(qName.prefix, n2, this.m_outputStream);
        }
    }

    private void writePrefixOfNS(String string, int n) throws IOException {
        StringTable.PrefixPartition prefixPartition = this.stringTable.getPrefixPartition(n);
        int n2 = prefixPartition.n_strings;
        int n3 = prefixPartition.forwardedWidth;
        int n4 = prefixPartition.internPrefix(string);
        if (n4 < n2) {
            this.writeNBitUnsigned(n4 + 1, n3, this.m_outputStream);
        } else {
            this.writeNBitUnsigned(0, n3, this.m_outputStream);
            int n5 = string.length();
            CharacterBuffer characterBuffer = this.ensureCharacters(n5);
            Characters characters = characterBuffer.addString(string, n5);
            this.writeLiteralCharacters(characters, n5, 0, -1, this.m_outputStream);
        }
    }

    protected void writeBoolean(boolean bl, OutputStream outputStream) throws IOException {
        outputStream.write(bl ? 1 : 0);
    }

    protected void writeNBitUnsigned(int n, int n2, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeNBitUnsigned(n, n2, outputStream);
    }

    protected void writeUnsignedInteger32(int n, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger32(n, outputStream);
    }

    protected void writeUnsignedInteger64(long l, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger64(l, outputStream);
    }

    protected void writeUnsignedInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger(bigInteger, outputStream);
    }

    public void finishBlock() throws IOException {
        int n;
        int n2;
        ArrayList<ScriberValueHolder> arrayList;
        ScriberChannel scriberChannel;
        int n3;
        EXIDeflaterOutputStream eXIDeflaterOutputStream = this.m_compressed ? (EXIDeflaterOutputStream)this.m_outputStream : null;
        boolean bl = false;
        if (this.m_compressed) {
            int n4 = this.m_channelKeeper.getTotalValueCount();
            if (n4 == 0) {
                eXIDeflaterOutputStream.resetDeflater();
                this.m_channelKeeper.punctuate();
                return;
            }
            bl = n4 > 100;
            if (bl) {
                eXIDeflaterOutputStream.resetDeflater();
            }
        }
        this.m_channelKeeper.finish();
        List<Channel> list = this.m_channelKeeper.getSmallChannels();
        int n5 = list.size();
        if (n5 != 0) {
            n3 = 0;
            do {
                scriberChannel = (ScriberChannel)list.get(n3);
                arrayList = scriberChannel.values;
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.get(n).scribeValue(this.m_outputStream, this);
                }
            } while (++n3 < n5);
            if (this.m_compressed && bl) {
                eXIDeflaterOutputStream.resetDeflater();
            }
        }
        List<Channel> list2 = this.m_channelKeeper.getLargeChannels();
        int n6 = list2.size();
        for (n3 = 0; n3 < n6; ++n3) {
            scriberChannel = (ScriberChannel)list2.get(n3);
            arrayList = scriberChannel.values;
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList.get(n).scribeValue(this.m_outputStream, this);
            }
            if (!this.m_compressed) continue;
            eXIDeflaterOutputStream.resetDeflater();
        }
        if (this.m_compressed && !bl) {
            eXIDeflaterOutputStream.resetDeflater();
        }
        this.m_channelKeeper.punctuate();
    }

    public void finish() throws IOException {
        this.finishBlock();
        this.m_baseDataStream.flush();
    }
}

