/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchema;

public final class StringValueScriber
extends ValueScriberBase {
    public StringValueScriber() {
        super(new QName("exi:string", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 15;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        scribble.stringValue1 = string;
        return true;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        int n4 = string.length();
        Characters characters = scriber.ensureCharacters(n4).addString(string, n4);
        this.scribeStringValue(characters, n, n2, n3, outputStream, scriber);
    }

    void scribeStringValue(Characters characters, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        StringTable.GlobalValuePartition globalValuePartition = scriber.stringTable.globalValuePartition;
        StringTable.GlobalEntry globalEntry = globalValuePartition.getEntry(characters);
        if (globalEntry == null) {
            int n4 = characters.length;
            scriber.writeLiteralCharacters(characters, n4, 2, n3, outputStream);
            if (n4 != 0 && n4 < scriber.valueMaxExclusiveLength) {
                globalValuePartition.addValue(characters, n, n2);
            }
            return;
        }
        StringTable.LocalValuePartition localValuePartition = globalEntry.localPartition;
        if (localValuePartition == globalValuePartition.getLocalPartition(n, n2)) {
            scriber.writeUnsignedInteger32(0, outputStream);
            scriber.writeNBitUnsigned(globalEntry.localEntry.number, localValuePartition.width, outputStream);
            return;
        }
        scriber.writeUnsignedInteger32(1, outputStream);
        scriber.writeNBitUnsigned(globalEntry.number, globalValuePartition.width, outputStream);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        int n = string.length();
        return scriber.ensureCharacters(n).addString(string, n);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeStringValue((Characters)object, n, n2, n3, outputStream, scriber);
    }
}

