/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.Apparatus;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.grammars.ValueApparatus;
import org.openexi.proc.io.Base64BinaryValueScriber;
import org.openexi.proc.io.BinaryValueScriber;
import org.openexi.proc.io.BooleanValueScriber;
import org.openexi.proc.io.BuiltinRCS;
import org.openexi.proc.io.CharacterBuffer;
import org.openexi.proc.io.DateTimeValueScriber;
import org.openexi.proc.io.DateValueScriber;
import org.openexi.proc.io.DecimalValueScriber;
import org.openexi.proc.io.EnumerationValueScriber;
import org.openexi.proc.io.FloatValueScriber;
import org.openexi.proc.io.GDayValueScriber;
import org.openexi.proc.io.GMonthDayValueScriber;
import org.openexi.proc.io.GMonthValueScriber;
import org.openexi.proc.io.GYearMonthValueScriber;
import org.openexi.proc.io.GYearValueScriber;
import org.openexi.proc.io.HexBinaryValueScriber;
import org.openexi.proc.io.IntegerValueScriber;
import org.openexi.proc.io.ListValueScriber;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.StringValueScriber;
import org.openexi.proc.io.TimeValueScriber;
import org.openexi.proc.io.ValueScriber;
import org.openexi.proc.io.ValueScriberLexical;
import org.openexi.schema.Characters;

public abstract class Scriber
extends Apparatus {
    static final BigInteger BIGINTEGER_0x007F = BigInteger.valueOf(127L);
    private static final byte[] COOKIE = new byte[]{36, 69, 88, 73};
    protected final DatatypeFactory m_datatypeFactory;
    protected boolean m_preserveNS = false;
    int valueMaxExclusiveLength = Integer.MAX_VALUE;
    private final ValueScriber[] m_valueScribers;
    protected final ValueScriber[] m_valueScriberTable;
    protected static final BinaryValueScriber m_base64BinaryValueScriberInherent = Base64BinaryValueScriber.instance;
    protected static final ValueScriber m_booleanValueScriberInherent = BooleanValueScriber.instance;
    protected static final ValueScriber m_floatValueScriberInherent;
    protected static final ValueScriber m_integerValueScriberInherent;
    protected static final BinaryValueScriber m_hexBinaryValueScriberInherent;
    protected static final ValueScriber m_decimalValueScriberInherent;
    protected static final DateTimeValueScriber m_dateTimeValueScriberInherent;
    protected static final DateValueScriber m_dateValueScriberInherent;
    protected static final TimeValueScriber m_timeValueScriberInherent;
    protected static final GYearMonthValueScriber m_gYearMonthValueScriberInherent;
    protected static final GMonthDayValueScriber m_gMonthDayValueScriberInherent;
    protected static final GYearValueScriber m_gYearValueScriberInherent;
    protected static final GMonthValueScriber m_gMonthValueScriberInherent;
    protected static final GDayValueScriber m_gDayValueScriberInherent;
    protected final StringValueScriber m_stringValueScriberInherent;
    protected final ValueScriber m_enumerationValueScriberInherent;
    protected final ValueScriber m_listValueScriberInherent;
    protected final ValueScriber m_stringValueScriberLexical;
    protected final ValueScriber m_booleanValueScriberLexical;
    protected final ValueScriber m_enumerationValueScriberLexical;
    protected final ValueScriber m_listValueScriberLexical;
    protected final ValueScriber m_decimalValueScriberLexical;
    protected final ValueScriber m_dateTimeValueScriberLexical;
    protected final ValueScriber m_timeValueScriberLexical;
    protected final ValueScriber m_dateValueScriberLexical;
    protected final ValueScriber m_gDayValueScriberLexical;
    protected final ValueScriber m_gMonthValueScriberLexical;
    protected final ValueScriber m_gMonthDayValueScriberLexical;
    protected final ValueScriber m_gYearValueScriberLexical;
    protected final ValueScriber m_gYearMonthValueScriberLexical;
    protected final ValueScriber m_floatValueScriberLexical;
    protected final ValueScriber m_integerValueScriberLexical;
    protected final ValueScriber m_base64BinaryValueScriberLexical;
    protected final ValueScriber m_hexBinaryValueScriberLexical;
    protected CharacterBuffer m_characterBuffer;
    private int[] m_ucsBuffer;
    final StringBuilder stringBuilder1;
    final StringBuilder stringBuilder2;
    final Scribble scribble1;

    public static StringTable createStringTable(GrammarCache grammarCache) {
        return new StringTable(grammarCache, StringTable.Usage.encoding);
    }

    protected Scriber(boolean bl) {
        this.m_preserveLexicalValues = false;
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
        this.m_datatypeFactory = datatypeFactory;
        ArrayList<ValueScriber> arrayList = new ArrayList<ValueScriber>();
        this.m_stringValueScriberInherent = new StringValueScriber();
        arrayList.add(this.m_stringValueScriberInherent);
        arrayList.add(m_booleanValueScriberInherent);
        arrayList.add(m_decimalValueScriberInherent);
        arrayList.add(m_floatValueScriberInherent);
        arrayList.add(m_integerValueScriberInherent);
        arrayList.add(m_base64BinaryValueScriberInherent);
        arrayList.add(m_hexBinaryValueScriberInherent);
        if (!bl) {
            this.m_stringValueScriberLexical = new ValueScriberLexical(this.m_stringValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_booleanValueScriberLexical = new ValueScriberLexical(m_booleanValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_integerValueScriberLexical = new ValueScriberLexical(m_integerValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_enumerationValueScriberInherent = new EnumerationValueScriber(this.m_datatypeFactory);
            arrayList.add(this.m_enumerationValueScriberInherent);
            this.m_enumerationValueScriberLexical = new ValueScriberLexical(this.m_enumerationValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_listValueScriberInherent = new ListValueScriber();
            arrayList.add(this.m_listValueScriberInherent);
            this.m_listValueScriberLexical = new ValueScriberLexical(this.m_listValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_decimalValueScriberLexical = new ValueScriberLexical(m_decimalValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_dateTimeValueScriberInherent);
            this.m_dateTimeValueScriberLexical = new ValueScriberLexical(m_dateTimeValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_timeValueScriberInherent);
            this.m_timeValueScriberLexical = new ValueScriberLexical(m_timeValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_dateValueScriberInherent);
            this.m_dateValueScriberLexical = new ValueScriberLexical(m_dateValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_gDayValueScriberInherent);
            this.m_gDayValueScriberLexical = new ValueScriberLexical(m_gDayValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_gMonthValueScriberInherent);
            this.m_gMonthValueScriberLexical = new ValueScriberLexical(m_gMonthValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_gMonthDayValueScriberInherent);
            this.m_gMonthDayValueScriberLexical = new ValueScriberLexical(m_gMonthDayValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_gYearValueScriberInherent);
            this.m_gYearValueScriberLexical = new ValueScriberLexical(m_gYearValueScriberInherent, this.m_stringValueScriberInherent);
            arrayList.add(m_gYearMonthValueScriberInherent);
            this.m_gYearMonthValueScriberLexical = new ValueScriberLexical(m_gYearMonthValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_floatValueScriberLexical = new ValueScriberLexical(m_floatValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_base64BinaryValueScriberLexical = new ValueScriberLexical(m_base64BinaryValueScriberInherent, this.m_stringValueScriberInherent);
            this.m_hexBinaryValueScriberLexical = new ValueScriberLexical(m_hexBinaryValueScriberInherent, this.m_stringValueScriberInherent);
        } else {
            this.m_stringValueScriberLexical = null;
            this.m_booleanValueScriberLexical = null;
            this.m_integerValueScriberLexical = null;
            this.m_decimalValueScriberLexical = null;
            this.m_floatValueScriberLexical = null;
            this.m_base64BinaryValueScriberLexical = null;
            this.m_hexBinaryValueScriberLexical = null;
            this.m_dateTimeValueScriberLexical = null;
            this.m_dateValueScriberLexical = null;
            this.m_timeValueScriberLexical = null;
            this.m_gYearMonthValueScriberLexical = null;
            this.m_gMonthDayValueScriberLexical = null;
            this.m_gYearValueScriberLexical = null;
            this.m_gMonthValueScriberLexical = null;
            this.m_gDayValueScriberLexical = null;
            this.m_enumerationValueScriberLexical = null;
            this.m_enumerationValueScriberInherent = null;
            this.m_listValueScriberLexical = null;
            this.m_listValueScriberInherent = null;
        }
        this.m_valueScribers = new ValueScriber[arrayList.size()];
        for (int i = 0; i < this.m_valueScribers.length; ++i) {
            this.m_valueScribers[i] = (ValueScriber)arrayList.get(i);
        }
        this.m_valueScriberTable = new ValueScriber[18];
        this.m_characterBuffer = new CharacterBuffer(false);
        this.m_ucsBuffer = new int[1024];
        this.stringBuilder1 = new StringBuilder();
        this.stringBuilder2 = new StringBuilder();
        this.scribble1 = new Scribble();
    }

    protected final CharacterBuffer ensureCharacters(int n) {
        int n2;
        CharacterBuffer characterBuffer = this.m_characterBuffer;
        int n3 = this.m_characterBuffer.availability();
        if (n3 < n) {
            n2 = n > 4096 ? n : 4096;
            characterBuffer = new CharacterBuffer(n2, false);
        }
        if (characterBuffer != this.m_characterBuffer && (n2 = characterBuffer.availability()) != 0 && n3 < n2) {
            this.m_characterBuffer = characterBuffer;
        }
        return characterBuffer;
    }

    public static void writeHeaderPreamble(OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            outputStream.write(COOKIE);
        }
        outputStream.write(bl2 ? 160 : 128);
    }

    protected final ValueApparatus[] getValueApparatuses() {
        return this.m_valueScribers;
    }

    public abstract void setOutputStream(OutputStream var1);

    public final void setValueMaxLength(int n) {
        this.valueMaxExclusiveLength = n == -1 ? Integer.MAX_VALUE : n + 1;
    }

    public final void setPreserveNS(boolean bl) {
        this.m_preserveNS = bl;
    }

    public abstract void setBlockSize(int var1);

    public void setDeflateParams(int n, int n2) {
    }

    public final ValueScriber getValueScriberByID(short s) {
        return this.m_valueScriberTable[s];
    }

    public final ValueScriber getValueScriber(int n) {
        assert (n != -1);
        int n2 = this.schema.getSerialOfType(n);
        return this.m_valueScriberTable[this.m_codecTable[n2]];
    }

    public abstract void writeEventType(EventType var1) throws IOException;

    public abstract void writeNS(String var1, String var2, boolean var3) throws IOException;

    public abstract void writeQName(QName var1, EventType var2) throws IOException;

    public final void writeName(String string) throws IOException {
        this.writeLiteralString(string, 0, this.getOutputStream());
    }

    public final void writePublic(String string) throws IOException {
        this.writeLiteralString(string, 0, this.getOutputStream());
    }

    public final void writeSystem(String string) throws IOException {
        this.writeLiteralString(string, 0, this.getOutputStream());
    }

    public final void writeText(String string) throws IOException {
        this.writeLiteralString(string, 0, this.getOutputStream());
    }

    public final void writeXsiTypeValue(QName qName) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (this.m_preserveLexicalValues) {
            this.m_valueScriberTable[15].scribe(qName.qName, null, 1, 2, -1, outputStream, this);
        } else {
            String string = qName.namespaceName;
            boolean bl = string != null;
            if (!bl) {
                string = "";
            }
            int n = this.writeURI(string, outputStream);
            StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n);
            this.writeLocalName(bl ? qName.localName : qName.qName, localNamePartition, outputStream);
            if (this.m_preserveNS) {
                this.writePrefixOfQName(qName.prefix, n, outputStream);
            }
        }
    }

    public final void writeXsiNilValue(boolean bl, String string) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (this.m_preserveLexicalValues) {
            this.m_valueScriberTable[15].scribe(string, null, 0, 2, -1, outputStream, this);
        } else {
            this.writeBoolean(bl, outputStream);
        }
    }

    protected abstract OutputStream getOutputStream();

    public abstract void finish() throws IOException;

    protected abstract void writeUnsignedInteger32(int var1, OutputStream var2) throws IOException;

    protected abstract void writeUnsignedInteger64(long var1, OutputStream var3) throws IOException;

    protected abstract void writeUnsignedInteger(BigInteger var1, OutputStream var2) throws IOException;

    protected final void writeLiteralCharacters(Characters characters, int n, int n2, int n3, OutputStream outputStream) throws IOException {
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        if (n3 >= 0) {
            n7 = this.m_restrictedCharacterCountTable[this.m_types[n3 + 2]];
            if (n7 != 0) {
                nArray = this.m_types;
                n6 = this.schema.getRestrictedCharacterOfSimpleType(n3);
                n5 = BuiltinRCS.WIDTHS[n7];
                n4 = n6 + n7;
            } else {
                n4 = -1;
                n5 = -1;
                n6 = -1;
                nArray = null;
            }
        } else if (n3 != -1) {
            n6 = 0;
            switch (n3) {
                case -2: {
                    nArray = BuiltinRCS.RCS_BASE64BINARY;
                    n5 = BuiltinRCS.RCS_BASE64BINARY_WIDTH;
                    break;
                }
                case -3: {
                    nArray = BuiltinRCS.RCS_HEXBINARY;
                    n5 = BuiltinRCS.RCS_HEXBINARY_WIDTH;
                    break;
                }
                case -4: {
                    nArray = BuiltinRCS.RCS_BOOLEAN;
                    n5 = BuiltinRCS.RCS_BOOLEAN_WIDTH;
                    break;
                }
                case -5: {
                    nArray = BuiltinRCS.RCS_DATETIME;
                    n5 = BuiltinRCS.RCS_DATETIME_WIDTH;
                    break;
                }
                case -6: {
                    nArray = BuiltinRCS.RCS_DECIMAL;
                    n5 = BuiltinRCS.RCS_DECIMAL_WIDTH;
                    break;
                }
                case -7: {
                    nArray = BuiltinRCS.RCS_DOUBLE;
                    n5 = BuiltinRCS.RCS_DOUBLE_WIDTH;
                    break;
                }
                case -8: {
                    nArray = BuiltinRCS.RCS_INTEGER;
                    n5 = BuiltinRCS.RCS_INTEGER_WIDTH;
                    break;
                }
                default: {
                    assert (false);
                    n5 = -1;
                    nArray = null;
                }
            }
            n4 = n7 = nArray.length;
        } else {
            n4 = -1;
            n5 = -1;
            n6 = -1;
            n7 = -1;
            nArray = null;
        }
        int n8 = characters.ucsCount;
        this.writeUnsignedInteger32(n2 + n8, outputStream);
        char[] cArray = characters.characters;
        int n9 = characters.startIndex;
        block9: for (int i = 0; i < n; ++i) {
            int n10;
            int n11;
            int n12 = cArray[n9 + i];
            if (n5 > 0) {
                n11 = n6;
                n10 = n4 - 1;
                do {
                    int n13;
                    int n14;
                    if (n12 == (n14 = nArray[n13 = (n11 + n10) / 2])) {
                        this.writeNBitUnsigned(n13 - n6, n5, outputStream);
                        continue block9;
                    }
                    if (n12 < n14) {
                        n10 = n13 - 1;
                        continue;
                    }
                    n11 = n13 + 1;
                } while (n11 <= n10);
                this.writeNBitUnsigned(n4 - n6, n5, outputStream);
            }
            if ((n12 & 0xFC00) != 55296) {
                n11 = n12;
            } else if (((n10 = cArray[n9 + ++i]) & 0xFC00) == 56320) {
                n11 = ((n12 & 0x3FF) << 10 | n10 & 0x3FF) + 65536;
            } else {
                --i;
                n11 = n12;
            }
            this.writeUnsignedInteger32(n11, outputStream);
        }
    }

    protected final int writeURI(String string, OutputStream outputStream) throws IOException {
        int n = this.stringTable.n_uris;
        int n2 = this.stringTable.uriForwardedWidth;
        int n3 = this.stringTable.internURI(string);
        if (n3 < n) {
            this.writeNBitUnsigned(n3 + 1, n2, outputStream);
        } else {
            this.writeNBitUnsigned(0, n2, outputStream);
            this.writeLiteralString(string, 0, outputStream);
        }
        return n3;
    }

    protected final int writeLocalName(String string, StringTable.LocalNamePartition localNamePartition, OutputStream outputStream) throws IOException {
        int n = localNamePartition.n_strings;
        int n2 = localNamePartition.width;
        int n3 = localNamePartition.internName(string);
        if (n3 < n) {
            this.writeUnsignedInteger32(0, outputStream);
            this.writeNBitUnsigned(n3, n2, outputStream);
        } else {
            this.writeLiteralString(string, 1, outputStream);
        }
        return n3;
    }

    private void writeLiteralString(String string, int n, OutputStream outputStream) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_ucsBuffer.length) {
            this.m_ucsBuffer = new int[n2 + 256];
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c;
            int n5;
            int n6 = n5 = string.charAt(n4++);
            if ((n5 & 0xFC00) == 55296 && n4 < n2 && ((c = string.charAt(n4)) & 0xFC00) == 56320) {
                n6 = ((n5 & 0x3FF) << 10 | c & 0x3FF) + 65536;
                ++n4;
            }
            this.m_ucsBuffer[n3] = n6;
            ++n3;
        }
        this.writeUnsignedInteger32(n + n3, outputStream);
        for (n4 = 0; n4 < n3; ++n4) {
            this.writeUnsignedInteger32(this.m_ucsBuffer[n4], outputStream);
        }
    }

    protected final void writePrefixOfQName(String string, int n, OutputStream outputStream) throws IOException {
        assert (this.m_preserveNS);
        StringTable.PrefixPartition prefixPartition = this.stringTable.getPrefixPartition(n);
        int n2 = prefixPartition.width;
        int n3 = prefixPartition.getCompactId(string);
        this.writeNBitUnsigned(n3 != -1 ? n3 : 0, n2, outputStream);
    }

    protected abstract void writeNBitUnsigned(int var1, int var2, OutputStream var3) throws IOException;

    protected abstract void writeBoolean(boolean var1, OutputStream var2) throws IOException;

    static {
        m_decimalValueScriberInherent = DecimalValueScriber.instance;
        m_hexBinaryValueScriberInherent = HexBinaryValueScriber.instance;
        m_integerValueScriberInherent = IntegerValueScriber.instance;
        m_floatValueScriberInherent = FloatValueScriber.instance;
        m_dateTimeValueScriberInherent = DateTimeValueScriber.instance;
        m_dateValueScriberInherent = DateValueScriber.instance;
        m_timeValueScriberInherent = TimeValueScriber.instance;
        m_gYearMonthValueScriberInherent = GYearMonthValueScriber.instance;
        m_gMonthDayValueScriberInherent = GMonthDayValueScriber.instance;
        m_gYearValueScriberInherent = GYearValueScriber.instance;
        m_gMonthValueScriberInherent = GMonthValueScriber.instance;
        m_gDayValueScriberInherent = GDayValueScriber.instance;
    }
}

