/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

final class DecimalValueScriber
extends ValueScriberBase {
    public static final DecimalValueScriber instance = new DecimalValueScriber();
    private static final int DECIMAL_MODE_MAYBE_SIGN = 0;
    private static final int DECIMAL_MODE_MAYBE_INTEGRAL = 1;
    private static final int DECIMAL_MODE_IS_INTEGRAL = 2;
    private static final int DECIMAL_MODE_IS_FRACTION = 3;
    private static final int DECIMAL_MODE_MAYBE_TRAILING_ZEROS = 4;

    private DecimalValueScriber() {
        super(new QName("exi:decimal", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 12;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -6;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = scriber.stringBuilder1;
        StringBuilder stringBuilder2 = scriber.stringBuilder2;
        stringBuilder.setLength(0);
        stringBuilder2.setLength(0);
        boolean bl = true;
        boolean bl2 = false;
        int n6 = 0;
        block6: for (int i = this.startPosition; i < this.limitPosition && !bl2; ++i) {
            char c = string.charAt(i);
            switch (n6) {
                case 0: {
                    if (c == '-' || c == '+') {
                        n6 = 1;
                        if (c == '+') continue block6;
                        bl = false;
                        continue block6;
                    }
                    if (c == '.') {
                        n6 = 3;
                        continue block6;
                    }
                    if (c >= '0' && c <= '9') {
                        n6 = 2;
                        ++n2;
                        if (c == '0') continue block6;
                        stringBuilder.append(c);
                        ++n3;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (c == '.') {
                        n6 = 3;
                        continue block6;
                    }
                    if (c >= '0' && c <= '9') {
                        n6 = 2;
                        ++n2;
                        if (n3 <= 0 && c == '0') continue block6;
                        stringBuilder.append(c);
                        ++n3;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 3: {
                    if (c == '0') {
                        ++n5;
                        n6 = 4;
                        continue block6;
                    }
                    if (c >= '1' && c <= '9') {
                        stringBuilder2.append(c);
                        ++n2;
                        ++n4;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 4: {
                    assert (n5 > 0);
                    if (c == '0') {
                        ++n5;
                        continue block6;
                    }
                    if (c >= '1' && c <= '9') {
                        n2 += n5;
                        n4 += n5;
                        for (int j = 0; j < n5; ++j) {
                            stringBuilder2.append('0');
                        }
                        stringBuilder2.append(c);
                        ++n2;
                        ++n4;
                        n5 = 0;
                        n6 = 3;
                        continue block6;
                    }
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            n2 += n5;
            if (n6 == 4) {
                n6 = 3;
            }
            if (n6 == 3 && n4 == 0 && n5 == 0) {
                n5 = 1;
            }
            n3 += n4;
        }
        if (bl2 || n6 != 2 && n6 != 3 || n2 == 0) {
            return false;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        if (stringBuilder2.length() == 0) {
            stringBuilder2.append('0');
        } else {
            stringBuilder2.reverse();
        }
        scribble.booleanValue1 = !bl;
        scribble.stringValue1 = stringBuilder.toString();
        scribble.stringValue2 = stringBuilder2.toString();
        return true;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeDecimalValue(scribble.stringValue1, scribble.stringValue2, scribble.booleanValue1, outputStream, scriber);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        return new DecimalValue(scribble.stringValue1, scribble.stringValue2, scribble.booleanValue1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        DecimalValue decimalValue = (DecimalValue)object;
        this.scribeDecimalValue(decimalValue.integralDigits, decimalValue.fractionalDigits, decimalValue.isNegative, outputStream, scriber);
    }

    private void scribeDecimalValue(String string, String string2, boolean bl, OutputStream outputStream, Scriber scriber) throws IOException {
        int n;
        scriber.writeBoolean(bl, outputStream);
        int n2 = string.length();
        if (n2 < 10 || n2 == 10 && "2147483647".compareTo(string) >= 0) {
            n = Integer.parseInt(string);
            scriber.writeUnsignedInteger32(n, outputStream);
        } else {
            BigInteger bigInteger = new BigInteger(string);
            scriber.writeUnsignedInteger(bigInteger, outputStream);
        }
        n = string2.length();
        if (n < 10 || n == 10 && "2147483647".compareTo(string2) >= 0) {
            int n3 = Integer.parseInt(string2);
            scriber.writeUnsignedInteger32(n3, outputStream);
        } else {
            BigInteger bigInteger = new BigInteger(string2);
            scriber.writeUnsignedInteger(bigInteger, outputStream);
        }
    }

    private static class DecimalValue {
        String integralDigits;
        String fractionalDigits;
        boolean isNegative;

        DecimalValue(String string, String string2, boolean bl) {
            this.integralDigits = string;
            this.fractionalDigits = string2;
            this.isNegative = bl;
        }
    }
}

