/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.io.BitOutputStream;
import org.openexi.proc.io.SimpleScriber;

public final class BitPackedScriber
extends SimpleScriber {
    private BitOutputStream m_dataStream = null;

    BitPackedScriber(boolean bl) {
        super(bl);
    }

    public AlignmentType getAlignmentType() {
        return AlignmentType.bitPacked;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.m_dataStream = new BitOutputStream(outputStream);
    }

    public void setBitOutputStream(BitOutputStream bitOutputStream) {
        this.m_dataStream = bitOutputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_dataStream;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.m_dataStream.putBit(bl);
    }

    protected void writeUnsignedInteger32(int n, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n2 = n & 0x7F;
            if ((n >>>= 7) != 0) {
                n2 |= 0x80;
            } else {
                bl = false;
            }
            this.writeNBitUnsigned(n2, 8, null);
        } while (bl);
    }

    protected void writeUnsignedInteger64(long l, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n = (int)l & 0x7F;
            if ((l >>>= 7) != 0L) {
                n |= 0x80;
            } else {
                bl = false;
            }
            this.writeNBitUnsigned(n, 8, null);
        } while (bl);
    }

    protected void writeUnsignedInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n = bigInteger.and(BIGINTEGER_0x007F).intValue();
            if (!(bigInteger = bigInteger.shiftRight(7)).equals(BigInteger.ZERO)) {
                n |= 0x80;
            } else {
                bl = false;
            }
            this.writeNBitUnsigned(n, 8, null);
        } while (bl);
    }

    protected void writeBoolean(boolean bl, OutputStream outputStream) throws IOException {
        this.m_dataStream.putBit(bl);
    }

    protected void writeNBitUnsigned(int n, int n2, OutputStream outputStream) throws IOException {
        this.m_dataStream.putBits(n2, n);
    }

    public void finish() throws IOException {
        this.m_dataStream.flush();
    }
}

