/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.BinaryDataSink;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ScriberException;
import org.openexi.proc.io.ValueScriberBase;

public abstract class BinaryValueScriber
extends ValueScriberBase
implements BinaryDataSink {
    BinaryValueScriber(String string) {
        super(new QName(string, "http://www.w3.org/2009/exi"));
    }

    public final void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeBinaryValue(scribble.binaryValue, scribble.intValue1, outputStream, scriber);
    }

    public final Object toValue(String string, Scribble scribble, Scriber scriber) {
        int n = scribble.intValue1;
        if (n != 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(scribble.binaryValue, 0, byArray, 0, n);
            return byArray;
        }
        return null;
    }

    public final void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        byte[] byArray;
        this.scribeBinaryValue(byArray, (byArray = (byte[])object) != null ? byArray.length : 0, outputStream, scriber);
    }

    public final void startBinaryData(long l, Scribble scribble, Scriber scriber) throws IOException {
        scribble.longValue = l;
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            scriber.writeUnsignedInteger64(l, null);
        } else {
            scriber.writeUnsignedInteger32((int)l, null);
        }
    }

    public final void binaryData(byte[] byArray, int n, int n2, Scribble scribble, Scriber scriber) throws IOException {
        for (int i = 0; i < n2; ++i) {
            scriber.writeNBitUnsigned(byArray[n + i], 8, null);
        }
        scribble.longValue -= (long)n2;
    }

    public final void endBinaryData(Scribble scribble, int n, int n2, Scriber scriber) throws ScriberException {
        if (scribble.longValue != 0L) {
            throw new ScriberException(1);
        }
    }

    private void scribeBinaryValue(byte[] byArray, int n, OutputStream outputStream, Scriber scriber) throws IOException {
        scriber.writeUnsignedInteger32(n, outputStream);
        for (int i = 0; i < n; ++i) {
            scriber.writeNBitUnsigned(byArray[i], 8, outputStream);
        }
    }
}

