/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.grammars;

import org.openexi.proc.common.EventType;
import org.openexi.proc.common.EventTypeList;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.BuiltinElementGrammar;
import org.openexi.proc.grammars.EXIGrammar;
import org.openexi.proc.grammars.EventCodeTuple;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.grammars.GrammarState;
import org.openexi.schema.EXISchema;

public abstract class Grammar {
    public static final byte BUILTIN_GRAMMAR_ELEMENT = 0;
    public static final byte BUILTIN_GRAMMAR_FRAGMENT = 1;
    public static final byte SCHEMA_GRAMMAR_DOCUMENT = 2;
    public static final byte SCHEMA_GRAMMAR_FRAGMENT = 3;
    public static final byte SCHEMA_GRAMMAR_ELEMENT_FRAGMENT = 4;
    public static final byte SCHEMA_GRAMMAR_ELEMENT_AND_TYPE = 5;
    public static final byte SCHEMA_GRAMMAR_ELEMENT_AND_TYPE_USE = 6;
    private static final byte DOCUMENT_STATE_BASE = 0;
    protected static final byte DOCUMENT_STATE_CREATED = 0;
    protected static final byte DOCUMENT_STATE_DEPLETE = 1;
    public static final byte DOCUMENT_STATE_COMPLETED = 2;
    public static final byte DOCUMENT_STATE_END = 3;
    public final byte grammarType;
    protected final GrammarCache m_grammarCache;
    protected final EXISchema schema;

    protected Grammar(byte by, GrammarCache grammarCache) {
        this.grammarType = by;
        this.m_grammarCache = grammarCache;
        this.schema = this.m_grammarCache.getEXISchema();
    }

    public abstract void init(GrammarState var1);

    public abstract boolean isSchemaInformed();

    abstract EventTypeList getNextEventTypes(GrammarState var1);

    abstract EventCodeTuple getNextEventCodes(GrammarState var1);

    void attribute(EventType eventType, GrammarState grammarState) {
    }

    public void wildcardAttribute(int n, int n2, int n3, GrammarState grammarState) {
    }

    public abstract void element(EventType var1, GrammarState var2);

    Grammar wildcardElement(int n, int n2, int n3, GrammarState grammarState) {
        GrammarState grammarState2 = grammarState.apparatus.pushState();
        StringTable stringTable = grammarState.apparatus.stringTable;
        StringTable.LocalNamePartition localNamePartition = stringTable.getLocalNamePartition(n2);
        Grammar grammar = (Grammar)((Object)localNamePartition.localNameEntries[n3].grammar);
        if (grammar != null) {
            grammar.init(grammarState2);
            return grammar;
        }
        BuiltinElementGrammar builtinElementGrammar = this.m_grammarCache.createBuiltinElementGrammar(stringTable.getURI(n2), grammarState.apparatus.eventTypesWorkSpace);
        builtinElementGrammar.localNamePartition = localNamePartition;
        localNamePartition.setGrammar(n3, builtinElementGrammar);
        builtinElementGrammar.init(grammarState2);
        return builtinElementGrammar;
    }

    abstract void xsitp(int var1, GrammarState var2);

    abstract void nillify(int var1, GrammarState var2);

    public abstract void chars(EventType var1, GrammarState var2);

    public abstract void undeclaredChars(int var1, GrammarState var2);

    public abstract void miscContent(int var1, GrammarState var2);

    public abstract void end(GrammarState var1);

    public void startDocument(GrammarState grammarState) {
        assert (false);
    }

    public void endDocument(GrammarState grammarState) {
        assert (false);
    }

    protected final EXIGrammar retrieveEXIGrammar(int n) {
        if (n != -1) {
            int n2 = this.schema.getSerialOfGrammar(n);
            EXIGrammar eXIGrammar = this.m_grammarCache.exiGrammars[n2];
            if (eXIGrammar != null) {
                return eXIGrammar;
            }
            return new EXIGrammar(n, false, this.m_grammarCache, this.m_grammarCache.exiGrammars);
        }
        return null;
    }

    protected final EXIGrammar getEXIGrammar(int n) {
        if (n != -1) {
            int n2 = this.schema.getSerialOfGrammar(n);
            return this.m_grammarCache.exiGrammars[n2];
        }
        return null;
    }
}

