/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.SchemaId;
import org.openexi.proc.events.EXIEventSchemaNil;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.grammars.OptionsGrammarCache;
import org.openexi.proc.io.BitPackedScanner;
import org.openexi.proc.io.HeaderOptionsInputStream;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ScannerFactory;
import org.openexi.schema.EXISchema;

class HeaderOptionsDecoder {
    private static final GrammarCache m_grammarCache = OptionsGrammarCache.getGrammarCache();
    private final BitPackedScanner m_scanner;

    HeaderOptionsDecoder() {
        block2: {
            this.m_scanner = ScannerFactory.createHeaderOptionsScanner();
            EXISchema eXISchema = m_grammarCache.getEXISchema();
            this.m_scanner.setSchema(eXISchema, null, 0);
            this.m_scanner.setStringTable(Scanner.createStringTable(m_grammarCache));
            try {
                this.m_scanner.prepare();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public HeaderOptionsInputStream decode(EXIOptions eXIOptions, InputStream inputStream) throws IOException, EXIOptionsException {
        short s;
        this.m_scanner.setEXIOptionsInputStream(inputStream);
        this.m_scanner.setGrammar(m_grammarCache.retrieveRootGrammar(false, this.m_scanner.eventTypesWorkSpace), HeaderOptionsDecoder.m_grammarCache.grammarOptions);
        this.m_scanner.reset();
        do {
            EventDescription eventDescription;
            if ((s = (short)(eventDescription = this.m_scanner.nextEvent()).getEventKind()) != 2) continue;
            String string = eventDescription.getName();
            String string2 = eventDescription.getURI();
            if (!"http://www.w3.org/2009/exi".equals(string2)) continue;
            if ("byte".equals(string)) {
                eXIOptions.setAlignmentType(AlignmentType.byteAligned);
                continue;
            }
            if ("pre-compress".equals(string)) {
                eXIOptions.setAlignmentType(AlignmentType.preCompress);
                continue;
            }
            if ("compression".equals(string)) {
                eXIOptions.setAlignmentType(AlignmentType.compress);
                continue;
            }
            if ("strict".equals(string)) {
                eXIOptions.setStrict(true);
                continue;
            }
            if ("comments".equals(string)) {
                eXIOptions.setPreserveComments(true);
                continue;
            }
            if ("pis".equals(string)) {
                eXIOptions.setPreservePIs(true);
                continue;
            }
            if ("dtd".equals(string)) {
                eXIOptions.setPreserveDTD(true);
                continue;
            }
            if ("prefixes".equals(string)) {
                eXIOptions.setPreserveNS(true);
                continue;
            }
            if ("lexicalValues".equals(string)) {
                eXIOptions.setDatatypeRepresentationMap(null, 0);
                eXIOptions.setPreserveLexicalValues(true);
                continue;
            }
            if ("schemaId".equals(string)) {
                eventDescription = this.m_scanner.nextEvent();
                EventType eventType = eventDescription.getEventType();
                if (eventType.itemType == 21) {
                    if (((EXIEventSchemaNil)eventDescription).isNilled()) {
                        eXIOptions.setSchemaId(new SchemaId(null));
                        continue;
                    }
                    eventDescription = this.m_scanner.nextEvent();
                    eventType = eventDescription.getEventType();
                }
                assert (eventType.itemType == 19);
                eXIOptions.setSchemaId(new SchemaId(eventDescription.getCharacters().makeString()));
                continue;
            }
            if ("blockSize".equals(string)) {
                eventDescription = this.m_scanner.nextEvent();
                assert (eventDescription.getEventType().itemType == 19);
                eXIOptions.setBlockSize(Integer.valueOf(eventDescription.getCharacters().makeString()));
                continue;
            }
            if ("valueMaxLength".equals(string)) {
                eventDescription = this.m_scanner.nextEvent();
                assert (eventDescription.getEventType().itemType == 19);
                eXIOptions.setValueMaxLength(Integer.valueOf(eventDescription.getCharacters().makeString()));
                continue;
            }
            if ("valuePartitionCapacity".equals(string)) {
                eventDescription = this.m_scanner.nextEvent();
                assert (eventDescription.getEventType().itemType == 19);
                eXIOptions.setValuePartitionCapacity(Integer.valueOf(eventDescription.getCharacters().makeString()));
                continue;
            }
            if ("datatypeRepresentationMap".equals(string)) {
                EventDescription eventDescription2 = this.m_scanner.nextEvent();
                assert (eventDescription2.getEventType().itemType == 14);
                eventDescription = this.m_scanner.nextEvent();
                assert (eventDescription.getEventType().itemType == 9);
                EventDescription eventDescription3 = this.m_scanner.nextEvent();
                assert (eventDescription3.getEventType().itemType == 14);
                eventDescription = this.m_scanner.nextEvent();
                assert (eventDescription.getEventType().itemType == 9);
                eXIOptions.appendDatatypeRepresentationMap(eventDescription2, eventDescription3);
                continue;
            }
            if ("fragment".equals(string)) {
                eXIOptions.setFragment(true);
                continue;
            }
            if (!"selfContained".equals(string)) continue;
            eXIOptions.setInfuseSC(true);
        } while (s != 1);
        return (HeaderOptionsInputStream)this.m_scanner.getBitInputStream();
    }
}

