/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.security.MessageDigest;
import tdm.lib.XMLNode;

public class XMLTextNode
extends XMLNode {
    private byte[] cHash = null;
    private char[] text = null;

    public XMLTextNode(char[] srctext, int first, int length) {
        this.text = new char[length];
        System.arraycopy(srctext, first, this.text, 0, length);
        this.cHash = this.calculateHash(this.text);
        this.infoSize = this.text.length > 5 ? this.text.length - 5 : 1;
    }

    public XMLTextNode(char[] srctext) {
        this(srctext, 0, srctext.length);
    }

    public XMLTextNode(String srctext) {
        this(srctext.toCharArray());
    }

    public Object clone() {
        return super.clone();
    }

    public boolean contentEquals(Object a) {
        if (a instanceof XMLTextNode) {
            return MessageDigest.isEqual(this.cHash, ((XMLTextNode)a).cHash);
        }
        return false;
    }

    public int getContentHash() {
        return this.cHash[0] + (this.cHash[1] << 8) + (this.cHash[2] << 16) + (this.cHash[3] << 24);
    }

    public char[] getText() {
        return this.text;
    }

    public void setText(char[] aText) {
        this.text = aText;
    }

    public String toString() {
        return new String(this.text);
    }
}

