/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.security.MessageDigest;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.XMLNode;

public class XMLElementNode
extends XMLNode {
    private byte[] attrHash = null;
    private AttributesImpl attributes = null;
    private int nHashCode = -1;
    private String name = null;

    public XMLElementNode(String aname, Attributes attr) {
        this.name = aname;
        this.attributes = new AttributesImpl(attr);
        int i = 0;
        while (i < this.attributes.getLength()) {
            String qName = this.attributes.getQName(i);
            if (qName == null || qName.length() == 0) {
                this.attributes.setQName(i, this.attributes.getLocalName(i));
            }
            ++i;
        }
        this.rehash();
    }

    public Object clone() {
        XMLElementNode clone = (XMLElementNode)super.clone();
        clone.attributes = new AttributesImpl(this.attributes);
        return clone;
    }

    public boolean contentEquals(Object a) {
        if (a instanceof XMLElementNode) {
            return ((XMLElementNode)a).nHashCode == this.nHashCode && MessageDigest.isEqual(((XMLElementNode)a).attrHash, this.attrHash);
        }
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getContentHash() {
        return this.attrHash[0] + (this.attrHash[1] << 8) + (this.attrHash[2] << 16) + (this.attrHash[3] << 24) ^ this.nHashCode;
    }

    public String getLocalName() {
        return "";
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getQName() {
        return this.name;
    }

    public void rehash() {
        this.nHashCode = this.name.hashCode();
        this.infoSize = 1;
        MessageDigest md = this.getMD();
        int i = 0;
        while (i < this.attributes.getLength()) {
            int vsize = this.attributes.getValue(i).length();
            this.infoSize += 2 + (vsize > 5 ? vsize - 5 : 1);
            md.update(this.calculateHash(this.attributes.getQName(i)));
            md.update(this.calculateHash(this.attributes.getValue(i)));
            ++i;
        }
        this.attrHash = md.digest();
    }

    public void setAttributes(Attributes atts) {
        this.attributes = new AttributesImpl(atts);
    }

    public void setQName(String aName) {
        this.name = aName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(" {");
        if (this.attributes != null && this.attributes.getLength() > 0) {
            int i = 0;
            while (i < this.attributes.getLength()) {
                sb.append(' ');
                sb.append(this.attributes.getQName(i));
                sb.append('=');
                sb.append(this.attributes.getValue(i));
                ++i;
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

