/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.PrintWriter;
import java.util.Vector;
import tdm.lib.MatchArea;
import tdm.lib.XMLNode;

public abstract class Node {
    protected MatchArea area = null;
    protected int childPos = -1;
    protected Vector children = new Vector();
    protected XMLNode content = null;
    protected Node parent = null;

    protected Node() {
    }

    public void addChild(int ix, Node n) {
        n.parent = this;
        this.children.add(ix, n);
        n.childPos = ix;
        int i = ix + 1;
        while (i < this.getChildCount()) {
            this.getChildAsNode((int)i).childPos = i;
            ++i;
        }
    }

    public void addChild(Node n) {
        n.parent = this;
        n.childPos = this.children.size();
        this.children.add(n);
    }

    public void debug(PrintWriter pw, int indent) {
        String ind = "                                                   ".substring(0, indent + 1);
        pw.println(ind + this.content);
    }

    public void debugTree(PrintWriter pw, int indent) {
        this.debug(pw, indent);
        int i = 0;
        while (i < this.getChildCount()) {
            ((Node)this.children.elementAt(i)).debugTree(pw, indent + 1);
            ++i;
        }
    }

    public Node getChildAsNode(int ix) {
        return (Node)this.children.elementAt(ix);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildPos() {
        return this.childPos;
    }

    public XMLNode getContent() {
        return this.content;
    }

    public Node getLeftSibling() {
        if (this.parent == null || this.childPos == 0) {
            return null;
        }
        return this.parent.getChildAsNode(this.childPos - 1);
    }

    public MatchArea getMatchArea() {
        return this.area;
    }

    public Node getParentAsNode() {
        return this.parent;
    }

    public Node getRightSibling() {
        if (this.parent == null || this.childPos == this.parent.children.size() - 1) {
            return null;
        }
        return this.parent.getChildAsNode(this.childPos + 1);
    }

    public boolean hasLeftSibling() {
        return this.childPos > 0;
    }

    public boolean hasRightSibling() {
        return this.parent != null && this.childPos < this.parent.children.size() - 1;
    }

    public void removeChild(int ix) {
        this.children.remove(ix);
        int i = ix;
        while (i < this.getChildCount()) {
            this.getChildAsNode((int)i).childPos = i;
            ++i;
        }
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void replaceChild(int ix, Node n) {
        this.children.setElementAt(n, ix);
    }

    public void setContent(XMLNode aContent) {
        this.content = aContent;
    }

    public void setMatchArea(MatchArea anArea) {
        this.area = anArea;
    }
}

