/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.ConflictLog;
import tdm.lib.EditLog;
import tdm.lib.MatchedNodes;
import tdm.lib.Node;
import tdm.lib.PathTracker;
import tdm.lib.TriMatching;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Merge
implements XMLNode.Merger {
    protected static final int DELETE = 4;
    static BranchNode END;
    protected static final int MOVE_F = 3;
    protected static final int MOVE_I = 2;
    protected static final int NOP = 1;
    static BranchNode START;
    private ConflictLog clog;
    private EditLog elog;
    private TriMatching m = null;
    private PathTracker pt = new PathTracker();

    static {
        START = new BranchNode(new XMLTextNode("__START__"));
        END = new BranchNode(new XMLTextNode("__END__"));
    }

    public Merge(TriMatching am) {
        this.clog = new ConflictLog(this.pt);
        this.elog = new EditLog(this.pt);
        this.m = am;
    }

    private boolean _isMovefMovefConflict(BaseNode n, Set matchesA, Set matchesB) {
        Iterator i = matchesB.iterator();
        while (i.hasNext()) {
            BranchNode bnA = (BranchNode)i.next();
            BranchNode bnAparent = bnA.getParent();
            if ((bnAparent.getBaseMatchType() & 2) == 0) {
                return true;
            }
            Iterator ip = bnAparent.getPartners().getMatches().iterator();
            while (ip.hasNext()) {
                BranchNode bnBparent = (BranchNode)ip.next();
                boolean hasNasChild = false;
                int ic = 0;
                while (ic < bnBparent.getChildCount() && !hasNasChild) {
                    hasNasChild = matchesA.contains(bnBparent.getChild(ic));
                    ++ic;
                }
                if (!hasNasChild || (bnBparent.getBaseMatchType() & 2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected boolean checkHangonCombine(MergeEntry ea, MergeEntry eb, MergeList mla, MergeList mlb) {
        boolean hangonsAreEqual = false;
        if (ea.getHangonCount() <= 0) return hangonsAreEqual;
        if (eb.getHangonCount() == ea.getHangonCount()) {
            hangonsAreEqual = true;
            int i = 0;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    hangonsAreEqual = this.treeMatches(eb.getHangon(i).getNode(), ea.getHangon(i).getNode());
                    ++i;
                }
                if (!hangonsAreEqual) break;
            } while (i < ea.getHangonCount());
        }
        if (hangonsAreEqual) {
            this.clog.addListWarning(3, "Equal insertions/copies in both branches after the context nodes.", ea.getNode().getBaseMatch() != null ? ea.getNode().getBaseMatch() : eb.getNode().getBaseMatch(), ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
            return hangonsAreEqual;
        }
        this.clog.addListWarning(3, "Insertions/copies in both branches after the context nodes. Sequencing the insertions.", ea.getNode().getBaseMatch() != null ? ea.getNode().getBaseMatch() : eb.getNode().getBaseMatch(), ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
        return hangonsAreEqual;
    }

    private XMLNode cmerge(BranchNode a, BranchNode b, XMLNode.Merger nodeMerger) {
        boolean bUpdated;
        boolean aUpdated = !this.matches(a, a.getBaseMatch());
        boolean bl = bUpdated = !this.matches(b, b.getBaseMatch());
        if (aUpdated && bUpdated) {
            if (!a.isLeftTree()) {
                BranchNode tmp = a;
                a = b;
                b = tmp;
            }
            if (this.matches(a, b)) {
                this.clog.addNodeWarning(1, "Node updated in both branches, but updates are equal", a.getBaseMatch(), a, b);
                this.logUpdateOperation(a);
                return a.getContent();
            }
            XMLNode merged = nodeMerger.merge(a.getBaseMatch().getContent(), a.getContent(), b.getContent());
            if (merged != null) {
                return merged;
            }
            this.clog.addNodeConflict(1, "Node updated in both branches, using branch 1", a.getBaseMatch(), a, b);
            this.logUpdateOperation(a);
            return a.getContent();
        }
        if (bUpdated) {
            this.logUpdateOperation(b);
            return b.getContent();
        }
        if (aUpdated) {
            this.logUpdateOperation(a);
            return a.getContent();
        }
        return a.getContent();
    }

    public ConflictLog getConflictLog() {
        return this.clog;
    }

    public EditLog getEditLog() {
        return this.elog;
    }

    protected int getOperation(BaseNode bn, MergeList ml) {
        int mlPos = ml.matchInList(bn);
        if (mlPos == -1) {
            MatchedNodes copiesInThisTree = null;
            copiesInThisTree = ml.getEntryParent().isLeftTree() ? bn.getLeft() : bn.getRight();
            if (copiesInThisTree.getMatches().isEmpty()) {
                return 4;
            }
            return 3;
        }
        if (ml.getEntry(mlPos).isMoved()) {
            return 2;
        }
        return 1;
    }

    protected MergePair getRecursionPartners(MergePair mp) {
        BranchNode n1 = mp.getFirstNode();
        BranchNode n2 = mp.getSecondNode();
        if (n1 == null || n2 == null) {
            return mp;
        }
        if (n1.isMatch(2) && n2.isMatch(2)) {
            return mp;
        }
        if (n1.isMatch(2) && n2.isMatch(1)) {
            return new MergePair(n2, null);
        }
        if (n1.isMatch(1) && n2.isMatch(2)) {
            return new MergePair(n1, null);
        }
        return mp;
    }

    private boolean isDeletiaModified(BranchNode n, MergeList ml) {
        BaseNode m = n.getBaseMatch();
        if (m == null) {
            return true;
        }
        if (this.getOperation(m, ml) != 1) {
            return true;
        }
        if (n.getBaseMatchType() != 3) {
            return true;
        }
        boolean deletedInOther = n.getPartners().getMatches().isEmpty();
        if (deletedInOther) {
            if (!this.matches(n, m)) {
                return true;
            }
            MergeList mlistN = this.makeMergeList(n);
            int i = 0;
            while (i < n.getChildCount()) {
                if (this.isDeletiaModified(n.getChild(i), mlistN)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    private boolean isMovefMovefConflict(BaseNode n) {
        return this._isMovefMovefConflict(n, n.getRight().getMatches(), n.getLeft().getMatches()) || this._isMovefMovefConflict(n, n.getLeft().getMatches(), n.getRight().getMatches());
    }

    protected void logEntryStructOps(MergeEntry m1, MergeEntry m2, int childPos) {
        if (m1.moved) {
            this.elog.move(m1.getNode(), childPos);
        } else if (m2.moved) {
            this.elog.move(m2.getNode(), childPos);
        }
    }

    protected void logHangonStructOps(BranchNode n, int childPos) {
        if (!n.hasBaseMatch()) {
            this.elog.insert(n, childPos);
        } else if (n.isLeftTree() && n.getBaseMatch().getLeft().getMatchCount() > 1 || !n.isLeftTree() && n.getBaseMatch().getRight().getMatchCount() > 1) {
            this.elog.copy(n, childPos);
        } else {
            this.elog.move(n, childPos);
        }
    }

    protected void logUpdateOperation(BranchNode n) {
        this.elog.update(n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected MergeList makeMergeList(BranchNode parent) {
        block9: {
            ml = new MergeList(parent);
            if (parent.getBaseMatch() != null) break block9;
            ml.add(Merge.START);
            i = 0;
            if (true) ** GOTO lbl16
        }
        baseMatches = new HashMap<BaseNode, Integer>();
        prevChildPos = -1;
        childPos = -1;
        ml.add(Merge.START);
        i = 0;
        if (true) ** GOTO lbl81
        do {
            ml.addHangOn(parent.getChild(i));
            ++i;
lbl16:
            // 2 sources

        } while (i < parent.getChildCount());
        ml.lockNeighborhood(0, 1);
        ml.add(Merge.END);
        return ml;
        do {
            block11: {
                block14: {
                    block8: {
                        block15: {
                            block13: {
                                block12: {
                                    block10: {
                                        if ((match = (current = parent.getChild(i)).getBaseMatch()) != null) break block10;
                                        ml.addHangOn(current);
                                        ml.lockNeighborhood(0, 1);
                                        break block11;
                                    }
                                    if (match.getParent() == parent.getBaseMatch()) break block12;
                                    ml.addHangOn(current);
                                    ml.lockNeighborhood(0, 1);
                                    break block11;
                                }
                                if (!baseMatches.containsKey(match)) break block13;
                                ml.addHangOn(current);
                                firstPos = (Integer)baseMatches.get(match);
                                if (firstPos != null) {
                                    ml.lockNeighborhood(firstPos, 1, 1);
                                    baseMatches.put(match, null);
                                }
                                ml.lockNeighborhood(0, 1);
                                break block11;
                            }
                            ml.add(current);
                            baseMatches.put(match, new Integer(MergeList.access$000(ml)));
                            childPos = match.getChildPos();
                            v0 = childPos = childPos == -1 ? -2 : childPos;
                            if (prevChildPos + 1 == childPos) break block14;
                            moved = false;
                            if (prevChildPos == -2 || childPos == -2 || prevChildPos >= childPos) break block15;
                            j = 0;
                            if (true) ** GOTO lbl64
                        }
                        moved = true;
                        break block8;
                        do {
                            v1 = basePos = (aBase = parent.getChild(j).getBaseMatch()) == null ? -1 : aBase.getChildPos();
                            if (basePos != -1 && basePos > prevChildPos && basePos < childPos) {
                                moved = true;
                            }
                            ++j;
lbl64:
                            // 2 sources

                            if (moved) break;
                        } while (j < parent.getChildCount());
                    }
                    if (moved) {
                        ml.lockNeighborhood(1, 0);
                        ml.setMoved(true);
                    } else {
                        ml.setMoved(false);
                    }
                }
                prevChildPos = childPos;
            }
            ++i;
lbl81:
            // 2 sources

        } while (i < parent.getChildCount());
        ml.add(Merge.END);
        if (prevChildPos + 1 != parent.getBaseMatch().getChildCount()) {
            ml.lockNeighborhood(1, 0);
        }
        return ml;
    }

    protected MergePairList makeMergePairList(MergeList mlistA, MergeList mlistB) {
        MergePairList merged = new MergePairList();
        this.removeDeletedOrMoved(mlistA, mlistB);
        this.elog.checkPoint();
        if (mlistA.getEntryCount() != mlistB.getEntryCount()) {
            throw new RuntimeException("ASSERTION FAILED: MergeList.merge(): lists different lengths!");
        }
        int posA = 0;
        int posB = 0;
        MergeEntry ea = mlistA.getEntry(posA);
        MergeEntry eb = mlistB.getEntry(posB);
        while (true) {
            int i = 0;
            while (i < ea.getHangonCount()) {
                BranchNode na = ea.getHangon(i).getNode();
                merged.append(na, na.getFirstPartner(3));
                this.logHangonStructOps(na, merged.getPairCount() - 1);
                ++i;
            }
            if (eb.getHangonCount() > 0 && !this.checkHangonCombine(ea, eb, mlistA, mlistB)) {
                int i2 = 0;
                while (i2 < eb.getHangonCount()) {
                    BranchNode nb = eb.getHangon(i2).getNode();
                    merged.append(nb, nb.getFirstPartner(3));
                    this.logHangonStructOps(nb, merged.getPairCount() - 1);
                    ++i2;
                }
            }
            int nextA = -1;
            int nextB = -1;
            nextA = ea.locked && mlistA.getEntry((int)(posA + 1)).locked ? posA + 1 : -1;
            int n = nextB = eb.locked && mlistB.getEntry((int)(posB + 1)).locked ? posB + 1 : -1;
            if (nextA == -1 && nextB == -1) {
                nextA = posA + 1;
                nextB = posB + 1;
            }
            if (nextB == -1) {
                nextB = mlistB.findPartner(mlistA.getEntry(nextA));
            } else if (nextA == -1) {
                nextA = mlistA.findPartner(mlistB.getEntry(nextB));
            } else if (nextB != mlistB.findPartner(mlistA.getEntry(nextA))) {
                this.clog.addListConflict(4, "Conflicting moves inside child list, using the sequencing of branch 1", ea.getNode() != START ? ea.getNode().getBaseMatch() : null, ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
                this.elog.rewind();
                return this.mergeListToPairList(mlistA.getEntryParent().isLeftTree() ? mlistA : mlistB, mlistA.getEntryParent().isLeftTree() ? mlistB : mlistA);
            }
            posA = nextA;
            posB = nextB;
            ea = mlistA.getEntry(posA);
            eb = mlistB.getEntry(posB);
            if (ea.node == END || eb.node == END) {
                if (ea.node == eb.node) break;
                throw new RuntimeException("ASSERTION FAILED: Merge.mergeLists(). Both cursors not at end");
            }
            merged.append(ea.getNode(), eb.getNode());
            this.logEntryStructOps(ea, eb, merged.getPairCount() - 1);
        }
        this.elog.commit();
        return merged;
    }

    protected boolean matches(Node a, Node b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getContent().contentEquals(b.getContent());
    }

    public XMLNode merge(XMLNode baseNode, XMLNode aNode, XMLNode bNode) {
        if (!(baseNode instanceof XMLElementNode && aNode instanceof XMLElementNode && bNode instanceof XMLElementNode)) {
            return null;
        }
        XMLElementNode baseN = (XMLElementNode)baseNode;
        XMLElementNode aN = (XMLElementNode)aNode;
        XMLElementNode bN = (XMLElementNode)bNode;
        String tagName = "";
        if (baseN.getQName().equals(bN.getQName())) {
            tagName = aN.getQName();
        } else if (baseN.getQName().equals(aN.getQName())) {
            tagName = bN.getQName();
        } else {
            return null;
        }
        Attributes base = baseN.getAttributes();
        Attributes a = aN.getAttributes();
        Attributes b = bN.getAttributes();
        HashSet<String> deletia = new HashSet<String>();
        int i = 0;
        while (i < base.getLength()) {
            int ixa = a.getIndex(base.getQName(i));
            int ixb = b.getIndex(base.getQName(i));
            if (ixa == -1 && ixb != -1 && !base.getValue(i).equals(b.getValue(ixb)) || ixb == -1 && ixa != -1 && !base.getValue(i).equals(a.getValue(ixa))) {
                return null;
            }
            if (ixa == -1 || ixb == -1) {
                deletia.add(base.getQName(i));
            }
            ++i;
        }
        AttributesImpl merged = new AttributesImpl();
        int i2 = 0;
        while (i2 < a.getLength()) {
            String qName = a.getQName(i2);
            String value = a.getValue(i2);
            if (!deletia.contains(qName)) {
                int ixb = b.getIndex(qName);
                if (ixb == -1) {
                    merged.addAttribute("", "", qName, a.getType(i2), value);
                } else {
                    String valueBase;
                    String valueB = b.getValue(ixb);
                    if (valueB.equals(valueBase = base.getValue(qName))) {
                        merged.addAttribute("", "", qName, a.getType(i2), value);
                    } else if (value.equals(valueBase)) {
                        merged.addAttribute("", "", qName, b.getType(ixb), valueB);
                    } else {
                        return null;
                    }
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < b.getLength()) {
            String qName = b.getQName(i3);
            if (!deletia.contains(qName) && a.getIndex(qName) == -1) {
                merged.addAttribute("", "", qName, b.getType(i3), b.getValue(i3));
            }
            ++i3;
        }
        return new XMLElementNode(tagName, merged);
    }

    public void merge(ContentHandler ch) throws SAXException {
        this.pt.resetContext();
        ch.startDocument();
        try {
            this.treeMerge(this.m.getLeftRoot(), this.m.getRightRoot(), new SAXExternalizer(ch), this);
        }
        catch (IOException x) {
            throw new SAXException("Externalizer threw IOException: " + x.getMessage());
        }
        ch.endDocument();
    }

    protected MergePairList mergeListToPairList(MergeList mlistA, MergeList mlistB) {
        MergePairList merged = new MergePairList();
        int i = 0;
        while (i < mlistA.getEntryCount() - 1) {
            MergeEntry pair;
            MergeEntry me = mlistA.getEntry(i);
            if (i > 0) {
                merged.append(me.getNode(), me.getNode().getFirstPartner(3));
                this.logHangonStructOps(me.getNode(), merged.getPairCount() - 1);
            }
            int ih = 0;
            while (ih < me.getHangonCount()) {
                BranchNode hangon = me.getHangon(ih).getNode();
                merged.append(hangon, hangon.getFirstPartner(3));
                this.logHangonStructOps(hangon, merged.getPairCount() - 1);
                ++ih;
            }
            if (mlistB != null && (pair = mlistB.getEntry(mlistB.findPartner(me))) != null && !this.checkHangonCombine(me, pair, mlistA, mlistB)) {
                int ih2 = 0;
                while (i < pair.getHangonCount()) {
                    BranchNode hangon = pair.getHangon(ih2).getNode();
                    merged.append(hangon, hangon.getFirstPartner(3));
                    this.logHangonStructOps(hangon, merged.getPairCount() - 1);
                    ++ih2;
                }
            }
            ++i;
        }
        return merged;
    }

    protected XMLNode mergeNodeContent(MergePair mp, XMLNode.Merger nodeMerger) {
        BranchNode n1 = mp.getFirstNode();
        BranchNode n2 = mp.getSecondNode();
        if (n1 == null || n2 == null) {
            return (n1 == null ? n2 : n1).getContent();
        }
        if (n1.isMatch(1)) {
            if (!n2.isMatch(1)) {
                this.logUpdateOperation(n2);
                return n2.getContent();
            }
            return this.cmerge(n1, n2, nodeMerger);
        }
        if (n2.isMatch(1)) {
            this.logUpdateOperation(n1);
            return n1.getContent();
        }
        return this.cmerge(n1, n2, nodeMerger);
    }

    private void removeDeletedOrMoved(MergeList mlistA, MergeList mlistB) {
        BaseNode baseParent = mlistA.getEntryParent().getBaseMatch();
        int i = 0;
        while (i < baseParent.getChildCount()) {
            int op2;
            BaseNode bn = baseParent.getChild(i);
            int op1 = this.getOperation(bn, mlistA);
            if (op1 > (op2 = this.getOperation(bn, mlistB))) {
                int t = op1;
                op1 = op2;
                op2 = t;
                MergeList tl = mlistA;
                mlistA = mlistB;
                mlistB = tl;
            }
            if (!(op1 == 1 && op2 == 1 || op1 == 1 && op2 == 2 || op1 == 2 && op2 == 2 || op1 == 4 && op2 == 4)) {
                if (op1 == 1 && (op2 == 3 || op2 == 4)) {
                    int ix = mlistA.matchInList(bn);
                    if (op2 == 4 && this.isDeletiaModified(mlistA.getEntry(ix).getNode(), mlistA)) {
                        this.clog.addListWarning(2, "Modifications in deleted subtree.", bn, mlistA.getEntry(ix).getNode(), null);
                    }
                    if (mlistA.getEntry(ix).getHangonCount() > 0) {
                        int ih = 0;
                        while (ih < mlistA.getEntry(ix).getHangonCount()) {
                            mlistA.getEntry(ix - 1).addHangon(mlistA.getEntry(ix).getHangon(ih));
                            ++ih;
                        }
                    }
                    int matchIx = mlistA.matchInList(bn);
                    if (op2 == 4) {
                        this.elog.delete(mlistA.getEntry(matchIx).getNode().getBaseMatch(), mlistB.getEntryParent());
                    }
                    if (op2 == 4 && mlistA.getEntry((int)matchIx).locked) {
                        this.clog.addListConflict(2, "Moved or copied node deleted. Moving on by allowing the delete.", bn, mlistA.getEntry(ix).getNode(), null);
                    }
                    mlistA.removeEntryAt(matchIx);
                } else if (op1 == 2 && op2 == 3) {
                    BranchNode op1node = mlistA.getEntry(mlistA.matchInList(bn)).getNode();
                    this.clog.addListConflict(4, "Node moved to different locations - trying to recover by ignoring move inside childlist (copies and inserts immediately following the node may have been deleted)", bn, op1node, op1node.getFirstPartner(3));
                    mlistA.removeEntryAt(mlistA.matchInList(bn));
                } else if (op1 == 2 && op2 == 4) {
                    this.clog.addListConflict(4, "Node moved and deleted - trying to recover by deleting the node (copies and inserts immediately following the node may also have been deleted)", bn, mlistA.getEntry(mlistA.matchInList(bn)).getNode(), null);
                    int matchIx = mlistA.matchInList(bn);
                    this.elog.delete(mlistA.getEntry(matchIx).getNode().getBaseMatch(), mlistB.getEntryParent());
                    mlistA.removeEntryAt(matchIx);
                } else if (op1 == 3 && op2 == 3) {
                    if (this.isMovefMovefConflict(bn)) {
                        this.clog.addListConflict(4, "The node was moved to different locations. It will appear at each location.", bn, bn.getLeft().getFullMatch(), bn.getRight().getFullMatch());
                    }
                } else if (op1 == 3 && op2 == 4) {
                    this.clog.addListConflict(4, "The node was moved and deleted. Ignoring the deletion.", bn, bn.getLeft().getFullMatch(), bn.getRight().getFullMatch());
                }
            }
            ++i;
        }
    }

    protected boolean treeMatches(Node a, Node b) {
        if (!this.matches(a, b)) {
            return false;
        }
        if (a.getChildCount() != b.getChildCount()) {
            return false;
        }
        boolean matches = true;
        int i = 0;
        while (i < a.getChildCount() && matches) {
            matches &= this.treeMatches(a.getChildAsNode(i), b.getChildAsNode(i));
            ++i;
        }
        return matches;
    }

    public void treeMerge(BranchNode a, BranchNode b, XMLNode.Externalizer ex, XMLNode.Merger nodeMerger) throws SAXException, IOException {
        if (a != null && (a.getBaseMatchType() | 2) == 0 || b != null && (b.getBaseMatchType() | 2) == 0) {
            throw new RuntimeException("mergeNode: match type should be match children, otherwise the node should be null!");
        }
        MergeList mlistA = a != null ? this.makeMergeList(a) : null;
        MergeList mlistB = b != null ? this.makeMergeList(b) : null;
        MergePairList merged = null;
        this.pt.enterSubtree();
        merged = mlistA != null && mlistB != null ? this.makeMergePairList(mlistA, mlistB) : this.mergeListToPairList(mlistA == null ? mlistB : mlistA, null);
        int i = 0;
        while (i < merged.getPairCount()) {
            MergePair mergePair = merged.getPair(i);
            XMLNode mergedNode = this.mergeNodeContent(mergePair, nodeMerger);
            if (mergedNode instanceof XMLTextNode) {
                XMLTextNode text = (XMLTextNode)mergedNode;
                ex.startNode(text);
                ex.endNode(text);
            } else {
                XMLNode mergedElement = mergedNode;
                ex.startNode(mergedElement);
                MergePair recursionPartners = this.getRecursionPartners(mergePair);
                this.treeMerge(recursionPartners.getFirstNode(), recursionPartners.getSecondNode(), ex, nodeMerger);
                ex.endNode(mergedElement);
            }
            this.pt.nextChild();
            ++i;
        }
        this.pt.exitSubtree();
    }

    private class SAXExternalizer
    implements XMLNode.Externalizer {
        private ContentHandler ch;

        public SAXExternalizer(ContentHandler ch) {
            this.ch = ch;
        }

        public void endNode(XMLNode n) throws SAXException {
            if (n instanceof XMLTextNode) {
                return;
            }
            XMLElementNode e = (XMLElementNode)n;
            this.ch.endElement(e.getNamespaceURI(), e.getLocalName(), e.getQName());
        }

        public void startNode(XMLNode n) throws SAXException {
            if (n instanceof XMLTextNode) {
                this.ch.characters(((XMLTextNode)n).getText(), 0, ((XMLTextNode)n).getText().length);
            } else {
                XMLElementNode e = (XMLElementNode)n;
                this.ch.startElement(e.getNamespaceURI(), e.getLocalName(), e.getQName(), e.getAttributes());
            }
        }
    }

    class MergeList {
        private MergeEntry currentEntry = null;
        private BranchNode entryParent = null;
        private Map index;
        private Vector list = new Vector();
        private int tailPos = -1;

        public MergeList(BranchNode anEntryParent) {
            this.index = new HashMap();
            this.entryParent = anEntryParent;
        }

        static /* synthetic */ int access$000(MergeList x0) {
            return x0.tailPos;
        }

        void add(BranchNode n) {
            this.add(new MergeEntry(n));
        }

        public void add(MergeEntry n) {
            ++this.tailPos;
            this.ensureCapacity(this.tailPos + 1, false);
            if (this.list.elementAt(this.tailPos) != null) {
                n.locked = ((MergeEntry)this.list.elementAt((int)this.tailPos)).locked;
            }
            this.list.setElementAt(n, this.tailPos);
            this.index.put(n.node.getBaseMatch(), new Integer(this.tailPos));
            this.currentEntry = n;
        }

        void addHangOn(BranchNode n) {
            this.getEntry(this.tailPos).addHangon(n);
            this.currentEntry = null;
        }

        private void ensureCapacity(int size, boolean fill) {
            int i = this.list.size();
            while (i < size) {
                this.list.add(fill ? new MergeEntry() : null);
                ++i;
            }
        }

        public int findPartner(MergeEntry b) {
            if (b.node == START) {
                return 0;
            }
            if (b.node == END) {
                return this.getEntryCount() - 1;
            }
            return (Integer)this.index.get(b.node.getBaseMatch());
        }

        public MergeEntry getEntry(int ix) {
            return (MergeEntry)this.list.elementAt(ix);
        }

        public int getEntryCount() {
            return this.tailPos + 1;
        }

        public BranchNode getEntryParent() {
            return this.entryParent;
        }

        public void lockNeighborhood(int acurrentPos, int left, int right) {
            this.ensureCapacity(acurrentPos + right + 1, true);
            int i = acurrentPos - left;
            while (i <= acurrentPos + right) {
                ((MergeEntry)this.list.elementAt((int)i)).locked = true;
                ++i;
            }
        }

        public void lockNeighborhood(int left, int right) {
            this.lockNeighborhood(this.tailPos, left, right);
        }

        public int matchInList(BaseNode n) {
            Integer i = (Integer)this.index.get(n);
            if (i == null) {
                return -1;
            }
            return i;
        }

        void print() {
            int pos = 0;
            MergeEntry me = null;
            do {
                me = (MergeEntry)this.list.elementAt(pos);
                me.print(pos);
                ++pos;
            } while (me.node != END);
        }

        public void removeEntryAt(int ix) {
            this.list.removeElementAt(ix);
            --this.tailPos;
            this.index.clear();
            int i = 0;
            while (i < this.getEntryCount()) {
                this.index.put(this.getEntry((int)i).node.getBaseMatch(), new Integer(i));
                ++i;
            }
        }

        public void setMoved(boolean moved) {
            this.currentEntry.setMoved(moved);
        }
    }

    class MergeEntry
    extends HangonEntry {
        Vector inserts = new Vector();
        boolean locked = false;
        private BranchNode mergePartner = null;
        private boolean moved = false;

        MergeEntry() {
        }

        MergeEntry(BranchNode n) {
            super(n);
        }

        void addHangon(HangonEntry e) {
            this.inserts.add(e);
        }

        void addHangon(BranchNode n) {
            this.addHangon(new HangonEntry(n));
        }

        HangonEntry getHangon(int ix) {
            return (HangonEntry)this.inserts.elementAt(ix);
        }

        int getHangonCount() {
            return this.inserts.size();
        }

        public BranchNode getMergePartner() {
            return this.mergePartner;
        }

        public boolean isMoved() {
            return this.moved;
        }

        void print(int pos) {
            System.out.print(pos + ": ");
            System.out.print(this.isMoved() ? (char)'m' : '-');
            System.out.print(this.locked ? (char)'*' : '-');
            System.out.print(this.mergePartner != null ? (char)'p' : '-');
            System.out.print(' ' + this.node.getContent().toString() + ' ');
            if (this.node.getChildCount() > 0) {
                System.out.print(' ' + this.node.getChild(0).getContent().toString() + ' ');
            }
            System.out.println(this.inserts.toString());
        }

        public void setMergePartner(BranchNode n) {
            this.mergePartner = n;
        }

        public void setMoved(boolean amoved) {
            this.moved = amoved;
        }
    }

    private class HangonEntry {
        BranchNode node = null;

        HangonEntry() {
        }

        HangonEntry(BranchNode an) {
            this.node = an;
        }

        public BranchNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.getContent().toString();
        }
    }

    class MergePairList {
        Vector list = new Vector();

        MergePairList() {
        }

        public void append(BranchNode a, BranchNode b) {
            this.list.add(new MergePair(a, b));
        }

        public MergePair getPair(int ix) {
            return (MergePair)this.list.elementAt(ix);
        }

        public int getPairCount() {
            return this.list.size();
        }

        public void print() {
            int i = 0;
            while (i < this.list.size()) {
                MergePair mp = (MergePair)this.list.elementAt(i);
                System.out.println("<" + (mp.first != null ? mp.first.getContent().toString() : ".") + "," + (mp.second != null ? mp.second.getContent().toString() : ".") + ">");
                ++i;
            }
        }
    }

    class MergePair {
        BranchNode first;
        BranchNode second;

        MergePair(BranchNode aFirst, BranchNode aSecond) {
            this.first = aFirst;
            this.second = aSecond;
        }

        public BranchNode getFirstNode() {
            return this.first;
        }

        public BranchNode getSecondNode() {
            return this.second;
        }
    }
}

