/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Node;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Measure {
    public static final int ATTR_INFO = 2;
    public static final int ATTR_VALUE_THRESHOLD = 5;
    private static final int C = 20;
    public static final int ELEMENT_NAME_INFO = 1;
    private static final int INIT_CAPACITY = 2048;
    public static final double MAX_DIST = 1.0;
    private static int Q = 4;
    public static final int TEXT_THRESHOLD = 5;
    public static final double ZERO_CHILDREN_MATCH = 1.0;
    private Map aGrams = new HashMap(2048);
    private Map bGrams = new HashMap(2048);
    private int mismatched = 0;
    private int total = 0;
    private boolean totalMismatch = false;

    protected void buildQGrams(char[] a, Map grams) {
        grams.clear();
        int i = 0;
        while (i < a.length) {
            int count = i + Q > a.length ? a.length - i : Q;
            String gram = new String(a, i, count);
            if (grams.containsKey(gram)) {
                ++((Counter)grams.get((Object)gram)).count;
            } else {
                grams.put(gram, new Counter());
            }
            ++i;
        }
    }

    protected void buildQGrams(String a, Map grams) {
        grams.clear();
        int i = 0;
        while (i < a.length()) {
            String gram = a.substring(i, i + Q > a.length() ? a.length() : i + Q);
            if (grams.containsKey(gram)) {
                ++((Counter)grams.get((Object)gram)).count;
            } else {
                grams.put(gram, new Counter());
            }
            ++i;
        }
    }

    protected int calcQDistance() {
        int dist = 0;
        Iterator i = this.aGrams.keySet().iterator();
        while (i.hasNext()) {
            Object gramA = i.next();
            int countA = ((Counter)this.aGrams.get(gramA)).count;
            int countB = 0;
            if (this.bGrams.containsKey(gramA)) {
                countB = ((Counter)this.bGrams.get(gramA)).count;
                continue;
            }
            dist += Math.abs(countA - countB);
        }
        Iterator i2 = this.bGrams.keySet().iterator();
        while (i2.hasNext()) {
            Object gramB = i2.next();
            if (this.aGrams.containsKey(gramB)) continue;
            dist += ((Counter)this.bGrams.get(gramB)).count;
        }
        return dist;
    }

    public double childListDistance(Node a, Node b) {
        if (a.getChildCount() == 0 && b.getChildCount() == 0) {
            return 1.0;
        }
        char[] ac = new char[a.getChildCount()];
        char[] bc = new char[b.getChildCount()];
        int i = 0;
        while (i < a.getChildCount()) {
            ac[i] = (char)(a.getChildAsNode(i).getContent().getContentHash() & 0xFFFF);
            ++i;
        }
        int i2 = 0;
        while (i2 < b.getChildCount()) {
            bc[i2] = (char)(b.getChildAsNode(i2).getContent().getContentHash() & 0xFFFF);
            ++i2;
        }
        return (double)this.stringDist(ac, bc, 1.0) / ((double)a.getChildCount() + (double)b.getChildCount());
    }

    protected int decideQ(int total) {
        int q = 1;
        if (total > 150) {
            q = 4;
        } else if (total > 50) {
            q = 2;
        }
        return q;
    }

    private double getDistance() {
        return this.getDistance(null, null);
    }

    public double getDistance(Node a, Node b) {
        if (a != null && b != null) {
            this.includeNodes(a, b);
        }
        double penalty = Math.max(0.0, 1.0 - (double)this.total / 20.0);
        double distance = penalty + (1.0 - penalty) * (double)this.mismatched / (double)this.total;
        this.resetDistance();
        return this.totalMismatch ? 1.0 : distance;
    }

    private void includeNodes(Node a, Node b) {
        if (a == null || b == null || this.totalMismatch) {
            return;
        }
        XMLNode ca = a.getContent();
        XMLNode cb = b.getContent();
        if (ca instanceof XMLElementNode && cb instanceof XMLElementNode) {
            XMLElementNode ea = (XMLElementNode)ca;
            XMLElementNode eb = (XMLElementNode)cb;
            ++this.total;
            this.mismatched += ea.getQName().equals(eb.getQName()) ? 0 : 1;
            Attributes aa = ea.getAttributes();
            Attributes ab = eb.getAttributes();
            int i = 0;
            while (i < aa.getLength()) {
                int index = ab.getIndex(aa.getQName(i));
                if (index != -1) {
                    String v1 = aa.getValue(i);
                    String v2 = ab.getValue(index);
                    int amismatch = this.stringDist(v1, v2, 1.0);
                    int info = (v1.length() > 5 ? v1.length() : 1) + (v2.length() > 5 ? v2.length() : 1);
                    this.mismatched += amismatch > info ? info : amismatch;
                    this.total += info;
                } else {
                    this.mismatched += 2;
                    this.total += 2;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < ab.getLength()) {
                if (aa.getIndex(ab.getQName(i2)) == -1) {
                    this.mismatched += 2;
                    this.total += 2;
                }
                ++i2;
            }
        } else if (ca instanceof XMLTextNode && cb instanceof XMLTextNode) {
            int info = ca.getInfoSize() + cb.getInfoSize() / 2;
            int amismatch = this.stringDist(((XMLTextNode)ca).getText(), ((XMLTextNode)cb).getText(), 1.0) / 2;
            this.mismatched += amismatch > info ? info : amismatch;
            this.total += info;
        } else {
            this.totalMismatch = true;
        }
    }

    public static void main(String[] args) {
        String a = "return stringDist( a, b, a.length()+b.length() );";
        String b = "return stzingDist( a, b, a.length()+b.length() );";
        System.out.println("a=" + a);
        System.out.println("b=" + b);
        System.out.println("Dist = " + new Measure().qDist(a, b));
    }

    public int matchedChildListDistance(BaseNode a, BranchNode b) {
        char[] ac = new char[a.getChildCount()];
        char[] bc = new char[b.getChildCount()];
        int i = 0;
        while (i < a.getChildCount()) {
            ac[i] = (char)(i + 1);
            ++i;
        }
        int i2 = 0;
        while (i2 < b.getChildCount()) {
            BaseNode m = b.getBaseMatch();
            bc[i2] = m != null && m.getParent() == a ? (char)m.getChildPos() : (char)(-(i2 + 1));
            ++i2;
        }
        return this.stringDist(ac, bc, 1.0);
    }

    protected int qDist(char[] a, char[] b) {
        this.decideQ(a.length + b.length);
        this.buildQGrams(a, this.aGrams);
        this.buildQGrams(b, this.bGrams);
        return this.calcQDistance();
    }

    protected int qDist(String a, String b) {
        this.decideQ(a.length() + b.length());
        this.buildQGrams(a, this.aGrams);
        this.buildQGrams(b, this.bGrams);
        return this.calcQDistance();
    }

    private void resetDistance() {
        this.mismatched = 0;
        this.total = 0;
        this.totalMismatch = false;
    }

    public int stringDist(char[] a, char[] b, double limit) {
        return this.qDist(a, b);
    }

    public int stringDist(String a, String b, double limit) {
        return this.qDist(a, b);
    }

    class Counter {
        public int count = 1;

        Counter() {
        }
    }
}

