/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.MatchArea;
import tdm.lib.Matching;
import tdm.lib.Measure;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class HeuristicMatching
implements Matching {
    public static int COPY_THRESHOLD;
    private static final double DFS_MATCH_THRESHOLD = 0.2;
    private static final int EDGE_BYTES = 4;
    private static final double END_MATCH = 1.0;
    private static final double MAX_FUZZY_MATCH = 0.2;
    private static NodeFactory baseNodeFactory;
    protected BaseNode baseRoot = null;
    private static NodeFactory branchNodeFactory;
    protected BranchNode branchRoot = null;
    private Comparator candComp;
    private Comparator candlrdComp;
    private static Measure measure;
    private Set removedMatchings = new HashSet();

    static {
        baseNodeFactory = new NodeFactory(){

            public Node makeNode(XMLNode content) {
                return new BaseNode(content);
            }
        };
        branchNodeFactory = new NodeFactory(){

            public Node makeNode(XMLNode content) {
                return new BranchNode(content);
            }
        };
        COPY_THRESHOLD = 128;
        measure = new Measure();
    }

    public HeuristicMatching(BaseNode abase, BranchNode abranch) {
        this.candComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                double diff = ((CandidateEntry)o1).distance - ((CandidateEntry)o2).distance;
                return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
            }
        };
        this.candlrdComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                double diff = ((CandidateEntry)o1).leftRightDown - ((CandidateEntry)o2).leftRightDown;
                return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
            }
        };
        this.buildMatching(abase, abranch);
    }

    public HeuristicMatching() {
        this.candComp = new /* invalid duplicate definition of identical inner class */;
        this.candlrdComp = new /* invalid duplicate definition of identical inner class */;
    }

    protected void addMatching(BranchNode a, BaseNode b) {
        a.setBaseMatch(b, 3);
        b.getLeft().addMatch(a);
    }

    protected void addMatchingIfSameType(BranchNode a, BaseNode b) {
        if (a.getContent() instanceof XMLTextNode && b.getContent() instanceof XMLTextNode || a.getContent() instanceof XMLElementNode && b.getContent() instanceof XMLElementNode) {
            this.addMatching(a, b);
        }
    }

    public void buildMatching(BaseNode abase, BranchNode abranch) {
        this.baseRoot = abase;
        this.branchRoot = abranch;
        this.matchSubtrees(this.baseRoot, this.branchRoot);
        this.removeSmallCopies(this.branchRoot);
        this.matchSimilarUnmatched(this.baseRoot, this.branchRoot);
        this.setMatchTypes(this.baseRoot);
        this.branchRoot.setBaseMatch(this.baseRoot, 3);
    }

    private void delMatchArea(BranchNode n, MatchArea m) {
        if (n.getMatchArea() == m) {
            n.setMatchArea(null);
            this.delMatching(n, n.getBaseMatch());
            int i = 0;
            while (i < n.getChildCount()) {
                this.delMatchArea(n.getChild(i), m);
                ++i;
            }
        }
    }

    protected void delMatchArea(MatchArea m) {
        this.delMatchArea(m.getRoot(), m);
    }

    protected void delMatching(BranchNode a, BaseNode b) {
        a.delBaseMatch();
        b.getLeft().delMatch(a);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected int dfsMatch(BaseNode a, BranchNode b, int count, Vector stopNodes, MatchArea ma) {
        block7: {
            block5: {
                block6: {
                    if (stopNodes != null) {
                        this.addMatching(b, a);
                        ma.addInfoBytes(a.getContent().getInfoSize());
                        b.setMatchArea(ma);
                    }
                    childrenMatch = true;
                    if (a.getChildCount() != b.getChildCount()) break block6;
                    i = 0;
                    if (true) ** GOTO lbl17
                }
                childrenMatch = false;
                break block5;
                do {
                    childrenMatch = a.getChild(i).getContent().contentEquals(b.getChild(i).getContent());
                    ++i;
lbl17:
                    // 2 sources

                    if (!childrenMatch) break;
                } while (i < a.getChildCount());
            }
            if (childrenMatch) break block7;
            i = 0;
            if (true) ** GOTO lbl33
        }
        if (ma != null) {
            ma.addInfoBytes(a.getChildCount() * 4);
        }
        i = 0;
        if (true) ** GOTO lbl40
        do {
            stopNodes.add(b.getChild(i));
            ++i;
lbl33:
            // 2 sources

            if (stopNodes == null) return count + 1;
        } while (i < b.getChildCount());
        return count + 1;
        do {
            count += this.dfsMatch(a.getChild(i), b.getChild(i), 0, stopNodes, ma);
            ++i;
lbl40:
            // 2 sources

        } while (i < a.getChildCount());
        return count + 1;
    }

    protected int dfsMatch(BaseNode a, BranchNode b, int count) {
        return this.dfsMatch(a, b, count, null, null);
    }

    protected boolean dfsTryFuzzyMatch(Node a, Node b) {
        double distance = measure.getDistance(a, b);
        return distance < 0.2;
    }

    private boolean exactChildListMatch(BaseNode base, BranchNode a) {
        if (a.getChildCount() != base.getChildCount()) {
            return false;
        }
        int i = 0;
        while (i < a.getChildCount()) {
            if (base.getChild(i) != a.getChild(i).getBaseMatch()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Vector findCandidates(BaseNode tree, BranchNode key) {
        Vector candidates = new Vector();
        this.findExactMatches(tree, key, candidates);
        if (candidates.isEmpty()) {
            this.findFuzzyMatches(tree, key, candidates);
        }
        return candidates;
    }

    protected void findExactMatches(BaseNode tree, BranchNode key, Vector candidates) {
        DFSTreeIterator i = new DFSTreeIterator(tree);
        while (i.hasNext()) {
            BaseNode cand = (BaseNode)i.next();
            if (!cand.getContent().contentEquals(key.getContent())) continue;
            candidates.add(new CandidateEntry(cand, 0.0, -1.0));
        }
    }

    protected void findFuzzyMatches(BaseNode tree, BranchNode key, Vector candidates) {
        TreeSet<CandidateEntry> cset = new TreeSet<CandidateEntry>(this.candComp);
        double cutoff = 0.4;
        DFSTreeIterator i = new DFSTreeIterator(tree);
        while (i.hasNext()) {
            double discount = 1.0;
            BaseNode cand = (BaseNode)i.next();
            double lrdDist = discount * Math.min(Math.min(this.getDistanceOfLeft(key, cand), this.getDistanceOfRight(key, cand)), measure.childListDistance(key, cand));
            double minDist = discount * Math.min(lrdDist, measure.getDistance(cand, key));
            if (!(minDist < 0.4)) continue;
            cset.add(new CandidateEntry(cand, minDist, lrdDist));
            cutoff = cutoff < 2.0 * minDist ? cutoff : 2.0 * minDist;
        }
        Iterator i2 = cset.iterator();
        while (i2.hasNext()) {
            CandidateEntry en = (CandidateEntry)i2.next();
            if (en.distance > cutoff) break;
            candidates.add(en);
        }
    }

    public void getAreaStopNodes(Vector stopNodes, BranchNode n) {
        boolean childrenInSameArea = true;
        MatchArea parentArea = n.getMatchArea();
        if (parentArea == null) {
            throw new RuntimeException("ASSERT FAILED");
        }
        int i = 0;
        while (i < n.getChildCount() && childrenInSameArea) {
            childrenInSameArea &= n.getChild(i).getMatchArea() == parentArea;
            ++i;
        }
        if (n.getChildCount() == 0 && n.getBaseMatch().getChildCount() != 0) {
            childrenInSameArea = false;
        }
        if (!childrenInSameArea) {
            stopNodes.add(n);
            return;
        }
        int i2 = 0;
        while (i2 < n.getChildCount()) {
            this.getAreaStopNodes(stopNodes, n.getChild(i2));
            ++i2;
        }
    }

    public NodeFactory getBaseNodeFactory() {
        return baseNodeFactory;
    }

    public BaseNode getBaseRoot() {
        return this.baseRoot;
    }

    protected CandidateEntry getBestCandidate(BranchNode branch, Vector bestCandidates, int bestCount) {
        CandidateEntry best = null;
        if (bestCandidates.size() > 1) {
            Iterator i = bestCandidates.iterator();
            while (i.hasNext()) {
                CandidateEntry candidate = (CandidateEntry)i.next();
                BranchNode left = (BranchNode)branch.getLeftSibling();
                if (left == null || !left.hasBaseMatch() || left.getBaseMatch() != candidate.candidate.getLeftSibling()) continue;
                return candidate;
            }
            Iterator i2 = bestCandidates.iterator();
            while (i2.hasNext()) {
                CandidateEntry candidate = (CandidateEntry)i2.next();
                if (!(candidate.leftRightDown < 0.0)) continue;
                candidate.leftRightDown = Math.min(measure.childListDistance(candidate.candidate, branch), Math.min(this.getDistanceOfRight(candidate.candidate, branch), this.getDistanceOfLeft(candidate.candidate, branch)));
            }
            Collections.sort(bestCandidates, this.candlrdComp);
        }
        CandidateEntry candidateEntry = best = bestCandidates.isEmpty() ? null : (CandidateEntry)bestCandidates.elementAt(0);
        if (best != null && bestCount == 1 && Math.min(best.leftRightDown, best.distance) > 0.1) {
            best = null;
        }
        return best;
    }

    public NodeFactory getBranchNodeFactory() {
        return branchNodeFactory;
    }

    public BranchNode getBranchRoot() {
        return this.branchRoot;
    }

    protected double getDistanceOfLeft(Node a, Node b) {
        if (a.parent == null || b.parent == null) {
            return 1.0;
        }
        if (a.getChildPos() > 0 && b.getChildPos() > 0) {
            return measure.getDistance(a.getLeftSibling(), b.getLeftSibling());
        }
        return 1.0;
    }

    protected double getDistanceOfRight(Node a, Node b) {
        if (a.parent == null || b.parent == null) {
            return 1.0;
        }
        if (a.getChildPos() < a.parent.getChildCount() - 1 && b.getChildPos() < b.parent.getChildCount() - 1) {
            return measure.getDistance(a.getRightSibling(), b.getRightSibling());
        }
        return 1.0;
    }

    private boolean isMatched(BaseNode n) {
        return n.getLeft().getMatchCount() > 0;
    }

    private void matchSimilarUnmatched(BaseNode base, BranchNode branch) {
        int i = 0;
        while (i < branch.getChildCount()) {
            this.matchSimilarUnmatched(base, branch.getChild(i));
            ++i;
        }
        BaseNode baseMatch = branch.getBaseMatch();
        if (baseMatch != null && baseMatch.getChildCount() > 0) {
            int i2 = 0;
            while (i2 < branch.getChildCount()) {
                BranchNode n = branch.getChild(i2);
                Object leftcand = null;
                Object rightcand = null;
                int lastBaseChild = baseMatch.getChildCount() - 1;
                if (n.getBaseMatch() == null) {
                    BaseNode x;
                    if (i2 == 0 && !this.isMatched(baseMatch.getChild(0))) {
                        this.addMatchingIfSameType(n, baseMatch.getChild(0));
                    } else if (i2 == branch.getChildCount() - 1 && !this.isMatched(baseMatch.getChild(lastBaseChild))) {
                        this.addMatchingIfSameType(n, baseMatch.getChild(lastBaseChild));
                    } else if (i2 > 0 && (x = branch.getChild(i2 - 1).getBaseMatch()) != null && x.hasRightSibling() && !this.isMatched((BaseNode)x.getRightSibling())) {
                        this.addMatchingIfSameType(n, (BaseNode)x.getRightSibling());
                    } else if (i2 < branch.getChildCount() - 1 && (x = branch.getChild(i2 + 1).getBaseMatch()) != null && x.hasLeftSibling() && !this.isMatched((BaseNode)x.getLeftSibling())) {
                        this.addMatchingIfSameType(n, (BaseNode)x.getLeftSibling());
                    }
                }
                ++i2;
            }
        }
    }

    protected void matchSubtrees(BaseNode base, BranchNode branch) {
        Vector candidates = this.findCandidates(base, branch);
        int bestCount = 0;
        CandidateEntry best = null;
        Vector<CandidateEntry> bestCandidates = new Vector<CandidateEntry>();
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            CandidateEntry candidate = (CandidateEntry)i.next();
            int initCount = 0;
            int thisCount = this.dfsMatch(candidate.candidate, branch, initCount);
            if (thisCount == bestCount) {
                bestCandidates.add(candidate);
                continue;
            }
            if (thisCount <= bestCount) continue;
            bestCount = thisCount;
            bestCandidates.clear();
            bestCandidates.add(candidate);
        }
        best = this.getBestCandidate(branch, bestCandidates, bestCount);
        Vector<BranchNode> stopNodes = new Vector<BranchNode>();
        if (best != null) {
            this.dfsMatch(best.candidate, branch, 0, stopNodes, new MatchArea(branch));
        } else {
            int i2 = 0;
            while (i2 < branch.getChildCount()) {
                stopNodes.add(branch.getChild(i2));
                ++i2;
            }
        }
        Iterator i3 = stopNodes.iterator();
        while (i3.hasNext()) {
            this.matchSubtrees(base, (BranchNode)i3.next());
        }
    }

    private void removeSmallCopies(BranchNode root) {
        BaseNode base = root.getBaseMatch();
        if (base != null && base.getLeft().getMatches().size() > 1) {
            HashSet<BranchNode> deletia = new HashSet<BranchNode>();
            Iterator i = base.getLeft().getMatches().iterator();
            while (i.hasNext()) {
                BranchNode copy = (BranchNode)i.next();
                if (copy.getMatchArea().getInfoBytes() >= COPY_THRESHOLD) continue;
                deletia.add(copy);
            }
            if (base.getLeft().getMatches().size() == deletia.size()) {
                int maxcopybytes = 0;
                int mincopybytes = Integer.MAX_VALUE;
                Node origInstance = null;
                Iterator i2 = base.getLeft().getMatches().iterator();
                while (i2.hasNext()) {
                    BranchNode copy = (BranchNode)i2.next();
                    int copybytes = copy.getMatchArea().getInfoBytes();
                    Node copyRoot = copy.getMatchArea().getRoot();
                    Node copyBase = ((BranchNode)copyRoot).getBaseMatch();
                    while ((copyRoot = copyRoot.getLeftSibling()) != null && (copyBase = copyBase.getLeftSibling()) != null && ((BranchNode)copyRoot).getBaseMatch() == copyBase && copybytes < COPY_THRESHOLD) {
                        copybytes += ((BranchNode)copyRoot).getMatchArea().getInfoBytes();
                    }
                    copyRoot = copy.getMatchArea().getRoot();
                    copyBase = ((BranchNode)copyRoot).getBaseMatch();
                    while ((copyRoot = (BranchNode)copyRoot.getRightSibling()) != null && (copyBase = (BaseNode)copyBase.getRightSibling()) != null && ((BranchNode)copyRoot).getBaseMatch() == copyBase && copybytes < COPY_THRESHOLD) {
                        copybytes += copyRoot.getMatchArea().getInfoBytes();
                    }
                    if (copybytes > maxcopybytes) {
                        origInstance = copy;
                        maxcopybytes = copybytes;
                    }
                    if (copybytes >= mincopybytes) continue;
                    mincopybytes = copybytes;
                }
                if (maxcopybytes > mincopybytes) {
                    deletia.remove(origInstance);
                    origInstance.getMatchArea().addInfoBytes(COPY_THRESHOLD + 1);
                }
            }
            if (!deletia.isEmpty()) {
                Iterator i3 = deletia.iterator();
                while (i3.hasNext()) {
                    this.delMatchArea(((BranchNode)i3.next()).getMatchArea());
                }
            }
        }
        int i = 0;
        while (i < root.getChildCount()) {
            this.removeSmallCopies(root.getChild(i));
            ++i;
        }
    }

    private void setMatchTypes(BaseNode base) {
        int i = 0;
        while (i < base.getChildCount()) {
            this.setMatchTypes(base.getChild(i));
            ++i;
        }
        if (base.getLeft().getMatches().size() > 1) {
            int minDist = Integer.MAX_VALUE;
            double minContentDist = Double.MAX_VALUE;
            BranchNode master = null;
            Iterator i2 = base.getLeft().getMatches().iterator();
            while (i2.hasNext()) {
                int dist;
                BranchNode cand = (BranchNode)i2.next();
                int n = dist = this.exactChildListMatch(base, cand) ? 0 : measure.matchedChildListDistance(base, cand);
                if (dist < minDist) {
                    minDist = dist;
                    master = cand;
                    continue;
                }
                if (dist != minDist) continue;
                minContentDist = measure.getDistance(base, master);
                double cDist = measure.getDistance(base, cand);
                if (!(cDist < minContentDist)) continue;
                minContentDist = cDist;
                master = cand;
            }
            this.removedMatchings.clear();
            Iterator i3 = base.getLeft().getMatches().iterator();
            while (i3.hasNext()) {
                BranchNode cand = (BranchNode)i3.next();
                if (cand == master) continue;
                boolean structMatch = this.exactChildListMatch(base, cand);
                boolean contMatch = cand.getContent().contentEquals(base.getContent());
                if (!structMatch && !contMatch) {
                    this.removedMatchings.add(cand);
                    continue;
                }
                cand.setMatchType((contMatch ? 1 : 0) + (structMatch ? 2 : 0));
            }
            Iterator i4 = this.removedMatchings.iterator();
            while (i4.hasNext()) {
                BranchNode cand = (BranchNode)i4.next();
                this.delMatching(cand, cand.getBaseMatch());
            }
        }
    }

    class DFSTreeIterator
    implements Iterator {
        int currentChild = 0;
        Node currentNode = null;

        public DFSTreeIterator(Node root) {
            this.currentNode = root;
        }

        public boolean hasNext() {
            return this.currentNode != null;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            block2: {
                result = this.currentNode;
                if (this.currentNode.getChildCount() <= 0) ** GOTO lbl6
                this.currentNode = this.currentNode.getChildAsNode(0);
                break block2;
lbl-1000:
                // 1 sources

                {
                    this.currentNode = this.currentNode.parent;
lbl6:
                    // 2 sources

                    ** while (this.currentNode != null && (this.currentNode.parent == null || this.currentNode.childPos == this.currentNode.parent.getChildCount() - 1))
                }
lbl7:
                // 1 sources

                if (this.currentNode != null) {
                    this.currentNode = this.currentNode.parent.getChildAsNode(this.currentNode.childPos + 1);
                }
            }
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CandidateEntry {
        BaseNode candidate = null;
        double distance = 0.0;
        double leftRightDown = 0.0;

        CandidateEntry(BaseNode n, double d, double lrd) {
            this.candidate = n;
            this.distance = d;
            this.leftRightDown = lrd;
        }
    }
}

