/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.PathTracker;

public class ConflictLog {
    public static final int DELETE = 2;
    public static final int INSERT = 3;
    public static final int MOVE = 4;
    private final String[] TYPETAGS = new String[]{null, "update", "delete", "insert", "move"};
    public static final int UPDATE = 1;
    private LinkedList conflicts = new LinkedList();
    private PathTracker pt = null;
    private LinkedList warnings = new LinkedList();

    public ConflictLog(PathTracker apt) {
        this.pt = apt;
    }

    protected void add(boolean list, boolean warning, int type, String text, BaseNode b, BranchNode ba, BranchNode bb) {
        ConflictEntry ce = new ConflictEntry();
        ce.text = text;
        ce.type = type;
        ce.b = b;
        if (ba == null) {
            ba = bb;
            bb = null;
        }
        if (ba != null && ba.isLeftTree()) {
            ce.b1 = ba;
            ce.b2 = bb;
        } else {
            ce.b1 = bb;
            ce.b2 = ba;
        }
        ce.mergePath = list ? this.pt.getPathString() : this.pt.getFullPathString();
        if (warning) {
            this.warnings.addLast(ce);
        } else {
            this.conflicts.addLast(ce);
        }
    }

    public void addListConflict(int type, String text, BaseNode b, BranchNode ba, BranchNode bb) {
        this.add(true, false, type, text, b, ba, bb);
    }

    public void addListWarning(int type, String text, BaseNode b, BranchNode ba, BranchNode bb) {
        this.add(true, true, type, text, b, ba, bb);
    }

    public void addNodeConflict(int type, String text, BaseNode b, BranchNode ba, BranchNode bb) {
        this.add(false, false, type, text, b, ba, bb);
    }

    public void addNodeWarning(int type, String text, BaseNode b, BranchNode ba, BranchNode bb) {
        this.add(false, true, type, text, b, ba, bb);
    }

    public boolean hasConflicts() {
        return this.conflicts.size() > 0;
    }

    protected void outputConflict(ConflictEntry ce, ContentHandler ch) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        ch.startElement("", "", this.TYPETAGS[ce.type], atts);
        ch.characters(ce.text.toCharArray(), 0, ce.text.length());
        atts = new AttributesImpl();
        atts.addAttribute("", "", "tree", "CDATA", "merged");
        atts.addAttribute("", "", "path", "CDATA", ce.mergePath);
        ch.startElement("", "", "node", atts);
        ch.endElement("", "", "node");
        if (ce.b != null) {
            atts = new AttributesImpl();
            atts.addAttribute("", "", "tree", "CDATA", "base");
            atts.addAttribute("", "", "path", "CDATA", PathTracker.getPathString(ce.b));
            ch.startElement("", "", "node", atts);
            ch.endElement("", "", "node");
        }
        if (ce.b1 != null) {
            atts = new AttributesImpl();
            atts.addAttribute("", "", "tree", "CDATA", "branch1");
            atts.addAttribute("", "", "path", "CDATA", PathTracker.getPathString(ce.b1));
            ch.startElement("", "", "node", atts);
            ch.endElement("", "", "node");
        }
        if (ce.b2 != null) {
            atts = new AttributesImpl();
            atts.addAttribute("", "", "tree", "CDATA", "branch2");
            atts.addAttribute("", "", "path", "CDATA", PathTracker.getPathString(ce.b2));
            ch.startElement("", "", "node", atts);
            ch.endElement("", "", "node");
        }
        ch.endElement("", "", this.TYPETAGS[ce.type]);
    }

    public void writeConflicts(ContentHandler ch) throws SAXException {
        Iterator i;
        AttributesImpl atts = new AttributesImpl();
        ch.startDocument();
        ch.startElement("", "", "conflictlist", atts);
        if (!this.conflicts.isEmpty()) {
            atts = new AttributesImpl();
            ch.startElement("", "", "conflicts", atts);
            i = this.conflicts.iterator();
            while (i.hasNext()) {
                this.outputConflict((ConflictEntry)i.next(), ch);
            }
            ch.endElement("", "", "conflicts");
        }
        if (!this.warnings.isEmpty()) {
            atts = new AttributesImpl();
            ch.startElement("", "", "warnings", atts);
            i = this.warnings.iterator();
            while (i.hasNext()) {
                this.outputConflict((ConflictEntry)i.next(), ch);
            }
            ch.endElement("", "", "warnings");
        }
        ch.endElement("", "", "conflictlist");
        ch.endDocument();
    }

    private class ConflictEntry {
        BaseNode b = null;
        BranchNode b1 = null;
        BranchNode b2 = null;
        String mergePath = null;
        String text = null;
        int type = 0;

        private ConflictEntry() {
        }
    }
}

